/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.archive.provider.ArchiveReadonlyContext;
import com.jxdinfo.hussar.archive.provider.ArchiveServiceMetadata;
import com.jxdinfo.hussar.archive.provider.ArchiveServiceProvider;
import com.jxdinfo.hussar.archive.provider.ArchiveServiceResult;
import com.jxdinfo.hussar.archive.provider.ArchiveWritableContext;
import com.jxdinfo.hussar.archive.utils.MigrationJsonUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.DumpAndLoadMetadata;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysBpmService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DumpAndLoadServiceImpl
implements ArchiveServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(DumpAndLoadServiceImpl.class);
    private static final String WORKFLOWNAME = "name";
    private static final String VERSION = "version";
    private static final String EXPORTDATA = "exportData";
    private static final DumpAndLoadMetadata METADATA = new DumpAndLoadMetadata();
    @Resource
    private SysBpmService sysBpmService;
    @Resource
    private ModelService modelService;

    public ArchiveServiceMetadata metadata() {
        return METADATA;
    }

    public ArchiveServiceResult<Object> dump(ArchiveWritableContext context, Map<String, Object> parameters) {
        ArrayList<String> fileNames = new ArrayList<String>();
        HashMap map = new HashMap();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            Map workflowInfo = (Map)MigrationJsonUtils.convert((Object)entry.getValue(), Map.class);
            String fileName = String.valueOf(workflowInfo.get(WORKFLOWNAME));
            String key = entry.getKey();
            String version = String.valueOf(workflowInfo.get(VERSION));
            String exportData = String.valueOf(workflowInfo.get(EXPORTDATA));
            HashMap<String, String> fileInfo = new HashMap<String, String>();
            fileInfo.put(VERSION, version);
            fileInfo.put(WORKFLOWNAME, fileName);
            fileInfo.put("myKey", key);
            List<String> keys = Collections.singletonList(entry.getKey());
            String filePrefix = fileName + "-" + key + "/" + fileName + key;
            if (exportData.contains("workFlowData")) {
                List sysActExtendProperties = this.sysBpmService.actExtendPropertiesExportData(keys);
                context.setPayloadOfByteArray(filePrefix + "-\u62d3\u5c55.json", MigrationJsonUtils.toByteArray((Object)sysActExtendProperties));
                Map fileModel = this.modelService.exportAllFileModel("0", entry.getKey(), Integer.parseInt(version));
                if (ToolUtil.isNotEmpty((Object)fileModel)) {
                    context.setPayloadOfByteArray(filePrefix + ".bpmn20.xml", (byte[])fileModel.get("xml"));
                    context.setPayloadOfByteArray(filePrefix + "-\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", MigrationJsonUtils.toByteArray(fileModel.get("file")));
                    fileNames.add(filePrefix + ".bpmn20.xml");
                    fileNames.add(filePrefix + "-\u6d41\u7a0b\u6587\u4ef6.lcdpbpm");
                }
            }
            if (exportData.contains("assigneeData")) {
                List sysActAssignees = this.sysBpmService.actAssigneeExportData(keys);
                context.setPayloadOfByteArray(filePrefix + "-\u53c2\u4e0e\u8005.json", MigrationJsonUtils.toByteArray((Object)sysActAssignees));
                fileNames.add(filePrefix + "-\u53c2\u4e0e\u8005.json");
            }
            if (exportData.contains("accessData")) {
                List sysActFormAuths = this.sysBpmService.actFormAuthExportData(keys);
                context.setPayloadOfByteArray(filePrefix + "-\u6743\u9650.json", MigrationJsonUtils.toByteArray((Object)sysActFormAuths));
                fileNames.add(filePrefix + "-\u6743\u9650.json");
            }
            map.put(entry.getKey(), fileInfo);
        }
        context.setAttribute("workFlows", map);
        context.setAttribute("fileNames", fileNames);
        return ArchiveServiceResult.success();
    }

    public ArchiveServiceResult<Object> preload(ArchiveReadonlyContext context, Map<String, Object> parameters) {
        return ArchiveServiceResult.success();
    }

    public ArchiveServiceResult<Object> load(ArchiveReadonlyContext context, Map<String, Object> parameters) {
        ArrayList assigneeTable = new ArrayList();
        ArrayList accessTable = new ArrayList();
        ArrayList expandTable = new ArrayList();
        HashMap fileMap = new HashMap();
        boolean isOverride = false;
        boolean hasFile = false;
        List fileNames = (List)context.getAttribute("fileNames");
        for (String string : fileNames) {
            if (string.endsWith("-\u6d41\u7a0b\u6587\u4ef6.lcdpbpm")) {
                hasFile = true;
            }
            if (string.endsWith("-\u6743\u9650.json")) {
                List sysActFormAuths = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(string), (TypeReference)new TypeReference<List<SysActFormAuth>>(){});
                if (sysActFormAuths == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)string);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)string);
                }
                assigneeTable.addAll(sysActFormAuths);
            }
            if (string.endsWith("-\u53c2\u4e0e\u8005.json")) {
                List sysActAssignees = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(string), (TypeReference)new TypeReference<List<SysActAssignee>>(){});
                if (sysActAssignees == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)string);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)string);
                }
                accessTable.addAll(sysActAssignees);
            }
            if (!string.endsWith("-\u62d3\u5c55.json")) continue;
            List sysActExtendProperties = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(string), (TypeReference)new TypeReference<List<SysActExtendProperties>>(){});
            if (sysActExtendProperties == null) {
                logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)string);
                return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)string);
            }
            expandTable.addAll(sysActExtendProperties);
        }
        if (assigneeTable.size() > 0) {
            this.sysBpmService.actFormAuthBatchImport(assigneeTable);
        }
        if (accessTable.size() > 0) {
            this.sysBpmService.actAssigneeBatchImport(accessTable);
        }
        if (expandTable.size() > 0) {
            this.sysBpmService.actExtendPropertiesImport(expandTable);
        }
        if (hasFile) {
            for (Map.Entry entry : parameters.entrySet()) {
                Map map = (Map)MigrationJsonUtils.convert(entry.getValue(), Map.class);
                isOverride = Integer.parseInt(String.valueOf(map.get(VERSION))) > 0 && "OverrideImport".equals(map.get("importType"));
                HashMap temp = new HashMap();
                fileMap.put(entry.getKey(), temp);
                for (String fileName : fileNames) {
                    if (fileName.contains((String)entry.getKey() + ".bpmn20.xml")) {
                        ((Map)fileMap.get(entry.getKey())).put("xml", context.getPayloadAsString(fileName));
                    }
                    if (!fileName.contains((String)entry.getKey() + "-\u6d41\u7a0b\u6587\u4ef6.lcdpbpm")) continue;
                    ((Map)fileMap.get(entry.getKey())).put("lcdpbpm", context.getPayloadAsString(fileName));
                }
                this.modelService.importModel("0", (String)((Map)fileMap.get(entry.getKey())).get("xml"), (String)((Map)fileMap.get(entry.getKey())).get("lcdpbpm"), Boolean.valueOf(isOverride));
            }
        }
        return ArchiveServiceResult.success();
    }
}

