/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TaskCreateListener
implements ActivitiEventListener {
    private static Logger logger = LogManager.getLogger(TaskCreateListener.class);
    @Resource
    private DataPushService dataPushService;
    @Autowired
    private ISysActCcTaskService sysActCcTaskService;
    @Lazy
    @Resource
    private HistoryService historyService;

    public void onEvent(ActivitiEvent activitiEvent) {
        TaskEntity taskEntity = (TaskEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        String userId = (String)taskEntity.getVariable("startUser");
        if (HussarUtils.isNotEmpty((Object)userId)) {
            taskEntity.removeVariable("startUser");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "taskCreateEnd");
        map.put("taskId", taskEntity.getId());
        map.put("taskName", taskEntity.getName());
        map.put("businessId", taskEntity.getProcessInstance().getBusinessKey());
        map.put("processInsId", taskEntity.getProcessInstanceId());
        map.put("processDefinitionId", taskEntity.getProcessDefinitionId());
        map.put("processKey", taskEntity.getProcessDefinitionId().split(":")[0]);
        map.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
        map.put("tenantId", taskEntity.getTenantId());
        map.put("formKey", taskEntity.getFormKey());
        String taskAssignee = this.getAssigneeByTaskId(taskEntity);
        userId = HussarUtils.isEmpty((Object)taskAssignee) ? userId : taskAssignee;
        map.put("userId", userId);
        map.put("sendUser", taskEntity.getVariable("sendUser"));
        map.put("sendUserDept", taskEntity.getVariable("sendUserOrganId"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("startDate", simpleDateFormat.format(taskEntity.getCreateTime()));
        map.put("endDate", null);
        map.put("url", taskEntity.getFormKey());
        map.put("description", taskEntity.getVariable("todoConfiguration"));
        map.put("comment", null);
        map.put("processName", taskEntity.getProcessInstance().getProcessDefinition().getName());
        List identityLinkEntityList = taskEntity.getProcessInstance().getIdentityLinks();
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntityList) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            map.put("starter", identityLinkEntity.getUserId());
            break;
        }
        CommonCodeUtil.triggerEventHandleClass(map);
        if (this.dataPushService.isDataPush()) {
            if (HussarUtils.isNotEmpty((Object)userId)) {
                taskEntity.removeVariable("startUser");
            }
            DataPush dataPush = this.dataPush(taskEntity);
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put(HussarUtils.isEmpty((Object)taskAssignee) ? userId : taskAssignee, null);
            dataPush.setUserInfo(Collections.singletonList(userInfo));
            List<Map<String, String>> taskAssigneeMap = this.getAssigneeMapByTaskId(taskEntity);
            if (taskAssigneeMap.isEmpty()) {
                HashMap<String, String> assigneeMap = new HashMap<String, String>();
                assigneeMap.put("userId", userId);
                taskAssigneeMap.add(assigneeMap);
            }
            dataPush.setTaskType(taskEntity.getTaskType());
            dataPush.setUserMaps(taskAssigneeMap);
            this.dataPushService.addDataPush(dataPush);
            List ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActCcTask::getTaskId, (Object)Long.parseLong(taskEntity.getId())));
            if (HussarUtils.isNotEmpty((Object)ccTasks)) {
                ArrayList ccUsers = new ArrayList();
                for (SysActCcTask sysActCcTask : ccTasks) {
                    HashMap<String, String> ccMap = new HashMap<String, String>();
                    ccMap.put(sysActCcTask.getReceiveUser(), sysActCcTask.getReceiveUserDept());
                    ccUsers.add(ccMap);
                }
                dataPush.setUserInfo(ccUsers);
                this.dataPushService.addCcTask(dataPush);
            }
        }
    }

    private String getAssigneeByTaskId(TaskEntity taskEntity) {
        HashSet<String> users = new HashSet<String>();
        List identityLinks = taskEntity.getIdentityLinks();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                users.add(identityLink.getUserId());
            }
        }
        if (taskEntity.getAssignee() != null) {
            users.add(taskEntity.getAssignee());
        }
        return String.join((CharSequence)",", users);
    }

    private List<Map<String, String>> getAssigneeMapByTaskId(TaskEntity taskEntity) {
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>();
        List identityLinks = taskEntity.getIdentityLinks();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", identityLink.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                    map.put("mandator", identityLink.getMandator());
                    map.put("taskState", identityLink.getTaskState());
                }
                userMaps.add(map);
            }
        }
        return userMaps;
    }

    public boolean isFailOnException() {
        logger.error("\u4efb\u52a1\u521b\u5efa\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }

    private DataPush dataPush(TaskEntity task) {
        String processInstanceId = task.getProcessInstanceId();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        if (historicProcessInstance != null) {
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
        } else {
            dataPush.setBusinessKey(task.getProcessInstance().getBusinessKey());
            dataPush.setStartUserId((String)task.getVariable("sendUser"));
        }
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setSendUser((String)task.getVariable("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(null);
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)task.getVariable("todoConfiguration"));
        dataPush.setComment(null);
        dataPush.setProcessName(task.getProcessInstance().getProcessDefinition().getName());
        dataPush.setProcessInsId(processInstanceId);
        dataPush.setTenantId(task.getTenantId());
        return dataPush;
    }
}

