/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskCompleteCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.ExecutionQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;

public class CompleteLeapTaskCmd
implements Command<TaskEntity> {
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    private String taskId;
    private String comment;
    private Map<String, String> userInfo;
    private String organId;
    private Map<String, String> mandatorInfo;
    private Map<String, Object> variables;
    private boolean isSubmit;
    private CommandContext commandContext;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;

    public CompleteLeapTaskCmd(String taskId, Map<String, String> mandatorInfo, Map<String, String> userInfo, String comment, Map<String, Object> variables, boolean isSubmit) {
        this.taskId = taskId;
        this.comment = comment;
        this.userInfo = userInfo;
        this.mandatorInfo = mandatorInfo;
        this.variables = variables;
        this.isSubmit = isSubmit;
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map != null && !map.isEmpty()) {
            for (String k : map.keySet()) {
                if (map.get(k.toString()) != null) {
                    context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
                    continue;
                }
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), Object.class));
            }
        }
        return context;
    }

    public TaskEntity execute(CommandContext commandContext) {
        this.commandContext = commandContext;
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        String userId = this.userInfo.get("userId");
        this.organId = this.userInfo.get("deptId");
        if (HussarUtils.isEmpty(this.mandatorInfo)) {
            commandContext.addAttribute("taskId", (Object)task.getId());
            commandContext.addAttribute("sendUser", (Object)userId);
            commandContext.addAttribute("sendUserOrganId", (Object)this.organId);
        }
        String subProcessKey = task.getSubProcessKey();
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(this.taskId);
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        task.setVariableLocal("taskSourceFlag", (Object)"complete_leap");
        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricTaskInstanceQuery().includeTaskLocalVariables()).processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).taskVariableValueNotEquals("reject_to", null)).orderByTaskCreateTime()).desc()).listPage(0, 1);
        if (!historicTaskInstanceList.isEmpty()) {
            Map<String, Object> objectMap;
            ActivityBehavior activityBehavior = task.getExecution().getActivity().getActivityBehavior();
            boolean isScope = activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior;
            Map hisVariables = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables();
            String rejectTo = (String)hisVariables.get("reject_to");
            String rejectFrom = (String)hisVariables.get("reject_from");
            if (HussarUtils.isEmpty((Object)rejectFrom)) {
                return this.complete(task);
            }
            Map rejectExecution = (Map)hisVariables.get("reject_execution");
            String executionId = task.getExecutionId();
            ActivityImpl currentActivity = task.getExecution().getActivity();
            StringBuilder stringBuilder = new StringBuilder();
            if (rejectExecution != null) {
                for (String key : rejectExecution.keySet()) {
                    stringBuilder.append(",").append(key);
                }
            }
            if ((objectMap = this.getBackTypeWithTasks(rejectFrom + stringBuilder, (Task)task)) == null) {
                return this.complete(task);
            }
            if (!rejectTo.contains(",")) {
                Set affectedTasks = (Set)objectMap.get("affectedTasks");
                if (affectedTasks.size() == 1 && ((String)affectedTasks.iterator().next()).equals(task.getTaskDefinitionKey())) {
                    if (!isScope) {
                        this.variables.put("reject_execution", rejectExecution);
                        this.variables.put("all_prev_node", "'" + task.getTaskDefinitionKey() + "'");
                        if (this.isSubmit) {
                            this.setCompleteLeapAppointAssignee(this.variables, rejectFrom, task.getProcessInstanceId(), subProcessKey);
                        }
                        task.setAssignee(this.userInfo.get("userId"), true, true, this.organId);
                        new CommonJumpTaskCmd(this.userInfo, this.mandatorInfo, executionId, rejectFrom, this.comment, "complete", this.variables, currentActivity).execute(commandContext);
                        return task;
                    }
                    if (this.multiCondition(task)) {
                        this.variables.put("reject_execution", rejectExecution);
                        this.variables.put("all_prev_node", "'" + task.getTaskDefinitionKey() + "'");
                        if (this.isSubmit) {
                            this.setCompleteLeapAppointAssignee(this.variables, rejectFrom, task.getProcessInstanceId(), subProcessKey);
                        }
                        task.setAssignee(this.userInfo.get("userId"), true, true, this.organId);
                        new MultiInstanceJumpTaskCmd(this.userInfo, this.mandatorInfo, executionId, rejectFrom, this.taskId, this.comment, "complete", this.variables, currentActivity).execute(commandContext);
                        return task;
                    }
                    return this.complete(task);
                }
                return this.complete(task);
            }
            HashSet<String> rejectToNodes = new HashSet<String>(Arrays.asList(rejectTo.split(",")));
            String targetGateway = this.recentSharedGateway(new ArrayList<String>(Arrays.asList(rejectFrom.split(","))), task.getProcessDefinitionId());
            List executionList = commandContext.getExecutionEntityManager().findExecutionsByQueryCriteria(new ExecutionQueryImpl().processInstanceId(task.getProcessInstanceId()).activityId(targetGateway), new Page(1, Integer.MAX_VALUE));
            boolean isCompleteLeap = true;
            Set affectedUserTasks = (Set)objectMap.get("affectedUserTasks");
            Map affectedExecution = (Map)objectMap.get("affectedExecution");
            Set affectedCallActicity = (Set)objectMap.get("affectedCallActivity");
            Set affectedSubProcess = (Set)objectMap.get("affectedSubProcess");
            if (HussarUtils.isNotEmpty((Object)affectedCallActicity) || HussarUtils.isNotEmpty((Object)affectedSubProcess)) {
                isCompleteLeap = false;
            } else if (affectedExecution.size() > 1 || affectedExecution.size() == 1 && !affectedExecution.containsKey(targetGateway)) {
                isCompleteLeap = false;
            } else if (rejectToNodes.size() < affectedExecution.size() || rejectToNodes.addAll(affectedUserTasks)) {
                isCompleteLeap = false;
            } else {
                List targetGatewayExecution = affectedExecution.get(targetGateway) != null ? (List)affectedExecution.get(targetGateway) : new ArrayList();
                List runningRejectTasks = commandContext.getTaskEntityManager().findTasksByProcessInstanceId(task.getProcessInstanceId()).stream().filter(o -> affectedUserTasks.contains(o.getTaskDefinitionKey()) && Objects.equals(o.getSubProcessKey(), subProcessKey)).collect(Collectors.toList());
                HashSet<String> runningRejectNode = new HashSet<String>();
                Iterator iterator = runningRejectTasks.iterator();
                while (iterator.hasNext()) {
                    Task runningRejectTask = (Task)iterator.next();
                    if (runningRejectNode.add(runningRejectTask.getTaskDefinitionKey()) || rejectTo.equals(runningRejectTask.getTaskLocalVariables().get("reject_to"))) continue;
                    isCompleteLeap = false;
                    break;
                }
                if (isCompleteLeap && rejectTo.split(",").length != runningRejectNode.size() + targetGatewayExecution.size()) {
                    isCompleteLeap = false;
                }
            }
            if (!isCompleteLeap) {
                return this.complete(task);
            }
            if (!isScope || this.multiCondition(task)) {
                int targetGatewayExecutionNum = 0;
                for (String[] execution : executionList) {
                    if (subProcessKey != null && !subProcessKey.equals(execution.getVariable("sub_process_key")) || !targetGateway.equals(execution.getActivityId())) continue;
                    ++targetGatewayExecutionNum;
                }
                if (targetGatewayExecutionNum >= rejectToNodes.size() - 1) {
                    StringBuilder allPrevNode = new StringBuilder();
                    for (String rejectToNode : rejectTo.split(",")) {
                        allPrevNode.append("'").append(rejectToNode).append("'").append(",");
                    }
                    allPrevNode.deleteCharAt(allPrevNode.length() - 1);
                    this.variables.put("reject_execution", rejectExecution);
                    this.variables.put("all_prev_node", allPrevNode.toString());
                    if (this.isSubmit) {
                        this.setCompleteLeapAppointAssignee(this.variables, rejectFrom, task.getProcessInstanceId(), subProcessKey);
                    }
                    ArrayList<String> affectedTasks = new ArrayList<String>();
                    affectedTasks.add(targetGateway);
                    affectedTasks.add(currentActivity.getId());
                    this.variables.put("affectedTasks", affectedTasks);
                    task.setAssignee(this.userInfo.get("userId"), true, true, this.organId);
                    new ParallelJumpTaskCmd(this.taskId, this.userInfo, this.mandatorInfo, executionId, rejectFrom, this.comment, "complete", task.getSubProcessKey(), this.variables, currentActivity).execute(commandContext);
                    return task;
                }
                HashMap<String, Object> executionParamvar = new HashMap<String, Object>(this.variables);
                executionParamvar.put("all_prev_node", "'" + task.getTaskDefinitionKey() + "'");
                ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(Collections.singletonList(executionParamvar));
                HashMap<String, ArrayList<HashMap<String, Object>>> rejectExecutionMap = new HashMap<String, ArrayList<HashMap<String, Object>>>();
                rejectExecutionMap.put(targetGateway, list);
                this.variables.put("reject_execution", rejectExecutionMap);
                task.setAssignee(this.userInfo.get("userId"), true, true, this.organId);
                new CommonJumpTaskCmd(this.userInfo, this.mandatorInfo, executionId, "", this.comment, "complete", this.variables, currentActivity).execute(commandContext);
                return task;
            }
            return this.complete(task);
        }
        return this.complete(task);
    }

    private Map<String, Object> getBackTypeWithTasks(String nodeId, Task task) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set<Object> affectedTasks = new HashSet();
        Set<Object> affectedUserTasks = new HashSet();
        int newNum = 1;
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> runningActivityNodeIds = new HashSet<String>();
        String processInstanceId = task.getProcessInstanceId();
        String processDefinitionId = task.getProcessDefinitionId();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        String subProcessKey = task.getSubProcessKey();
        BpmnModel bm = this.commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(processDefinitionId);
        if (task.getSubProcessKey() != null && bm.getMainProcess().getFlowElement(nodeId) != null) {
            return null;
        }
        boolean isSubProcessJump = false;
        if (bm.getMainProcess().getFlowElement(nodeId.split(",")[0]) != null) {
            isSubProcessJump = true;
            subProcessKey = null;
        }
        List list = this.commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("callActivity").list();
        for (Object historicActivityInstance : list) {
            runningActivityNodeIds.add(historicActivityInstance.getActivityId());
        }
        result.put("runningActivitiNodeIds", runningActivityNodeIds);
        HashSet<String> runningSubProcessNodeIds = new HashSet<String>();
        if (!isSubProcessJump) {
            list = this.commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("subProcess").list();
            for (String[] historicActivityInstance : list) {
                runningSubProcessNodeIds.add(historicActivityInstance.getActivityId());
            }
        }
        result.put("runningSubProcessNodeIds", runningSubProcessNodeIds);
        List executions = this.commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(processInstanceId);
        for (String[] execution1 : executions) {
            Map variable;
            if (execution1.isScope() || execution1.getActivityId() == null || (variable = execution1.getVariables()).get("sub_process_key") != null && !subProcessKey.equals(variable.get("sub_process_key"))) continue;
            taskIds.add(execution1.getActivityId());
        }
        taskIds.addAll(runningActivityNodeIds);
        taskIds.addAll(runningSubProcessNodeIds);
        taskIds = new ArrayList(new HashSet(taskIds));
        if (taskIds.size() > 1) {
            if (nodeId.contains(",")) {
                for (String targetNodeId : nodeId.split(",")) {
                    if (!HussarUtils.isEmpty((Object)bm.getFlowElement(targetNodeId))) continue;
                    throw new PublicClientException(bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
                }
            } else if (HussarUtils.isEmpty((Object)bm.getFlowElement(nodeId))) {
                throw new PublicClientException(bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
            }
            boolean isFindTask = false;
            if (nodeId.contains(",")) {
                for (String targetNodeId : nodeId.split(",")) {
                    Map<String, Set<String>> map = this.findAffectedTask(bm, targetNodeId, true, taskIds);
                    affectedTasks.addAll((Collection<Object>)map.get("affectedTasks"));
                    affectedUserTasks.addAll((Collection)map.get("affectedUserTasks"));
                }
            } else {
                Map<String, Set<String>> map = this.findAffectedTask(bm, nodeId, true, taskIds);
                affectedTasks = map.get("affectedTasks");
                affectedUserTasks = map.get("affectedUserTasks");
            }
            if (affectedTasks.contains(taskDefinitionKey)) {
                isFindTask = true;
                affectedTasks.remove(taskDefinitionKey);
            }
            if (!affectedTasks.isEmpty()) {
                newNum = 3;
            }
            if (!isFindTask) {
                Set<Object> affetedAllTasks = new HashSet();
                if (!affectedTasks.isEmpty()) {
                    affetedAllTasks = affectedTasks;
                }
                if (nodeId.contains(",")) {
                    for (String targetNodeId : nodeId.split(",")) {
                        Map<String, Set<String>> map = this.findAffectedTask(bm, targetNodeId, false, taskIds);
                        affectedTasks.addAll((Collection<Object>)map.get("affectedTasks"));
                        affectedUserTasks.addAll((Collection<Object>)map.get("affectedUserTasks"));
                    }
                } else {
                    Map<String, Set<String>> map = this.findAffectedTask(bm, nodeId, false, taskIds);
                    affectedTasks = map.get("affectedTasks");
                    affectedUserTasks = map.get("affectedUserTasks");
                }
                if (affectedTasks.contains(taskDefinitionKey)) {
                    isFindTask = true;
                    affectedTasks.remove(taskDefinitionKey);
                }
                if (!affectedTasks.isEmpty()) {
                    newNum = 3;
                }
                if (!isFindTask && affectedTasks.size() + affetedAllTasks.size() > 0) {
                    newNum = -1;
                }
            }
        }
        HashSet<String> affectedCallActivity = new HashSet<String>();
        for (String activityId : runningActivityNodeIds) {
            if (!affectedTasks.contains(activityId)) continue;
            affectedCallActivity.add(activityId);
        }
        affectedUserTasks.addAll(affectedCallActivity);
        HashSet<String> affectedSubProcess = new HashSet<String>();
        for (String activityId : runningSubProcessNodeIds) {
            if (!affectedTasks.contains(activityId)) continue;
            affectedSubProcess.add(activityId);
        }
        affectedUserTasks.addAll(affectedSubProcess);
        HashMap affectedExecution = new HashMap();
        for (ExecutionEntity execution1 : executions) {
            List<Map> affectedExecutionList;
            if (execution1.isScope() || execution1.getActivityId() == null || affectedUserTasks.contains(execution1.getActivityId()) || !affectedTasks.contains(execution1.getActivityId()) || subProcessKey != null && !subProcessKey.equals(execution1.getVariable("sub_process_key"))) continue;
            if (affectedExecution.get(execution1.getActivityId()) != null) {
                affectedExecutionList = (List)affectedExecution.get(execution1.getActivityId());
                affectedExecutionList.add(execution1.getVariablesLocal());
                continue;
            }
            affectedExecutionList = new ArrayList<Map>();
            affectedExecutionList.add(execution1.getVariablesLocal());
            affectedExecution.put(execution1.getActivityId(), affectedExecutionList);
        }
        result.put("affectedExecution", affectedExecution);
        affectedTasks.add(taskDefinitionKey);
        result.put("affectedTasks", affectedTasks);
        result.put("affectedUserTasks", affectedUserTasks);
        result.put("affectedCallActivity", affectedCallActivity);
        result.put("affectedSubProcess", affectedSubProcess);
        result.put("num", newNum);
        return result;
    }

    private Map<String, Set<String>> findAffectedTask(BpmnModel bm, String nodeId, boolean isGoToNext, List<String> taskIds) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        HashSet<String> affectedTasks = new HashSet<String>();
        HashSet<String> affectedUserTasks = new HashSet<String>();
        flowElements.add(bm.getFlowElement(nodeId));
        HashSet<FlowElement> list = new HashSet<FlowElement>();
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (!list.add(flowElement)) continue;
            if (taskIds.contains(flowElement.getId())) {
                affectedTasks.add(flowElement.getId());
                if (flowElement instanceof UserTask) {
                    affectedUserTasks.add(flowElement.getId());
                    continue;
                }
            }
            if (flowElement instanceof EndEvent || flowElement instanceof StartEvent || !(flowElement instanceof FlowNode)) continue;
            if (isGoToNext) {
                for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getOutgoingFlows()) {
                    flowElements.add(bm.getFlowElement(sequenceFlow.getTargetRef()));
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getIncomingFlows()) {
                flowElements.add(bm.getFlowElement(sequenceFlow.getSourceRef()));
            }
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("affectedTasks", affectedTasks);
        map.put("affectedUserTasks", affectedUserTasks);
        return map;
    }

    private String recentSharedGateway(List<String> nodes, String procDefId) {
        Collections.sort(nodes);
        String node = nodes.get(0);
        BpmnModel bm = this.commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(procDefId);
        FlowElement flowElement = bm.getFlowElement(node);
        while (!(flowElement instanceof Gateway) || flowElement instanceof ExclusiveGateway) {
            SequenceFlow sequenceFlow = (SequenceFlow)((FlowNode)flowElement).getIncomingFlows().get(0);
            if (!((flowElement = bm.getFlowElement(sequenceFlow.getSourceRef())) instanceof StartEvent)) continue;
            throw new PublicClientException("\u672a\u627e\u5230\u76ee\u6807\u8282\u70b9\u7684\u516c\u5171\u7f51\u5173");
        }
        return flowElement.getId();
    }

    private void setCompleteLeapAppointAssignee(Map<String, Object> map, String rejectNodes, String processInstanceId, String subProcessKey) {
        HashMap appointAssignee;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if ((appointAssignee = (HashMap)map.get("appoint_assignee")) == null) {
            appointAssignee = new HashMap();
        }
        String targetNodeId = rejectNodes.split(",")[0];
        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(targetNodeId)).finished().includeTaskLocalVariables()).taskVariableValueEquals("taskSourceFlag", (Object)"reject")).taskVariableValueNotEquals("old_appoint_assignee", null)).subProcessKey(subProcessKey)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
        if (historicTaskInstanceList.size() == 1) {
            List oldAppointAssignee;
            Object oldAppointMessage = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
            if (oldAppointMessage instanceof HashMap) {
                Map oldAppointAssigneeMap = (Map)oldAppointMessage;
                if (oldAppointAssigneeMap.get(targetNodeId) instanceof ArrayList) {
                    oldAppointAssignee = (List)oldAppointAssigneeMap.get(targetNodeId);
                } else {
                    String userIds = (String)oldAppointAssigneeMap.get(targetNodeId);
                    List usersInfo = this.iAssigneeChooseService.getSourceDeptIdByUserId(Arrays.asList(userIds.split(",")));
                    oldAppointAssignee = usersInfo.stream().map(userInfo -> {
                        HashMap temp = new HashMap();
                        temp.put("userId", userInfo.get("userId"));
                        temp.put("deptId", userInfo.get("deptId"));
                        return temp;
                    }).collect(Collectors.toList());
                }
            } else {
                String userIds = (String)oldAppointMessage;
                List usersInfo = this.iAssigneeChooseService.getSourceDeptIdByUserId(Arrays.asList(userIds.split(",")));
                oldAppointAssignee = usersInfo.stream().map(userInfo -> {
                    HashMap temp = new HashMap();
                    temp.put("userId", userInfo.get("userId"));
                    temp.put("deptId", userInfo.get("deptId"));
                    return temp;
                }).collect(Collectors.toList());
            }
            if (HussarUtils.isNotEmpty((Object)oldAppointAssignee)) {
                appointAssignee.put(targetNodeId, oldAppointAssignee);
            }
        }
        map.put("appoint_assignee", appointAssignee);
    }

    private boolean multiCondition(TaskEntity task) {
        Map multiVariables = task.getExecution().getVariables();
        int nrOfCompletedInstances = (Integer)multiVariables.get("nrOfCompletedInstances") + 1;
        int nrOfInstances = (Integer)multiVariables.get("nrOfInstances");
        if (nrOfInstances != 0 && nrOfInstances > nrOfCompletedInstances) {
            String multiType = (String)multiVariables.get("multi_type");
            String multiFinishCondition = multiVariables.get("multi_finish_condition").toString();
            if (HussarUtils.isNotEmpty((Object)multiType) && HussarUtils.isNotEmpty((Object)multiFinishCondition)) {
                if ("0".equals(multiType) ? (double)nrOfCompletedInstances / (double)nrOfInstances >= Double.parseDouble(multiFinishCondition) / 100.0 : "1".equals(multiType) && nrOfCompletedInstances == Integer.parseInt(multiFinishCondition)) {
                    return true;
                }
            } else {
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                contextMap.put("nrOfCompletedInstances", nrOfCompletedInstances);
                contextMap.put("nrOfInstances", nrOfInstances);
                boolean condition = false;
                BpmnModel bm = this.commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(task.getProcessDefinitionId());
                String k = ((Activity)bm.getFlowElement(task.getTaskDefinitionKey())).getLoopCharacteristics().getCompletionCondition();
                ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
                SimpleContext context = CompleteLeapTaskCmd.getVariables(contextMap);
                ValueExpression e = factory.createValueExpression((ELContext)context, k, Boolean.TYPE);
                if (((Boolean)e.getValue((ELContext)context)).booleanValue()) {
                    condition = true;
                }
                if (condition) {
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    private TaskEntity complete(TaskEntity task) {
        task.setAssignee(this.userInfo.get("userId"), true, true, this.organId);
        return new TaskCompleteCmd(this.taskId, this.userInfo, this.mandatorInfo, this.variables).execute(this.commandContext);
    }
}

