/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.dao.AssigneeChooseMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assist.service.IAssistService;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.service.TaskCommentService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.InstanceEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.PreemptCommonDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskReceiveDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CompleteLeapTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CompleteReturnValueCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.EntrustAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceAddAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceDelAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.PreemptTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ReceiveTaskAddVariablesCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.RejectReturnValueCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskCompleteCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskCompletePrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.TaskRejectCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.UnPreemptTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.updateHisProcessVariableCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.updateHisTaskVariableCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.el.SqlConditionHandleService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class TaskEngineServiceImpl
implements ITaskEngineService {
    private static Logger logger = LoggerFactory.getLogger(TaskEngineServiceImpl.class);
    private static final Pattern BPM_NEXT_NODE_REGEX = Pattern.compile("bpm_next_node [!=]= '([^'])*'");
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private TaskManagerService taskManagerService;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Resource
    private AssigneeChooseMapper assigneeChooseMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private TaskCommentService taskCommentService;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService sysActUrgeTaskService;
    @Autowired
    private IAssistService assistService;
    @Autowired
    private SqlConditionHandleService sqlConditionHandleService;
    @Resource
    private ICandidateUserService candidateUserService;
    @Autowired
    private IFlowTaskService flowTaskService;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private ISysActEntrustService sysActEntrustService;
    @Resource
    private InstanceEngineMapper instanceEngineMapper;
    protected static List<String> CALL_REJECT_LIST = new ArrayList<String>();
    protected static List<String> SUB_PROCESS_REJECT_LIST = new ArrayList<String>();

    public static List<String> getCallRejectList() {
        return CALL_REJECT_LIST;
    }

    public static List<String> getSubProcessRejectList() {
        return SUB_PROCESS_REJECT_LIST;
    }

    public Task getTask(String taskId, String state) {
        if (HussarUtils.isEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIdNull(), Boolean.valueOf(false));
        }
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().taskId(taskId);
        if ("1".equals(state)) {
            taskQuery = (TaskQuery)taskQuery.includeTaskLocalVariables();
        } else if ("2".equals(state)) {
            taskQuery = (TaskQuery)((TaskQuery)taskQuery.includeTaskLocalVariables()).includeProcessVariables();
        }
        Task task = (Task)taskQuery.singleResult();
        if (task == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound(), Boolean.valueOf(false));
        }
        if (task.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended(), Boolean.valueOf(false));
        }
        return task;
    }

    public Task getTaskWithOutCheckSuspended(String taskId, String state) {
        if (HussarUtils.isEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIdNull(), Boolean.valueOf(false));
        }
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).includeTaskLocalVariables();
        if ("1".equals(state)) {
            taskQuery = (TaskQuery)taskQuery.includeTaskLocalVariables();
        } else if ("2".equals(state)) {
            taskQuery = (TaskQuery)((TaskQuery)taskQuery.includeTaskLocalVariables()).includeProcessVariables();
        }
        Task task = (Task)taskQuery.singleResult();
        if (task == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound(), Boolean.valueOf(false));
        }
        return task;
    }

    public ApiResponse<Map<String, Object>> queryTask(String taskId, String tenantId) {
        String message;
        String sendUserDept;
        if ((taskId = this.getRealTaskId(taskId)) == null) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getNotNullParamIsNull());
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).includeTaskLocalVariables()).includeProcessVariables()).singleResult();
        if (historicTaskInstance == null) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getTaskNotFound());
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).singleResult();
        Map variables = historicTaskInstance.getProcessVariables();
        Map taskVariables = historicTaskInstance.getTaskLocalVariables();
        map.put("taskId", historicTaskInstance.getId());
        map.put("name", historicTaskInstance.getName());
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(hpi.getStartUserId());
        String sendUser = taskVariables.get("sendUser") == null ? "" : taskVariables.get("sendUser").toString();
        String string = sendUserDept = taskVariables.get("sendUserOrganId") == null ? "" : taskVariables.get("sendUserOrganId").toString();
        if (HussarUtils.isNotEmpty((Object)sendUser)) {
            userIds.add(sendUser);
            map.put("sendUser", sendUser);
            map.put("sendUserOrganId", sendUserDept);
        }
        Map finalUsers = new HashMap();
        if (HussarUtils.isNotEmpty((Object)historicTaskInstance.getAssignee())) {
            userIds.add(historicTaskInstance.getAssignee());
            map.put("assigneeId", historicTaskInstance.getAssignee());
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            map.put("assigneeName", finalUsers.get(historicTaskInstance.getAssignee()));
        } else {
            Set users = this.getAssigneeByTaskId(taskId).stream().map(a -> (String)a.get("userId")).collect(Collectors.toSet());
            if (HussarUtils.isNotEmpty(users)) {
                userIds.addAll(users);
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilderName = new StringBuilder();
                for (String user : users) {
                    stringBuilder.append(",").append(user);
                    stringBuilderName.append(",").append((String)finalUsers.get(user));
                }
                map.put("assigneeId", stringBuilder.toString().substring(1));
                map.put("assigneeName", stringBuilderName.toString().substring(1));
            } else if (!userIds.isEmpty()) {
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            }
        }
        if (HussarUtils.isNotEmpty((Object)sendUser)) {
            map.put("sendUserName", finalUsers.get(sendUser));
        }
        map.put("processStartUserId", hpi.getStartUserId());
        map.put("processStartUserName", finalUsers.get(hpi.getStartUserId()));
        map.put("processDefinitionId", historicTaskInstance.getProcessDefinitionId());
        map.put("processKey", hpi.getProcessDefinitionKey());
        map.put("processDefinitionName", hpi.getProcessDefinitionName());
        map.put("taskDefinitionKey", historicTaskInstance.getTaskDefinitionKey());
        map.put("processInsId", historicTaskInstance.getProcessInstanceId());
        map.put("claimTime", historicTaskInstance.getClaimTime());
        map.put("startTime", historicTaskInstance.getStartTime());
        map.put("endTime", historicTaskInstance.getEndTime());
        map.put("businessId", hpi.getBusinessKey());
        map.put("variables", variables);
        map.put("taskVariables", taskVariables);
        map.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
        String string2 = message = taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString();
        if (HussarUtils.isNotEmpty((Object)message)) {
            map.put("message", message);
        }
        map.put("formKey", historicTaskInstance.getFormKey());
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(historicTaskInstance.getTaskDefinitionKey());
        String formDetail = (String)this.iSysActExtendPropertiesService.queryList(ids, historicTaskInstance.getProcessDefinitionId()).get(historicTaskInstance.getTaskDefinitionKey());
        map.put("formDetailKey", formDetail);
        return ApiResponse.success(map);
    }

    public ApiResponse<JSONObject> queryAllToDoTaskList(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, String tenantId, Integer page, Integer size) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        GetTaskManagerDto taskManagerDto = new GetTaskManagerDto();
        taskManagerDto.setProcessName(processName);
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            List<String> processDefinitionKeies = Arrays.asList(processKey.split(","));
            taskManagerDto.setProcessKey(processDefinitionKeies);
        }
        taskManagerDto.setStartTime(start);
        taskManagerDto.setEndTime(end);
        taskManagerDto.setTimeoutState(timeoutState);
        taskManagerDto.setSuspensionState(Long.valueOf(Long.parseLong(suspensionState)));
        taskManagerDto.setTodoConfiguration(todoConfiguration);
        taskManagerDto.setTenantId(tenantId);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), size == null ? 10L : (long)size.intValue());
        List list = this.taskManagerService.getTask(pages, taskManagerDto);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", (Object)list);
        return ApiResponse.success((Object)object);
    }

    public ApiResponse<JSONObject> queryAllToDoTaskListByBusiness(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, List<String> businessList, String tenantId, Integer page, Integer size) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        GetTaskManagerDto taskManagerDto = new GetTaskManagerDto();
        taskManagerDto.setProcessName(processName);
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            List<String> processDefinitionKeies = Arrays.asList(processKey.split(","));
            taskManagerDto.setProcessKey(processDefinitionKeies);
        }
        taskManagerDto.setStartTime(start);
        taskManagerDto.setEndTime(end);
        taskManagerDto.setTimeoutState(timeoutState);
        taskManagerDto.setSuspensionState(Long.valueOf(Long.parseLong(suspensionState)));
        taskManagerDto.setTodoConfiguration(todoConfiguration);
        taskManagerDto.setTenantId(tenantId);
        taskManagerDto.setBusinessList(!HussarUtils.isNotEmpty(businessList) ? businessList : null);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), size == null ? 10L : (long)size.intValue());
        List list = this.taskManagerService.getTask(pages, taskManagerDto);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", (Object)list);
        return ApiResponse.success((Object)object);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, String processKey, String definitionKey, String tenantId) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.todoList(new Page(1L, 1000L), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, String processKey, String definitionKey, String tenantId, Integer page, Integer rows) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.todoList(new Page((long)page.intValue(), (long)rows.intValue()), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, List<String> businessIds, String tenantId) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel();
        flowTaskQueryModel.setUserId(userId);
        flowTaskQueryModel.setBusinessIds(businessIds);
        return this.flowTaskService.todoList(new Page(1L, 1000L), flowTaskQueryModel, null);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedTaskList(String userId, String processKey, String definitionKey, String tenantId) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.doneList(new Page(1L, 1000L), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedTaskList(String userId, String processKey, String definitionKey, String tenantId, Integer page, Integer rows) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.doneList(new Page((long)page.intValue(), (long)rows.intValue()), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<List<Map<String, String>>> queryUserTaskCount(String userId) {
        return ApiResponse.success(this.taskEngineMapper.getUserTask(userId));
    }

    public ApiResponse<List<Map<String, String>>> queryUserTaskCountByNode(String userId) {
        return ApiResponse.success(this.taskEngineMapper.getUserTaskByNode(userId));
    }

    public BpmResponseResult claimTask(String taskId, Map<String, String> userInfo) {
        taskId = this.getRealTaskId(taskId);
        this.taskService.claim(taskId, userInfo.get("userId"), userInfo.get("deptId"));
        this.claimDataPush(taskId, userInfo);
        this.activityRedisTimerService.updateTimeOutModel(taskId, Collections.singletonList(userInfo), null, 0);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult unClaimTask(String taskId) {
        taskId = this.getRealTaskId(taskId);
        this.taskService.unclaim(taskId);
        this.claimDataPush(taskId, null);
        this.activityRedisTimerService.updateTimeOutModel(taskId, null, null, 1);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult completeTask(String taskId, Map<String, String> userInfo, Map<String, Object> map, boolean isAuditAuthority) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userInfo, mandataryInfo, isAuditAuthority));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userInfo, mandataryInfo, map));
        this.completeDataPush(task, "", userInfo, mandataryInfo, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), map));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, Map<String, String> userInfo, Map<String, String> assigneeMap, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userInfo, mandataryInfo))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userInfo, mandataryInfo, newMap));
        this.completeDataPush(task, "", userInfo, mandataryInfo, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, Map<String, String> userInfo, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userInfo, mandataryInfo))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userInfo, mandataryInfo, comment, newMap));
        this.completeDataPush(task, comment, userInfo, mandataryInfo, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, Map<String, String> userInfo, Map<String, Object> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && !users.isEmpty()) {
            newMap.put("cc_user", users);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userInfo, mandataryInfo))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userInfo, mandataryInfo, comment, newMap));
        this.completeDataPush(task, comment, userInfo, mandataryInfo, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, Map<String, String> userInfo, String comment, Map<String, Object> map) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userInfo, mandataryInfo));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userInfo, mandataryInfo, comment, map));
        this.completeDataPush(task, comment, userInfo, mandataryInfo, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), map));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, Map<String, String> userInfo, String comment, String subProcesses, Map<String, Object> map) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        String[] subs = subProcesses.split(",");
        JSONArray jsonArray = new JSONArray();
        for (String sub : subs) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("businessId", (Object)"");
            jsonObject.put("processKey", (Object)sub);
            jsonObject.put("userId", (Object)"");
            jsonArray.add((Object)jsonObject);
        }
        newMap.put("call_activity_info", jsonArray);
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userInfo, mandataryInfo));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userInfo, mandataryInfo, comment, newMap));
        this.completeDataPush(task, comment, userInfo, mandataryInfo, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeTask(String taskId, Map<String, String> userInfo, Map<String, Object> assigneeMap, Set<String> users, String comment, Map<String, Object> map, boolean isAuditAuthority) {
        CommonPrepareCmd.PrepareReturn prepareReturn;
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && !users.isEmpty()) {
            newMap.put("cc_user", users);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        if (!(prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new TaskCompletePrepareCmd(taskId, userInfo, mandataryInfo).isAuditAuthority(isAuditAuthority))).isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new TaskCompleteCmd(taskId, userInfo, mandataryInfo, comment, newMap));
        this.completeDataPush(task, comment, userInfo, mandataryInfo, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryRejectComment(String taskId) {
        taskId = this.getRealTaskId(taskId);
        JSONArray json = new JSONArray();
        String comment = "";
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).includeTaskLocalVariables()).singleResult();
        if (task == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
        }
        if (task.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended(), Boolean.valueOf(false));
        }
        Map variable = task.getTaskLocalVariables();
        if (variable.get("reject_from") != null) {
            HistoricTaskInstance historicTaskInstance;
            List comments;
            String rejectTask = ((String)variable.get("reject_from")).split(",")[0];
            List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(rejectTask)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
            if (HussarUtils.isNotEmpty((Object)historicTaskInstanceList) && HussarUtils.isNotEmpty((Object)(comments = this.taskService.getTaskComments((historicTaskInstance = (HistoricTaskInstance)historicTaskInstanceList.get(0)).getId(), "complete")))) {
                comment = ((Comment)comments.get(0)).getFullMessage();
            }
        }
        json.add((Object)comment);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult completeLeapTask(String taskId, Map<String, String> userInfo, Map<String, Object> assigneeMap, String comment, Map<String, Object> map) {
        return this.completeLeapTask(taskId, userInfo, assigneeMap, null, comment, map, false);
    }

    public BpmResponseResult completeLeapTask(String taskId, Map<String, String> userInfo, Map<String, Object> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return this.completeLeapTask(taskId, userInfo, assigneeMap, users, comment, map, false);
    }

    public BpmResponseResult completeLeapTask(String taskId, Map<String, String> userInfo, Map<String, Object> assigneeMap, Set<String> users, String comment, Map<String, Object> map, boolean isSubmit) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userInfo, mandataryInfo));
        if (!prepareReturn.isSuccess()) {
            return InstallResult.fail((String)prepareReturn.getMessage());
        }
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && !users.isEmpty()) {
            newMap.put("cc_user", users);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        Task task = (Task)this.processEngine.getManagementService().executeCommand((Command)new CompleteLeapTaskCmd(taskId, mandataryInfo, userInfo, comment, newMap, isSubmit));
        this.completeDataPush(task, comment, userInfo, mandataryInfo, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), newMap));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private boolean auditAuthority(List<Map<String, String>> userInfo, String taskId) {
        boolean flag = false;
        List<Map<String, String>> usersInfo = this.getAssigneeByTaskId(taskId);
        Iterator<Map<String, String>> iterator = userInfo.iterator();
        if (iterator.hasNext()) {
            Map<String, String> map = iterator.next();
            return usersInfo.contains(map);
        }
        return flag;
    }

    public BpmResponseResult rejectToLastTask(String taskId, Map<String, String> userInfo, String comment, List<Map<String, String>> assignees, boolean canRejectToMainProcess, boolean isSubmit, Map<String, Object> map, String rejectActivityId, boolean isAuditAuthority) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userInfo, mandataryInfo, isAuditAuthority));
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userInfo, mandataryInfo, comment, isSubmit, taskId, "reject", null, Boolean.valueOf(false), map);
        taskRejectModel.setAssigneesInfo(assignees);
        taskRejectModel.setCanRejectToMainProcess(canRejectToMainProcess);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        Task task = taskRejectModel.getTask();
        this.cancelNodeRevoke(task, taskRejectModel.getCancelTaskDefKeys());
        if (HussarUtils.isEmpty((Object)rejectActivityId)) {
            rejectActivityId = task.getTaskDefinitionKey();
        }
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), taskRejectModel.getTargetIds(), HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, task.getTaskDefinitionKey(), "reject", task.getName()));
        boolean needReject = false;
        String rejectTaskId = "";
        if (HussarUtils.isNotEmpty((Object)json)) {
            for (int i = 0; i < json.size(); ++i) {
                JSONObject object = json.getJSONObject(i);
                if (!object.get((Object)"taskDefinitionKey").equals(taskRejectModel.getTargetIds()) || !HussarUtils.isEmpty((Object)object.get((Object)"userId")) || !object.get((Object)"processInsId").equals(task.getProcessInstanceId()) || taskRejectModel.getSubProcessFirst()) continue;
                needReject = true;
                rejectTaskId = object.get((Object)"taskId") == null ? "" : object.get((Object)"taskId").toString();
                break;
            }
        }
        if (needReject) {
            return this.rejectToLastTask(rejectTaskId, userInfo, comment, assignees, canRejectToMainProcess, isSubmit, taskRejectModel.getMap(), rejectActivityId, false);
        }
        this.rejectDataPush(task, comment, userInfo, mandataryInfo, taskState);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult rejectToFirstTask(String taskId, Map<String, String> userInfo, String comment, List<Map<String, String>> assignees, boolean isSubProcessFirst, boolean isSubmit, Map<String, Object> map, boolean isAuditAuthority) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userInfo, mandataryInfo, isAuditAuthority));
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        if (HussarUtils.isEmpty((Object)taskId)) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessNotStart(), Boolean.valueOf(false));
        }
        TaskRejectModel taskRejectModel = new TaskRejectModel(userInfo, mandataryInfo, comment, isSubmit, taskId, "reject", null, Boolean.valueOf(true), map);
        taskRejectModel.setAssigneesInfo(assignees);
        taskRejectModel.setCanRejectToMainProcess(true);
        if (isSubProcessFirst) {
            taskRejectModel.setSubProcessFirst(true);
            taskRejectModel.setFirst(false);
        }
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        Task task = taskRejectModel.getTask();
        this.cancelNodeRevoke(task, taskRejectModel.getCancelTaskDefKeys());
        this.rejectDataPush(task, comment, userInfo, mandataryInfo, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), true, taskRejectModel.getStartUserId(), taskRejectModel.getFirstNodeId(), HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, task.getTaskDefinitionKey(), "reject", task.getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private void cancelNodeRevoke(Task task, Set<String> set) {
        if (set != null && !set.isEmpty()) {
            this.taskEngineMapper.cancelNodeRevoke(task.getProcessInstanceId(), set, task.getSubProcessKey());
        }
    }

    public BpmResponseResult rejectToAnyTask(String taskId, Map<String, String> userInfo, String backActivityId, String comment, List<Map<String, String>> assignees, Map<String, String> assigneeMap, boolean isSubmit, Map<String, Object> map, boolean isAuditAuthority) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userInfo, mandataryInfo, isAuditAuthority));
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userInfo, mandataryInfo, comment, isSubmit, taskId, "reject", backActivityId, Boolean.valueOf(false), map);
        taskRejectModel.setAssigneesInfo(assignees);
        taskRejectModel.setAssigneeMap(assigneeMap);
        taskRejectModel.setCanRejectToMainProcess(true);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        Task task = taskRejectModel.getTask();
        this.cancelNodeRevoke(task, taskRejectModel.getCancelTaskDefKeys());
        this.rejectDataPush(taskRejectModel.getTask(), comment, userInfo, mandataryInfo, taskState);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), backActivityId, HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, task.getTaskDefinitionKey(), "reject", task.getName()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryRejectNode(String taskId, boolean getWithMainProcess) {
        Task task = this.getTaskWithOutCheckSuspended(taskId = this.getRealTaskId(taskId), "1");
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm != null) {
            HistoricProcessInstance processInstance;
            List hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"skip")).subProcessKey(task.getSubProcessKey())).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
            List<String> hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
            List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityType("callActivity").subProcessKey(task.getSubProcessKey()).finished().list();
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!HussarUtils.isNotEmpty((Object)historicActivityInstance.getEndTime())) continue;
                hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
            }
            list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityType("subProcess").finished().list();
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!HussarUtils.isNotEmpty((Object)historicActivityInstance.getEndTime())) continue;
                hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
            }
            JSONArray json = new JSONArray();
            FlowNode userTask = (FlowNode)bm.getFlowElement(task.getTaskDefinitionKey());
            HashSet<String> ids = new HashSet<String>();
            ids.add(task.getTaskDefinitionKey());
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            if (userTask == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
            }
            this.getAllHisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
            List<String> finalList = this.getFinalList(lists);
            this.updateJsonResult(bm, json, finalList, false);
            if (getWithMainProcess && task.getSubProcessKey() != null) {
                String taskDefKey = task.getSubProcessKey().split(":")[0];
                FlowNode subProcess = (FlowNode)bm.getFlowElement(taskDefKey);
                ids = new HashSet();
                ids.add(taskDefKey);
                lists = new ArrayList();
                if (subProcess == null) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
                }
                this.getAllHisNodeList(bm, subProcess.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
                finalList = this.getFinalList(lists);
                this.updateJsonResult(bm, json, finalList, false);
            }
            if ((getWithMainProcess && task.getSubProcessKey() != null || task.getSubProcessKey() == null) && HussarUtils.isNotEmpty((Object)(processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).getSuperProcessInstanceId()) && !(hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"skip")).orderByHistoricTaskInstanceEndTime().asc()).finished().list()).isEmpty()) {
                bm = this.repositoryService.getBpmnModel(((HistoricTaskInstance)hisList.get(0)).getProcessDefinitionId());
                hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
                list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((HistoricTaskInstance)hisList.get(0)).getProcessInstanceId()).activityType("callActivity").list();
                String taskDefinitionKey = "";
                for (HistoricActivityInstance historicActivityInstance : list) {
                    if (HussarUtils.isNotEmpty((Object)historicActivityInstance.getEndTime())) {
                        hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
                    }
                    if (!"".equals(taskDefinitionKey) || !processInstance.getId().equals(historicActivityInstance.getCalledProcessInstanceId())) continue;
                    taskDefinitionKey = historicActivityInstance.getActivityId();
                }
                list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityType("subProcess").finished().list();
                for (HistoricActivityInstance historicActivityInstance : list) {
                    if (!HussarUtils.isNotEmpty((Object)historicActivityInstance.getEndTime())) continue;
                    hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
                }
                hisTaskDefinitionKey = new ArrayList<String>(new HashSet<String>(hisTaskDefinitionKey));
                hisTaskDefinitionKey.remove(taskDefinitionKey);
                userTask = (FlowNode)bm.getFlowElement(taskDefinitionKey);
                ids = new HashSet();
                ids.add(taskDefinitionKey);
                lists = new ArrayList();
                if (userTask == null) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
                }
                this.getAllHisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
                finalList = this.getFinalList(lists);
                this.updateJsonResult(bm, json, finalList, true);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
    }

    private void getAllHisNodeList(BpmnModel bm, List<SequenceFlow> incomingFlows, List<String> hisTaskDefinitionKey, List<String> goneNode, List<String> hisNode, List<List<String>> allHisNode) {
        Process process = (Process)bm.getProcesses().get(0);
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = bm.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            ArrayList<String> hisNodeSave = new ArrayList<String>(hisNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(hisNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            if (hisTaskDefinitionKey.contains(flowElement.getId())) {
                hisNodeSave.add(flowElement.getId());
            }
            this.getAllHisNodeList(bm, ((FlowNode)flowElement).getIncomingFlows(), hisTaskDefinitionKey, goneNodeSave, hisNodeSave, allHisNode);
        }
    }

    private List<String> getFinalList(List<List<String>> lists) {
        if (lists.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> finalList = lists.get(0);
        for (int i = 1; i < lists.size(); ++i) {
            List<String> list = lists.get(i);
            int index = 0;
            for (String id : list) {
                if (finalList.contains(id)) {
                    index = finalList.indexOf(id) + 1;
                    continue;
                }
                finalList.add(index, id);
                ++index;
            }
        }
        return finalList;
    }

    private void updateJsonResult(BpmnModel bm, JSONArray json, List<String> finalList, boolean isRejectMain) {
        Process process = (Process)bm.getProcesses().get(0);
        String preFix = isRejectMain ? "main_process_" : "";
        String namePreFix = isRejectMain ? "\u4e3b\u6d41\u7a0b" : "";
        for (String id : finalList) {
            FlowElement flowElement = bm.getFlowElement(id);
            JSONObject object = new JSONObject();
            object.put("id", (Object)(preFix + flowElement.getId()));
            object.put("name", (Object)(namePreFix + flowElement.getName()));
            json.add((Object)object);
        }
    }

    private List<Map<String, String>> getTaskCommitUser(String processInsId, String backActivityId) {
        List hisTaskList;
        ArrayList assignees = new ArrayList();
        if (backActivityId.startsWith("main_process_")) {
            backActivityId = backActivityId.substring("main_process_".length());
        }
        if ((hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(backActivityId)).finished().includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).list()) != null && !hisTaskList.isEmpty()) {
            block0: for (int i = 0; i < hisTaskList.size(); ++i) {
                String taskSourceFlag = (String)((HistoricTaskInstance)hisTaskList.get(i)).getTaskLocalVariables().get("taskSourceFlag");
                if ("reject".equals(taskSourceFlag) || "revoke".equals(taskSourceFlag) || "reject_revoke".equals(taskSourceFlag)) continue;
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(i);
                Date start = historicTaskInstance.getStartTime();
                HashMap<String, String> assignee = new HashMap<String, String>();
                assignee.put("userId", historicTaskInstance.getOriginalAssignee());
                assignee.put("deptId", historicTaskInstance.getOrganId());
                assignees.add(assignee);
                for (int j = i + 1; j < hisTaskList.size(); ++j) {
                    historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(j);
                    if (start.getTime() > historicTaskInstance.getEndTime().getTime()) break block0;
                    if (historicTaskInstance.getCreateTime().compareTo(start) < 0) {
                        start = historicTaskInstance.getCreateTime();
                    }
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put("userId", historicTaskInstance.getOriginalAssignee());
                    temp.put("deptId", historicTaskInstance.getOrganId());
                    assignees.add(temp);
                }
                break;
            }
        }
        return assignees.stream().distinct().collect(Collectors.toList());
    }

    public BpmResponseResult delegateTask(String taskId, Map<String, String> userInfo) {
        taskId = this.getRealTaskId(taskId);
        this.taskService.delegateTask(taskId, userInfo.get("userId"), userInfo.values().toString());
        this.activityRedisTimerService.updateTimeOutModel(taskId, Collections.singletonList(userInfo), null, 1);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult entrustTask(String taskId, Map<String, String> userInfo, Map<String, String> mandataryInfo) {
        ArrayList<Map<String, String>> userList = new ArrayList<Map<String, String>>();
        userList.add(userInfo);
        ArrayList<Map<String, String>> mandatartyList = new ArrayList<Map<String, String>>();
        mandatartyList.add(mandataryInfo);
        taskId = this.getRealTaskId(taskId);
        if (HussarUtils.isEmpty((Object)taskId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotStart(), null);
        }
        if (HussarUtils.isEmpty(userInfo) || HussarUtils.isEmpty(mandataryInfo)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        if (!this.auditAuthority(Collections.singletonList(userInfo), taskId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoAuthorityTransferTask(), null);
        }
        if (userInfo.equals(mandataryInfo)) {
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        if (!this.auditAuthority(mandatartyList, taskId)) {
            this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, userList, mandatartyList, false, false));
            this.activityRedisTimerService.updateTimeOutModel(taskId, Collections.singletonList(mandataryInfo), userInfo, 0);
            SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
            sysActUrgeTask.setReceiveUser(mandataryInfo.get("userId"));
            this.sysActUrgeTaskService.update((Object)sysActUrgeTask, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId)).eq(SysActUrgeTask::getReceiveUser, (Object)userInfo.get("userId")));
        } else {
            this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, userList, null, false, true));
            this.activityRedisTimerService.updateTimeOutModel(taskId, null, userInfo, 0);
            this.sysActUrgeTaskService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId)).eq(SysActUrgeTask::getReceiveUser, (Object)userInfo.get("userId")));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult entrustTask(String taskId, List<Map<String, String>> mandatarysInfo, int state) {
        if (HussarUtils.isEmpty((Object)(taskId = this.getRealTaskId(taskId))) || HussarUtils.isEmpty(mandatarysInfo)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        if ("2".equals(task.getTaskType())) {
            this.assistService.assistTaskAddAssignee(taskId, mandatarysInfo, state == 1);
        }
        if (state != 0 && mandatarysInfo.size() > 1 && this.isMulti(task) == 2) {
            return InstallResult.getResult((String)String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), (String)String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), null);
        }
        this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, null, mandatarysInfo, state == 0, false));
        List list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(taskId)));
        if (list != null && !list.isEmpty()) {
            String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                list.remove(i);
            }
            List receiveUsers = mandatarysInfo.stream().map(mandataryInfo -> (String)mandataryInfo.get("userId")).collect(Collectors.toList());
            ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
            for (String receiveUser : receiveUsers) {
                for (SysActUrgeTask urgeTask : list) {
                    SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                    saveUrgeTask.setTaskId(urgeTask.getTaskId());
                    saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                    saveUrgeTask.setProcName(urgeTask.getProcName());
                    saveUrgeTask.setTaskName(urgeTask.getTaskName());
                    saveUrgeTask.setSendUser(urgeTask.getSendUser());
                    saveUrgeTask.setReceiveUser(receiveUser);
                    saveUrgeTask.setSendTime(urgeTask.getSendTime());
                    saveUrgeTask.setFormKey(urgeTask.getFormKey());
                    saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                    saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                    saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                    saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                    saveList.add(saveUrgeTask);
                }
            }
            if (state == 1) {
                this.sysActUrgeTaskService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(taskId)));
            }
            this.sysActUrgeTaskService.saveBatch(saveList);
            this.addUrgeTask(task, mandatarysInfo);
        }
        this.activityRedisTimerService.updateTimeOutModel(taskId, mandatarysInfo, null, state);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult freeJump(String taskId, String activitiId, Map<String, String> userInfo, List<Map<String, String>> assigneesInfo, Map<String, String> assigneeMap, boolean canRejectToMainProcess, boolean isSubmit, String comment, Map<String, Object> map, boolean isAuditAuthority) {
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(taskId);
        taskId = realTaskId.getTaskId();
        Map<String, String> mandataryInfo = realTaskId.getMandataryInfo();
        CommonPrepareCmd.PrepareReturn prepareReturn = (CommonPrepareCmd.PrepareReturn)this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(taskId, userInfo, mandataryInfo, isAuditAuthority));
        mandataryInfo = prepareReturn.getMandatorInfo();
        String taskState = prepareReturn.getTaskState();
        TaskRejectModel taskRejectModel = new TaskRejectModel(userInfo, mandataryInfo, comment, isSubmit, taskId, "freejump", activitiId, Boolean.valueOf(false), map);
        taskRejectModel.setAssigneesInfo(assigneesInfo);
        taskRejectModel.setAssigneeMap(assigneeMap);
        taskRejectModel.setCanRejectToMainProcess(canRejectToMainProcess);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        this.freeJumpDataPush(taskRejectModel.getTask(), comment, userInfo, taskRejectModel.getAllAffectedTaskIds(), mandataryInfo, taskState);
        this.cancelNodeRevoke(taskRejectModel.getTask(), taskRejectModel.getCancelTaskDefKeys());
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(HussarUtils.isEmpty(mandataryInfo) ? userInfo : mandataryInfo, taskRejectModel.getProcInsId(), taskRejectModel.getTask().getTaskDefinitionKey(), taskRejectModel.getTask().getSubProcessKey(), taskRejectModel.getMap()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult multiInstanceAddAssignee(String taskId, List<Map<String, String>> assigneeInfo) {
        taskId = this.getRealTaskId(taskId);
        if (HussarUtils.isEmpty(assigneeInfo)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        int num = this.isMulti(task);
        if (num != 2) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotMultiCantAddAssignee(), null);
        }
        String outTimeType = null;
        long dueTime = 0L;
        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            FlowElement element = bm.getFlowElement(task.getTaskDefinitionKey());
            List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
            if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy)) {
                outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
            }
            dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
        }
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        variableMap.put("old_appoint_assignee", task.getTaskLocalVariables().get("old_appoint_assignee"));
        variableMap.put("complete_type", task.getTaskLocalVariables().get("complete_type"));
        Map newTaskIdMap = (Map)this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), assigneeInfo, dueTime, outTimeType, variableMap));
        List list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId));
        if (list != null && !list.isEmpty()) {
            String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                list.remove(i);
            }
            ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
            for (Map<String, String> receiveUser : assigneeInfo) {
                String newTaskId = (String)newTaskIdMap.get(receiveUser);
                for (SysActUrgeTask urgeTask : list) {
                    SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                    saveUrgeTask.setTaskId(Long.valueOf(Long.parseLong(newTaskId)));
                    saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                    saveUrgeTask.setProcName(urgeTask.getProcName());
                    saveUrgeTask.setTaskName(urgeTask.getTaskName());
                    saveUrgeTask.setSendUser(urgeTask.getSendUser());
                    String userId = receiveUser.get("userId");
                    String userDept = receiveUser.get("deptId");
                    saveUrgeTask.setReceiveUser(userId);
                    saveUrgeTask.setReceiveDeptId(userDept);
                    saveUrgeTask.setSendTime(urgeTask.getSendTime());
                    saveUrgeTask.setFormKey(urgeTask.getFormKey());
                    saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                    saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                    saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                    saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                    saveList.add(saveUrgeTask);
                }
            }
            this.sysActUrgeTaskService.saveBatch(saveList);
            this.addUrgeTask(task, assigneeInfo);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult taskAddAssignee(String taskId, List<Map<String, String>> assigneesInfo) {
        int num;
        taskId = this.getRealTaskId(taskId);
        if (HussarUtils.isEmpty(assigneesInfo)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        if ("2".equals(task.getTaskType())) {
            this.assistService.assistTaskAddAssignee(taskId, assigneesInfo, false);
        }
        if ((num = this.isMulti(task)) != 2) {
            this.entrustTask(taskId, assigneesInfo, 0);
        } else {
            List list;
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).list();
            for (Task runningTask : tasks) {
                if (!HussarUtils.isNotEmpty((Object)runningTask.getAssignee())) continue;
                assigneesInfo.remove(runningTask.getAssignee());
            }
            String outTimeType = null;
            long dueTime = 0L;
            if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
                FlowElement element = bm.getFlowElement(task.getTaskDefinitionKey());
                List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
                if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy)) {
                    outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
                }
                dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
            }
            Map newTaskIdMap = null;
            if (HussarUtils.isNotEmpty(assigneesInfo)) {
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                variableMap.put("old_appoint_assignee", task.getTaskLocalVariables().get("old_appoint_assignee"));
                variableMap.put("complete_type", task.getTaskLocalVariables().get("complete_type"));
                newTaskIdMap = (Map)this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), assigneesInfo, dueTime, outTimeType, variableMap));
            }
            if ((list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId))) != null && !list.isEmpty()) {
                String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
                HashSet<String> set = new HashSet<String>();
                for (int i = list.size() - 1; i >= 0; --i) {
                    set.add(((SysActUrgeTask)list.get(i)).getReceiveUser());
                    if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                    list.remove(i);
                }
                List receiveUsers = assigneesInfo.stream().map(assigneeInfo -> (String)assigneeInfo.get("userId")).collect(Collectors.toList());
                ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
                for (String receiveUser : receiveUsers) {
                    String newTaskId;
                    if (set.contains(receiveUser) || (newTaskId = (String)newTaskIdMap.get(receiveUser)) == null) continue;
                    for (SysActUrgeTask urgeTask : list) {
                        SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                        saveUrgeTask.setTaskId(Long.valueOf(Long.parseLong(newTaskId)));
                        saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                        saveUrgeTask.setProcName(urgeTask.getProcName());
                        saveUrgeTask.setTaskName(urgeTask.getTaskName());
                        saveUrgeTask.setSendUser(urgeTask.getSendUser());
                        saveUrgeTask.setReceiveUser(receiveUser);
                        saveUrgeTask.setSendTime(urgeTask.getSendTime());
                        saveUrgeTask.setFormKey(urgeTask.getFormKey());
                        saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                        saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                        saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                        saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                        saveList.add(saveUrgeTask);
                    }
                }
                this.sysActUrgeTaskService.saveBatch(saveList);
                this.addUrgeTask(task, assigneesInfo);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        taskId = this.getRealTaskId(taskId);
        Task task = this.getTask(taskId, "0");
        JSONArray json = new JSONArray();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        if (processDefinition == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                json.add((Object)object);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
    }

    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        taskId = this.getRealTaskId(taskId);
        JSONArray json = new JSONArray();
        List<Map<String, String>> users = this.getAssigneeByTaskId(taskId);
        json.add(users);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult addAssignees(String taskId, String businessId, List<Map<String, String>> usersInfo) {
        taskId = this.getRealTaskId(taskId);
        if (HussarUtils.isEmpty(usersInfo)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(taskId, usersInfo));
            this.activityRedisTimerService.updateTimeOutModel(taskId, usersInfo, null, 0);
        } else {
            if (businessId == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
            if (tasks.isEmpty()) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
            }
            for (Task task : tasks) {
                this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(task.getId(), usersInfo));
                this.activityRedisTimerService.updateTimeOutModel(task.getId(), usersInfo, null, 0);
            }
        }
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getAppointAssigneesSuccess(), null);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        Object level;
        String appointAssignees;
        taskId = this.getRealTaskId(taskId);
        Task task = this.getTaskWithOutCheckSuspended(taskId, "2");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("bpm_submit_source", task.getTaskDefinitionKey());
        Object publicAppointAssignee = task.getProcessVariables().get("public_appoint_assignee");
        if (publicAppointAssignee != null && HussarUtils.isNotEmpty((Object)(appointAssignees = (String)((Map)publicAppointAssignee).get(nodeId)))) {
            HashSet<String> users = new HashSet<String>(Arrays.asList(appointAssignees.split(",")));
            JSONArray jsonArray = new JSONArray();
            if (!users.isEmpty()) {
                jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        if (HussarUtils.isNotEmpty((Object)task.getProcessVariables()) && (level = task.getProcessVariables().get("security_level")) != null) {
            map.put("security_level", level);
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        HashMap<String, String> userInfo = new HashMap<String, String>();
        if (HussarUtils.isEmpty((Object)map.get("userId"))) {
            userInfo.put("userId", null);
        } else {
            userInfo.put("userId", map.get("userId").toString());
        }
        if (HussarUtils.isEmpty((Object)map.get("deptId"))) {
            userInfo.put("deptId", null);
        } else {
            userInfo.put("deptId", map.get("deptId").toString());
        }
        AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, task, userInfo, nodeId, bm, task.getProcessDefinitionId(), tenantId, map);
        List<Map<String, String>> usersInfo = AnalyticalModelUtil.getNextCandidateUser(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, task.getSubProcessKey(), tenantId, map, task);
        if (!usersInfo.isEmpty()) {
            Set users = usersInfo.stream().map(a -> (String)a.get("userId")).collect(Collectors.toSet());
            jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList(users), tenantId));
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeIdByMobile(String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        Object level;
        String appointAssignees;
        taskId = this.getRealTaskId(taskId);
        Task task = this.getTaskWithOutCheckSuspended(taskId, "2");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("bpm_submit_source", task.getTaskDefinitionKey());
        Object publicAppointAssignee = task.getProcessVariables().get("public_appoint_assignee");
        if (publicAppointAssignee != null && HussarUtils.isNotEmpty((Object)(appointAssignees = (String)((Map)publicAppointAssignee).get(nodeId)))) {
            HashSet<String> users = new HashSet<String>(Arrays.asList(appointAssignees.split(",")));
            JSONArray jsonArray = new JSONArray();
            if (!users.isEmpty()) {
                jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        if (HussarUtils.isNotEmpty((Object)task.getProcessVariables()) && (level = task.getProcessVariables().get("security_level")) != null) {
            map.put("security_level", level);
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        HashMap<String, String> userInfo = new HashMap<String, String>();
        if (HussarUtils.isEmpty((Object)map.get("userId"))) {
            userInfo.put("userId", null);
        } else {
            userInfo.put("userId", map.get("userId").toString());
        }
        if (HussarUtils.isEmpty((Object)map.get("deptId"))) {
            userInfo.put("deptId", null);
        } else {
            userInfo.put("deptId", map.get("deptId").toString());
        }
        AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, task, userInfo, nodeId, bm, task.getProcessDefinitionId(), tenantId, map);
        List<Map<String, String>> usersInfo = AnalyticalModelUtil.getNextCandidateUser(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, task.getSubProcessKey(), tenantId, map, task);
        if (!usersInfo.isEmpty()) {
            jsonArray.addAll(usersInfo);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processKey, String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        List<Map<String, String>> assignee = this.getAssigneeByTaskId(taskId = this.getRealTaskId(taskId));
        if (HussarUtils.isNotEmpty(assignee)) {
            map = new HashMap<String, Object>();
            map.put("userId", assignee.get(0).get("userId"));
            map.put("deptId", assignee.get(0).get("deptId"));
        }
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            return this.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, tenantId, map);
        }
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
            }
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            StartEvent startEvent = new StartEvent();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                break;
            }
            String taskDefinitionKey = null;
            List sequenceFlowList = startEvent.getOutgoingFlows();
            String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
            FlowElement flowElement = bpmnModel.getFlowElement(targetRef);
            if (flowElement instanceof UserTask) {
                taskDefinitionKey = flowElement.getId();
            }
            if (flowElement instanceof ExclusiveGateway) {
                taskDefinitionKey = null;
            }
            if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("bpm_submit_source", taskDefinitionKey);
            JSONArray jsonArray = new JSONArray();
            List<Object> usersInfo = new ArrayList();
            try {
                HashMap<String, String> userInfo = new HashMap<String, String>();
                userInfo.put("userId", map.containsKey("userId") ? map.get("userId").toString() : "");
                userInfo.put("deptId", map.containsKey("deptId") ? map.get("deptId").toString() : "");
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, userInfo, nodeId, bpmnModel, processDefinitionId, tenantId, map);
                usersInfo = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bpmnModel, nodeId, null, tenantId, map, null);
            }
            catch (PropertyNotFoundException userInfo) {
                // empty catch block
            }
            if (!usersInfo.isEmpty()) {
                Set users = usersInfo.stream().map(a -> (String)a.get("userId")).collect(Collectors.toSet());
                jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList(users), tenantId));
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeIdByMobile(String processKey, String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        List<Map<String, String>> assignee = this.getAssigneeByTaskId(taskId = this.getRealTaskId(taskId));
        if (HussarUtils.isNotEmpty(assignee)) {
            map = new HashMap<String, Object>();
            map.put("userId", assignee.get(0).get("userId"));
            map.put("deptId", assignee.get(0).get("deptId"));
        }
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            return this.queryNextAssigneeByTaskIdAndNodeIdByMobile(taskId, nodeId, tenantId, map);
        }
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
            }
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            StartEvent startEvent = new StartEvent();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                break;
            }
            String taskDefinitionKey = null;
            List sequenceFlowList = startEvent.getOutgoingFlows();
            String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
            FlowElement flowElement = bpmnModel.getFlowElement(targetRef);
            if (flowElement instanceof UserTask) {
                taskDefinitionKey = flowElement.getId();
            }
            if (flowElement instanceof ExclusiveGateway) {
                taskDefinitionKey = null;
            }
            if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("bpm_submit_source", taskDefinitionKey);
            JSONArray jsonArray = new JSONArray();
            List<Object> usersInfo = new ArrayList();
            try {
                HashMap<String, String> userInfo = new HashMap<String, String>();
                userInfo.put("userId", map.containsKey("userId") ? map.get("userId").toString() : "");
                userInfo.put("deptId", map.containsKey("deptId") ? map.get("deptId").toString() : "");
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, userInfo, nodeId, bpmnModel, processDefinitionId, tenantId, map);
                usersInfo = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bpmnModel, nodeId, null, tenantId, map, null);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            if (!usersInfo.isEmpty()) {
                jsonArray.addAll(usersInfo);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
    }

    public List<BpmTreeModel> queryNodeAssigneeAndDept(NodeAssigneeQueryDto nodeAssigneeQueryDto, String tenantId) {
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        List<Map<String, String>> usersInfo = this.queryNodeAssignee(nodeAssigneeQueryDto.getProcessKey(), nodeAssigneeQueryDto.getTaskId(), nodeAssigneeQueryDto.getNodeId(), null, nodeAssigneeQueryDto.getUserInfo());
        if (HussarUtils.isNotEmpty(usersInfo)) {
            List users = usersInfo.stream().map(a -> (String)a.get("userId")).collect(Collectors.toList());
            List list = this.iAssigneeChooseService.queryAssigneeAndDept(users, nodeAssigneeQueryDto.getOrganName(), null);
            BpmResponseResult res = this.queryOrganTree(nodeAssigneeQueryDto.getProcessKey(), nodeAssigneeQueryDto.getTaskId(), nodeAssigneeQueryDto.getNodeId(), nodeAssigneeQueryDto.getUserId(), nodeAssigneeQueryDto.getDeptId(), true);
            JSONArray array = res.getResult();
            block0: for (BpmTreeModel model : list) {
                if ("organ".equals(model.getType())) {
                    for (Object obj : array) {
                        if (!String.valueOf(obj).equals(model.getId())) continue;
                        result.add(model);
                        continue block0;
                    }
                    continue;
                }
                result.add(model);
            }
            return result;
        }
        return new ArrayList<BpmTreeModel>();
    }

    public IPage<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> page, NodeAssigneeQueryDto nodeAssigneeQueryDto, String tenantId) {
        List<Map<String, String>> usersInfo = this.queryNodeAssignee(nodeAssigneeQueryDto.getProcessKey(), nodeAssigneeQueryDto.getTaskId(), nodeAssigneeQueryDto.getNodeId(), null, nodeAssigneeQueryDto.getUserInfo());
        if (HussarUtils.isNotEmpty(usersInfo)) {
            return this.iAssigneeChooseService.queryNodeAssigneeListByPage(page, usersInfo, nodeAssigneeQueryDto, null);
        }
        return page.setRecords(new ArrayList());
    }

    public BpmResponseResult getTaskVariable(String taskId) {
        List<Variables> variableList = this.taskEngineMapper.getTaskVariables(taskId);
        Map<Object, Object> map = new HashMap();
        if (!HussarUtils.isNotEmpty(variableList)) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        map = this.traverseVariables(variableList);
        map.put("taskId", taskId);
        ArrayList<Map<Object, Object>> taskVarList = new ArrayList<Map<Object, Object>>();
        taskVarList.add(map);
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll(taskVarList);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult getProcessVariable(String processInsId, String businessKey) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)(processInsId = this.getProcessInsId(businessKey)))) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        Map<Object, Object> map = new HashMap();
        ArrayList varList = new ArrayList();
        JSONArray jsonArray = new JSONArray();
        List<Variables> variableList = this.taskEngineMapper.getProcessVariables(processInsId);
        map = this.traverseVariables(variableList);
        varList.add(map);
        jsonArray.addAll(varList);
        List taskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByTaskCreateTime()).asc()).list();
        for (HistoricTaskInstance historicTaskInstance : taskList) {
            BpmResponseResult result = this.getTaskVariable(historicTaskInstance.getId());
            Object obj = result.getResult().get(0);
            jsonArray.add(obj);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public Map<String, Object> traverseVariables(List<Variables> variableList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Variables variables : variableList) {
            if (map.containsKey(variables.getName())) continue;
            if ("string".equals(variables.getVariableType()) || "json".equals(variables.getVariableType()) || "uuid".equals(variables.getVariableType())) {
                map.put(variables.getName(), variables.getTextValue());
                continue;
            }
            if ("integer".equals(variables.getVariableType()) || "boolean".equals(variables.getVariableType()) || "date".equals(variables.getVariableType()) || "long".equals(variables.getVariableType()) || "short".equals(variables.getVariableType())) {
                map.put(variables.getName(), variables.getLongValue());
                continue;
            }
            if ("double".equals(variables.getVariableType())) {
                map.put(variables.getName(), variables.getDoubleValue());
                continue;
            }
            if ("serializable".equals(variables.getVariableType()) || "bytes".equals(variables.getVariableType())) {
                byte[] bytes = variables.getBytes();
                Object obj = null;
                ByteArrayInputStream bis = null;
                ObjectInputStream ois = null;
                try {
                    bis = new ByteArrayInputStream(bytes);
                    ois = new ObjectInputStream(bis);
                    obj = ois.readObject();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new PublicClientException(this.bpmConstantProperties.getErrorFormatTransfer());
                }
                finally {
                    try {
                        bis.close();
                        ois.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                String jsonString = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                String str = "[" + jsonString + "]";
                JSONArray objects = JSONArray.parseArray((String)str);
                map.put(variables.getName(), objects);
                continue;
            }
            map.put(variables.getName(), "");
        }
        return map;
    }

    public BpmResponseResult updateTaskVariable(String taskId, List<Map<String, Object>> variableList) {
        try {
            if (HussarUtils.isNotEmpty(variableList)) {
                for (Map<String, Object> map : variableList) {
                    Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
                    if (task != null) {
                        this.taskService.setVariables(taskId, map);
                        continue;
                    }
                    this.processEngine.getManagementService().executeCommand((Command)new updateHisTaskVariableCmd(taskId, map));
                }
                return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getSuccessUpdate(), null);
            }
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(this.bpmConstantProperties.getErrorUpdate());
        }
    }

    public BpmResponseResult updateProcessVariable(String processInsId, String businessKey, List<Map<String, Object>> variableList) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)(processInsId = this.getProcessInsId(businessKey)))) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        try {
            for (Map<String, Object> variableMap : variableList) {
                List executionList = this.runtimeService.createExecutionQuery().processInstanceId(processInsId).list();
                if (executionList.size() > 0) {
                    this.runtimeService.setVariables(processInsId, variableMap);
                    continue;
                }
                this.processEngine.getManagementService().executeCommand((Command)new updateHisProcessVariableCmd(processInsId, variableMap));
            }
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(this.bpmConstantProperties.getErrorUpdate());
        }
    }

    public BpmResponseResult getCommentByTaskId(List<String> taskIds) {
        try {
            JSONArray jsonArray = new JSONArray();
            List<Long> longTaskIds = taskIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List<Map<String, String>> taskComments = this.taskEngineMapper.getTaskComments(longTaskIds);
            jsonArray.addAll(taskComments);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(this.bpmConstantProperties.getSelectFailed());
        }
    }

    public BpmResponseResult getComments(String processInsId, String businessKey) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)(processInsId = this.getProcessInsId(businessKey)))) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        try {
            List taskInstanceList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).list();
            JSONArray jsonArray = new JSONArray();
            List<Map<String, String>> processComments = this.taskEngineMapper.getProcessComments(processInsId);
            jsonArray.add(processComments);
            ArrayList<Long> taskIds = new ArrayList<Long>();
            for (HistoricTaskInstance taskInstance : taskInstanceList) {
                taskIds.add(Long.parseLong(taskInstance.getId()));
            }
            List<Map<String, String>> taskComments = this.taskEngineMapper.getTaskComments(taskIds);
            jsonArray.add(taskComments);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(this.bpmConstantProperties.getSelectFailed());
        }
    }

    public BpmResponseResult queryOrganTree(String processDefinitionKey, String taskId, String nodeId, String userId, String deptId, boolean query) {
        List<Object> result = new ArrayList();
        List<Object> userIds = new ArrayList();
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)nodeId)) {
            userMap.put("userId", userId);
            userMap.put("deptId", deptId);
            BpmResponseResult assigneeResult = this.queryNextAssigneeByTaskIdAndNodeId(processDefinitionKey, taskId, nodeId, null, userMap);
            JSONArray assigneeArray = assigneeResult.getResult();
            for (Object assigneeArr : assigneeArray) {
                JSONObject assigneeMap = JSONObject.parseObject((String)JSON.toJSONString(assigneeArr));
                userIds.add((String)assigneeMap.get("id"));
            }
        } else {
            BpmResponseResult nodeResult = this.queryNextNode(processDefinitionKey, taskId, false, false, null);
            JSONArray nodeArray = nodeResult.getResult();
            for (Object arr : nodeArray) {
                JSONObject map = JSONObject.parseObject((String)JSON.toJSONString(arr));
                BpmResponseResult assigneeResult = this.queryNextAssigneeByTaskIdAndNodeId(processDefinitionKey, taskId, map.get("id").toString(), null, userMap);
                JSONArray assigneeArray = assigneeResult.getResult();
                for (Object assigneeArr : assigneeArray) {
                    JSONObject assigneeMap = JSONObject.parseObject((String)JSON.toJSONString(assigneeArr));
                    userIds.add((String)assigneeMap.get("id"));
                }
            }
        }
        if ((userIds = userIds.stream().distinct().collect(Collectors.toList())).size() < 1) {
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDefaultSuccessMessage(), (JSONArray)JSONArray.parseArray((String)JSON.toJSONString(result)));
        }
        if (query) {
            List allOrgans = this.iAssigneeChooseService.getAllOrganMain();
            ArrayList<String> list = new ArrayList<String>();
            List assigneeOrgans = this.iAssigneeChooseService.getAssigneeOrgan(userIds);
            assigneeOrgans = assigneeOrgans.stream().distinct().collect(Collectors.toList());
            HashMap<String, String> organMap = new HashMap<String, String>();
            for (Map allOrganMap : allOrgans) {
                organMap.put(String.valueOf(allOrganMap.get("ORGAN_ID")), String.valueOf(allOrganMap.get("PARENT_ID")));
            }
            for (String assigneeOrgan : assigneeOrgans) {
                list.add(assigneeOrgan);
                this.getAllAssigneeOrgans(assigneeOrgan, organMap, list);
            }
            list = list.stream().distinct().collect(Collectors.toList());
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDefaultSuccessMessage(), (JSONArray)JSONArray.parseArray((String)JSON.toJSONString(list)));
        }
        List assigneeOrgan = this.iAssigneeChooseService.getAssigneeOrgan(userIds);
        result = TaskEngineServiceImpl.screenTree(this.listWithTree(), assigneeOrgan);
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDefaultSuccessMessage(), (JSONArray)JSONArray.parseArray((String)JSON.toJSONString(result)));
    }

    protected List<BpmTreeModel> listWithTree() {
        List<BpmTreeModel> allDept = this.assigneeChooseMapper.getAllDept();
        List<BpmTreeModel> resultList = allDept.stream().filter(bpmTreeModel -> !bpmTreeModel.getIsLeaf()).map(dept -> {
            dept.setChildrenList(this.getChildrens((BpmTreeModel)dept, allDept));
            return dept;
        }).sorted((dept1, dept2) -> {
            int sort1 = HussarUtils.isEmpty((Object)dept1.getSort()) ? 0 : Integer.parseInt(dept1.getSort());
            int sort2 = HussarUtils.isEmpty((Object)dept2.getSort()) ? 0 : Integer.parseInt(dept2.getSort());
            return sort1 - sort2;
        }).collect(Collectors.toList());
        return resultList;
    }

    protected List<BpmTreeModel> getChildrens(BpmTreeModel bpmTreeModel, List<BpmTreeModel> list) {
        List<BpmTreeModel> resultList = list.stream().filter(temp -> temp.getParentId().equals(bpmTreeModel.getId())).map(bpmTreeModelChild -> {
            bpmTreeModel.setChildrenList(this.getChildrens((BpmTreeModel)bpmTreeModelChild, list));
            return bpmTreeModelChild;
        }).sorted((dept1, dept2) -> {
            int sort1 = HussarUtils.isEmpty((Object)dept1.getSort()) ? 0 : Integer.parseInt(dept1.getSort());
            int sort2 = HussarUtils.isEmpty((Object)dept2.getSort()) ? 0 : Integer.parseInt(dept2.getSort());
            return sort1 - sort2;
        }).collect(Collectors.toList());
        return resultList;
    }

    protected static List<BpmTreeModel> screenTree(List<BpmTreeModel> treeModels, List<String> list) {
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        if (HussarUtils.isNotEmpty(treeModels) && HussarUtils.isNotEmpty(list)) {
            treeModels.stream().filter(bpmTreeModel -> "11".equals(bpmTreeModel.getParentId())).forEach(treeModel -> {
                List childrens = treeModel.getChildrenList();
                BpmTreeModel realChild = TaskEngineServiceImpl.getRealChild(treeModel, childrens, list);
                if (HussarUtils.isNotEmpty((Object)realChild)) {
                    result.add(realChild);
                }
            });
        }
        return result;
    }

    protected static BpmTreeModel getRealChild(BpmTreeModel bpmTreeModel, List<BpmTreeModel> bpmTreeModelList, List<String> list) {
        if (HussarUtils.isNotEmpty(bpmTreeModelList)) {
            ArrayList<BpmTreeModel> addTreeList = new ArrayList<BpmTreeModel>();
            for (BpmTreeModel b : bpmTreeModelList) {
                List childrenList;
                BpmTreeModel realChild = TaskEngineServiceImpl.getRealChild(b, childrenList = b.getChildrenList(), list);
                if (!HussarUtils.isNotEmpty((Object)realChild)) continue;
                addTreeList.add(realChild);
            }
            if (HussarUtils.isNotEmpty(addTreeList)) {
                bpmTreeModel.setChildrenList(addTreeList);
                return bpmTreeModel;
            }
            if (list.contains(bpmTreeModel.getId())) {
                bpmTreeModel.setChildrenList(null);
                return bpmTreeModel;
            }
            return null;
        }
        if (list.contains(bpmTreeModel.getId())) {
            return bpmTreeModel;
        }
        return null;
    }

    private List<String> getAllAssigneeOrgans(String assigneeOrgan, Map<String, String> organMap, List<String> list) {
        if (HussarUtils.isNotEmpty((Object)organMap.get(assigneeOrgan))) {
            list.add(assigneeOrgan);
            this.getAllAssigneeOrgans(organMap.get(assigneeOrgan), organMap, list);
        }
        return list;
    }

    private List<String> getAllDeptOrgans(String assigneeOrgan, Map<String, Object> organMap, List<String> list) {
        if (HussarUtils.isNotEmpty((Object)organMap.get(assigneeOrgan))) {
            Map map = (Map)organMap.get(assigneeOrgan);
            if (!"3".equals(map.get("INST_ORGAN_TYPE"))) {
                list.add(assigneeOrgan);
            }
            this.getAllDeptOrgans(String.valueOf(map.get("PARENT_ID")), organMap, list);
        }
        return list;
    }

    public BpmResponseResult queryOrganTreeByOrganId(String processDefinitionKey, String taskId, String nodeId, String organId) {
        ArrayList<Map<String, String>> organs = new ArrayList();
        ArrayList<String> assigneesOrgans = new ArrayList<String>();
        List<Object> userIds = new ArrayList<String>();
        ArrayList ids = new ArrayList();
        List<Object> assigneeOrgans = new ArrayList<String>();
        ArrayList idsOrgans = new ArrayList();
        BpmResponseResult assigneeResult = this.queryNextAssigneeByTaskIdAndNodeIdByMobile(processDefinitionKey, taskId, nodeId, null, null);
        JSONArray assigneeArray = assigneeResult.getResult();
        for (Object assigneeArr : assigneeArray) {
            JSONObject assigneeMap = JSONObject.parseObject((String)JSON.toJSONString(assigneeArr));
            userIds.add((String)assigneeMap.get("userId"));
            assigneeOrgans.add((String)assigneeMap.get("deptId"));
        }
        userIds.addAll(ids);
        userIds = userIds.stream().distinct().collect(Collectors.toList());
        if (userIds.size() < 1) {
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDefaultSuccessMessage(), (JSONArray)JSONArray.parseArray((String)JSON.toJSONString(organs)));
        }
        List allOrgans = this.iAssigneeChooseService.getAllOrganInfo(organId);
        assigneeOrgans = assigneeOrgans.stream().distinct().collect(Collectors.toList());
        HashMap<String, Object> organMap = new HashMap<String, Object>();
        for (Map map : allOrgans) {
            organMap.put(String.valueOf(map.get("ORGAN_ID")), map);
        }
        for (String string : assigneeOrgans) {
            assigneesOrgans.add(string);
            this.getAllDeptOrgans(string, organMap, assigneesOrgans);
        }
        assigneesOrgans = assigneesOrgans.stream().distinct().collect(Collectors.toList());
        HashMap<String, Object> objOrganMap = new HashMap<String, Object>();
        for (Map allOrganMap : allOrgans) {
            objOrganMap.put(String.valueOf(allOrganMap.get("ORGAN_ID")), allOrganMap);
        }
        for (Map orgMap : allOrgans) {
            if (!organId.equals(String.valueOf(orgMap.get("PARENT_ID")))) continue;
            this.getAllUsers(String.valueOf(orgMap.get("ORGAN_ID")), objOrganMap, userIds, organs, allOrgans, assigneesOrgans, organId);
        }
        List list = this.iAssigneeChooseService.getUserInfoByIds(userIds);
        for (Map map : list) {
            if (!"11".equals(String.valueOf(map.get("PARENT_ID")))) continue;
            map.put("PARENT_ID", "");
            organs.add(map);
        }
        organs = organs.stream().distinct().collect(Collectors.toList());
        Collections.sort(organs, (o1, o2) -> {
            String t1 = (String)o1.get("ORGAN_TYPE");
            String t2 = (String)o2.get("ORGAN_TYPE");
            return t2.compareTo(t1);
        });
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDefaultSuccessMessage(), (JSONArray)JSONArray.parseArray((String)JSON.toJSONString(organs)));
    }

    private List<Map<String, String>> getAllUsers(String organ, Map<String, Object> organMap, List<String> userIds, List<Map<String, String>> list, List<Map<String, String>> allOrgans, List<String> assigneeOrgans, String organId) {
        Map map = (Map)organMap.get(organ);
        if (HussarUtils.isNotEmpty((Object)map)) {
            if ("user".equals(map.get("ORGAN_TYPE")) && userIds.contains(String.valueOf(map.get("ORGAN_ID")))) {
                map.put("PARENT_ID", map.get("PARENT_ID"));
                list.add(map);
            }
            if ("organ".equals(map.get("ORGAN_TYPE")) && !"3".equals(map.get("INST_ORGAN_TYPE")) && assigneeOrgans.contains(String.valueOf(map.get("ORGAN_ID")))) {
                list.add(map);
            } else if ("organ".equals(map.get("ORGAN_TYPE")) && "3".equals(map.get("INST_ORGAN_TYPE")) && assigneeOrgans.contains(String.valueOf(map.get("ORGAN_ID")))) {
                list.add(map);
            }
        }
        return list;
    }

    public BpmResponseResult deleteComment(String taskId) {
        try {
            this.taskEngineMapper.deleteComment(taskId);
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDeleteSuccess(), null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(this.bpmConstantProperties.getDeleteFail());
        }
    }

    public String getProcessInsId(String businessKey) {
        HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (instance != null) {
            return instance.getId();
        }
        return null;
    }

    private List<Map<String, String>> queryNodeAssignee(String processKey, String taskId, String nodeId, String tenantId, Map<String, String> userInfo) {
        if (HussarUtils.isNotEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            BpmnModel bm;
            Object level;
            List appointAssignees;
            Task task = this.getTaskWithOutCheckSuspended(taskId, "2");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userId", userInfo.get("userId"));
            map.put("deptId", userInfo.get("deptId"));
            map.put("bpm_submit_source", task.getTaskDefinitionKey());
            Object publicAppointAssignee = task.getProcessVariables().get("public_appoint_assignee");
            if (publicAppointAssignee != null && HussarUtils.isNotEmpty((Object)(appointAssignees = (List)((Map)publicAppointAssignee).get(nodeId)))) {
                return appointAssignees;
            }
            if (HussarUtils.isNotEmpty((Object)task.getProcessVariables()) && (level = task.getProcessVariables().get("security_level")) != null) {
                map.put("security_level", level);
            }
            if ((bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId())) == null) {
                throw new PublicClientException(this.bpmConstantProperties.getModelNotFound());
            }
            AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, task, userInfo, nodeId, bm, task.getProcessDefinitionId(), tenantId, map);
            List<Map<String, String>> usersInfo = AnalyticalModelUtil.getNextCandidateUser(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, task.getSubProcessKey(), tenantId, map, task);
            if (!usersInfo.isEmpty()) {
                return usersInfo;
            }
            return new ArrayList<Map<String, String>>();
        }
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                throw new PublicClientException(this.bpmConstantProperties.getModelNotFound());
            }
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            StartEvent startEvent = new StartEvent();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                break;
            }
            String taskDefinitionKey = null;
            List sequenceFlowList = startEvent.getOutgoingFlows();
            String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
            FlowElement flowElement = bpmnModel.getFlowElement(targetRef);
            if (flowElement instanceof UserTask) {
                taskDefinitionKey = flowElement.getId();
            }
            if (flowElement instanceof ExclusiveGateway) {
                taskDefinitionKey = null;
            }
            if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
                throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bpm_submit_source", taskDefinitionKey);
            map.put("userId", userInfo.get("userId"));
            map.put("deptId", userInfo.get("deptId"));
            AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, userInfo, nodeId, bpmnModel, processDefinitionId, tenantId, map);
            List<Map<String, String>> usersInfo = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bpmnModel, nodeId, null, tenantId, map, null);
            if (!usersInfo.isEmpty()) {
                return usersInfo;
            }
            return new ArrayList<Map<String, String>>();
        }
        throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
    }

    public BpmResponseResult queryAllAssignee(String procDefinitionKey, String taskDefinitionKey) {
        JSONObject jsonObject;
        String tenantId = "";
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(procDefinitionKey).getId();
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
        HashSet userIds = new HashSet();
        JSONArray jsonArray = new JSONArray();
        if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask)) continue;
                jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowElement.getId());
                jsonObject.put("name", (Object)flowElement.getName());
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, null, taskDefinitionKey, bm, processDefinitionId, tenantId, variableMap);
                List<Map<String, String>> usersInfo = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), null, tenantId, variableMap, null);
                userIds.addAll(usersInfo.stream().map(a -> (String)a.get("userId")).collect(Collectors.toSet()));
                jsonObject.put("assignee", usersInfo);
                jsonArray.add((Object)jsonObject);
            }
        } else {
            boolean isContain = false;
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask) || !flowElement.getId().equals(taskDefinitionKey)) continue;
                isContain = true;
                JSONObject jsonObject2 = new JSONObject();
                jsonObject2.put("id", (Object)flowElement.getId());
                jsonObject2.put("name", (Object)flowElement.getName());
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, null, taskDefinitionKey, bm, processDefinitionId, tenantId, variableMap);
                List<Map<String, String>> usersInfo = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), null, tenantId, variableMap, null);
                userIds.addAll(usersInfo.stream().map(a -> (String)a.get("userId")).collect(Collectors.toSet()));
                jsonObject2.put("assignee", usersInfo);
                jsonArray.add((Object)jsonObject2);
            }
            if (!isContain) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNodeNotFound(), null);
            }
        }
        Map userMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userIds), tenantId);
        for (int i = 0; i < jsonArray.size(); ++i) {
            jsonObject = jsonArray.getJSONObject(i);
            JSONArray users = jsonObject.getJSONArray("assignee");
            ArrayList user = new ArrayList();
            for (int j = 0; j < users.size(); ++j) {
                String userId = users.getString(j);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", userId);
                map.put("userName", (String)userMap.get(userId));
                user.add(map);
            }
            jsonObject.put("assignee", user);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryAllOfAssignee(String procDefinitionKey, String nodeId, String taskId, String personName) {
        JSONArray result = new JSONArray();
        String tenantId = "";
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(procDefinitionKey).getId();
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
        HashSet userIds = new HashSet();
        JSONArray jsonArray = new JSONArray();
        if (HussarUtils.isEmpty((Object)nodeId)) {
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowElement.getId());
                jsonObject.put("name", (Object)flowElement.getName());
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, null, nodeId, bm, processDefinitionId, tenantId, variableMap);
                List<Map<String, String>> usersInfo = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), null, tenantId, variableMap, null);
                userIds.addAll(usersInfo.stream().map(a -> (String)a.get("userId")).collect(Collectors.toSet()));
                jsonObject.put("assignee", usersInfo);
                jsonArray.add((Object)jsonObject);
            }
        } else {
            boolean isContain = false;
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask) || !flowElement.getId().equals(nodeId)) continue;
                isContain = true;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowElement.getId());
                jsonObject.put("name", (Object)flowElement.getName());
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, null, nodeId, bm, processDefinitionId, tenantId, variableMap);
                List<Map<String, String>> usersInfo = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), null, tenantId, variableMap, null);
                userIds.addAll(usersInfo.stream().map(a -> (String)a.get("userId")).collect(Collectors.toSet()));
                jsonObject.put("assignee", usersInfo);
                jsonArray.add((Object)jsonObject);
            }
            if (!isContain) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNodeNotFound(), null);
            }
        }
        List<Map<String, String>> userInfo = this.assigneeChooseMapper.getUserInfo(new ArrayList<String>(userIds), personName);
        HashMap<String, String> userMap = new HashMap<String, String>();
        for (Map<String, String> map : userInfo) {
            userMap.put(map.get("id"), map.get("name"));
        }
        for (Map<String, String> map : userInfo) {
            JSONObject jsonObject = new JSONObject();
            String deptId = this.iAssigneeChooseService.getSourceDeptIdByUserId(String.valueOf(map.get("id")), tenantId);
            jsonObject.put("assigneeId", (Object)map.get("id"));
            jsonObject.put("assigneeName", userMap.get(map.get("id")));
            if (HussarUtils.isNotEmpty((Object)deptId)) {
                jsonObject.put("deptId", (Object)deptId);
            } else {
                jsonObject.put("deptId", (Object)"1");
            }
            result.add((Object)jsonObject);
        }
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getDefaultSuccessMessage(), (JSONArray)result);
    }

    private List<Map<String, String>> getAssigneeByTaskId(String taskId) {
        taskId = this.getRealTaskId(taskId);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        List identityLinkList = this.taskService.getIdentityLinksType(taskId);
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                HashMap<String, String> user = new HashMap<String, String>();
                user.put("userId", identityLink.getUserId());
                user.put("deptId", identityLink.getOrganId());
                list.add(user);
            }
        }
        return list;
    }

    public ApiResponse<Map<String, Object>> queryHistoryActByTaskId(String taskId, String processInsId) {
        taskId = this.getRealTaskId(taskId);
        JSONArray json = new JSONArray();
        String newProcessInstanceId = processInsId;
        if (newProcessInstanceId == null) {
            Task task = this.getTask(taskId, "0");
            newProcessInstanceId = task.getProcessInstanceId();
        }
        try {
            List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(newProcessInstanceId)).orderByHistoricTaskInstanceEndTime().finished().desc()).list();
            if (list != null && !list.isEmpty()) {
                for (HistoricTaskInstance historyIns : list) {
                    JSONObject object = new JSONObject();
                    String tId = historyIns.getId();
                    if (tId.equals(taskId)) continue;
                    object.put("nodeId", (Object)historyIns.getTaskDefinitionKey());
                    object.put("nodeName", (Object)historyIns.getName());
                    object.put("taskId", (Object)tId);
                    object.put("endTime", historyIns.getEndTime() == null ? null : Long.valueOf(historyIns.getEndTime().getTime()));
                    json.add((Object)object);
                }
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put("count", list != null ? list.size() : 0);
            result.put("data", (Integer)json);
            return ApiResponse.success(result);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5386\u53f2\u73af\u8282\u4fe1\u606f\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public ApiResponse<JSONObject> getProcessDefinitionIdAndNodeId(String processKey, String taskId) {
        taskId = this.getRealTaskId(taskId);
        JSONObject object = new JSONObject();
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            if (definitionModel != null) {
                object.put("processDefinitionId", (Object)definitionModel.getId());
            }
        } else {
            Task task = this.getTask(taskId, "0");
            object.put("processDefinitionId", (Object)task.getProcessDefinitionId());
            object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
        }
        return ApiResponse.success((Object)object);
    }

    public BpmResponseResult queryTaskIdByBusinessId(String businessId) {
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        if (tasks != null) {
            for (Task task : tasks) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("name", (Object)task.getName());
                jsonObject.put("processInsId", (Object)task.getProcessInstanceId());
                json.add((Object)jsonObject);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private BpmResponseResult queryNextNode(String taskId, boolean isGetRevokeNode, boolean isGetWithGroup, Map<String, Object> lineCondition) {
        Map variables;
        taskId = this.getRealTaskId(taskId);
        Task task = this.getTaskWithOutCheckSuspended(taskId, isGetRevokeNode ? "1" : "0");
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        if (isGetRevokeNode && HussarUtils.isNotEmpty((Object)(variables = task.getTaskLocalVariables())) && HussarUtils.isNotEmpty(variables.get("reject_from"))) {
            String nodeId = String.valueOf(variables.get("reject_from"));
            for (String id : nodeId.split(",")) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)id);
                FlowElement flowElement = bm.getFlowElement(id);
                if (flowElement instanceof UserTask) {
                    jsonObject.put("type", (Object)"userTask");
                    jsonObject.put("allowSetParticipant", (Object)"true");
                } else if (flowElement instanceof CallActivity) {
                    jsonObject.put("type", (Object)"callActivity");
                }
                jsonObject.put("mustCheck", (Object)true);
                jsonObject.put("relatedNodes", new ArrayList());
                jsonObject.put("name", (Object)flowElement.getName());
                jsonArray.add((Object)jsonObject);
            }
            if (isGetWithGroup) {
                JSONArray group = new JSONArray();
                group.add((Object)jsonArray);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("data", (Object)group);
                jsonObject.put("mustCheckGroups", new ArrayList());
                JSONArray result = new JSONArray();
                result.add((Object)jsonObject);
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)result);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        UserTask userTask = (UserTask)bm.getFlowElement(task.getTaskDefinitionKey());
        if (userTask == null) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        List sequenceFlows = userTask.getOutgoingFlows();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (bm.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            resultMap = CommonCodeUtil.getGodAxeResult(null, userTask.getId(), historicProcessInstance.getBusinessKey(), task.getProcessDefinitionId());
        }
        if (task.getSubProcessKey() != null) {
            resultMap.put("sub_process_separate_variable", task.getSubProcessKey().split(":")[1]);
        }
        if (lineCondition != null) {
            resultMap.putAll(lineCondition);
        }
        HashMap<String, NodeMessage> nodeMessages = new HashMap<String, NodeMessage>();
        HashMap<String, SimpleGroupMessage> simpleGroupMessages = new HashMap<String, SimpleGroupMessage>();
        AnalyticalModelUtil.getSqlVariableMapWithOutExecution("", task, null, task.getTaskDefinitionKey(), bm, task.getProcessDefinitionId(), task.getTenantId(), resultMap);
        this.getUserTaskByCondition(jsonArray, bm, sequenceFlows, 0, userTask.getId(), resultMap, nodeMessages, simpleGroupMessages, null);
        if (isGetWithGroup) {
            JSONArray mustCheckGroups = this.getNodeRelationMessages(nodeMessages, jsonArray);
            JSONArray result = this.getNextNodeGroupMessage(((SequenceFlow)sequenceFlows.get(0)).getTargetRef(), simpleGroupMessages);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("data", (Object)result);
            jsonObject.put("mustCheckGroups", (Object)mustCheckGroups);
            jsonArray = new JSONArray();
            jsonArray.add((Object)jsonObject);
        } else {
            JSONArray result = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                if (jsonArray.getJSONObject(i).getString("type").contains("Gateway")) continue;
                result.add((Object)jsonArray.getJSONObject(i));
            }
            jsonArray = result;
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private BpmResponseResult queryNextNodeNewReturn(String taskId, boolean isGetRevokeNode, boolean isGetWithGroup, Map<String, Object> lineCondition) {
        taskId = this.getRealTaskId(taskId);
        Task task = this.getTaskWithOutCheckSuspended(taskId, isGetRevokeNode ? "1" : "0");
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        Map variables = task.getTaskLocalVariables();
        if (HussarUtils.isNotEmpty((Object)variables) && HussarUtils.isNotEmpty(variables.get("reject_from"))) {
            String nodeId = String.valueOf(variables.get("reject_from"));
            JSONArray results = new JSONArray();
            ArrayList<JSONObject> obj = new ArrayList<JSONObject>();
            for (String id : nodeId.split(",")) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)id);
                FlowElement flowElement = bm.getFlowElement(id);
                if (flowElement instanceof UserTask) {
                    jsonObject.put("type", (Object)"userTask");
                    jsonObject.put("allowSetParticipant", (Object)"true");
                } else if (flowElement instanceof CallActivity) {
                    jsonObject.put("type", (Object)"callActivity");
                }
                jsonObject.put("mustCheck", (Object)true);
                jsonObject.put("relatedNodes", new ArrayList());
                jsonObject.put("name", (Object)flowElement.getName());
                obj.add(jsonObject);
            }
            results.add(obj);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("data", (Object)results);
            jsonObject.put("mustCheckGroups", new ArrayList());
            jsonArray = new JSONArray();
            jsonArray.add((Object)jsonObject);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        UserTask userTask = (UserTask)bm.getFlowElement(task.getTaskDefinitionKey());
        if (userTask == null) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        List sequenceFlows = userTask.getOutgoingFlows();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (bm.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            resultMap = CommonCodeUtil.getGodAxeResult(null, userTask.getId(), historicProcessInstance.getBusinessKey(), task.getProcessDefinitionId());
        }
        if (task.getSubProcessKey() != null) {
            resultMap.put("sub_process_separate_variable", task.getSubProcessKey().split(":")[1]);
        }
        if (lineCondition != null) {
            resultMap.putAll(lineCondition);
        }
        HashMap<String, NodeMessage> nodeMessages = new HashMap<String, NodeMessage>();
        HashMap<String, SimpleGroupMessage> simpleGroupMessages = new HashMap<String, SimpleGroupMessage>();
        AnalyticalModelUtil.getSqlVariableMapWithOutExecution("", task, null, task.getTaskDefinitionKey(), bm, task.getProcessDefinitionId(), task.getTenantId(), resultMap);
        this.getUserTaskByCondition(jsonArray, bm, sequenceFlows, 0, userTask.getId(), resultMap, nodeMessages, simpleGroupMessages, null);
        if (isGetWithGroup) {
            JSONArray mustCheckGroups = this.getNodeRelationMessages(nodeMessages, jsonArray);
            JSONArray result = this.getNextNodeGroupMessage(((SequenceFlow)sequenceFlows.get(0)).getTargetRef(), simpleGroupMessages);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("data", (Object)result);
            jsonObject.put("mustCheckGroups", (Object)mustCheckGroups);
            jsonArray = new JSONArray();
            jsonArray.add((Object)jsonObject);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
    }

    private JSONArray getNextNodeGroupMessage(String firstNode, Map<String, SimpleGroupMessage> simpleGroupMessages) {
        ArrayList<SimpleGroupMessage> simpleGroupMessageList = new ArrayList<SimpleGroupMessage>();
        SimpleGroupMessage simpleGroupMessage = simpleGroupMessages.get(firstNode);
        simpleGroupMessageList.add(simpleGroupMessage);
        int i = 0;
        while (i < simpleGroupMessageList.size()) {
            SimpleGroupMessage groupMessage = (SimpleGroupMessage)simpleGroupMessageList.get(i);
            if (!groupMessage.childGroupIds.isEmpty()) {
                simpleGroupMessageList.remove(i);
                List<String> childIds = groupMessage.childGroupIds.get(0);
                groupMessage.childGroupIds.remove(0);
                for (String childId : childIds) {
                    SimpleGroupMessage child = simpleGroupMessages.get(childId);
                    SimpleGroupMessage simpleGroupMessage1 = new SimpleGroupMessage();
                    simpleGroupMessage1.groupId = groupMessage.groupId;
                    simpleGroupMessage1.childGroupIds = new ArrayList<List<String>>(groupMessage.childGroupIds);
                    simpleGroupMessage1.childGroupIds.addAll(child.childGroupIds);
                    simpleGroupMessage1.jsonObjects = new ArrayList<JSONObject>(groupMessage.jsonObjects);
                    simpleGroupMessage1.jsonObjects.addAll(child.jsonObjects);
                    simpleGroupMessageList.add(simpleGroupMessage1);
                }
                continue;
            }
            ++i;
        }
        JSONArray result = new JSONArray();
        for (SimpleGroupMessage groupMessage : simpleGroupMessageList) {
            List jsonObjects = groupMessage.jsonObjects.stream().filter(o -> !o.getString("type").contains("Gateway")).collect(Collectors.toList());
            result.add(jsonObjects);
        }
        return result;
    }

    private JSONArray getNodeRelationMessages(Map<String, NodeMessage> nodeMessages, JSONArray jsonArray) {
        if (nodeMessages.size() == 1) {
            jsonArray.getJSONObject(0).put("mustCheck", (Object)true);
            jsonArray.getJSONObject(0).put("relatedNodes", new ArrayList());
            return new JSONArray();
        }
        HashMap<String, JSONArray> mustCheckGroupMap = new HashMap<String, JSONArray>();
        JSONArray mustCheckGroups = new JSONArray();
        ArrayList<String> removeGroupIds = new ArrayList<String>();
        for (NodeMessage nodeMessage : nodeMessages.values()) {
            if (!"inclusiveGateway".equals(nodeMessage.getewayType)) continue;
            boolean isMustCheckGroup = true;
            for (String string : nodeMessage.childNodes) {
                if (nodeMessages.get((Object)string).conditionWithNextNode) continue;
                isMustCheckGroup = false;
            }
            if (isMustCheckGroup) {
                NodeMessage parent = nodeMessages.get(nodeMessage.parentNode);
                while (parent != null) {
                    if ("inclusiveGateway".equals(parent.getewayType)) {
                        for (String childNode : parent.childNodes) {
                            if (nodeMessages.get((Object)childNode).conditionWithNextNode) continue;
                            isMustCheckGroup = false;
                            break;
                        }
                        if (!isMustCheckGroup) break;
                    }
                    parent = nodeMessages.get(parent.parentNode);
                }
            }
            JSONArray mustCheckGroup = new JSONArray();
            if (!isMustCheckGroup) continue;
            ArrayList<String> arrayList = new ArrayList<String>(nodeMessage.childNodes);
            for (int i = 0; i < arrayList.size(); ++i) {
                NodeMessage node = nodeMessages.get(arrayList.get(i));
                if (node.getewayType != null) {
                    removeGroupIds.add(node.nodeId);
                    arrayList.addAll(node.childNodes);
                    continue;
                }
                mustCheckGroup.add((Object)node.nodeId);
            }
            mustCheckGroupMap.put(nodeMessage.nodeId, mustCheckGroup);
        }
        for (Map.Entry entry : mustCheckGroupMap.entrySet()) {
            if (removeGroupIds.contains(entry.getKey())) continue;
            mustCheckGroups.add(entry.getValue());
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            NodeMessage parentNode;
            JSONObject jSONObject = jsonArray.getJSONObject(i);
            if (jSONObject.getString("type").contains("Gateway")) continue;
            String nodeId = jSONObject.getString("id");
            NodeMessage nodeMessage = nodeMessages.get(nodeId);
            boolean bl = true;
            ArrayList<String> relatedNodes = new ArrayList<String>();
            NodeMessage parent = parentNode = nodeMessages.get(nodeMessage.parentNode);
            NodeMessage child = nodeMessage;
            while (parent != null) {
                if ("inclusiveGateway".equals(parent.getewayType) && child.conditionWithNextNode) {
                    bl = false;
                    break;
                }
                child = parent;
                parent = nodeMessages.get(parent.parentNode);
            }
            ArrayList<String> relateGroupIds = new ArrayList<String>();
            String currentNodeId = nodeId;
            while (parentNode != null) {
                NodeMessage childNode;
                if ("inclusiveGateway".equals(parentNode.getewayType)) {
                    for (String childNodeId : parentNode.childNodes) {
                        if (childNodeId.equals(currentNodeId)) continue;
                        childNode = nodeMessages.get(childNodeId);
                        if (childNode.conditionWithNextNode && parentNode.childNodes.size() != 1) continue;
                        if (childNode.getewayType != null) {
                            this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                            continue;
                        }
                        relatedNodes.add(childNodeId);
                    }
                } else if (parentNode.getewayType != null) {
                    for (String childNodeId : parentNode.childNodes) {
                        if (childNodeId.equals(currentNodeId)) continue;
                        childNode = nodeMessages.get(childNodeId);
                        if (childNode.getewayType != null) {
                            this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                            continue;
                        }
                        relatedNodes.add(childNodeId);
                    }
                }
                currentNodeId = parentNode.nodeId;
                parentNode = nodeMessages.get(parentNode.parentNode);
            }
            jSONObject.put("mustCheck", (Object)bl);
            jSONObject.put("relatedNodes", relatedNodes);
            JSONArray relateGroups = new JSONArray();
            for (String relateGroupId : relateGroupIds) {
                relateGroups.add(mustCheckGroupMap.get(relateGroupId));
            }
            jSONObject.put("relateGroups", (Object)relateGroups);
        }
        return mustCheckGroups;
    }

    private void setNodeMessage(List<String> relatedNodes, NodeMessage parentNode, Map<String, NodeMessage> nodeMessages, List<String> relateGroupIds) {
        if ("inclusiveGateway".equals(parentNode.getewayType)) {
            boolean containsRelateNode = false;
            for (String childNodeId : parentNode.childNodes) {
                NodeMessage childNode = nodeMessages.get(childNodeId);
                if (childNode.conditionWithNextNode && parentNode.childNodes.size() != 1) continue;
                containsRelateNode = true;
                if (childNode.getewayType != null) {
                    this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                    continue;
                }
                relatedNodes.add(childNodeId);
            }
            if (!containsRelateNode) {
                relateGroupIds.add(parentNode.nodeId);
            }
        } else {
            for (String childNodeId : parentNode.childNodes) {
                NodeMessage childNode = nodeMessages.get(childNodeId);
                if (childNode.getewayType != null) {
                    this.setNodeMessage(relatedNodes, childNode, nodeMessages, relateGroupIds);
                    continue;
                }
                relatedNodes.add(childNodeId);
            }
        }
    }

    public BpmResponseResult queryNextNode(String processKey, String taskId, boolean isGetRevokeNode, boolean isGetWithGroup, Map<String, Object> lineCondition) {
        if (HussarUtils.isNotEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            return this.queryNextNode(taskId, isGetRevokeNode, isGetWithGroup, lineCondition);
        }
        JSONArray jsonArray = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            String procDefId = definitionModel.getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                List startOut;
                String firstUserTask;
                if (!(flowElement instanceof StartEvent) || !(bpmnModel.getFlowElement(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef()) instanceof UserTask)) continue;
                UserTask userTask = (UserTask)bpmnModel.getFlowElement(firstUserTask);
                List sequenceFlows = userTask.getOutgoingFlows();
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                if (bpmnModel.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
                    resultMap = CommonCodeUtil.getGodAxeResult(null, userTask.getId(), "", procDefId);
                }
                if (lineCondition != null) {
                    resultMap.putAll(lineCondition);
                }
                HashMap<String, SimpleGroupMessage> simpleGroupMessages = new HashMap<String, SimpleGroupMessage>();
                HashMap<String, NodeMessage> nodeMessages = new HashMap<String, NodeMessage>();
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, null, userTask.getId(), bpmnModel, procDefId, null, resultMap);
                this.getUserTaskByCondition(jsonArray, bpmnModel, sequenceFlows, 0, userTask.getId(), resultMap, nodeMessages, simpleGroupMessages, null);
                if (isGetWithGroup) {
                    JSONArray mustCheckGroups = this.getNodeRelationMessages(nodeMessages, jsonArray);
                    JSONArray result = this.getNextNodeGroupMessage(((SequenceFlow)sequenceFlows.get(0)).getTargetRef(), simpleGroupMessages);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("data", (Object)result);
                    jsonObject.put("mustCheckGroups", (Object)mustCheckGroups);
                    jsonArray = new JSONArray();
                    jsonArray.add((Object)jsonObject);
                    continue;
                }
                JSONArray result = new JSONArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    if (jsonArray.getJSONObject(i).getString("type").contains("Gateway")) continue;
                    result.add((Object)jsonArray.getJSONObject(i));
                }
                jsonArray = result;
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), (JSONArray)jsonArray);
    }

    public BpmResponseResult queryRejectNodeOrNextNodeNewReturn(String processKey, String taskId, boolean isGetRevokeNode, boolean isGetWithGroup, Map<String, Object> lineCondition) {
        if (HussarUtils.isNotEmpty((Object)(taskId = this.getRealTaskId(taskId)))) {
            return this.queryNextNodeNewReturn(taskId, isGetRevokeNode, isGetWithGroup, lineCondition);
        }
        JSONArray jsonArray = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            String procDefId = definitionModel.getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                List startOut;
                String firstUserTask;
                if (!(flowElement instanceof StartEvent) || !(bpmnModel.getFlowElement(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef()) instanceof UserTask)) continue;
                UserTask userTask = (UserTask)bpmnModel.getFlowElement(firstUserTask);
                List sequenceFlows = userTask.getOutgoingFlows();
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                if (bpmnModel.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
                    resultMap = CommonCodeUtil.getGodAxeResult(null, userTask.getId(), "", procDefId);
                }
                if (lineCondition != null) {
                    resultMap.putAll(lineCondition);
                }
                HashMap<String, SimpleGroupMessage> simpleGroupMessages = new HashMap<String, SimpleGroupMessage>();
                HashMap<String, NodeMessage> nodeMessages = new HashMap<String, NodeMessage>();
                AnalyticalModelUtil.getSqlVariableMapWithOutExecution(null, null, null, userTask.getId(), bpmnModel, procDefId, null, resultMap);
                this.getUserTaskByCondition(jsonArray, bpmnModel, sequenceFlows, 0, userTask.getId(), resultMap, nodeMessages, simpleGroupMessages, null);
                JSONArray mustCheckGroups = this.getNodeRelationMessages(nodeMessages, jsonArray);
                JSONArray result = this.getNextNodeGroupMessage(((SequenceFlow)sequenceFlows.get(0)).getTargetRef(), simpleGroupMessages);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("data", (Object)result);
                jsonObject.put("mustCheckGroups", (Object)mustCheckGroups);
                jsonArray = new JSONArray();
                jsonArray.add((Object)jsonObject);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), (JSONArray)jsonArray);
    }

    private void getUserTaskByCondition(JSONArray jsonArray, BpmnModel bm, List<SequenceFlow> sfs, int sourceType, String superParentId, Map<String, Object> visitorMap, Map<String, NodeMessage> nodeMessages, Map<String, SimpleGroupMessage> simpleGroupMessages, SimpleGroupMessage oldSimpleGroupMessage) {
        if (sfs != null && !sfs.isEmpty()) {
            String parentId = sfs.get(0).getSourceRef();
            if (superParentId.equals(parentId)) {
                parentId = "";
            }
            for (SequenceFlow sequenceFlow : sfs) {
                boolean required = true;
                if (sfs.size() > 1) {
                    if (sourceType == 1) {
                        required = false;
                    } else if (sourceType == 2 && sequenceFlow.getConditionExpression() != null && sequenceFlow.getConditionExpression().contains("bpm_next_node")) {
                        required = false;
                    }
                }
                FlowElement flowElement = bm.getFlowElement(sequenceFlow.getTargetRef());
                SimpleGroupMessage simpleGroupMessage = oldSimpleGroupMessage;
                if (simpleGroupMessage == null) {
                    simpleGroupMessage = new SimpleGroupMessage();
                    simpleGroupMessage.jsonObjects = new ArrayList<JSONObject>();
                    simpleGroupMessage.childGroupIds = new ArrayList<List<String>>();
                    simpleGroupMessage.groupId = flowElement.getId();
                    simpleGroupMessages.put(simpleGroupMessage.groupId, simpleGroupMessage);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowElement.getId());
                jsonObject.put("name", (Object)flowElement.getName());
                jsonObject.put("parentId", (Object)parentId);
                NodeMessage nodeMessage = new NodeMessage(sequenceFlow.getTargetRef(), sequenceFlow.getSourceRef(), !required, null, null);
                if (flowElement instanceof Gateway) {
                    Gateway gateway = (Gateway)flowElement;
                    if (gateway instanceof ParallelGateway) {
                        this.getUserTaskByCondition(jsonArray, bm, gateway.getOutgoingFlows(), 3, superParentId, visitorMap, nodeMessages, simpleGroupMessages, simpleGroupMessage);
                        jsonObject.put("type", (Object)"parallelGateway");
                        nodeMessage.getewayType = "parallelGateway";
                        ArrayList<String> childNode = new ArrayList<String>();
                        for (SequenceFlow flow : gateway.getOutgoingFlows()) {
                            childNode.add(flow.getTargetRef());
                        }
                        nodeMessage.childNodes = childNode;
                    } else {
                        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
                        SimpleContext context = new SimpleContext();
                        if (visitorMap != null && !visitorMap.isEmpty()) {
                            SequenceFlow flow;
                            flow = visitorMap.keySet().iterator();
                            while (flow.hasNext()) {
                                String k = flow.next();
                                if (visitorMap.get(k.toString()) != null) {
                                    context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), visitorMap.get(k.toString()).getClass()));
                                    continue;
                                }
                                context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), Object.class));
                            }
                        }
                        ArrayList<SequenceFlow> defaultList = new ArrayList<SequenceFlow>();
                        ArrayList<SequenceFlow> allList = new ArrayList<SequenceFlow>();
                        boolean flag = true;
                        List sequenceFlowsList = gateway.getOutgoingFlows();
                        for (SequenceFlow sequenceFlows : sequenceFlowsList) {
                            if (sequenceFlows.getConditionExpression() != null) {
                                String condition = sequenceFlows.getConditionExpression();
                                boolean isConditionWithNextNode = condition.contains("bpm_next_node");
                                if (isConditionWithNextNode) {
                                    Matcher matcher = BPM_NEXT_NODE_REGEX.matcher(condition);
                                    String bpmNextNodeCondition = "";
                                    if (matcher.find()) {
                                        bpmNextNodeCondition = matcher.group();
                                    }
                                    String bpmNextNodeConditionValue = "";
                                    if (bpmNextNodeCondition.contains("==")) {
                                        bpmNextNodeConditionValue = bpmNextNodeCondition.split("'")[1];
                                    }
                                    context.setVariable("bpm_next_node", factory.createValueExpression((Object)bpmNextNodeConditionValue, Object.class));
                                }
                                condition = this.sqlConditionHandleService.getSqlRealCondition(condition, visitorMap);
                                ValueExpression valueExpression = factory.createValueExpression((ELContext)context, condition, Boolean.TYPE);
                                try {
                                    if (!((Boolean)valueExpression.getValue((ELContext)context)).booleanValue()) continue;
                                    allList.add(sequenceFlows);
                                    if (isConditionWithNextNode) continue;
                                    flag = false;
                                }
                                catch (PropertyNotFoundException e) {
                                    allList.add(sequenceFlows);
                                }
                                continue;
                            }
                            defaultList.add(sequenceFlows);
                        }
                        int type = 1;
                        if (gateway instanceof ExclusiveGateway) {
                            jsonObject.put("type", (Object)"exclusiveGateway");
                            nodeMessage.getewayType = "exclusiveGateway";
                        } else if (gateway instanceof InclusiveGateway) {
                            flag = true;
                            type = 2;
                            jsonObject.put("type", (Object)"inclusiveGateway");
                            nodeMessage.getewayType = "inclusiveGateway";
                        }
                        if (flag) {
                            allList.addAll(defaultList);
                        }
                        ArrayList<String> childNode = new ArrayList<String>();
                        for (SequenceFlow flow : allList) {
                            childNode.add(flow.getTargetRef());
                        }
                        nodeMessage.childNodes = childNode;
                        if (gateway instanceof ExclusiveGateway) {
                            simpleGroupMessage.childGroupIds.add(childNode);
                            this.getUserTaskByCondition(jsonArray, bm, allList, type, superParentId, visitorMap, nodeMessages, simpleGroupMessages, null);
                        } else {
                            this.getUserTaskByCondition(jsonArray, bm, allList, type, superParentId, visitorMap, nodeMessages, simpleGroupMessages, simpleGroupMessage);
                        }
                    }
                } else if (flowElement instanceof UserTask) {
                    UserTask u = (UserTask)flowElement;
                    jsonObject.put("type", (Object)"userTask");
                    String allowSetParticipantRepetition = "";
                    if (u.getExtensionElements().get("allowSetParticipant") != null) {
                        allowSetParticipantRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)u.getExtensionElements().get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant")).get(0)).getValue();
                    }
                    jsonObject.put("allowSetParticipant", (Object)allowSetParticipantRepetition);
                } else if (flowElement instanceof EndEvent) {
                    jsonObject.put("type", (Object)"endEvent");
                } else if (flowElement instanceof CallActivity) {
                    jsonObject.put("type", (Object)"callActivity");
                } else if (flowElement instanceof ServiceTask) {
                    jsonObject.put("type", (Object)"serviceTask");
                } else if (flowElement instanceof ReceiveTask) {
                    jsonObject.put("type", (Object)"receiveTask");
                } else if (flowElement instanceof SubProcess) {
                    jsonObject.put("type", (Object)"subProcess");
                }
                simpleGroupMessage.jsonObjects.add(jsonObject);
                nodeMessages.put(sequenceFlow.getTargetRef(), nodeMessage);
                jsonArray.add((Object)jsonObject);
            }
        }
    }

    public BpmResponseResult withdrawState(String historicTaskId) {
        ProcessInstance instance;
        if (historicTaskId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray json = new JSONArray();
        boolean result = true;
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).includeTaskLocalVariables()).singleResult();
        if (currTask == null) {
            logger.error(this.bpmConstantProperties.getTaskNotFound());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (HussarUtils.isEmpty((Object)currTask.getEndTime())) {
            logger.error(this.bpmConstantProperties.getCurrentTaskCannotRevoke());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getCurrentTaskCannotRevoke(), null);
        }
        if ("skip".equals(currTask.getTaskLocalVariables().get("taskSourceFlag"))) {
            result = false;
        }
        if ((instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult()) == null) {
            logger.error(this.bpmConstantProperties.getProcessEnd());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessEnd(), null);
        }
        if (instance.isSuspended()) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", Long.parseLong(currTask.getProcessInstanceId()));
        map.put("endTime", currTask.getEndTime());
        map.put("taskDefinitionKey", currTask.getTaskDefinitionKey());
        map.put("sub_process_key", currTask.getSubProcessKey());
        map.put("isEnd", "true");
        map.put("userId", currTask.getAssignee());
        if (!"0".equals(this.taskEngineMapper.withdrawState(map))) {
            result = false;
        }
        map.put("isEnd", "false");
        if ("0".equals(this.taskEngineMapper.withdrawState(map))) {
            List taskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(currTask.getProcessInstanceId())).taskDefinitionKey(currTask.getTaskDefinitionKey())).finished().taskVariableValueEquals("taskSourceFlag", (Object)"revoke")).orderByHistoricTaskInstanceEndTime().desc()).list();
            if (HussarUtils.isNotEmpty((Object)taskInstanceList)) {
                HistoricTaskInstance historicTaskInstance;
                Iterator iterator = taskInstanceList.iterator();
                while (iterator.hasNext() && (historicTaskInstance = (HistoricTaskInstance)iterator.next()).getEndTime().after(currTask.getEndTime())) {
                    if (!historicTaskInstance.getAssignee().equals(currTask.getAssignee())) continue;
                    result = false;
                    break;
                }
            }
            if (result) {
                if (this.runtimeService.createExecutionQuery().processInstanceId(currTask.getProcessInstanceId()).variableValueLike("all_prev_node", "%'" + currTask.getTaskDefinitionKey() + "'%").listPage(0, 1).isEmpty()) {
                    result = false;
                } else {
                    HistoricTaskInstance historicTaskInstance;
                    List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(currTask.getProcessInstanceId())).taskDefinitionKey(currTask.getTaskDefinitionKey())).subProcessKey(currTask.getSubProcessKey())).list();
                    list.sort((o1, o2) -> {
                        if (o1.getEndTime() == null) {
                            return -1;
                        }
                        if (o2.getEndTime() == null) {
                            return 1;
                        }
                        return o2.getEndTime().compareTo(o1.getEndTime());
                    });
                    Date date = ((HistoricTaskInstance)list.get(0)).getStartTime();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext() && ((historicTaskInstance = (HistoricTaskInstance)iterator.next()).getEndTime() == null || historicTaskInstance.getEndTime().compareTo(date) >= 0)) {
                        if (historicTaskInstance.getCreateTime().compareTo(date) >= 0) continue;
                        date = historicTaskInstance.getCreateTime();
                    }
                    if (currTask.getEndTime().before(date)) {
                        result = false;
                    }
                }
            }
        }
        json.add((Object)result);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult revokeTask(String historicTaskId, Map<String, String> userInfo, String comment, boolean isSubmit, Map<String, Object> map) {
        TaskRejectModel taskRejectModel = new TaskRejectModel(userInfo, null, comment, isSubmit, null, "revoke", null, Boolean.valueOf(false), map);
        taskRejectModel.setHistoryTaskId(historicTaskId);
        this.processEngine.getManagementService().executeCommand((Command)new TaskRejectCmd(taskRejectModel));
        HashMap<String, String> mapInfo = new HashMap<String, String>();
        String userId = "";
        String userDept = "";
        if (taskRejectModel.getHistoricTaskInstance().getTaskLocalVariables().get("sendUser") != null) {
            userId = taskRejectModel.getHistoricTaskInstance().getTaskLocalVariables().get("sendUser").toString();
            userDept = taskRejectModel.getHistoricTaskInstance().getTaskLocalVariables().get("sendUserOrganId").toString();
        }
        mapInfo.put(userId, userDept);
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new RejectReturnValueCmd(taskRejectModel.getProcInsId(), taskRejectModel.getFirst(), taskRejectModel.getStartUserId(), taskRejectModel.getHistoricTaskInstance().getTaskDefinitionKey(), mapInfo, taskRejectModel.getHistoricTaskInstance().getTaskDefinitionKey(), "revoke", taskRejectModel.getHistoricTaskInstance().getName()));
        this.taskEngineMapper.cancelTaskRevoke(historicTaskId);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private int isMulti(Task task) {
        int num = 1;
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            logger.error(this.bpmConstantProperties.getProcessNotFound());
            return 0;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        return num;
    }

    public BpmResponseResult editTaskComment(String taskId, String comment) {
        if ((taskId = this.getRealTaskId(taskId)) == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (HussarUtils.isEmpty((Object)historicTaskInstance)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (HussarUtils.isEmpty((Object)historicTaskInstance.getEndTime())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getUnfinishedTaskCanNotEditComment(), null);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TaskComment::getTaskId, (Object)taskId)).eq(TaskComment::getType, (Object)"complete")).eq(TaskComment::getAction, (Object)"AddComment");
        this.taskCommentService.saveOrUpdate((Object)new TaskComment(taskId, comment, comment.getBytes()), (Wrapper)queryWrapper);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult multiInstanceDelAssignee(String taskId, List<Map<String, String>> assignees) {
        Task task = this.getTask(taskId = this.getRealTaskId(taskId), "0");
        if (this.isMulti(task) != 2) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotMultiCanDelAssignee(), null);
        }
        if (HussarUtils.isEmpty(assignees) && task.getDueDate() != null) {
            this.activityRedisTimerService.delTimeOutModel(taskId);
        }
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceDelAssigneeCmd(task.getExecutionId(), taskId, assignees));
        this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(null, task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getSubProcessKey(), new HashMap<String, Object>()));
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public Map<String, Map<String, Set<String>>> updateRejectForm(Map<String, Object> map) {
        String procDefId = (String)map.get("procDefId");
        Set delNodeIds = (Set)map.get("delNodeIds");
        Set changeNodeIds = (Set)map.get("changeNodeIds");
        HashMap<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>();
        HashMap del = new HashMap();
        HashMap change = new HashMap();
        HashSet<String> processAll = new HashSet<String>();
        result.put("delNode", del);
        result.put("changeNode", change);
        del.put("", processAll);
        List list = this.runtimeService.createExecutionQuery().processDefinitionId(procDefId).list();
        if (list.isEmpty()) {
            return result;
        }
        for (String delNode : delNodeIds) {
            del.put(delNode, new HashSet());
        }
        for (String changeNode : changeNodeIds) {
            change.put(changeNode, new HashSet());
        }
        for (Execution execution : list) {
            if (delNodeIds.contains(execution.getActivityId())) {
                Set nodeDelSet = (Set)del.get(execution.getActivityId());
                nodeDelSet.add(execution.getProcessInstanceId());
                processAll.add(execution.getProcessInstanceId());
                continue;
            }
            if (!changeNodeIds.contains(execution.getActivityId())) continue;
            Set nodeChangeSet = (Set)change.get(execution.getActivityId());
            nodeChangeSet.add(execution.getActivityId());
            processAll.add(execution.getProcessInstanceId());
        }
        for (String delNode : delNodeIds) {
            if (((Set)del.get(delNode)).size() != 0) continue;
            del.remove(delNode);
        }
        for (String changeNode : changeNodeIds) {
            if (((Set)change.get(changeNode)).size() != 0) continue;
            change.remove(changeNode);
        }
        return result;
    }

    public void reStartProcessUpdate(String processInsId, String businessId, String processDefinitionId, String parentExecutionId, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        map.put("businessId", businessId);
        map.put("tenantId", tenantId);
        map.put("parentExecutionId", parentExecutionId);
        map.put("processDefinitionId", processDefinitionId);
        this.taskEngineMapper.reStartProcessUpdate(map);
        this.taskEngineMapper.reStartProcessInsert(map);
    }

    public BpmResponseResult reStartProcess(String processInsId, String businessId, String taskDefinitionKey, Map<String, String> userInfo, List<Map<String, String>> assigneeInfo, boolean isSubmit, Map<String, Object> map) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processInsId, businessId})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).processInstanceBusinessKey(businessId).singleResult();
        if (HussarUtils.isNotEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
            throw new PublicClientException("\u4e0d\u5141\u8bb8\u91cd\u542f\u5b50\u6d41\u7a0b\uff01", Boolean.valueOf(false));
        }
        if (historicProcessInstance != null) {
            if (HussarUtils.isEmpty((Object)historicProcessInstance.getEndTime())) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessInstanceIsNotEnd(), Boolean.valueOf(false));
            }
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicProcessInstance.getProcessDefinitionId());
            if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
                for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                    if (!activityImpl.getIncomingTransitions().isEmpty()) continue;
                    taskDefinitionKey = ((PvmTransition)activityImpl.getOutgoingTransitions().get(0)).getDestination().getId();
                    break;
                }
            }
            if (HussarUtils.isEmpty(map)) {
                map = new HashMap<String, Object>();
            }
            String userId = userInfo.get("userId");
            String userDept = userInfo.get("deptId");
            map.put("sendUser", userId);
            map.put("sendUserOrganId", userDept);
            if (isSubmit && HussarUtils.isEmpty(assigneeInfo)) {
                assigneeInfo = this.getTaskCommitUser(historicProcessInstance.getId(), taskDefinitionKey);
            }
            if (HussarUtils.isNotEmpty(assigneeInfo)) {
                HashMap<String, List<Map<String, String>>> appointAssignee = new HashMap<String, List<Map<String, String>>>();
                appointAssignee.put("static_appoint_assignee", assigneeInfo);
                map.put("appoint_assignee", appointAssignee);
            }
            this.reStartProcessUpdate(historicProcessInstance.getId(), historicProcessInstance.getBusinessKey(), historicProcessInstance.getProcessDefinitionId(), null, historicProcessInstance.getTenantId());
            this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(null, userInfo, null, historicProcessInstance.getId(), taskDefinitionKey, null, "", null, map, null).setProcessEventType("process_restart"));
            JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userInfo, historicProcessInstance.getId(), null, null, map));
            this.instanceEngineMapper.updateProcStatus(processInsId, "1");
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
    }

    public BpmResponseResult updateUserSecurityLevel(Map<String, String> userInfo, Integer level) {
        String userId = userInfo.get("userId");
        String userDept = userInfo.get("deptId");
        List<Map<String, String>> multiTaskMessages = this.taskEngineMapper.getSecurityLevelMultiTask(userId, userDept, level);
        for (Map<String, String> map : multiTaskMessages) {
            if (map.get("DUEDATE") != null) {
                this.activityRedisTimerService.delTimeOutModel(String.valueOf(map.get("TASKID")));
            }
            this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceDelAssigneeCmd(String.valueOf(map.get("EXECUTIONID")), String.valueOf(map.get("TASKID")), null));
            this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userInfo, String.valueOf(map.get("processInsId")), map.get("TASKDEFKEY"), map.get("SUBPROCESSKEY"), new HashMap<String, Object>()));
        }
        this.taskEngineMapper.updateRuIdentityLink(userId, level);
        this.taskEngineMapper.updateRuTask(userId, userDept, level);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult updateStarter(String processInsId, String businessId, Map<String, String> userInfo) {
        if (HussarUtils.isEmpty((Object)processInsId) && HussarUtils.isEmpty((Object)businessId) || HussarUtils.isEmpty(userInfo)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getErrorReset(), null);
        }
        if (HussarUtils.isEmpty((Object)processInsId)) {
            processInsId = this.taskEngineMapper.getProcessInsIdByBusinessId(businessId);
        }
        String userId = userInfo.get("userId");
        this.taskEngineMapper.updateActHiProcinstStater(processInsId, userId);
        this.taskEngineMapper.updateActHiIdentitylinkStater(processInsId, userId);
        this.taskEngineMapper.updateActRuIdentitylinkStater(processInsId, userId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activeTaskCandidates(String taskId) {
        taskId = this.getRealTaskId(taskId);
        Task task = this.getTask(taskId, "0");
        LambdaQueryWrapper ew = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(CandidateUser::getTaskId, (Object)taskId);
        List candidateUserList = this.candidateUserService.list((Wrapper)ew);
        List users = candidateUserList.stream().map(CandidateUser::getAssignee).collect(Collectors.toList());
        if (HussarUtils.isEmpty(users)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        HashMap entrustUser = new HashMap();
        ArrayList userInfo = new ArrayList();
        candidateUserList.forEach(temp -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userId", temp.getAssignee());
            map.put("deptId", temp.getDeptId());
            userInfo.add(map);
        });
        Map entrustMap = this.sysActEntrustService.queryByUsers(userInfo, task.getProcessDefinitionId().split(":")[0], task.getTaskDefinitionKey());
        for (String user : users) {
            if (!entrustMap.containsKey(user)) {
                entrustMap.put(user, null);
                List collect = userInfo.stream().filter(a -> ((String)a.get("userId")).equals(user)).collect(Collectors.toList());
                entrustUser.put(user, ((Map)collect.get(0)).get("deptId"));
                continue;
            }
            String[] usersplit = ((String)entrustMap.get(user)).split(",");
            entrustUser.put(usersplit[0], usersplit[1]);
        }
        this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(taskId, entrustMap));
        this.candidateUserService.remove((Wrapper)ew);
        this.activityRedisTimerService.updateTimeOutModel(taskId, Collections.singletonList(entrustUser), null, 0);
        return InstallResult.success((String)this.bpmConstantProperties.getAppointAssigneesSuccess());
    }

    public BpmResponseResult getExecutionByBusinessId(String businessId) {
        String processInsId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult()).getId();
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("receiveTask").unfinished().list();
            JSONArray json = new JSONArray();
            if (HussarUtils.isEmpty((Object)historicActivityInstances)) {
                return InstallResult.getResult((String)"0", (String)"\u67e5\u8be2\u5931\u8d25", null);
            }
            for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                JSONObject object = new JSONObject();
                object.put("activitiName", (Object)historicActivityInstance.getActivityName());
                object.put("activitiType", (Object)historicActivityInstance.getActivityType());
                object.put("activitiId", (Object)historicActivityInstance.getActivityId());
                object.put("executionId", (Object)historicActivityInstance.getExecutionId());
                object.put("subProcessKey", (Object)historicActivityInstance.getSubProcessKey());
                json.add((Object)object);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)"\u67e5\u8be2\u5931\u8d25", null);
    }

    public BpmResponseResult receiveTaskSignalByProcessInfo(TaskReceiveDto taskReceiveDto) {
        if (HussarUtils.isEmpty((Object)taskReceiveDto.getTaskDefinitionKey())) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (HussarUtils.isAllEmpty((Object[])new Object[]{taskReceiveDto.getProcessInsId(), taskReceiveDto.getBusinessId()})) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        HistoricProcessInstance processInstance = HussarUtils.isEmpty((Object)taskReceiveDto.getProcessInsId()) ? (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(taskReceiveDto.getBusinessId()).singleResult() : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(taskReceiveDto.getProcessInsId()).singleResult();
        if (processInstance == null) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessNotStart());
        }
        if (processInstance.getEndTime() != null) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessEnd());
        }
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityType("receiveTask").unfinished().list();
        if (historicActivityInstances == null || historicActivityInstances.isEmpty()) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessReceiveTaskNotFound());
        }
        String taskDefKey = taskReceiveDto.getTaskDefinitionKey();
        if ((historicActivityInstances = historicActivityInstances.stream().filter(o -> taskDefKey.equals(o.getActivityId())).collect(Collectors.toList())).isEmpty()) {
            throw new PublicClientException(this.bpmConstantProperties.getReceiveTaskNotFound());
        }
        JSONArray json = null;
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            String executionId = historicActivityInstance.getExecutionId();
            Map map = (Map)this.processEngine.getManagementService().executeCommand((Command)new ReceiveTaskAddVariablesCmd(executionId, null, null, true, taskReceiveDto.getVariableMap()));
            this.runtimeService.signal(executionId, map);
            this.activityRedisTimerService.delTimeOutModel(executionId);
            HashMap<String, String> userInfo = new HashMap<String, String>();
            userInfo.put(map.get("sendUser").toString(), map.get("sendUserOrganId").toString());
            json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userInfo, (String)map.get("processInsId"), (String)map.get("backActivityId"), (String)map.get("sub_process_key"), new HashMap<String, Object>()));
        }
        return InstallResult.getResult((String)"1", (String)"success", json);
    }

    public BpmResponseResult receiveTaskSignal(String executionId, Map<String, Object> variableMap) {
        Map map = (Map)this.processEngine.getManagementService().executeCommand((Command)new ReceiveTaskAddVariablesCmd(executionId, null, null, true, variableMap));
        this.runtimeService.signal(executionId, map);
        this.activityRedisTimerService.delTimeOutModel(executionId);
        HashMap<String, String> userInfo = new HashMap<String, String>();
        userInfo.put("userId", map.get("sendUser").toString());
        userInfo.put("deptId", map.get("sendUserOrganId").toString());
        JSONArray json = (JSONArray)this.processEngine.getManagementService().executeCommand((Command)new CompleteReturnValueCmd(userInfo, (String)map.get("processInsId"), (String)map.get("backActivityId"), (String)map.get("sub_process_key"), new HashMap<String, Object>()));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private void rejectDataPush(Task task, String comment, Map<String, String> userInfo, Map<String, String> mandatorInfo, String taskState) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, Collections.singletonList(userInfo)).setConsignor(Collections.singletonList(mandatorInfo)).setTaskState(taskState);
            this.dataPushService.rejectDataPush(dataPush);
        }
    }

    private void completeDataPush(Task task, String comment, Map<String, String> userInfo, Map<String, String> mandatorInfo, String taskState) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, Collections.singletonList(userInfo)).setConsignor(Collections.singletonList(mandatorInfo)).setTaskState(taskState);
            this.dataPushService.completeDataPush(dataPush);
        }
    }

    private void claimDataPush(String taskId, Map<String, String> userInfo) {
        if (this.dataPushService.isDataPush()) {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            DataPush dataPush = this.dataPush(task, null, Collections.singletonList(userInfo));
            this.dataPushService.claimDataPush(dataPush);
        }
    }

    private void freeJumpDataPush(Task task, String comment, Map<String, String> userInfo, String taskIds, Map<String, String> mandatorInfo, String taskState) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, Collections.singletonList(userInfo)).setConsignor(Collections.singletonList(mandatorInfo)).setTaskState(taskState);
            if (HussarUtils.isNotEmpty((Object)taskIds)) {
                dataPush.setTaskId(taskIds);
            }
            this.dataPushService.freeJumpDataPush(dataPush);
        }
    }

    private void addUrgeTask(Task task, List<Map<String, String>> userInfo) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, null, userInfo);
            this.dataPushService.addUrgeTask(dataPush);
        }
    }

    private DataPush dataPush(Task task, String comment, List<Map<String, String>> userInfo) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserInfo(userInfo);
        dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        HashMap map = new HashMap();
        map.putAll(task.getProcessVariables());
        map.putAll(task.getTaskLocalVariables());
        dataPush.setSendUser((String)map.get("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)map.get("todoConfiguration"));
        dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
        if (HussarUtils.isNotEmpty((Object)comment)) {
            dataPush.setComment(comment);
        }
        dataPush.setProcessInsId(task.getProcessInstanceId());
        dataPush.setTenantId(task.getTenantId());
        return dataPush;
    }

    private void setRejectAppointAssignee(String processInstanceId, String backActivityId, String assignees, Map<String, String> assigneeMap, boolean isSubmit, Map<String, Object> map) {
        Map<String, List<Object>> appointAssignee;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (!isSubmit) {
            List historicTaskInstanceList;
            if (HussarUtils.isEmpty((Object)assignees) && !backActivityId.contains(",") && (historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(backActivityId)).finished().includeTaskLocalVariables()).taskVariableValueEquals("taskSourceFlag", (Object)"complete")).taskVariableValueNotEquals("old_appoint_assignee", null)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1)).size() == 1) {
                List oldAppointAssignee;
                Object oldAppointMessage = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
                if (oldAppointMessage instanceof HashMap) {
                    Map oldAppointAssigneeMap = (Map)oldAppointMessage;
                    if (oldAppointAssigneeMap.get(backActivityId) instanceof ArrayList) {
                        oldAppointAssignee = (List)oldAppointAssigneeMap.get(backActivityId);
                    } else {
                        String userIds = (String)oldAppointAssigneeMap.get(backActivityId);
                        List usersInfo = this.iAssigneeChooseService.getSourceDeptIdByUserId(Arrays.asList(userIds.split(",")));
                        oldAppointAssignee = usersInfo.stream().map(userInfo -> {
                            HashMap temp = new HashMap();
                            temp.put("userId", userInfo.get("userId"));
                            temp.put("deptId", userInfo.get("deptId"));
                            return temp;
                        }).collect(Collectors.toList());
                    }
                } else {
                    String userIds = (String)oldAppointMessage;
                    List usersInfo = this.iAssigneeChooseService.getSourceDeptIdByUserId(Arrays.asList(userIds.split(",")));
                    oldAppointAssignee = usersInfo.stream().map(userInfo -> {
                        HashMap temp = new HashMap();
                        temp.put("userId", userInfo.get("userId"));
                        temp.put("deptId", userInfo.get("deptId"));
                        return temp;
                    }).collect(Collectors.toList());
                }
                if (HussarUtils.isNotEmpty((Object)oldAppointAssignee)) {
                    map.put("reject_appoint_assignee", oldAppointAssignee);
                }
            }
            if (backActivityId.contains(",")) {
                appointAssignee = (HashMap<String, List<Object>>)map.get("appoint_assignee");
                if (appointAssignee == null) {
                    appointAssignee = new HashMap<String, List<Object>>();
                }
                for (String targetNodeId : backActivityId.split(",")) {
                    List oldAppointAssignee;
                    List historicTaskInstanceList2;
                    if (appointAssignee.containsKey(targetNodeId) || (historicTaskInstanceList2 = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(targetNodeId)).finished().includeTaskLocalVariables()).taskVariableValueEquals("taskSourceFlag", (Object)"complete")).taskVariableValueNotEquals("old_appoint_assignee", null)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1)).size() != 1) continue;
                    Object oldAppointMessage = ((HistoricTaskInstance)historicTaskInstanceList2.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
                    if (oldAppointMessage instanceof HashMap) {
                        Map oldAppointAssigneeMap = (Map)oldAppointMessage;
                        if (oldAppointAssigneeMap.get(targetNodeId) instanceof ArrayList) {
                            oldAppointAssignee = (List)oldAppointAssigneeMap.get(targetNodeId);
                        } else {
                            String userIds = (String)oldAppointAssigneeMap.get(targetNodeId);
                            List usersInfo = this.iAssigneeChooseService.getSourceDeptIdByUserId(Arrays.asList(userIds.split(",")));
                            oldAppointAssignee = usersInfo.stream().map(userInfo -> {
                                HashMap temp = new HashMap();
                                temp.put("userId", userInfo.get("userId"));
                                temp.put("deptId", userInfo.get("deptId"));
                                return temp;
                            }).collect(Collectors.toList());
                        }
                    } else {
                        String userIds = (String)oldAppointMessage;
                        List usersInfo = this.iAssigneeChooseService.getSourceDeptIdByUserId(Arrays.asList(userIds.split(",")));
                        oldAppointAssignee = usersInfo.stream().map(userInfo -> {
                            HashMap temp = new HashMap();
                            temp.put("userId", userInfo.get("userId"));
                            temp.put("deptId", userInfo.get("deptId"));
                            return temp;
                        }).collect(Collectors.toList());
                    }
                    if (!HussarUtils.isNotEmpty((Object)oldAppointAssignee)) continue;
                    appointAssignee.put(targetNodeId, oldAppointAssignee);
                }
                map.put("appoint_assignee", appointAssignee);
            }
        }
        if (HussarUtils.isNotEmpty((Object)assignees)) {
            map.put("reject_appoint_assignee", assignees);
        }
        if (HussarUtils.isNotEmpty(assigneeMap)) {
            map.put("appoint_assignee", assigneeMap);
        }
        if (isSubmit) {
            if (backActivityId.contains(",")) {
                appointAssignee = (Map)map.get("appoint_assignee");
                if (appointAssignee == null) {
                    appointAssignee = new HashMap();
                }
                for (String targetNodeId : backActivityId.split(",")) {
                    List<Map<String, String>> taskCommitUser = this.getTaskCommitUser(processInstanceId, targetNodeId);
                    if (!HussarUtils.isNotEmpty(taskCommitUser)) continue;
                    appointAssignee.put(targetNodeId, taskCommitUser);
                }
                map.put("appoint_assignee", appointAssignee);
            } else {
                List<Map<String, String>> taskCommitUser = this.getTaskCommitUser(processInstanceId, backActivityId);
                if (HussarUtils.isNotEmpty(taskCommitUser)) {
                    map.put("reject_appoint_assignee", taskCommitUser);
                }
            }
        }
    }

    public BpmResponseResult preemptTask(PreemptCommonDto preemptCommonDto) {
        Map userInfo = preemptCommonDto.getUserInfo();
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(preemptCommonDto.getTaskId());
        String taskId = realTaskId.getTaskId();
        this.processEngine.getManagementService().executeCommand((Command)new PreemptTaskCmd(taskId, userInfo, realTaskId.getMandataryInfo()));
        return InstallResult.success();
    }

    public BpmResponseResult unPreemptTask(PreemptCommonDto preemptCommonDto) {
        Map userInfo = preemptCommonDto.getUserInfo();
        boolean isAuditAuthority = preemptCommonDto.getIsAuditAuthority();
        RealTaskId realTaskId = this.getRealTaskIdAndMandatary(preemptCommonDto.getTaskId());
        String taskId = realTaskId.getTaskId();
        this.processEngine.getManagementService().executeCommand((Command)new UnPreemptTaskCmd(taskId, userInfo, realTaskId.getMandataryInfo(), isAuditAuthority));
        return InstallResult.success();
    }

    private RealTaskId getRealTaskIdAndMandatary(String taskId) {
        if (taskId == null) {
            return new RealTaskId(null, null);
        }
        if (taskId.contains(":")) {
            String[] str = taskId.split(":");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userId", str[1]);
            map.put("deptId", str[2]);
            return new RealTaskId(str[0], map);
        }
        return new RealTaskId(taskId, null);
    }

    private String getRealTaskId(String taskId) {
        if (taskId == null) {
            return null;
        }
        if (taskId.contains(":")) {
            String[] str = taskId.split(":");
            return str[0];
        }
        return taskId;
    }

    private static class RealTaskId {
        private String taskId;
        private Map<String, String> mandataryInfo;

        public String getTaskId() {
            return this.taskId;
        }

        public Map<String, String> getMandataryInfo() {
            return this.mandataryInfo;
        }

        public RealTaskId(String taskId, Map<String, String> mandataryInfo) {
            this.taskId = taskId;
            this.mandataryInfo = mandataryInfo;
        }
    }

    private static class NodeMessage {
        String nodeId;
        String parentNode;
        boolean conditionWithNextNode;
        String getewayType;
        List<String> childNodes;

        public NodeMessage(String nodeId, String parentNode, boolean conditionWithNextNode, String gatewayType, List<String> childNodes) {
            this.nodeId = nodeId;
            this.parentNode = parentNode;
            this.conditionWithNextNode = conditionWithNextNode;
            this.getewayType = gatewayType;
            this.childNodes = childNodes;
        }
    }

    private static class SimpleGroupMessage {
        String groupId;
        List<JSONObject> jsonObjects;
        List<List<String>> childGroupIds;

        private SimpleGroupMessage() {
        }
    }
}

