/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.dao.AssigneeChooseMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmUserMsg;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.DirectDepartmentModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitor;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.outside.assignee.service.AssigneeChooseService;
import com.jxdinfo.hussar.workflow.outside.assigneefunction.service.AssigneeFunctionService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    AssigneeChooseMapper assigneeChooseMapper;
    @Resource
    IAssigneeChooseService assignmentChooseService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private HistoryService historyService;
    private static Logger logger = LogManager.getLogger(AssigneeChooseServiceImpl.class);
    private static final Pattern ORG_REGEX = Pattern.compile("O.ORGAN_ID IN \\(\\'\\@\\{([^@]|[^}]\\@)*\\}\\@\\'\\)");
    private static final Pattern ORGN_REGEX = Pattern.compile("O.ORGAN_ID NOT IN \\(\\'\\@\\{([^@]|[^}]\\@)*\\}\\@\\'\\)");
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    private static final Pattern UPDATE_SQL_REGEX = Pattern.compile("[^'\"]\\b(CREATE|INSERT|DELETE|UPDATE|DROP|ALTER)\\b[^'\"]");
    private static final Pattern SQL_REGEX = Pattern.compile("\\@Sql\\{([^@]|[^}]\\@)*\\}\\@");
    private static final Pattern ORGAN_CONTAINS_CHILD_REGEX = Pattern.compile("O.PARENT_ID( NOT)? CONTAINSCHILD \\('([^)])*\\)");
    private static final String DEFAULT_PARENTID = "11";
    public static final String ORGAN = "organ";
    public static final String USER = "user";

    public List<BpmTreeModel> userTree(String id, String tenantId, boolean isInterface, boolean isGetTenantUser) {
        String newId;
        String string = newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.userTree(Long.parseLong(newId), null);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.userTree(newId);
    }

    public List<BpmTreeModel> deptTree(String id, String tenantId, boolean isInterface) {
        String newId;
        String string = newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.deptTree(Long.parseLong(newId), null);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.deptTree(newId);
    }

    public List<BpmTreeModel> roleTree(String tenantId, boolean isInterface) {
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.roleTree();
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.roleTree();
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, String tenantId, boolean isInterface) {
        if ((userIds = new ArrayList<String>(new HashSet<String>(userIds))) != null) {
            ArrayList<String> removeList = new ArrayList<String>();
            removeList.add(null);
            removeList.add("null");
            userIds.removeAll(removeList);
        }
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<BpmTreeModel>();
        }
        ArrayList<Long> userIdL = new ArrayList<Long>();
        for (String str : userIds) {
            if (!ToolUtil.isNotEmpty((Object)str)) continue;
            userIdL.add(Long.parseLong(str));
        }
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.userDetail(userIdL);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.userDetail(String.join((CharSequence)",", userIds));
    }

    private List<BpmTreeModel> userDeptDetail(String userId, String tenantId, boolean isInterface) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return new ArrayList<BpmTreeModel>();
        }
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.userDeptDetail(userId);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.userDeptDetail(userId);
    }

    public String getUserNames(List<String> userIds, String tenantId) {
        StringBuilder result = new StringBuilder();
        List<BpmTreeModel> list = this.userDetail(userIds, tenantId, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                result.append(bpmTreeModel.getLabel()).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    public List<String> getEntrustUserNamesWithOrgan(List<IdentityLink> userIds, String tenantId) {
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> orgs = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                users.add(identityLink.getUserId());
                users.add(identityLink.getMandator());
                if (identityLink.getOrganId() != null) {
                    orgs.add(identityLink.getOrganId());
                }
                if (identityLink.getMandatorOrganId() == null) continue;
                orgs.add(identityLink.getMandatorOrganId());
                continue;
            }
            users.add(identityLink.getUserId());
            if (identityLink.getOrganId() == null) continue;
            orgs.add(identityLink.getOrganId());
        }
        Map<String, String> map = this.getUserListByUserId(users, tenantId);
        Map deptNameMap = this.assignmentChooseService.getDeptNameByImmediateSuperiorIds(orgs);
        ArrayList<String> result = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            StringBuilder userName;
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                userName = new StringBuilder();
                userName.append(map.get(identityLink.getUserId()));
                if (identityLink.getOrganId() != null) {
                    userName.append("[").append((String)deptNameMap.get(identityLink.getOrganId())).append("]");
                }
                userName.append("(").append(map.get(identityLink.getMandator()));
                if (identityLink.getMandatorOrganId() != null) {
                    userName.append("[").append((String)deptNameMap.get(identityLink.getMandatorOrganId())).append("]");
                }
                userName.append(")");
                result.add(userName.toString());
                continue;
            }
            userName = new StringBuilder();
            userName.append(map.get(identityLink.getUserId()));
            if (identityLink.getOrganId() != null) {
                userName.append("[").append((String)deptNameMap.get(identityLink.getOrganId())).append("]");
            }
            result.add(userName.toString());
        }
        return result;
    }

    public List<String> getEntrustUserNames(List<IdentityLink> userIds, String tenantId) {
        ArrayList<String> users = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                users.add(identityLink.getUserId());
                users.add(identityLink.getMandator());
                continue;
            }
            users.add(identityLink.getUserId());
        }
        Map<String, String> map = this.getUserListByUserId(users, tenantId);
        ArrayList<String> result = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                result.add(map.get(identityLink.getUserId()) + "(" + map.get(identityLink.getMandator()) + ")");
                continue;
            }
            result.add(map.get(identityLink.getUserId()));
        }
        return result;
    }

    public List<Map<String, String>> getUserListByUserIdWithSelect(List<String> userList, String tenantId) {
        List<BpmTreeModel> list = this.userDetail(userList, tenantId, true);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(2);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    public Map<String, String> getUserListByUserId(List<String> userIds, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, tenantId, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getLabel());
            }
        }
        return map;
    }

    public List<Map<String, String>> getCandidateUser(String condition, String serviceName, String tenantId, Integer securityLevel, Map<String, String> processInfo) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        condition = this.getFunctionCondition(condition, processInfo, serviceName);
        if (!this.lcdpBpmProperties.isStartAlone()) {
            if (condition.startsWith("and (@Sql{")) {
                Map sqlMap = (Map)JSON.parseObject((String)condition.substring(10, condition.length() - 3), Map.class);
                List sqlResult = (List)this.getSqlResult(sqlMap);
                ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
                for (Map sql : sqlResult) {
                    if (ToolUtil.isEmpty(sql.get("userId"))) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("userId", String.valueOf(sql.get("userId")));
                    map.put("deptId", sql.get("organId") == null ? null : String.valueOf(sql.get("organId")));
                }
                return result;
            }
            condition = this.getRealCondition(condition);
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(" SELECT DISTINCT O.ORGAN_ID AS id, ").append(" O.PARENT_ID AS parentId ").append(" FROM HUSSAR_BPM_ORGAN_VIEW O ").append("  LEFT JOIN HUSSAR_BPM_USER_ROLE_VIEW R ON R.USER_ID = O.ORGAN_ID ").append("  WHERE O.ORGAN_TYPE = 'user'  ");
                sb.append(condition);
                List<BpmTreeModel> usersInfo = this.assigneeChooseMapper.getCandidateUsers(sb.toString(), securityLevel);
                ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
                for (BpmTreeModel userInfo : usersInfo) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("userId", userInfo.getId());
                    map.put("deptId", userInfo.getParentId());
                    result.add(map);
                }
                return result;
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        try {
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            List userIds = assigneeChooseService.getCandidateUser(condition, securityLevel, false);
            return userIds;
        }
        catch (Exception e) {
            throw new PublicClientException("\u83b7\u53d6\u53c2\u4e0e\u8005\u5f02\u5e38\uff01");
        }
    }

    private String getFunctionCondition(String realCondition, Map<String, String> processInfo, String serviceName) {
        if (realCondition.contains("@{")) {
            Matcher orgMatcher = ORG_REGEX.matcher(realCondition);
            while (orgMatcher.find()) {
                String message = orgMatcher.group().substring(17, orgMatcher.group().length() - 3);
                realCondition = this.matcheREGXE(realCondition, message, orgMatcher, processInfo, serviceName, true);
            }
            Matcher orgnMatcher = ORGN_REGEX.matcher(realCondition);
            while (orgnMatcher.find()) {
                String message = orgnMatcher.group().substring(21, orgnMatcher.group().length() - 3);
                realCondition = this.matcheREGXE(realCondition, message, orgnMatcher, processInfo, serviceName, false);
            }
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                realCondition = this.matcheREGXE(realCondition, message, matcher, processInfo, serviceName, true);
            }
        }
        return realCondition;
    }

    private String matcheREGXE(String realCondition, String message, Matcher matcher, Map<String, String> processInfo, String serviceName, boolean include) {
        CharSequence[] messages = message.split(":");
        for (int j = 0; j < messages.length; ++j) {
            String str = messages[j];
            if (j != messages.length - 1) {
                if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                str = str.replace("','", ",");
                int num = str.lastIndexOf(44);
                messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                continue;
            }
            messages[j] = str.replace("','", ",");
        }
        message = String.join((CharSequence)":", messages);
        List<String> userList = this.functionUser((Map)JSON.parse((String)message), processInfo, serviceName);
        StringBuilder result = new StringBuilder();
        String functionUsers = "";
        if (userList != null && !userList.isEmpty()) {
            boolean containsOrg = false;
            for (String user : userList) {
                if (!user.contains(",")) continue;
                containsOrg = true;
                break;
            }
            if (containsOrg) {
                for (String user : userList) {
                    String[] split = user.split(",");
                    if (include) {
                        result.append(" (O.ORGAN_ID IN ( '").append(split[0]).append("' ) AND O.PARENT_ID IN ( '").append(split[1]).append("' )) OR");
                        continue;
                    }
                    result.append(" (O.ORGAN_ID NOT IN ( '").append(split[0]).append("' ) OR O.PARENT_ID NOT IN ( '").append(split[1]).append("' )) AND");
                }
                functionUsers = include ? result.toString().substring(0, result.toString().length() - 2) : result.toString().substring(0, result.toString().length() - 3);
            } else {
                for (String user : userList) {
                    if (include) {
                        result.append(" O.ORGAN_ID IN ( '").append(user).append("','");
                        continue;
                    }
                    result.append(" O.ORGAN_ID NOT IN ( '").append(user).append("','");
                }
                functionUsers = result.toString().substring(0, result.toString().length() - 2) + " ) ";
            }
            return realCondition.replace(matcher.group(), functionUsers);
        }
        return realCondition.replace("@" + message + "@", functionUsers);
    }

    private String getRealCondition(String realCondition) {
        if (realCondition.contains("CONTAINSCHILD")) {
            List<Map<String, String>> allOrgans = this.assigneeChooseMapper.getAllOrgans();
            HashMap<String, ArrayList<String>> maps = new HashMap<String, ArrayList<String>>();
            for (Map<String, String> map : allOrgans) {
                String organId = String.valueOf(map.get("ORGAN_ID"));
                String parentId = String.valueOf(map.get("PARENT_ID"));
                ArrayList<String> list = (ArrayList<String>)maps.get(parentId);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(organId);
                maps.put(parentId, list);
            }
            Matcher organMatcher = ORGAN_CONTAINS_CHILD_REGEX.matcher(realCondition);
            while (organMatcher.find()) {
                int i;
                String organCondition = organMatcher.group();
                String[] organConditions = organCondition.split("'");
                ArrayList<String> organIds = new ArrayList<String>();
                for (i = 1; i < organConditions.length; i += 2) {
                    organIds.add(organConditions[i]);
                }
                for (i = 0; i < organIds.size(); ++i) {
                    List addOrgans = (List)maps.get(organIds.get(i));
                    if (addOrgans == null) continue;
                    organIds.addAll(addOrgans);
                }
                organIds = new ArrayList(new HashSet(organIds));
                StringBuilder stringBuilder = new StringBuilder();
                boolean isConditionNotIn = organCondition.contains("NOT CONTAINSCHILD");
                if (isConditionNotIn) {
                    stringBuilder.append("O.PARENT_ID NOT IN (");
                } else {
                    stringBuilder.append("O.PARENT_ID IN (");
                }
                for (String s : organIds) {
                    stringBuilder.append("'").append(s).append("',");
                }
                stringBuilder.append("'')");
                String replactCondition = stringBuilder.toString();
                while (replactCondition.contains(",''")) {
                    replactCondition = replactCondition.replace(",''", "");
                }
                while (replactCondition.contains("'',")) {
                    replactCondition = replactCondition.replace("'',", "");
                }
                if (replactCondition.contains("('')")) {
                    replactCondition = isConditionNotIn ? "1=1" : "1!=1";
                }
                realCondition = realCondition.replace(organCondition, replactCondition);
            }
        }
        return realCondition;
    }

    private List<String> functionUser(Map<String, Object> message, Map<String, String> processInfo, String serviceName) {
        String beanId = new ArrayList<String>(message.keySet()).get(0);
        if (beanId == null) {
            return new ArrayList<String>();
        }
        Map map = (Map)message.get(beanId);
        map.putAll(processInfo);
        if (!this.lcdpBpmProperties.isStartAlone()) {
            AssigneeVisitor hussarBpmVariablesVisitor;
            try {
                hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean((String)beanId);
            }
            catch (NoSuchBeanDefinitionException e) {
                return new ArrayList<String>();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new ArrayList<String>();
            }
            return hussarBpmVariablesVisitor.visit(map);
        }
        try {
            AssigneeFunctionService assigneeFunctionService = (AssigneeFunctionService)SpringContextHolder.getBean(AssigneeFunctionService.class);
            return assigneeFunctionService.executeListener(beanId, map, serviceName);
        }
        catch (NoSuchBeanDefinitionException e) {
            return new ArrayList<String>();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public String getSameLevelDeptIdByUserId(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                List<String> deptId = this.assigneeChooseMapper.getSameLevelDeptIdByUserId(userId);
                return String.join((CharSequence)",", deptId);
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getSameLevelDeptIdByUserId(userId);
        }
        return "";
    }

    public String getParentDeptIdByUserId(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                List<String> deptId = this.assigneeChooseMapper.getParentDeptIdByUserId(userId);
                return String.join((CharSequence)",", deptId);
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getParentDeptIdByUserId(userId);
        }
        return "";
    }

    public String getDeptIdByUserIds(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                List<String> deptId = this.assigneeChooseMapper.getDeptIdByUserIds(new ArrayList<String>(Arrays.asList(userId.split(","))));
                return String.join((CharSequence)",", new HashSet<String>(deptId));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getDeptIdByUserIds(userId);
        }
        return "";
    }

    public String getSameLevelDeptIdByUserIds(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                List<String> deptId = this.assigneeChooseMapper.getSameLevelDeptIdByUserIds(new ArrayList<String>(Arrays.asList(userId.split(","))));
                return String.join((CharSequence)",", new HashSet<String>(deptId));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getSameLevelDeptIdByUserIds(userId);
        }
        return "";
    }

    public String getParentDeptIdByUserIds(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                List<String> deptId = this.assigneeChooseMapper.getParentDeptIdByUserIds(new ArrayList<String>(Arrays.asList(userId.split(","))));
                return String.join((CharSequence)",", new HashSet<String>(deptId));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getParentDeptIdByUserIds(userId);
        }
        return "";
    }

    public Integer getSecurityLevel(String userId, String url, String tenantId) {
        if (!this.lcdpBpmProperties.isStartAlone()) {
            return this.assigneeChooseMapper.getSecurityLevel(userId);
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return Integer.valueOf(remoteAssigneeChooseService.getSecurityLevel(userId));
    }

    public String getStarterDept(String userId, String tenantId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return null;
        }
        List<BpmTreeModel> list = this.userDeptDetail(userId, tenantId, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (BpmTreeModel bpmTreeModel : list) {
            if (bpmTreeModel.getParentId() == null) continue;
            stringBuilder.append(",").append(bpmTreeModel.getParentId());
        }
        String result = stringBuilder.toString();
        if (result.length() > 0) {
            result = result.substring(1);
        }
        return result;
    }

    public Map<String, Object> getDeptParamsByUserId(String userId, String tenantId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return null;
        }
        Map<String, Object> result = this.assigneeChooseMapper.getDeptParamsByUserId(userId);
        return result;
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName, String tenantId) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        if (!this.lcdpBpmProperties.isStartAlone()) {
            List<BpmTreeModel> childrenNode = this.assigneeChooseMapper.queryDeptTreeByDeptName(organName);
            return this.queryAllTreeByChildrenNode(childrenNode);
        }
        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
        return assigneeChooseService.queryDeptTreeByDeptName(organName);
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName, String tenantId) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        if (!this.lcdpBpmProperties.isStartAlone()) {
            List<BpmTreeModel> childrenNode = this.assigneeChooseMapper.queryUserTreeByUserName(organName);
            return this.queryAllTreeByChildrenNode(childrenNode);
        }
        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
        return assigneeChooseService.queryUserTreeByUserName(organName);
    }

    private List<BpmTreeModel> queryAllTreeByChildrenNode(List<BpmTreeModel> childrenNode) {
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        List<BpmTreeModel> allDept = this.assigneeChooseMapper.getAllDept();
        HashMap<String, BpmTreeModel> deptMap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptMap.put(dept.getId(), dept);
        }
        block1: for (BpmTreeModel bpmTreeModel : childrenNode) {
            BpmTreeModel children = bpmTreeModel;
            if (deptMap.containsKey(children.getId())) {
                children = (BpmTreeModel)deptMap.get(children.getId());
            }
            while (true) {
                if (!deptMap.containsKey(children.getParentId())) {
                    int i;
                    for (BpmTreeModel rootNode : result) {
                        if (!rootNode.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < result.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)result.get(i)).getType())) {
                                result.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < result.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)result.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    }
                    result.add(children);
                    continue block1;
                }
                BpmTreeModel parent = (BpmTreeModel)deptMap.get(children.getParentId());
                ArrayList<BpmTreeModel> childrenList = parent.getChildrenList();
                if (!HussarUtils.isEmpty((Object)childrenList)) {
                    int i;
                    for (BpmTreeModel parentChildrenList : childrenList) {
                        if (!parentChildrenList.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)childrenList.get(i)).getType())) {
                                childrenList.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)childrenList.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    }
                    childrenList.add(children);
                    continue block1;
                }
                childrenList = new ArrayList<BpmTreeModel>();
                childrenList.add(children);
                parent.setChildrenList(childrenList);
                children = parent;
            }
        }
        return result;
    }

    public List<BpmTreeModel> queryUserTree(String organName, String tenantId) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        if (!this.lcdpBpmProperties.isStartAlone()) {
            return this.assigneeChooseMapper.queryUserTree(organName);
        }
        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
        return assigneeChooseService.queryUserTree(organName);
    }

    public IPage<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, BpmTreeModel bpmTreeModel, String tenantId) {
        if (HussarUtils.isEmpty((Object)bpmTreeModel.getId()) || HussarUtils.isEmpty((Object)bpmTreeModel.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.assigneeChooseMapper.getUserListByParentId(pages, null));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(assigneeChooseService.getUserListByParentId(pages, null));
        }
        if (ORGAN.equals(bpmTreeModel.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.assigneeChooseMapper.getUserListByParentId(pages, Long.parseLong(bpmTreeModel.getId())));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(assigneeChooseService.getUserListByParentId(pages, bpmTreeModel.getId()));
        }
        if (USER.equals(bpmTreeModel.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.assigneeChooseMapper.getUserListByUserId(pages, Long.parseLong(bpmTreeModel.getId())));
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(assigneeChooseService.getUserListByUserId(pages, bpmTreeModel.getId()));
        }
        return pages.setRecords(new ArrayList());
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel, String tenantId) {
        if (HussarUtils.isEmpty((Object)bpmTreeModel.getId()) || HussarUtils.isEmpty((Object)bpmTreeModel.getParentId())) {
            return new ArrayList<BpmTreeModel>();
        }
        List<BpmTreeModel> allDept = this.assigneeChooseMapper.getAllDept();
        HashMap<String, BpmTreeModel> deptmap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptmap.put(dept.getId(), dept);
        }
        if (USER.equals(bpmTreeModel.getType())) {
            if (HussarUtils.isEmpty((Object)(bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())))) {
                return new ArrayList<BpmTreeModel>();
            }
        } else if (ORGAN.equals(bpmTreeModel.getType())) {
            bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getId());
        }
        while (deptmap.containsKey(bpmTreeModel.getParentId())) {
            ArrayList<BpmTreeModel> children = new ArrayList<BpmTreeModel>();
            children.add(bpmTreeModel);
            bpmTreeModel = ((BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())).setChildrenList(children);
        }
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        result.add(bpmTreeModel);
        return result;
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName, String tenantId) {
        String name;
        if (HussarUtils.isEmpty(users) || HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        Pattern JUDGE = Pattern.compile("[\u4e00-\u9f9f]");
        Matcher matcher = JUDGE.matcher(organName);
        String string = name = matcher.find() ? organName : organName.replace("", "%");
        if (!this.lcdpBpmProperties.isStartAlone()) {
            return this.assigneeChooseMapper.queryAssigneeAndDept(users, name);
        }
        AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
        return assigneeChooseService.queryAssigneeAndDept(users, name);
    }

    public IPage<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, List<Map<String, String>> usersInfo, NodeAssigneeQueryDto nodeAssigneeQueryDto, String tenantId) {
        AssigneeChooseService assigneeChooseService;
        ArrayList<Long> LongUsers = new ArrayList<Long>();
        ArrayList<String> StringUsers = new ArrayList<String>();
        for (Map<String, String> user : usersInfo) {
            LongUsers.add(Long.parseLong(user.get("userId")));
            StringUsers.add(user.get("userId"));
        }
        if (HussarUtils.isEmpty((Object)nodeAssigneeQueryDto.getId()) || HussarUtils.isEmpty((Object)nodeAssigneeQueryDto.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.filterOrgan(this.assigneeChooseMapper.getNodeAssigneeListByParentId(pages, null, LongUsers), usersInfo));
            }
            assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(this.filterOrgan(assigneeChooseService.getNodeAssigneeListByParentId(pages, null, String.join((CharSequence)",", StringUsers)), usersInfo));
        }
        if (ORGAN.equals(nodeAssigneeQueryDto.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.filterOrgan(this.assigneeChooseMapper.getNodeAssigneeListByParentId(pages, Long.parseLong(nodeAssigneeQueryDto.getId()), LongUsers), usersInfo));
            }
            assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(this.filterOrgan(assigneeChooseService.getNodeAssigneeListByParentId(pages, nodeAssigneeQueryDto.getId(), String.join((CharSequence)",", StringUsers)), usersInfo));
        }
        if (USER.equals(nodeAssigneeQueryDto.getType())) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                return pages.setRecords(this.filterOrgan(this.assigneeChooseMapper.getNodeAssigneeListByUserId(pages, Long.parseLong(nodeAssigneeQueryDto.getId()), LongUsers), usersInfo));
            }
            assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return pages.setRecords(this.filterOrgan(assigneeChooseService.getNodeAssigneeListByUserId(pages, nodeAssigneeQueryDto.getId(), String.join((CharSequence)",", StringUsers)), usersInfo));
        }
        return pages.setRecords(new ArrayList());
    }

    private List<BpmTreeModel> filterOrgan(List<BpmTreeModel> bpmTreeModels, List<Map<String, String>> usersInfo) {
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        bpmTreeModels.forEach(bpmTreeModel -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userId", bpmTreeModel.getId());
            map.put("deptId", bpmTreeModel.getParentId());
            if (usersInfo.contains(map)) {
                result.add((BpmTreeModel)bpmTreeModel);
            }
        });
        return result;
    }

    public List<Map<String, Object>> getUserAndAccountListByUserId(List<String> userIds) {
        ArrayList<Long> LongUsers = new ArrayList<Long>();
        for (String user : userIds) {
            LongUsers.add(Long.parseLong(user));
        }
        return this.assigneeChooseMapper.getUserAndAccountListByUserId(LongUsers);
    }

    public String getSourceDeptIdByUserId(String userId, String tenantId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return null;
        }
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                BpmTreeModel model = this.assigneeChooseMapper.getUserDept(userId);
                if (model == null) {
                    return "";
                }
                if ("2".equals(model.getType())) {
                    return model.getId();
                }
                if (model.getParentId().equals(DEFAULT_PARENTID)) {
                    return "";
                }
                List<BpmTreeModel> allOrgans = this.assigneeChooseMapper.getAllOrgansType();
                return this.getSourceOrganId(model.getParentId(), allOrgans);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.getSourceDeptIdByUserId(userId);
    }

    public List<Map<String, String>> getSourceDeptIdByUserId(List<String> userIds) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (HussarUtils.isEmpty(userIds)) {
            return null;
        }
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                List<BpmTreeModel> models = this.assigneeChooseMapper.getUsersDept(userIds);
                if (HussarUtils.isEmpty(models)) {
                    return null;
                }
                List<BpmTreeModel> allOrgans = this.assigneeChooseMapper.getAllOrgansType();
                for (BpmTreeModel model : models) {
                    String userId = "";
                    String deptId = "";
                    String deptName = "";
                    HashMap<String, String> map = new HashMap<String, String>();
                    userId = model.getLeafId();
                    if (HussarUtils.isNotEmpty((Object)model.getType())) {
                        if ("2".equals(model.getType())) {
                            deptId = model.getId();
                            deptName = model.getLabel();
                        } else {
                            if (DEFAULT_PARENTID.equals(model.getParentId())) break;
                            deptId = this.getSourceOrganId(model.getParentId(), allOrgans);
                            List<String> organNameByOrganId = this.assigneeChooseMapper.getOrganNameByOrganId(deptId, null);
                            deptName = HussarUtils.isNotEmpty(organNameByOrganId) && !organNameByOrganId.isEmpty() ? organNameByOrganId.get(0) : "";
                        }
                    }
                    map.put("userId", userId);
                    map.put("deptId", deptId);
                    map.put("deptName", deptName);
                    list.add(map);
                }
                return list;
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        List sourceDeptIdByUserIds = remoteAssigneeChooseService.getSourceDeptIdByUserIds(userIds);
        for (BpmTreeModel info : sourceDeptIdByUserIds) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userId", info.getLeafId());
            map.put("deptId", info.getId());
            map.put("deptName", info.getLabel());
            list.add(map);
        }
        return list;
    }

    public String getSameLevelSourceDeptIdByUserId(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                String userOrganId = this.getSourceDeptIdByUserId(userId, tenantId);
                if (HussarUtils.isEmpty((Object)userOrganId)) {
                    return "";
                }
                List<String> deptId = this.assigneeChooseMapper.getSameLevelDeptIdByOrganId(userOrganId);
                return String.join((CharSequence)",", deptId);
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getSameLevelSourceDeptIdByUserId(userId);
        }
        return "";
    }

    public String getParentSourceDeptIdByUserId(String userId, String tenantId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            if (!this.lcdpBpmProperties.isStartAlone()) {
                String userOrganId = this.getSourceDeptIdByUserId(userId, tenantId);
                if (HussarUtils.isEmpty((Object)userOrganId)) {
                    return "";
                }
                String userOrganParentId = this.assigneeChooseMapper.getDeptParentId(userOrganId);
                List<BpmTreeModel> allOrgans = this.assigneeChooseMapper.getAllOrgansType();
                if (userOrganParentId.equals(DEFAULT_PARENTID)) {
                    return "";
                }
                return this.getSourceOrganId(userOrganParentId, allOrgans);
            }
            AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
            return assigneeChooseService.getParentSourceDeptIdByUserId(userId);
        }
        return "";
    }

    private String getSourceOrganId(String sourceOrganId, List<BpmTreeModel> allOrgans) {
        for (BpmTreeModel organ : allOrgans) {
            if (!sourceOrganId.equals(organ.getId())) continue;
            if ("2".equals(organ.getType())) {
                return organ.getId();
            }
            if (organ.getParentId().equals(DEFAULT_PARENTID)) {
                return "";
            }
            sourceOrganId = organ.getParentId();
            break;
        }
        return this.getSourceOrganId(sourceOrganId, allOrgans);
    }

    public Object getSqlResult(Map<String, String> sqlMessage) {
        Matcher matcher;
        boolean needChangeDataSource = false;
        if (!"master".equals(sqlMessage.get("dataBaseName"))) {
            needChangeDataSource = true;
        }
        boolean isSqlError = (matcher = UPDATE_SQL_REGEX.matcher(" " + sqlMessage.get("sql").toUpperCase() + " ")).find() || sqlMessage.get("sql").contains(";");
        switch (sqlMessage.get("resultType")) {
            case "List<String>": {
                if (isSqlError) {
                    return new ArrayList();
                }
                return this.assigneeChooseMapper.getListStringSqlResult(sqlMessage.get("sql"));
            }
            case "List<Map<String, String>>": {
                if (isSqlError) {
                    return new ArrayList();
                }
                return this.assigneeChooseMapper.getListMapSqlResult(sqlMessage.get("sql"));
            }
            case "Boolean": {
                if (isSqlError) {
                    return false;
                }
                return this.assigneeChooseMapper.getBooleanSqlResult(sqlMessage.get("sql"));
            }
        }
        return null;
    }

    public List<String> getAssigneeOrgan(List<String> userIds) {
        ArrayList<Long> LongUsers = new ArrayList<Long>();
        for (String user : userIds) {
            LongUsers.add(Long.parseLong(user));
        }
        return this.assigneeChooseMapper.getAssigneeOrgan(LongUsers);
    }

    public List<Map<String, String>> getAllOrganMain() {
        return this.assigneeChooseMapper.getAllOrganMain();
    }

    public List<String> getAssigneeOrgId(String userId) {
        return this.assigneeChooseMapper.getAssigneeOrgId(userId);
    }

    public List<Map<String, String>> getAllOrganInfo(String organId) {
        return this.assigneeChooseMapper.getAllOrganInfo(organId, "2");
    }

    public List<Map<String, String>> getOrgansByParentId(String organId, List<String> userIds) {
        return this.assigneeChooseMapper.getOrgansByParentId(organId, userIds, "2");
    }

    public List<Map<String, String>> getUserInfoByIds(List<String> userIds) {
        return this.assigneeChooseMapper.getUserInfoByIds(userIds);
    }

    public Map<String, String> getOrganNameByOrganId(List<String> organIds) {
        List<Map<String, String>> organMaps = this.getUserInfoByIds(organIds);
        HashMap<String, String> organMap = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty(organMaps)) {
            for (Map<String, String> map : organMaps) {
                organMap.put(String.valueOf(map.get("ORGAN_ID")), String.valueOf(map.get("ORGAN_NAME")));
            }
        }
        return organMap;
    }

    public List<BpmUserMsg> getUserMsgByUserIds(List<String> userIds, String tenantId) {
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<BpmUserMsg>();
        }
        List<Long> ids = userIds.stream().map(Long::parseLong).collect(Collectors.toList());
        return this.assigneeChooseMapper.getUserMsgByUserIds(ids);
    }

    public List<DirectDepartmentModel> getDirectDepartmentByImmediateSuperiorIds(List<String> immediateSuperiorIds) {
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.getDirectDepartmentByImmediateSuperiorIds(immediateSuperiorIds);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
        return remoteAssigneeChooseService.getDirectDepartmentByImmediateSuperiorIds(immediateSuperiorIds);
    }

    public Map<String, String> getDeptNameByImmediateSuperiorIds(List<String> immediateSuperiorIds) {
        List<DirectDepartmentModel> directDepartmentModels = null;
        HashMap<String, String> deptMap = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty(immediateSuperiorIds)) {
            directDepartmentModels = this.getDirectDepartmentByImmediateSuperiorIds(immediateSuperiorIds);
        }
        if (HussarUtils.isNotEmpty(directDepartmentModels)) {
            List deptIds = directDepartmentModels.stream().map(DirectDepartmentModel::getDeptId).collect(Collectors.toList());
            for (DirectDepartmentModel directDepartmentModel : directDepartmentModels) {
                String immediateSuperiorId = directDepartmentModel.getImmediateSuperiorId();
                String deptName = "";
                deptName = "3".equals(directDepartmentModel.getOrganType()) ? (Collections.frequency(deptIds, directDepartmentModel.getDeptId()) > 1 ? directDepartmentModel.getDeptName() + "(" + directDepartmentModel.getImmediateSuperiorName() + ")" : directDepartmentModel.getDeptName()) : directDepartmentModel.getImmediateSuperiorName();
                deptMap.put(immediateSuperiorId, deptName);
            }
        }
        return deptMap;
    }
}

