/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.bpmn.behavior.ReceiveTaskActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendReceiveTaskActivityBehavior
extends ReceiveTaskActivityBehavior {
    private static final Logger logger = LoggerFactory.getLogger(ExtendReceiveTaskActivityBehavior.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)SpringContextHolder.getApplicationContext().getBean(ActivityRedisTimerService.class);

    public void execute(ActivityExecution execution) throws Exception {
        BpmnModel bm = this.repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        FlowElement element = bm.getFlowElement(execution.getActivity().getId());
        List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
        List receiveDueDateElement = (List)element.getExtensionElements().get("receiveDueDate");
        Date createDate = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date createTime = null;
        Date receiveDueTime = null;
        String receiveDueDate = "";
        if (HussarUtils.isNotEmpty((Object)receiveDueDateElement) && HussarUtils.isNotEmpty(((ExtensionElement)receiveDueDateElement.get(0)).getAttributes().get("receiveDueDate"))) {
            receiveDueDate = ((ExtensionAttribute)((List)((ExtensionElement)receiveDueDateElement.get(0)).getAttributes().get("receiveDueDate")).get(0)).getValue();
        }
        try {
            createTime = formatter.parse(formatter.format(createDate));
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (HussarUtils.isNotEmpty((Object)createTime) && HussarUtils.isNotEmpty((Object)receiveDueDate)) {
            receiveDueTime = new DateTime(createTime.getTime()).plus((ReadablePeriod)Period.parse((String)receiveDueDate)).toDate();
        }
        if (HussarUtils.isNotEmpty(receiveDueTime) && HussarUtils.isNotEmpty((Object)timeOutStrategy) && HussarUtils.isNotEmpty((Object)((ExtensionElement)timeOutStrategy.get(0)).getAttributes())) {
            TimeOutModel timeOutModel = new TimeOutModel();
            timeOutModel.setId(Long.valueOf(Long.parseLong(execution.getId())));
            timeOutModel.setCreateTime(createTime);
            timeOutModel.setDueTime(receiveDueTime);
            timeOutModel.setTimeOutType("receiveTask-" + ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue());
            timeOutModel.setTenantId(execution.getTenantId());
            if (timeOutModel.getTimeOutType().startsWith("receiveTask-http")) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", ((ExecutionEntity)execution).getName());
                map.put("processInsId", execution.getProcessInstanceId());
                map.put("processDefinitionId", execution.getProcessDefinitionId());
                map.put("executionId", execution.getId());
                map.put("businessId", execution.getProcessBusinessKey());
                map.put("processName", ((ExecutionEntity)execution).getProcessDefinition().getName());
                timeOutModel.setMap(JSON.toJSONString(map));
            }
            this.activityRedisTimer.addTimeOutModel(timeOutModel);
        }
    }

    public void signal(ActivityExecution execution, String signalName, Object data) throws Exception {
        ParamModel paramModel = this.getParamModel(execution);
        Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
        this.leave(execution);
    }

    public ParamModel getParamModel(ActivityExecution execution) {
        ParamModel paramModel = new ParamModel();
        String sendUser = (String)execution.getVariable("sendUser");
        paramModel.setSendUser(sendUser);
        String activityType = execution.getActivity().getProperty("type").toString();
        paramModel.setActivityType(activityType);
        paramModel.setCompleteType("complete");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        String lastNodeId = execution.getActivity().getId();
        paramModel.setLastNodeId(lastNodeId);
        String lastNodeName = execution.getActivity().getProperty("name").toString();
        paramModel.setLastNodeName(lastNodeName);
        String lastNodeHandler = (String)execution.getVariable("sendUser");
        paramModel.setLastNodeHandler(lastNodeHandler);
        paramModel.setCreateReason("skipReceiveTaskCreate");
        return paramModel;
    }
}

