/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class UnPreemptTaskCmd
extends CommonPrepareCmd {
    protected static DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);
    protected static TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);

    @Override
    protected CommonPrepareCmd.PrepareReturn execute(CommandContext commandContext, TaskEntity task) {
        task.setPreempted(null);
        List identityLinkEntityList = task.getIdentityLinks();
        Set users = identityLinkEntityList.stream().filter(identityLink -> !identityLink.isEntrust() && "candidate".equals(identityLink.getType())).map(IdentityLinkEntity::getUserId).collect(Collectors.toSet());
        if (!users.isEmpty()) {
            taskEngineMapper.unPreemptDeduplication(users, this.taskId);
        }
        String userId = (String)this.userInfo.get("userId");
        String userDept = (String)this.userInfo.get("deptId");
        if (identityLinkEntityList.size() > 1) {
            HashMap<String, String> addUsers = new HashMap<String, String>();
            ArrayList addUserMaps = new ArrayList();
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntityList) {
                if (!"preempted".equals(identityLinkEntity.getType()) || !identityLinkEntity.isEntrust() && (identityLinkEntity.isEntrust() || users.contains(identityLinkEntity.getUserId()))) continue;
                if (!identityLinkEntity.getUserId().equals(userId) || !identityLinkEntity.getOrganId().equals(userDept)) {
                    addUsers.put(identityLinkEntity.getUserId(), identityLinkEntity.getOrganId());
                }
                HashMap<String, String> addUserMap = new HashMap<String, String>();
                addUserMap.put("userId", identityLinkEntity.getUserId());
                if (identityLinkEntity.isEntrust()) {
                    addUserMap.put("mandator", identityLinkEntity.getMandator());
                    addUserMap.put("taskState", identityLinkEntity.getTaskState());
                }
                addUserMaps.add(addUserMap);
            }
            if (dataPushService.isDataPush()) {
                dataPushService.entrustDataPush(new DataPush().setUserInfo(HussarUtils.isNotEmpty(addUsers) ? Collections.singletonList(addUsers) : null).setUserMaps(addUserMaps).setTaskId(this.taskId));
            }
        }
        taskEngineMapper.unPreemptTask(this.taskId);
        return new CommonPrepareCmd.PrepareReturn(this);
    }

    @Override
    protected void taskAuthentication(TaskEntity task) {
        super.taskAuthentication(task);
        if (!task.typeOfPreempted()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotPreempt());
        }
    }

    public UnPreemptTaskCmd(String taskId, Map<String, String> userInfo) {
        super(taskId, userInfo);
    }

    public UnPreemptTaskCmd(String taskId, Map<String, String> userInfo, Map<String, String> mandatorInfo) {
        super(taskId, userInfo, mandatorInfo);
    }

    public UnPreemptTaskCmd(String taskId, Map<String, String> userInfo, Map<String, String> mandatorInfo, boolean isAuditAuthority) {
        super(taskId, userInfo, mandatorInfo, isAuditAuthority);
    }
}

