/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendParallelMultiInstanceBehavior;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.runtime.Execution;

public class MultiInstanceDelAssigneeCmd
implements Command<Void> {
    protected String executionId;
    protected String taskId;
    protected String sourceTaskDefId;
    protected String sourceTaskDefName;
    private List<Map<String, String>> assignees;
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getApplicationContext().getBean(TaskEngineMapper.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getApplicationContext().getBean(ActivityRedisTimerService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ISysActCcTaskService sysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getApplicationContext().getBean(ISysActCcTaskService.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);

    public MultiInstanceDelAssigneeCmd(String executionId, String taskId, String sourceTaskDefId, String sourceTaskDefName, List<Map<String, String>> assignees) {
        this.executionId = executionId;
        this.taskId = taskId;
        this.sourceTaskDefId = sourceTaskDefId;
        this.sourceTaskDefName = sourceTaskDefName;
        this.assignees = assignees;
    }

    public Void execute(CommandContext commandContext) {
        ActivityBehavior activityBehavior;
        List executionEntities;
        commandContext.addAttribute("sourceTaskDefId", (Object)this.sourceTaskDefId);
        commandContext.addAttribute("sourceTaskDefName", (Object)this.sourceTaskDefName);
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        ExecutionEntity ee = (ExecutionEntity)execution;
        int nrOfInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfInstances");
        int num = 1;
        if (nrOfInstances == 1) {
            throw new PublicClientException(this.bpmConstantProperties.getTheOnlyAssigneeInMulti(), Boolean.valueOf(false));
        }
        if (this.assignees != null && !this.assignees.isEmpty()) {
            Object ccTasks;
            executionEntities = ee.getParent().getExecutions();
            ArrayList<String> taskIds = new ArrayList<String>();
            ArrayList<Long> longTaskIds = new ArrayList<Long>();
            ArrayList<ExecutionEntity> entities = new ArrayList<ExecutionEntity>();
            String unDelTaskId = null;
            for (ExecutionEntity entity : executionEntities) {
                if (HussarUtils.isNotEmpty((Object)entity.getTasks()) && this.isTaskAssignee(entity)) {
                    longTaskIds.add(Long.parseLong(((TaskEntity)entity.getTasks().get(0)).getId()));
                    taskIds.add(((TaskEntity)entity.getTasks().get(0)).getId());
                    entities.add(entity);
                    continue;
                }
                if (!HussarUtils.isNotEmpty((Object)entity.getTasks())) continue;
                unDelTaskId = ((TaskEntity)entity.getTasks().get(0)).getId();
            }
            num = entities.size();
            if (nrOfInstances == num) {
                throw new PublicClientException(this.bpmConstantProperties.getTheOnlyAssigneeInMulti(), Boolean.valueOf(false));
            }
            if (num == 0) {
                return null;
            }
            this.taskEngineMapper.removeMultiHistoryTask(longTaskIds);
            if (this.dataPushService.isDataPush()) {
                this.dataPushService.deleteMultiTask(taskIds);
            }
            if (HussarUtils.isNotEmpty(unDelTaskId) && HussarUtils.isNotEmpty((Object)(ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().in(SysActCcTask::getTaskId, taskIds)))) && !ccTasks.isEmpty()) {
                ArrayList userList = new ArrayList();
                Iterator iterator = ccTasks.iterator();
                while (iterator.hasNext()) {
                    SysActCcTask ccTask = (SysActCcTask)iterator.next();
                    ccTask.setTaskId(Long.valueOf(Long.parseLong(unDelTaskId)));
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(ccTask.getReceiveUser(), ccTask.getReceiveUserDept());
                    userList.add(map);
                }
                this.sysActCcTaskService.updateBatchById((Collection)ccTasks);
                if (this.dataPushService.isDataPush()) {
                    DataPush dataPush = new DataPush();
                    dataPush.setUserInfo(userList);
                    dataPush.setTaskId(unDelTaskId);
                    this.dataPushService.addCcTask(dataPush);
                }
            }
            if (((TaskEntity)((ExecutionEntity)entities.get(0)).getTasks().get(0)).getDueDate() != null) {
                this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", taskIds));
            }
            ee = (ExecutionEntity)entities.get(0);
            for (ExecutionEntity entity : entities) {
                entity.remove();
                Context.getCommandContext().getHistoryManager().recordActivityEnd(entity);
            }
        } else {
            List ccTasks;
            this.taskEngineMapper.removeMultiHistoryTask(new ArrayList<Long>(Collections.singletonList(Long.parseLong(this.taskId))));
            if (this.dataPushService.isDataPush()) {
                this.dataPushService.deleteMultiTask(new ArrayList<String>(Collections.singletonList(this.taskId)));
            }
            executionEntities = ee.getParent().getExecutions();
            String unDelTaskId = null;
            for (ExecutionEntity entity : executionEntities) {
                if (!HussarUtils.isNotEmpty((Object)entity.getTasks()) || this.taskId.equals(((TaskEntity)entity.getTasks().get(0)).getId())) continue;
                unDelTaskId = ((TaskEntity)entity.getTasks().get(0)).getId();
                break;
            }
            if (HussarUtils.isNotEmpty(unDelTaskId) && HussarUtils.isNotEmpty((Object)(ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActCcTask::getTaskId, (Object)this.taskId))))) {
                ArrayList userList = new ArrayList();
                for (SysActCcTask ccTask : ccTasks) {
                    ccTask.setTaskId(Long.valueOf(Long.parseLong(unDelTaskId)));
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(ccTask.getReceiveUser(), ccTask.getReceiveUserDept());
                    userList.add(map);
                }
                this.sysActCcTaskService.updateBatchById((Collection)ccTasks);
                if (this.dataPushService.isDataPush()) {
                    DataPush dataPush = new DataPush();
                    dataPush.setUserInfo(userList);
                    dataPush.setTaskId(unDelTaskId);
                    this.dataPushService.addCcTask(dataPush);
                }
            }
            ee.remove();
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        }
        int nrOfCompletedInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfCompletedInstances");
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfInstances", nrOfInstances - num);
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfCompletedInstances", nrOfCompletedInstances - 1);
        if (num > 1) {
            int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfActiveInstances");
            MultiInstancePercentUtils.setLoopVariable(ee, "nrOfActiveInstances", nrOfActiveInstances - num + 1);
        }
        if ((activityBehavior = ee.getActivity().getActivityBehavior()) instanceof ExtendParallelMultiInstanceBehavior) {
            ((ExtendParallelMultiInstanceBehavior)activityBehavior).leave((ActivityExecution)ee);
        }
        return null;
    }

    private boolean isTaskAssignee(ExecutionEntity entity) {
        String userId = ((IdentityLinkEntity)((TaskEntity)entity.getTasks().get(0)).getIdentityLinks().get(0)).getUserId();
        String organId = ((IdentityLinkEntity)((TaskEntity)entity.getTasks().get(0)).getIdentityLinks().get(0)).getOrganId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("deptId", organId);
        for (Map<String, String> assignee : this.assignees) {
            if (!assignee.equals(map) && !assignee.get("userId").equals(((TaskEntity)entity.getTasks().get(0)).getAssignee())) continue;
            return true;
        }
        return false;
    }
}

