/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;

public class CommonPrepareCmd
extends NeedsActiveTaskCmd<PrepareReturn> {
    protected BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    protected IAssigneeChooseService assigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);
    protected Map<String, String> userInfo;
    protected String organId;
    protected Map<String, String> mandatorInfo;
    protected String taskState;
    protected boolean isAuditAuthority = true;

    public CommonPrepareCmd(String taskId, Map<String, String> userInfo, Map<String, String> mandatorInfo, boolean isAuditAuthority) {
        super(taskId);
        this.userInfo = userInfo;
        this.mandatorInfo = mandatorInfo;
        this.isAuditAuthority = isAuditAuthority;
    }

    public PrepareReturn execute(CommandContext commandContext) {
        TaskEntity task;
        block12: {
            block10: {
                String mandator;
                boolean mandataryFlag;
                boolean mandatorFlag;
                ArrayList<IdentityLinkEntity> userTasks;
                block16: {
                    String mandatorDept;
                    block13: {
                        block14: {
                            block15: {
                                String taskMandatorOrg;
                                block11: {
                                    if (this.taskId == null) {
                                        throw new PublicClientException(this.bpmConstantProperties.getTaskIdNull());
                                    }
                                    task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
                                    this.taskAuthentication(task);
                                    if (!this.isAuditAuthority) break block10;
                                    if (!HussarUtils.isNotEmpty((Object)task.getAssignee()) || !task.getAssignee().equals(this.userInfo.get("userId")) || !task.getProcessVariables().get("deptId").equals(this.userInfo.get("deptId"))) break block11;
                                    this.mandatorInfo = null;
                                    this.taskState = null;
                                    break block12;
                                }
                                List identityLinks = task.getIdentityLinks();
                                userTasks = new ArrayList<IdentityLinkEntity>();
                                mandatorFlag = HussarUtils.isEmpty(this.mandatorInfo);
                                mandataryFlag = HussarUtils.isNotEmpty(this.mandatorInfo);
                                String userId = this.userInfo.get("userId");
                                String userDept = this.userInfo.get("deptId");
                                mandator = HussarUtils.isNotEmpty(this.mandatorInfo) ? this.mandatorInfo.get("userId") : "";
                                mandatorDept = HussarUtils.isNotEmpty(this.mandatorInfo) ? this.mandatorInfo.get("deptId") : "";
                                for (IdentityLinkEntity identityLink : identityLinks) {
                                    if (!userId.equals(identityLink.getUserId()) || !userDept.equals(identityLink.getOrganId())) continue;
                                    userTasks.add(identityLink);
                                    this.organId = identityLink.getOrganId();
                                }
                                if (userTasks.isEmpty()) {
                                    for (IdentityLinkEntity identityLink : identityLinks) {
                                        if (!HussarUtils.isNotEmpty((Object)identityLink.getTaskState()) || !identityLink.getMandator().equals(userId) || !userDept.equals(identityLink.getOrganId())) continue;
                                        if (Context.getCommandContext().getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceCountByQueryCriteria(new HistoricTaskInstanceQueryImpl().processInstanceId(task.getProcessInstanceId())) == 1L) {
                                            return new PrepareReturn(this, "\u5f53\u524d\u4efb\u52a1\u5df2\u59d4\u6258\u7ed9(" + (String)this.assigneeChooseService.getUserListByUserId(Collections.singletonList(identityLink.getUserId()), task.getTenantId()).get(identityLink.getUserId()) + ")\uff01");
                                        }
                                        throw new PublicClientException("\u5f53\u524d\u4efb\u52a1\u5df2\u59d4\u6258\u7ed9(" + (String)this.assigneeChooseService.getUserListByUserId(Collections.singletonList(identityLink.getUserId()), task.getTenantId()).get(identityLink.getUserId()) + ")\uff01");
                                    }
                                    throw new PublicClientException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u529e\u7406\u6743\u9650\uff01");
                                }
                                if (userTasks.size() != 1) break block13;
                                if (!TaskStateType.isEntrust((IdentityLink)((IdentityLink)userTasks.get(0)))) break block14;
                                String taskMandator = ((IdentityLinkEntity)userTasks.get(0)).getMandator();
                                String string = taskMandatorOrg = ((IdentityLinkEntity)userTasks.get(0)).getMandatorOrganId() == null ? "null" : ((IdentityLinkEntity)userTasks.get(0)).getMandatorOrganId();
                                if (!HussarUtils.isNotEmpty(this.mandatorInfo) || !mandator.equals(taskMandator) || !mandatorDept.equals(taskMandatorOrg)) break block15;
                                this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                                mandatorFlag = true;
                                break block16;
                            }
                            if (!HussarUtils.isEmpty(this.mandatorInfo)) break block16;
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("userId", ((IdentityLinkEntity)userTasks.get(0)).getMandator());
                            map.put("deptId", ((IdentityLinkEntity)userTasks.get(0)).getOrganId());
                            this.mandatorInfo = map;
                            this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                            mandataryFlag = true;
                            break block16;
                        }
                        if (!HussarUtils.isEmpty(this.mandatorInfo)) break block16;
                        mandataryFlag = true;
                        break block16;
                    }
                    for (IdentityLinkEntity identityLink : userTasks) {
                        if (HussarUtils.isEmpty((Object)mandator) && HussarUtils.isEmpty((Object)identityLink.getMandator())) {
                            mandataryFlag = true;
                            break;
                        }
                        if (!HussarUtils.isNotEmpty((Object)mandator) || !mandator.equals(identityLink.getMandator()) || !mandatorDept.equals(identityLink.getOrganId())) continue;
                        mandatorFlag = true;
                        this.taskState = identityLink.getTaskState();
                        break;
                    }
                }
                if (!mandatorFlag) {
                    throw new PublicClientException("\u7528\u6237(" + (String)this.assigneeChooseService.getUserListByUserId(Collections.singletonList(mandator), task.getTenantId()).get(mandator) + ")\u4e0d\u662f\u59d4\u6258\u4eba\uff01");
                }
                if (!mandataryFlag) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("userId", ((IdentityLinkEntity)userTasks.get(0)).getMandator());
                    map.put("deptId", ((IdentityLinkEntity)userTasks.get(0)).getOrganId());
                    this.mandatorInfo = map;
                    this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                }
                break block12;
            }
            if (HussarUtils.isNotEmpty(this.userInfo)) {
                this.organId = this.userInfo.get("deptId");
            }
        }
        this.follow(commandContext, task);
        return new PrepareReturn(this);
    }

    protected PrepareReturn execute(CommandContext commandContext, TaskEntity task) {
        block11: {
            block9: {
                boolean mandataryFlag;
                boolean mandatorFlag;
                ArrayList<IdentityLinkEntity> userTasks;
                block15: {
                    block12: {
                        block13: {
                            block14: {
                                String userDept;
                                String userId;
                                block10: {
                                    this.taskAuthentication(task);
                                    userId = this.userInfo.get("userId");
                                    userDept = this.userInfo.get("deptId");
                                    if (!this.isAuditAuthority) break block9;
                                    List collect = task.getIdentityLinks().stream().filter(identityLink -> identityLink.getUserId().equals(userId)).collect(Collectors.toList());
                                    String deptId = ((IdentityLinkEntity)collect.get(0)).getOrganId();
                                    if (!HussarUtils.isNotEmpty((Object)task.getAssignee()) || !task.getAssignee().equals(userId) || !deptId.equals(userDept)) break block10;
                                    this.mandatorInfo = null;
                                    this.taskState = null;
                                    break block11;
                                }
                                List identityLinks = task.getIdentityLinkType("candidate");
                                userTasks = new ArrayList<IdentityLinkEntity>();
                                mandatorFlag = HussarUtils.isEmpty(this.mandatorInfo);
                                mandataryFlag = HussarUtils.isNotEmpty(this.mandatorInfo);
                                for (IdentityLinkEntity identityLink2 : identityLinks) {
                                    if (!userId.equals(identityLink2.getUserId()) || !userDept.equals(identityLink2.getOrganId())) continue;
                                    userTasks.add(identityLink2);
                                    this.organId = userDept;
                                }
                                if (userTasks.isEmpty()) {
                                    for (IdentityLinkEntity identityLink2 : identityLinks) {
                                        if (!HussarUtils.isNotEmpty((Object)identityLink2.getTaskState()) || !identityLink2.getMandator().equals(userId) || !identityLink2.getOrganId().equals(userDept)) continue;
                                        if (Context.getCommandContext().getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceCountByQueryCriteria(new HistoricTaskInstanceQueryImpl().processInstanceId(task.getProcessInstanceId())) == 1L) {
                                            return new PrepareReturn(this, "\u5f53\u524d\u4efb\u52a1\u5df2\u59d4\u6258\u7ed9(" + (String)this.assigneeChooseService.getUserListByUserId(Collections.singletonList(identityLink2.getUserId()), BaseSecurityUtil.getUser().getStringTenantId()).get(identityLink2.getUserId()) + ")\uff01");
                                        }
                                        throw new PublicClientException("\u5f53\u524d\u4efb\u52a1\u5df2\u59d4\u6258\u7ed9(" + (String)this.assigneeChooseService.getUserListByUserId(Collections.singletonList(identityLink2.getUserId()), BaseSecurityUtil.getUser().getStringTenantId()).get(identityLink2.getUserId()) + ")\uff01");
                                    }
                                    throw new PublicClientException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u529e\u7406\u6743\u9650\uff01");
                                }
                                if (userTasks.size() != 1) break block12;
                                if (!TaskStateType.isEntrust((IdentityLink)((IdentityLink)userTasks.get(0)))) break block13;
                                String taskMandator = ((IdentityLinkEntity)userTasks.get(0)).getMandator();
                                String taskMandatorOrg = ((IdentityLinkEntity)userTasks.get(0)).getOrganId();
                                if (!HussarUtils.isNotEmpty(this.mandatorInfo) || !this.mandatorInfo.get("userId").equals(taskMandator) || !this.mandatorInfo.get("deptId").equals(taskMandatorOrg)) break block14;
                                this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                                mandatorFlag = true;
                                break block15;
                            }
                            if (!HussarUtils.isEmpty(this.mandatorInfo)) break block15;
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("userId", ((IdentityLinkEntity)userTasks.get(0)).getMandator());
                            map.put("deptId", ((IdentityLinkEntity)userTasks.get(0)).getOrganId());
                            this.mandatorInfo = map;
                            this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                            mandataryFlag = true;
                            break block15;
                        }
                        if (!HussarUtils.isEmpty(this.mandatorInfo)) break block15;
                        mandataryFlag = true;
                        break block15;
                    }
                    for (IdentityLinkEntity identityLink2 : userTasks) {
                        if (HussarUtils.isEmpty(this.mandatorInfo) && HussarUtils.isEmpty((Object)identityLink2.getMandator())) {
                            mandataryFlag = true;
                            break;
                        }
                        if (!HussarUtils.isNotEmpty(this.mandatorInfo) || !this.mandatorInfo.get("userId").equals(identityLink2.getMandator()) || !this.mandatorInfo.get("deptId").equals(identityLink2.getOrganId())) continue;
                        mandatorFlag = true;
                        this.taskState = identityLink2.getTaskState();
                        break;
                    }
                }
                if (!mandatorFlag) {
                    throw new PublicClientException("\u7528\u6237(" + (String)this.assigneeChooseService.getUserListByUserId(new ArrayList<String>(this.mandatorInfo.keySet()), BaseSecurityUtil.getUser().getStringTenantId()).get(this.mandatorInfo.get("userId")) + ")\u4e0d\u662f\u59d4\u6258\u4eba\uff01");
                }
                if (!mandataryFlag) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("userId", ((IdentityLinkEntity)userTasks.get(0)).getMandator());
                    map.put("deptId", ((IdentityLinkEntity)userTasks.get(0)).getOrganId());
                    this.mandatorInfo = map;
                    this.taskState = ((IdentityLinkEntity)userTasks.get(0)).getTaskState();
                }
                break block11;
            }
            if (HussarUtils.isNotEmpty(this.userInfo)) {
                this.organId = this.userInfo.get("deptId");
            }
        }
        this.follow(commandContext, task);
        return new PrepareReturn(this);
    }

    protected void taskAuthentication(TaskEntity task) {
        if (task == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
        }
        if (task.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended());
        }
    }

    public CommonPrepareCmd(String taskId, Map<String, String> userInfo) {
        super(taskId);
        this.userInfo = userInfo;
    }

    public CommonPrepareCmd(String taskId, Map<String, String> userInfo, Map<String, String> mandatorInfo) {
        super(taskId);
        this.userInfo = userInfo;
        this.mandatorInfo = mandatorInfo;
    }

    protected void follow(CommandContext commandContext, TaskEntity task) {
    }

    public CommonPrepareCmd notAuditAuthority() {
        this.isAuditAuthority = false;
        return this;
    }

    public CommonPrepareCmd isAuditAuthority(boolean isAuditAuthority) {
        this.isAuditAuthority = isAuditAuthority;
        return this;
    }

    public static class PrepareReturn {
        private final Map<String, String> mandatorInfo;
        private final String taskState;
        private final boolean isSuccess;
        private final String message;

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public String getMessage() {
            return this.message;
        }

        public Map<String, String> getMandatorInfo() {
            return this.mandatorInfo;
        }

        public String getTaskState() {
            return this.taskState;
        }

        PrepareReturn(CommonPrepareCmd commonPrepareCmd) {
            this.mandatorInfo = commonPrepareCmd.mandatorInfo;
            this.taskState = commonPrepareCmd.taskState;
            this.isSuccess = true;
            this.message = null;
        }

        private PrepareReturn(CommonPrepareCmd commonPrepareCmd, String message) {
            this.mandatorInfo = commonPrepareCmd.mandatorInfo;
            this.taskState = commonPrepareCmd.taskState;
            this.isSuccess = false;
            this.message = message;
        }
    }
}

