/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;

public class AddAssigneeCmd
implements Command<Void> {
    private TaskService taskService = (TaskService)SpringContextHolder.getApplicationContext().getBean(TaskService.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    protected List<Map<String, String>> usersInfo;
    protected String taskId;
    protected Map<String, String> entrustMap;

    public AddAssigneeCmd(String taskId, List<Map<String, String>> usersInfo) {
        this.usersInfo = usersInfo;
        this.taskId = taskId;
    }

    public AddAssigneeCmd(String taskId, Map<String, String> entrustMap) {
        this.taskId = taskId;
        this.entrustMap = entrustMap;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (taskEntity == null) {
            throw new PublicClientException(bpmConstantProperties.getTaskNotFound(), Boolean.valueOf(false));
        }
        if (HussarUtils.isNotEmpty(this.entrustMap)) {
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            list.add(this.entrustMap);
            taskEntity.addEntrustCandidateUser(list);
            return null;
        }
        if (HussarUtils.isNotEmpty(this.usersInfo)) {
            Set<String> userSet = this.getAssigneeByTaskId(taskEntity.getId());
            for (String user : userSet) {
                this.taskService.deleteCandidateUser(taskEntity.getId(), user);
            }
            taskEntity.addCandidateUsers(this.usersInfo);
        }
        return null;
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        List identityLinkList;
        HashSet<String> userSet = new HashSet<String>();
        if (HussarUtils.isNotEmpty((Object)taskId) && (identityLinkList = this.taskService.getIdentityLinksType(taskId)) != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                userSet.add(identityLink.getUserId());
            }
        }
        return userSet;
    }
}

