/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpRequestUtil {
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private static Logger logger = LogManager.getLogger(HttpRequestUtil.class);
    public static final String UTF_8 = "utf-8";
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    public static String getRequestResult(String address, Map<String, Object> params) {
        String stringParam = "";
        if (params != null && !params.isEmpty()) {
            StringBuilder str = new StringBuilder();
            Set<String> set = params.keySet();
            Iterator<String> iter = set.iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                if (params.get(key) == null) continue;
                try {
                    str.append(key).append("=").append(URLEncoder.encode(String.valueOf(params.get(key)), UTF_8)).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (str.length() > 0) {
                stringParam = "?" + str.substring(0, str.length() - 1);
            }
        }
        return HttpRequestUtil.getRequestResult(address, stringParam, false);
    }

    public static String post(String address, Map<String, Object> params) {
        String stringParam = "";
        if (params != null && !params.isEmpty()) {
            StringBuilder str = new StringBuilder();
            Set<String> set = params.keySet();
            Iterator<String> iter = set.iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                if (params.get(key) == null) continue;
                try {
                    str.append(key).append("=").append(URLEncoder.encode(String.valueOf(params.get(key)), UTF_8)).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (str.length() > 0) {
                stringParam = "?" + str.substring(0, str.length() - 1);
            }
        }
        return HttpRequestUtil.getRequestResult(address, stringParam, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRequestResult(String address, String stringParam, boolean isPost) {
        HttpURLConnection conn = null;
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        OutputStreamWriter outputStreamWriter = null;
        StringBuilder result = new StringBuilder();
        try {
            try {
                URL url = new URL(isPost ? address : address + stringParam);
                conn = (HttpURLConnection)url.openConnection();
                conn.setReadTimeout(lcdpBpmProperties.getReadTimeOut());
                conn.setConnectTimeout(lcdpBpmProperties.getConnectionTimeOut());
                if (isPost) {
                    conn.setDoOutput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("POST");
                    if (stringParam != null && !stringParam.isEmpty()) {
                        outputStreamWriter = new OutputStreamWriter(conn.getOutputStream(), UTF_8);
                        outputStreamWriter.write(stringParam);
                        outputStreamWriter.flush();
                    }
                } else {
                    conn.connect();
                }
                if (conn.getResponseCode() == 404) {
                    logger.error(address + "\u8c03\u7528\u5931\u8d25\uff01");
                    throw new PublicClientException(bpmConstantProperties.getError404());
                }
            }
            catch (Exception e) {
                logger.error(address + "\u8c03\u7528\u5931\u8d25\uff01", (Throwable)e);
                throw new PublicClientException(bpmConstantProperties.getErrorHttpRequest());
            }
            try {
                String line;
                inputStreamReader = new InputStreamReader(conn.getInputStream(), UTF_8);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((line = bufferedReader.readLine()) != null) {
                    result.append(line);
                }
                if (conn.getResponseCode() != 200) {
                    logger.error(address + "\u8c03\u7528\u5931\u8d25\uff01");
                    throw new PublicClientException(bpmConstantProperties.getErrorHttpRequest());
                }
            }
            catch (Exception e) {
                logger.error(address + "\u8c03\u7528\u5931\u8d25\uff01", (Throwable)e);
                throw new PublicClientException(bpmConstantProperties.getErrorHttpRequest());
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result.toString();
    }

    private HttpRequestUtil() {
    }
}

