/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowProcess;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowTaskServiceImpl
implements IFlowTaskService {
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;

    public ApiResponse<Page<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel, String tenantId) {
        TaskManagerQueryVo taskManagerQueryVo;
        Object variables22;
        long todoTotal = this.flowTaskMapper.countTodoTotal(flowTaskQueryModel);
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> todoList = this.flowTaskMapper.todoList(pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask2 : todoList) {
            taskIds.add(Long.parseLong(flowTask2.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask2.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        if (!todoList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.flowTaskMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowTaskMapper.getAllToDoVariables(taskIds, null);
            allVariables.addAll(this.flowTaskMapper.getAllToDoVariables(null, processInsIds));
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables22 : allVariables) {
            List<Object> list;
            if (variables22.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables22.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables22);
                processVariablesMap.put(variables22.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables22.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables22);
            taskVariablesMap.put(variables22.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        variables22 = todoList.iterator();
        while (variables22.hasNext()) {
            FlowTask flowTask3;
            flowTask3.setTaskVariables(taskVariablesMap.get((flowTask3 = (FlowTask)variables22.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask3.getTaskId()));
            flowTask3.setProcessVariables(processVariablesMap.get(flowTask3.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask3.getProcessInsId()));
            FlowProcess flowProcess = (FlowProcess)processMap.get(flowTask3.getProcessInsId());
            flowTask3.setBusinessId(flowProcess.getBusinessId());
            flowTask3.setDeptId(flowProcess.getDeptId());
            flowTask3.setDeptName(flowProcess.getDeptName());
            flowTask3.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask3.setProcessEndTime(flowProcess.getProcessEndTime());
            flowTask3.setStartUserName(flowProcess.getStartUserName());
            flowTask3.setTitle(flowProcess.getTitle());
            flowTask3.setProcessStatus(flowProcess.getProcessStatus());
        }
        ArrayList<TaskManagerQueryVo> resultData = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        HashSet<String> deptIds = new HashSet<String>();
        for (FlowTask flowTask : todoList) {
            taskManagerQueryVo = new TaskManagerQueryVo();
            taskManagerQueryVo.setTaskId(HussarUtils.isNotEmpty((Object)flowTask.getTaskState()) ? flowTask.getTaskId() + ":" + flowTask.getOwner() + ":" + flowTask.getOwnerOrgan() : flowTask.getTaskId());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
            taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
            taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
            taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setStartTime(flowTask.getStartTime());
            taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
            taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
            taskManagerQueryVo.setFormKey(flowTask.getFormKey());
            taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
            taskManagerQueryVo.setTaskState(flowTask.getTaskState());
            taskManagerQueryVo.setOwner(flowTask.getOwner());
            taskManagerQueryVo.setSendUserDept(flowTask.getSendUserDept());
            taskManagerQueryVo.setFormAddress((Map)JSON.parse((String)flowTask.getFormKey()));
            if (taskManagerQueryVo.getFormAddress() != null) {
                taskManagerQueryVo.setWeb((String)taskManagerQueryVo.getFormAddress().get("web"));
                taskManagerQueryVo.setMobile((String)taskManagerQueryVo.getFormAddress().get("mobile"));
            }
            taskManagerQueryVo.setVariables(flowTask.getProcessVariableMap());
            taskManagerQueryVo.setTaskVariables(flowTask.getTaskVariableMap());
            if (flowTask.getTaskVariableMap() != null) {
                taskManagerQueryVo.setMessage((String)(flowTask.getTaskVariableMap().get("todoConfiguration") == null ? flowTask.getTaskVariableMap().get("todoConfiguration".toLowerCase()) : flowTask.getTaskVariableMap().get("todoConfiguration")));
                taskManagerQueryVo.setTaskSourceFlag((String)(flowTask.getTaskVariableMap().get("taskSourceFlag") == null ? flowTask.getTaskVariableMap().get("taskSourceFlag".toLowerCase()) : flowTask.getTaskVariableMap().get("taskSourceFlag")));
                taskManagerQueryVo.setSendUser((String)(flowTask.getTaskVariableMap().get("sendUser") == null ? flowTask.getTaskVariableMap().get("sendUser".toLowerCase()) : flowTask.getTaskVariableMap().get("sendUser")));
                if ("reject".equalsIgnoreCase((String)(flowTask.getTaskVariableMap().get("complete_type") == null ? flowTask.getTaskVariableMap().get("complete_type".toLowerCase()) : flowTask.getTaskVariableMap().get("complete_type")))) {
                    taskManagerQueryVo.setIsReject("1");
                } else {
                    taskManagerQueryVo.setIsReject("0");
                }
            }
            userIds.add(String.valueOf(taskManagerQueryVo.getSendUser()));
            userIds.add(String.valueOf(taskManagerQueryVo.getAssigneeId()));
            userIds.add(String.valueOf(taskManagerQueryVo.getOwner()));
            deptIds.add(String.valueOf(taskManagerQueryVo.getSendUserDept()));
            taskManagerQueryVo.setStartUserName(flowTask.getStartUserName());
            taskManagerQueryVo.setDeptId(flowTask.getDeptId());
            taskManagerQueryVo.setDeptName(flowTask.getDeptName());
            taskManagerQueryVo.setProcessStatus(flowTask.getProcessStatus());
            taskManagerQueryVo.setTitle(flowTask.getTitle());
            resultData.add(taskManagerQueryVo);
        }
        Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        Map directOrgs = this.iAssigneeChooseService.getDeptNameByImmediateSuperiorIds(new ArrayList(deptIds));
        Iterator iterator = resultData.iterator();
        while (iterator.hasNext()) {
            taskManagerQueryVo.setSendUserName(finalUsers.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator.next()).getSendUser()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getSendUser()));
            taskManagerQueryVo.setAssigneeName(finalUsers.get(taskManagerQueryVo.getAssigneeId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getAssigneeId()));
            taskManagerQueryVo.setOwnerName(finalUsers.get(taskManagerQueryVo.getOwner()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getOwner()));
            taskManagerQueryVo.setSendUserDeptName((String)directOrgs.get(taskManagerQueryVo.getSendUserDept()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(resultData);
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel, String tenantId) {
        Object variables2;
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = null;
            securityLevel = this.iAssigneeChooseService.getSecurityLevel(flowTaskQueryModel.getUserId(), null, tenantId);
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        long todoTotal = this.flowTaskMapper.countDoneTotal(flowTaskQueryModel);
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<FlowTask> doneList = this.flowTaskMapper.doneList(pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        if (!doneList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.flowTaskMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowTaskMapper.getAllVariables(taskIds, null));
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables2 : allVariables) {
            List<Object> list;
            if (variables2.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables2.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables2);
                processVariablesMap.put(variables2.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables2.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables2);
            taskVariablesMap.put(variables2.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        variables2 = doneList.iterator();
        while (variables2.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)variables2.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            FlowProcess flowProcess = (FlowProcess)processMap.get(flowTask.getProcessInsId());
            flowTask.setBusinessId(flowProcess.getBusinessId());
            flowTask.setDeptId(flowProcess.getDeptId());
            flowTask.setDeptName(flowProcess.getDeptName());
            flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
            flowTask.setStartUserName(flowProcess.getStartUserName());
            flowTask.setTitle(flowProcess.getTitle());
            flowTask.setProcessStatus(flowProcess.getProcessStatus());
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList, tenantId));
        return ApiResponse.success((Object)page);
    }

    private List<TaskManagerQueryVo> hisTasksToVo(List<FlowTask> lists, String tenantId) {
        ArrayList<TaskManagerQueryVo> list = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        HashSet<String> deptIds = new HashSet<String>();
        Map finalUsers = new HashMap();
        Map directOrgs = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map taskVariables = flowTask.getTaskVariableMap();
                if (HussarUtils.isNotEmpty(taskVariables.get("sendUser"))) {
                    userIds.add(String.valueOf(taskVariables.get("sendUser")));
                }
                if (HussarUtils.isNotEmpty(taskVariables.get("sendUserOrganId"))) {
                    deptIds.add(String.valueOf(taskVariables.get("sendUserOrganId")));
                }
                if (HussarUtils.isNotEmpty(taskVariables.get("assigneeOrganId"))) {
                    deptIds.add(String.valueOf(taskVariables.get("assigneeOrganId")));
                }
                userIds.add(flowTask.getUserId());
                ids.add(flowTask.getTaskDefinitionKey());
            }
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            directOrgs = this.iAssigneeChooseService.getDeptNameByImmediateSuperiorIds(new ArrayList(deptIds));
        }
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                String scope;
                TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
                Map variables = flowTask.getProcessVariableMap();
                Map taskVariables = flowTask.getTaskVariableMap();
                taskManagerQueryVo.setTaskId(flowTask.getTaskId());
                taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
                taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
                taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
                taskManagerQueryVo.setAssigneeName((String)finalUsers.get(flowTask.getUserId()));
                taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
                taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
                taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
                taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
                taskManagerQueryVo.setStartTime(flowTask.getStartTime());
                taskManagerQueryVo.setEndTime(flowTask.getEndTime());
                taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
                taskManagerQueryVo.setProcessEndTime(flowTask.getProcessEndTime());
                taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
                taskManagerQueryVo.setVariables(variables);
                taskManagerQueryVo.setOwner(flowTask.getOwner());
                taskManagerQueryVo.setTaskState(flowTask.getTaskState());
                taskManagerQueryVo.setTaskVariables(taskVariables);
                taskManagerQueryVo.setTaskSourceFlag((String)taskVariables.get("taskSourceFlag"));
                taskManagerQueryVo.setRevokeFlag(flowTask.getRevokeFlag());
                String sendUserOrganId = (String)taskVariables.get("sendUserOrganId");
                String assigneeOrganId = flowTask.getAssigneeOrganId();
                if (HussarUtils.isNotEmpty((Object)assigneeOrganId)) {
                    taskManagerQueryVo.setAssigneeOrganId(assigneeOrganId);
                    taskManagerQueryVo.setAssigneeDeptName((String)directOrgs.get(assigneeOrganId));
                }
                if (HussarUtils.isNotEmpty((Object)sendUserOrganId)) {
                    taskManagerQueryVo.setSendUserDept(sendUserOrganId);
                    taskManagerQueryVo.setSendUserDeptName((String)directOrgs.get(sendUserOrganId));
                }
                scope = "reject".equals(scope = String.valueOf(taskVariables.get("taskSourceFlag"))) ? "\u5df2\u9a73\u56de" : (HussarUtils.isNotEmpty((Object)flowTask.getEndTime()) ? "\u5df2\u5b8c\u6210" : "\u672a\u5b8c\u6210");
                taskManagerQueryVo.setState(scope);
                taskManagerQueryVo.setSendUser((String)taskVariables.get("sendUser"));
                taskManagerQueryVo.setSendUserName((String)finalUsers.get(taskVariables.get("sendUser")));
                String message = HussarUtils.isNotEmpty((Object)flowTask.getTodoConfiguration()) ? flowTask.getTodoConfiguration() : (taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString());
                taskManagerQueryVo.setMessage(message);
                taskManagerQueryVo.setFormKey(flowTask.getFormKey());
                String formDetail = flowTask.getFormDetail();
                taskManagerQueryVo.setFormDetailKey(formDetail);
                if (HussarUtils.isNotEmpty((Object)formDetail)) {
                    JSONObject object = JSON.parseObject((String)formDetail);
                    taskManagerQueryVo.setWeb(object.getString("web"));
                    taskManagerQueryVo.setMobile(object.getString("mobile"));
                }
                taskManagerQueryVo.setStartUserName(flowTask.getStartUserName());
                taskManagerQueryVo.setDeptId(flowTask.getDeptId());
                taskManagerQueryVo.setDeptName(flowTask.getDeptName());
                taskManagerQueryVo.setProcessStatus(flowTask.getProcessStatus());
                taskManagerQueryVo.setTitle(flowTask.getTitle());
                list.add(taskManagerQueryVo);
            }
        }
        return list;
    }
}

