/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAssigneeSaveTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;

public class MultiInstanceAddAssigneeCmd
implements Command<Map<String, String>> {
    protected String executionId;
    protected List<Map<String, String>> assigneeInfo;
    private long dueTime;
    private String outTimeType;
    private Map<String, Object> variableMap;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);

    public MultiInstanceAddAssigneeCmd(String executionId, List<Map<String, String>> assigneeInfo, long dueTime, String outTimeType, Map<String, Object> variableMap) {
        this.executionId = executionId;
        this.assigneeInfo = assigneeInfo;
        this.dueTime = dueTime;
        this.outTimeType = outTimeType;
        this.variableMap = variableMap;
    }

    public Map<String, String> execute(CommandContext commandContext) {
        if (this.assigneeInfo == null || this.assigneeInfo.isEmpty()) {
            return null;
        }
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        TaskService taskService = pec.getTaskService();
        IdGenerator idGenerator = pec.getIdGenerator();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        ExecutionEntity ee = (ExecutionEntity)execution;
        ExecutionEntity parent = ee.getParent();
        Task newTask = (Task)((TaskQuery)((TaskQuery)taskService.createTaskQuery().executionId(this.executionId)).includeTaskLocalVariables()).singleResult();
        HashMap<String, String> newTaskIdMap = new HashMap<String, String>();
        for (Map<String, String> userInfo : this.assigneeInfo) {
            TaskEntity t = (TaskEntity)newTask;
            ExecutionEntity newExecution = parent.createExecution();
            newExecution.setActive(true);
            newExecution.setConcurrent(true);
            newExecution.setScope(false);
            TaskEntity taskEntity = new TaskEntity();
            taskEntity.setCreateTime(new Date());
            taskEntity.setTaskDefinition(t.getTaskDefinition());
            taskEntity.setProcessDefinitionId(t.getProcessDefinitionId());
            taskEntity.setTaskDefinitionKey(t.getTaskDefinitionKey());
            taskEntity.setFormKey(t.getFormKey());
            taskEntity.setProcessInstanceId(t.getProcessInstanceId());
            taskEntity.setExecutionId(newExecution.getId());
            taskEntity.setName(newTask.getName());
            String taskId = idGenerator.getNextId();
            taskEntity.setId(taskId);
            taskEntity.setExecution(newExecution);
            taskEntity.addCandidateUser(Collections.singletonList(userInfo));
            taskEntity.setSubProcessKey(t.getSubProcessKey());
            taskEntity.setSourceTaskDefId(t.getSourceTaskDefId());
            taskEntity.setSourceTaskDefName(t.getSourceTaskDefName());
            newTaskIdMap.put(userInfo.get("userId"), taskId);
            if (HussarUtils.isNotEmpty((Object)newTask.getTaskLocalVariables())) {
                for (String key : newTask.getTaskLocalVariables().keySet()) {
                    taskEntity.setVariableLocal(key, newTask.getTaskLocalVariables().get(key));
                }
            }
            if (this.dueTime != 0L && this.outTimeType != null) {
                taskEntity.setDueDate(new Date(taskEntity.getCreateTime().getTime() + this.dueTime));
                TimeOutModel timeOutModel = new TimeOutModel();
                timeOutModel.setId(Long.valueOf(Long.parseLong(taskId)));
                timeOutModel.setCreateTime(taskEntity.getCreateTime());
                timeOutModel.setDueTime(taskEntity.getDueDate());
                String temp = userInfo.get("userId") + ":" + userInfo.get("deptId");
                timeOutModel.setAssigneeAndDept(temp);
                timeOutModel.setTimeOutType(this.outTimeType);
                timeOutModel.setTenantId(execution.getTenantId());
                if (timeOutModel.getTimeOutType().startsWith("http") || "urging".equals(timeOutModel.getTimeOutType())) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("name", taskEntity.getName());
                    map.put("processInsId", taskEntity.getProcessInstanceId());
                    map.put("processDefinitionId", taskEntity.getProcessDefinitionId());
                    map.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
                    map.put("formKey", taskEntity.getFormKey());
                    ExecutionEntity entity = parent;
                    while (entity.getParent() != null) {
                        entity = entity.getParent();
                    }
                    map.put("businessId", entity.getProcessBusinessKey());
                    map.put("processName", entity.getProcessDefinition().getName());
                    map.put("todoConfiguration", taskEntity.getVariable("todoConfiguration"));
                    map.put("sendUser", taskEntity.getVariable("sendUser"));
                    map.put("sendUserOrganId", taskEntity.getVariable("sendUserOrganId"));
                    timeOutModel.setMap(JSON.toJSONString(map));
                }
                this.activityRedisTimerService.addTimeOutModel(timeOutModel);
            }
            this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeSaveTaskCmd((Task)taskEntity, (Execution)taskEntity.getExecution()));
            taskService.setVariablesLocal(taskEntity.getId(), this.variableMap);
            int nrOfInstances = MultiInstancePercentUtils.getLoopVariable(newExecution, "nrOfInstances");
            int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(newExecution, "nrOfActiveInstances");
            MultiInstancePercentUtils.setLoopVariable(newExecution, "nrOfInstances", nrOfInstances + 1);
            MultiInstancePercentUtils.setLoopVariable(newExecution, "nrOfActiveInstances", nrOfActiveInstances + 1);
        }
        return newTaskIdMap;
    }
}

