/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.taskmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.AssistQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d41\u7a0b\u534f\u529e"})
@RequestMapping(value={"/bpm/assist"})
public class AssistManageController {
    private static final Logger logger = LoggerFactory.getLogger(AssistManageController.class);
    @Autowired
    private IFlowTaskService flowTaskService;

    @GetMapping(value={"/queryAssistTaskList"})
    @ApiOperation(value="\u83b7\u53d6\u534f\u529e\u4efb\u52a1\u5217\u8868", notes="\u83b7\u53d6\u534f\u529e\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u534f\u529e\u4efb\u52a1\u5217\u8868", eventDesc="\u83b7\u53d6\u534f\u529e\u4efb\u52a1\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<TaskManagerQueryVo>> queryAssistTaskList(Page<TaskManagerQueryVo> pages, AssistQueryDto assistQueryDto) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        String userId = null;
        String assistInitiator = null;
        if (assistQueryDto.isAssistInitator()) {
            assistInitiator = String.valueOf(BaseSecurityUtil.getUser().getId());
        } else {
            userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        }
        try {
            start = HussarUtils.isNotEmpty((Object)assistQueryDto.getStartTime()) ? formatter.parse(assistQueryDto.getStartTime()) : null;
            end = HussarUtils.isNotEmpty((Object)assistQueryDto.getEndTime()) ? formatter.parse(assistQueryDto.getEndTime()) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (assistQueryDto.isFinished()) {
            return this.flowTaskService.doneList(new Page(pages.getCurrent(), pages.getSize()), new FlowTaskQueryModel().setProcessKey(assistQueryDto.getProcessKey()).setDefinitionKey(assistQueryDto.getTaskDefinitionKey()).setUserId(userId).setSendUserId(assistQueryDto.getSendUserId()).setTodoConfiguration(assistQueryDto.getMessage()).setStartTime(start).setEndTime(end).setTaskType("2").setAssistInitiator(assistInitiator), BaseSecurityUtil.getUser().getStringTenantId());
        }
        return this.flowTaskService.todoList(new Page(pages.getCurrent(), pages.getSize()), new FlowTaskQueryModel().setProcessKey(assistQueryDto.getProcessKey()).setDefinitionKey(assistQueryDto.getTaskDefinitionKey()).setUserId(userId).setSendUserId(assistQueryDto.getSendUserId()).setTodoConfiguration(assistQueryDto.getMessage()).setStartTime(start).setEndTime(end).setTaskType("2").setAssistInitiator(assistInitiator), BaseSecurityUtil.getUser().getStringTenantId());
    }
}

