/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.RevokeFlagUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class TaskCompleteListener
implements ActivitiEventListener {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    private static Logger logger = LogManager.getLogger(TaskCompleteListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        Set<String> set;
        String type;
        TaskEntity taskEntity = (TaskEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        boolean flag = "1".equals(taskEntity.getUrgeState());
        if (flag) {
            this.sysActUrgeTaskMapper.deleteByTaskId(Long.parseLong(taskEntity.getId()));
        }
        boolean isSubProcessStart = false;
        if (taskEntity.getProcessInstance().getSuperExecution() != null) {
            String callCompleteFrom = (String)taskEntity.getVariableLocal("call_complete_from");
            String mainRejectFrom = (String)taskEntity.getVariableLocal("main_reject_from");
            if (callCompleteFrom != null || mainRejectFrom != null) {
                isSubProcessStart = true;
                HashSet<String> set2 = new HashSet<String>();
                if (mainRejectFrom != null) {
                    set2.add(mainRejectFrom);
                } else {
                    String allPervNode = (String)taskEntity.getVariableLocal("all_prev_node");
                    if (allPervNode != null && allPervNode.length() != 0) {
                        RevokeFlagUtil.getRevokeFlagTask(allPervNode.replace("'", ""), set2);
                    }
                }
                if (!set2.isEmpty()) {
                    this.taskEngineMapper.cancelNodeRevoke(Long.parseLong(taskEntity.getProcessInstance().getSuperExecution().getProcessInstanceId()), set2, null);
                }
            }
        }
        if (!((type = (String)Context.getCommandContext().getAttribute("type")) != null && type.endsWith("revoke") || isSubProcessStart || (set = RevokeFlagUtil.getRevokeFlagTask(taskEntity)).isEmpty())) {
            this.taskEngineMapper.cancelNodeRevoke(Long.parseLong(taskEntity.getProcessInstanceId()), set, taskEntity.getSubProcessKey());
        }
        if ("freejump".equals(type) || "complete".equals(type) || "reject".equals(type) && Context.getCommandContext().getAttribute("isAffected") != null) {
            HistoricTaskInstanceEntity historicTaskInstance = Context.getCommandContext().getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(taskEntity.getId());
            if (HussarUtils.isNotEmpty((Object)historicTaskInstance)) {
                historicTaskInstance.setRevokeFlag("1");
            }
            this.taskEngineMapper.cancelNodeRevoke(Long.parseLong(taskEntity.getProcessInstanceId()), Collections.singleton(taskEntity.getTaskDefinitionKey()), taskEntity.getSubProcessKey());
        }
    }

    public boolean isFailOnException() {
        logger.error("\u4efb\u52a1\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

