/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;

public class EntrustAssigneeCmd
implements Command<Void> {
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private ISysActEntrustService sysActEntrustService = (ISysActEntrustService)BpmSpringContextHolder.getBean(ISysActEntrustService.class);
    protected String taskId;
    protected List<Map<String, String>> userInfo;
    protected List<Map<String, String>> mandataryInfo;
    protected boolean isAdd;
    protected boolean isSame;

    public EntrustAssigneeCmd(String taskId, List<Map<String, String>> userInfo, List<Map<String, String>> mandataryInfo, boolean isAdd, boolean isSame) {
        this.taskId = taskId;
        this.userInfo = userInfo;
        this.mandataryInfo = mandataryInfo;
        this.isAdd = isAdd;
        this.isSame = isSame;
    }

    public Void execute(CommandContext commandContext) {
        String userOrgan;
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        String userId = HussarUtils.isNotEmpty(this.userInfo) ? this.userInfo.get(0).get("userId") : "";
        String string = userOrgan = HussarUtils.isNotEmpty(this.userInfo) ? this.userInfo.get(0).get("deptId") : "";
        if (taskEntity.getAssignee() != null) {
            taskEntity.addCandidateUser(this.mandataryInfo);
            this.dataPushService.entrustDataPush((Task)taskEntity, this.userInfo, this.mandataryInfo.get(0));
        } else {
            if (this.isSame) {
                taskEntity.deleteCandidateUser(userId, userOrgan);
                this.dataPushService.entrustDataPush((Task)taskEntity, this.userInfo, null);
                return null;
            }
            List identityLinks = taskEntity.getIdentityLinks();
            if (HussarUtils.isNotEmpty((Object)userId)) {
                taskEntity.deleteCandidateUser(userId, userOrgan);
                taskEntity.addCandidateUsers(this.mandataryInfo);
                this.dataPushService.entrustDataPush((Task)taskEntity, this.userInfo, this.mandataryInfo.get(0));
            } else {
                List users = this.mandataryInfo.stream().map(temp -> (String)temp.get("userId")).collect(Collectors.toList());
                HashMap<String, String> currentUsers = new HashMap<String, String>();
                for (IdentityLink identityLink : identityLinks) {
                    if (this.isAdd) {
                        users.remove(identityLink.getUserId());
                        continue;
                    }
                    taskEntity.deleteCandidateUser(identityLink.getUserId(), identityLink.getOrganId());
                    currentUsers.put(identityLink.getUserId(), identityLink.getOrganId());
                }
                if (!users.isEmpty()) {
                    taskEntity.addCandidateUsers(this.mandataryInfo);
                    if (this.isAdd) {
                        this.dataPushService.addUserDataPush(this.dataPush((Task)taskEntity, this.mandataryInfo));
                    } else {
                        this.entrustDataPush((Task)taskEntity, currentUsers, this.mandataryInfo, taskEntity.getCreateTime(), new Date());
                    }
                }
            }
        }
        return null;
    }

    private DataPush dataPush(Task task, List<Map<String, String>> userInfo) {
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserInfo(userInfo);
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        HashMap map = new HashMap();
        map.putAll(task.getProcessVariables());
        map.putAll(task.getTaskLocalVariables());
        dataPush.setSendUser((String)map.get("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)map.get("todoConfiguration"));
        dataPush.setProcessInsId(task.getProcessInstanceId());
        dataPush.setTenantId(task.getTenantId());
        return dataPush;
    }

    public void entrustDataPush(Task task, Map<String, String> userInfo, List<Map<String, String>> consignee, Date startTime, Date endTime) {
        if (this.dataPushService.isDataPush()) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setUserInfo(consignee);
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            HashMap map = new HashMap();
            map.putAll(task.getProcessVariables());
            map.putAll(task.getTaskLocalVariables());
            dataPush.setStartDate(startTime);
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription((String)map.get("todoConfiguration"));
            dataPush.setSendUser((String)task.getTaskLocalVariables().get("sendUser"));
            dataPush.setProcessName(historicProcessInstance.getProcessDefinitionName());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            if (HussarUtils.isNotEmpty(userInfo)) {
                dataPush.setConsignor(Collections.singletonList(userInfo));
                dataPush.setEndDate(endTime);
            }
            dataPush.setTenantId(task.getTenantId());
            this.dataPushService.entrustDataPush(dataPush);
        }
    }
}

