/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class AddHistoryTaskCmd
implements Command<Void> {
    protected String comment;
    protected Date startTime;
    protected Map<String, String> userInfo;
    protected TaskEntity task;
    protected String historyTaskType;
    private static final Map<String, String> HISTORY_MAP = new HashMap<String, String>();
    protected DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);

    public Void execute(CommandContext commandContext) {
        TaskEntity task = this.getTask();
        ExecutionEntity execution = task.getExecution();
        TaskEntity taskEntity = this.initTask(commandContext, task, execution);
        String userId = this.userInfo.get("userId");
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(taskEntity.getId());
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            if (this.comment.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                this.comment = this.comment.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(this.comment);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(taskEntity.getId());
        dataPush.setTaskDefinitionName(taskEntity.getName());
        dataPush.setUserInfo(Collections.singletonList(this.userInfo));
        dataPush.setBusinessKey(execution.getBusinessKey());
        dataPush.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        dataPush.setProcessKey(taskEntity.getProcessDefinitionId().split(":")[0]);
        dataPush.setSendUser(userId);
        dataPush.setStartDate(this.startTime);
        dataPush.setEndDate(new Date());
        dataPush.setUrl(taskEntity.getFormKey());
        dataPush.setDescription((String)task.getVariableLocal("todoConfiguration"));
        dataPush.setProcessName(execution.getProcessDefinitionName());
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            dataPush.setComment(this.comment);
        }
        dataPush.setProcessInsId(taskEntity.getProcessInstanceId());
        dataPush.setTenantId(taskEntity.getTenantId());
        this.dataPush(dataPush);
        taskEntity.setVariableLocal("taskSourceFlag", (Object)this.historyTaskType);
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
        Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, HISTORY_MAP.get(this.historyTaskType), false, new Date(), this.userInfo.get("deptId"));
        HistoricTaskInstanceEntity historicTaskInstance = (HistoricTaskInstanceEntity)commandContext.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskEntity.getId());
        historicTaskInstance.setRevokeFlag("1");
        return null;
    }

    protected TaskEntity getTask() {
        return this.task;
    }

    protected TaskEntity initTask(CommandContext commandContext, TaskEntity task, ExecutionEntity execution) {
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        IdGenerator idGenerator = pec.getIdGenerator();
        TaskEntity taskEntity = new TaskEntity();
        taskEntity.setCreateTime(this.startTime);
        taskEntity.setTaskDefinition(task.getTaskDefinition());
        taskEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        taskEntity.setTaskDefinitionKey(task.getTaskDefinitionKey());
        taskEntity.setProcessInstanceId(execution.getProcessInstanceId());
        taskEntity.setExecutionId(execution.getId());
        taskEntity.setName(task.getName());
        String taskId = idGenerator.getNextId();
        taskEntity.setId(taskId);
        taskEntity.setExecution(execution);
        String userId = this.userInfo.get("userId");
        String userDept = this.userInfo.get("deptId");
        taskEntity.setAssignee(userId, false, false, userDept);
        taskEntity.setFormKey(task.getFormKey());
        taskEntity.setVariableLocal("sendUser", (Object)userId);
        taskEntity.setVariableLocal("sendUserOrganId", (Object)userDept);
        taskEntity.setVariableLocal("todoConfiguration", task.getVariableLocal("todoConfiguration"));
        taskEntity.setVariableLocal("complete_from", (Object)task.getTaskDefinitionKey());
        taskEntity.setSubProcessKey(task.getSubProcessKey());
        taskEntity.setSourceTaskDefId(task.getSourceTaskDefId());
        taskEntity.setSourceTaskDefName(task.getSourceTaskDefName());
        taskEntity.insert(taskEntity.getExecution());
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)taskEntity));
        }
        return taskEntity;
    }

    protected void dataPush(DataPush dataPush) {
        this.dataPushService.completeDataPush(dataPush);
    }

    public AddHistoryTaskCmd(TaskEntity task, String comment, Map<String, String> userInfo, String taskType) {
        this.task = task;
        this.comment = comment;
        this.startTime = new Date();
        this.userInfo = userInfo;
        this.historyTaskType = taskType;
    }

    protected AddHistoryTaskCmd(String comment, Date startTime, Map<String, String> userInfo) {
        this.comment = comment;
        this.startTime = startTime;
        this.userInfo = userInfo;
    }

    static {
        HISTORY_MAP.put("revoke", "RevokeHistory");
        HISTORY_MAP.put("assist", "AssistHistory");
    }
}

