/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;

public class TaskCompleteCmd
implements Command<TaskEntity> {
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ITaskEngineService iTaskEngineService = (ITaskEngineService)SpringContextHolder.getBean(ITaskEngineService.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);
    private String taskId;
    private Map<String, String> userInfo;
    private Map<String, String> mandatorInfo;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String comment;
    private IAssigneeChooseService iAssigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);

    public TaskEntity execute(CommandContext commandContext) {
        TaskEntityManager taskEntityManager;
        List childTasks;
        Map deptParams;
        if (this.variables.containsKey("bpm_next_node")) {
            commandContext.addAttribute("bpm_next_node", this.variables.get("bpm_next_node"));
            this.variables.remove("bpm_next_node");
        }
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        commandContext.addAttribute("sourceTaskDefId", (Object)task.getTaskDefinitionKey());
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        commandContext.addAttribute("sourceTaskDefName", (Object)bm.getFlowElement(task.getTaskDefinitionKey()).getName());
        String userId = this.userInfo.get("userId");
        String userDept = this.userInfo.get("deptId");
        if (HussarUtils.isEmpty(this.mandatorInfo)) {
            commandContext.addAttribute("taskId", (Object)task.getId());
            commandContext.addAttribute("sendUser", (Object)userId);
        }
        commandContext.addAttribute("sendUserOrganId", (Object)userDept);
        TaskComment taskComment = new TaskComment();
        taskComment.setUserId(userId);
        taskComment.setType("complete");
        taskComment.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        taskComment.setTaskId(this.taskId);
        taskComment.setAction("AddComment");
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            if (this.comment.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                this.comment = this.comment.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            taskComment.setMessage(this.comment);
            taskComment.setFullMsg(this.comment.getBytes(StandardCharsets.UTF_8));
        }
        String userName = null;
        String organFullName = null;
        if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser()) && HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser().getOrganFullName()) && HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser().getUserName())) {
            deptParams = BaseSecurityUtil.getUser().getOrganFullName();
            organFullName = (String)deptParams.get(userDept);
            userName = BaseSecurityUtil.getUser().getUserName();
        } else {
            deptParams = this.iAssigneeChooseService.getDeptParams(userId, userDept);
            userName = (String)deptParams.get("name");
            organFullName = (String)deptParams.get("organFullName");
        }
        taskComment.setUserName(userName);
        taskComment.setDeptName(organFullName);
        taskComment.setDeptId(userDept);
        taskComment.insert();
        this.variables.put("sendUser", HussarUtils.isEmpty(this.mandatorInfo) ? userId : this.mandatorInfo.get("userId"));
        this.variables.put("sendUserOrganId", HussarUtils.isEmpty(this.mandatorInfo) ? userDept : this.mandatorInfo.get("deptId"));
        this.variables.put("bpm_submit_source", task.getTaskDefinitionKey());
        task.setVariableLocalWithOutQuery("taskSourceFlag", (Object)"complete", true);
        this.variables.put("all_prev_node", "'" + task.getTaskDefinitionKey() + "'");
        Map<String, Object> appointAssignee = new HashMap();
        if (this.variables.get("appoint_assignee") != null) {
            appointAssignee = (Map)this.variables.get("appoint_assignee");
        }
        if (HussarUtils.isEmpty(appointAssignee.get("static_appoint_assignee"))) {
            appointAssignee.put("static_appoint_assignee", null);
            this.variables.put("appoint_assignee", appointAssignee);
        }
        if (!(childTasks = (taskEntityManager = commandContext.getTaskEntityManager()).findTasksByParentTaskId(this.taskId)).isEmpty()) {
            ArrayList<String> childTaskIds = new ArrayList<String>();
            childTasks.forEach(childTask -> {
                taskEntityManager.deleteTask((TaskEntity)childTask, null, true);
                childTaskIds.add(childTask.getId());
            });
            if (this.dataPushService.isDataPush()) {
                this.dataPushService.deleteMultiTask(childTaskIds);
            }
        }
        if (task.getDelegationState() != null) {
            task.resolve();
        }
        task.fireEvent("beforeComplete");
        if (task.getExecutionId() != null) {
            task.setExecutionVariables(this.variables);
        } else {
            task.setVariables(this.variables);
        }
        ParamModel paramModel = this.getParamModel(task, this.variables);
        Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
        if (HussarUtils.isEmpty(this.mandatorInfo)) {
            task.complete(this.variables, false);
        } else {
            task.complete(this.variables, false, this.mandatorInfo.get("userId"));
        }
        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(this.taskId);
        }
        return task;
    }

    public TaskCompleteCmd(String taskId, Map<String, String> userInfo) {
        this.taskId = taskId;
        this.userInfo = userInfo;
    }

    public TaskCompleteCmd(String taskId, Map<String, String> userInfo, Map<String, String> mandatorInfo, Map<String, Object> variables) {
        this(taskId, userInfo);
        this.mandatorInfo = mandatorInfo;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public TaskCompleteCmd(String taskId, Map<String, String> userInfo, String comment) {
        this(taskId, userInfo);
        this.comment = comment;
    }

    public TaskCompleteCmd(String taskId, Map<String, String> userInfo, Map<String, String> mandatorInfo, String comment, Map<String, Object> variables) {
        this(taskId, userInfo, comment);
        this.mandatorInfo = mandatorInfo;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public ParamModel getParamModel(TaskEntity task, Map<String, Object> variables) {
        ParamModel paramModel = new ParamModel();
        paramModel.setCompleteType("complete");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        if (HussarUtils.isNotEmpty((Object)task.getTaskDefinition().getTaskListener("complete"))) {
            BpmResponseResult result = this.iTaskEngineService.queryNextNode(null, this.taskId, false, false, null);
            JSONArray jsonArray = result.getResult();
            String nextNodeId = "";
            HashMap<String, String> activityTypeMap = new HashMap<String, String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                nextNodeId = nextNodeId + "," + jsonObject.get((Object)"id").toString();
                activityTypeMap.put(jsonObject.get((Object)"id").toString(), jsonObject.get((Object)"type").toString());
            }
            nextNodeId = nextNodeId.substring(1);
            paramModel.setNextNodeId(nextNodeId);
            paramModel.setNextActivityType(activityTypeMap);
            List<String> nextNodeIdList = Arrays.asList(nextNodeId.split(","));
            HashMap<String, String> assigneeMap = new HashMap<String, String>();
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.putAll(this.userInfo);
            for (String nextNode : nextNodeIdList) {
                BpmResponseResult result1 = this.iTaskEngineService.queryNextAssigneeByTaskIdAndNodeId(this.taskId, nextNode, "0", userMap);
                JSONArray assigneeArray = result1.getResult();
                String nextAppointAssignee = "";
                for (int i = 0; i < assigneeArray.size(); ++i) {
                    JSONObject jsonObject = assigneeArray.getJSONObject(i);
                    nextAppointAssignee = nextAppointAssignee + "," + jsonObject.get((Object)"id").toString();
                }
                if (HussarUtils.isNotEmpty((Object)nextAppointAssignee)) {
                    nextAppointAssignee = nextAppointAssignee.substring(1);
                }
                assigneeMap.put(nextNode, nextAppointAssignee);
            }
            paramModel.setNextNodeAssignee(assigneeMap);
        }
        String userId = this.userInfo.get("userId");
        paramModel.setHandler(userId);
        paramModel.setLastNodeId(task.getTaskDefinitionKey());
        paramModel.setLastTaskId(task.getId());
        paramModel.setLastNodeName(task.getName());
        paramModel.setLastCompleteType("complete");
        paramModel.setLastNodeHandler(userId);
        paramModel.setSendUser(userId);
        paramModel.setCreateReason("completeCreate");
        return paramModel;
    }
}

