/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assist.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assist.service.IAssistService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ChildTaskCompleteCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ChildTaskCreateCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.cmd.DeleteCommentCmd;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssistServiceImpl
implements IAssistService {
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private ISysActUrgeTaskService sysActUrgeTaskService;
    @Autowired
    private ISysActEntrustService sysActEntrustService;
    @Autowired
    private DataPushService dataPushService;

    public BpmResponseResult createAssistTask(String taskId, Map<String, String> assistInitiatorInfo, List<Map<String, String>> usersInfo, String comment) {
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(realTaskId.getTaskId(), assistInitiatorInfo, realTaskId.getMandataryInfo()));
        this.processEngine.getManagementService().executeCommand((Command)new ChildTaskCreateCmd(taskId, assistInitiatorInfo, usersInfo, comment, "2"));
        return InstallResult.success();
    }

    public BpmResponseResult completeAssistTask(String taskId, Map<String, String> userInfo, String comment) {
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        this.processEngine.getManagementService().executeCommand((Command)new ChildTaskCompleteCmd(realTaskId.getTaskId(), userInfo, realTaskId.getMandataryInfo(), comment));
        return InstallResult.success();
    }

    public BpmResponseResult editAssistTaskComment(String taskId, Map<String, String> userInfo, String comment) {
        if (taskId == null || HussarUtils.isEmpty(userInfo)) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        String userId = userInfo.get("userId");
        String userDept = userInfo.get("deptId");
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            HistoricTaskInstanceEntity historicTaskInstance = commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(taskId);
            if (historicTaskInstance == null) {
                throw new ActivitiObjectNotFoundException("No historic task exists with the given id: " + taskId, HistoricTaskInstance.class);
            }
            if (historicTaskInstance.getParentTaskId() == null || !"2".equals(historicTaskInstance.getTaskType())) {
                throw new ActivitiException("\u6b64\u4efb\u52a1\u4e0d\u662f\u534f\u529e\u4efb\u52a1");
            }
            if (!userId.equals(historicTaskInstance.getAssignee()) || !userDept.equals(historicTaskInstance.getOrganId())) {
                throw new PublicClientException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u529e\u7406\u6743\u9650\uff01");
            }
            if (historicTaskInstance.getEndTime() == null) {
                throw new PublicClientException("\u6b64\u534f\u529e\u4efb\u52a1\u5c1a\u672a\u529e\u7406");
            }
            if (commandContext.getTaskEntityManager().findTaskById(historicTaskInstance.getParentTaskId()) == null) {
                throw new PublicClientException("\u88ab\u534f\u529e\u4efb\u52a1\u5df2\u529e\u7406\uff0c\u65e0\u6cd5\u4fee\u6539\u610f\u89c1");
            }
            List commentList = commandContext.getCommentEntityManager().findCommentsByTaskIdAndType(taskId, "complete");
            for (Comment delComment : commentList) {
                commandContext.getCommentEntityManager().delete((PersistentObject)((CommentEntity)delComment));
            }
            new DeleteCommentCmd(taskId, null, null).execute(commandContext);
            String userName = null;
            String organFullName = null;
            if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser().getOrganFullName()) && HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser().getUserName())) {
                Map deptParams = BaseSecurityUtil.getUser().getOrganFullName();
                organFullName = (String)deptParams.get(userDept);
                userName = BaseSecurityUtil.getUser().getUserName();
            }
            CommentEntity.addComment((String)userId, (String)taskId, (String)comment, (String)userDept, userName, organFullName);
            return null;
        });
        return InstallResult.success();
    }

    public BpmResponseResult assistTaskAddAssignee(String taskId, final List<Map<String, String>> usersInfo, final boolean isDelete) {
        if (usersInfo == null) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        final List userIds = usersInfo.stream().map(userInfo -> (String)userInfo.get("userId")).collect(Collectors.toList());
        this.processEngine.getManagementService().executeCommand((Command)new NeedsActiveTaskCmd<Void>(taskId){

            protected Void execute(CommandContext commandContext, TaskEntity task) {
                List identityLinkEntityList;
                if (task.getParentTaskId() == null || !"2".equals(task.getTaskType())) {
                    throw new ActivitiException("\u6b64\u4efb\u52a1\u4e0d\u662f\u534f\u529e\u4efb\u52a1");
                }
                TaskEntity parentTask = commandContext.getTaskEntityManager().findTaskById(task.getParentTaskId());
                if (parentTask == null) {
                    throw new ActivitiException("\u88ab\u534f\u529e\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
                }
                if (task.isSuspended()) {
                    throw new ActivitiException("\u88ab\u534f\u529e\u4efb\u52a1\u5df2\u6302\u8d77\uff01");
                }
                if (parentTask.getExecution().getActivity().getActivityBehavior() instanceof MultiInstanceActivityBehavior) {
                    List tasks = parentTask.getExecution().getSuperExecution().getTasks();
                    for (TaskEntity taskEntity : tasks) {
                        if (taskEntity.getTaskType() != null) continue;
                        if (taskEntity.getAssignee() != null && userIds.contains(taskEntity.getAssignee())) {
                            throw new ActivitiException("\u65e0\u6cd5\u6dfb\u52a0\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005\u4e3a\u534f\u529e\u4eba");
                        }
                        List identityLinkEntityList2 = taskEntity.getIdentityLinks();
                        if (identityLinkEntityList2 == null) continue;
                        Iterator iterator = identityLinkEntityList2.iterator();
                        while (iterator.hasNext()) {
                            IdentityLinkEntity identityLink = (IdentityLinkEntity)iterator.next();
                            if (!userIds.contains(identityLink.getUserId())) continue;
                            throw new ActivitiException("\u65e0\u6cd5\u6dfb\u52a0\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005\u4e3a\u534f\u529e\u4eba");
                        }
                    }
                } else {
                    identityLinkEntityList = parentTask.getIdentityLinks();
                    for (IdentityLinkEntity identityLink : identityLinkEntityList) {
                        if (!userIds.contains(identityLink.getUserId())) continue;
                        throw new ActivitiException("\u65e0\u6cd5\u6dfb\u52a0\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005\u4e3a\u534f\u529e\u4eba");
                    }
                }
                identityLinkEntityList = task.getIdentityLinks();
                String assistInitiator = ((IdentityLinkEntity)identityLinkEntityList.get(0)).getAssistInitiator();
                List childTask = Context.getCommandContext().getTaskEntityManager().findTasksByParentTaskId(task.getParentTaskId());
                if (isDelete) {
                    commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByTaskId(this.taskId);
                }
                if (childTask != null && !childTask.isEmpty()) {
                    for (Task taskEntity : childTask) {
                        if (!"2".equals(taskEntity.getTaskType()) || isDelete && taskEntity.getId().equals(task.getId())) continue;
                        List identityLinkEntities = ((TaskEntity)taskEntity).getIdentityLinks();
                        for (IdentityLinkEntity identityLink : identityLinkEntities) {
                            if (!userIds.contains(identityLink.getUserId()) || !assistInitiator.equals(identityLink.getAssistInitiator())) continue;
                            throw new ActivitiException("\u65e0\u6cd5\u6dfb\u52a0\u5df2\u6709\u534f\u529e\u4eba\u4e3a\u534f\u529e\u4eba");
                        }
                    }
                }
                task.addCandidateUser(usersInfo, null, null, assistInitiator);
                HashMap<String, String> consigneeInfo = new HashMap<String, String>();
                identityLinkEntityList.forEach(identityLinkEntity -> {
                    consigneeInfo.put("userId", identityLinkEntity.getUserId());
                    consigneeInfo.put("deptId", identityLinkEntity.getOrganId());
                });
                AssistServiceImpl.this.dataPushService.entrustDataPush((Task)task, usersInfo, isDelete ? consigneeInfo : null);
                return null;
            }
        });
        List<SysActUrgeTask> list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId));
        if (list != null && !list.isEmpty()) {
            String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
            list = list.stream().filter(sysActUrgeTask -> sysActUrgeTask.getReceiveUser().equals(randomUser)).collect(Collectors.toList());
            ArrayList saveList = new ArrayList();
            list.forEach(sysActUrgeTask -> userIds.forEach(userId -> saveList.add(sysActUrgeTask.copyUrge(userId))));
            if (isDelete) {
                this.sysActUrgeTaskService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId));
            }
            this.sysActUrgeTaskService.saveBatch(saveList);
        }
        return InstallResult.success();
    }
}

