/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.AddCustomNodeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequenceXy;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowTodoCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.LineConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.MultiUser;
import com.jxdinfo.hussar.workflow.engine.flowmodel.SequenceSourceTarget;
import com.jxdinfo.hussar.workflow.engine.flowmodel.enums.BpmNodeTypeEnum;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.Bpm2XMLService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AddCustomNodeServiceImpl
implements AddCustomNodeService {
    private static final Logger logger = LoggerFactory.getLogger(AddCustomNodeServiceImpl.class);
    private static final int USER_TASK_WIDTH = 48;
    private static final int USER_TASK_HEIGHT = 48;
    private static final int MOVE_WIDTH = 96;
    private static final String ADD_CUSTOM_PATH_ID_PREFIX = "jxd_bpm_custom_path";
    private Bpm2XMLService xmlService;
    private SysActProcessFileService sysActProcessFileService;
    private ITaskEngineService taskEngineService;
    private ModelService modelService;
    private BpmConstantProperties bpmConstantProperties;
    private SysActFormAuthService sysActFormAuthService;
    private LcdpBpmProperties lcdpBpmProperties;

    @Autowired
    public AddCustomNodeServiceImpl(Bpm2XMLService xmlService, ModelService modelService, SysActProcessFileService sysActProcessFileService, BpmConstantProperties bpmConstantProperties, ITaskEngineService taskEngineService, SysActFormAuthService sysActFormAuthService, LcdpBpmProperties lcdpBpmProperties) {
        this.xmlService = xmlService;
        this.modelService = modelService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.taskEngineService = taskEngineService;
        this.bpmConstantProperties = bpmConstantProperties;
        this.sysActFormAuthService = sysActFormAuthService;
        this.lcdpBpmProperties = lcdpBpmProperties;
    }

    public ApiResponse<String> isAddParallel(String taskId, String tenantId) {
        taskId = RealTaskId.getRealTaskId(taskId);
        Task task = this.taskEngineService.getTask(taskId, "0");
        String identityId = task.getProcessDefinitionId().split(":")[0];
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(identityId, task.getProcessDefinitionId(), tenantId);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        String nextNodeId = null;
        block0: for (Object path : paths) {
            if (!path.getStart().getKey().equals(task.getTaskDefinitionKey())) continue;
            nextNodeId = path.getEnd().getKey();
            for (FlowObject flowObject : elements) {
                if (!flowObject.getId().equals(nextNodeId)) continue;
                if (BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) || BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) break block0;
                return ApiResponse.fail((String)this.bpmConstantProperties.getIsNotAddParallel());
            }
        }
        if (nextNodeId == null) {
            throw new PublicClientException(this.bpmConstantProperties.getSubProcessCanNotAddNode());
        }
        ArrayList<String> gatewayNextNodeId = new ArrayList<String>();
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(nextNodeId)) continue;
            gatewayNextNodeId.add(path.getEnd().getKey());
        }
        String mergeGatewayId = null;
        for (FlowSequence path : paths) {
            if (!gatewayNextNodeId.contains(path.getStart().getKey())) continue;
            if (mergeGatewayId == null) {
                mergeGatewayId = path.getEnd().getKey();
                continue;
            }
            if (path.getEnd().getKey().equals(mergeGatewayId)) continue;
            return ApiResponse.fail((String)this.bpmConstantProperties.getIsNotConfluenceParallel());
        }
        if (mergeGatewayId == null) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getIsNotConfluenceParallel());
        }
        for (FlowObject flowObject : elements) {
            if (!flowObject.getId().equals(mergeGatewayId)) continue;
            if (BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) || BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) break;
            return ApiResponse.fail((String)this.bpmConstantProperties.getIsNotConfluenceParallel());
        }
        return ApiResponse.success((String)this.bpmConstantProperties.getIsAddParallel());
    }

    public ApiResponse<String> addNode(String taskId, String addList, String tenantId, String parallel) {
        if (HussarUtils.isEmpty((Object)(taskId = RealTaskId.getRealTaskId(taskId)))) {
            throw new PublicClientException(this.bpmConstantProperties.getProcessNotStart(), Boolean.valueOf(false));
        }
        List list = (List)JSON.parseObject((String)addList, List.class);
        Task task = this.taskEngineService.getTask(taskId, "0");
        try {
            String identityId = task.getProcessDefinitionId().split(":")[0];
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(identityId, task.getProcessDefinitionId(), tenantId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("nodeId", task.getTaskDefinitionKey());
            map.put("addList", list);
            map.put("parallel", parallel);
            ArrayList<String> addNodeIds = new ArrayList<String>();
            WorkFlow newWorkFlow = this.getNewWorkFlow(workFlow, addNodeIds, map);
            BpmnModel bpmnModel = this.xmlService.getBpmnModel(newWorkFlow, identityId, tenantId);
            SysActProcessFile metaInfo = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)identityId)).eq(SysActProcessFile::getType, (Object)"meta")).eq(SysActProcessFile::getVersion, (Object)0));
            Long modelId = metaInfo.getModelId();
            String version = this.modelService.getRealVersion(task.getProcessDefinitionId());
            String processKey = task.getProcessDefinitionId().split(":")[0];
            this.saveFormAuth(processKey, task.getTaskDefinitionKey(), addNodeIds);
            if (!task.getProcessDefinitionId().split(":")[1].equals(version)) {
                this.xmlService.updateModel(newWorkFlow, bpmnModel, task.getProcessDefinitionId());
                this.modelService.addNodeSaveModelExtendProperties(bpmnModel, task.getProcessDefinitionId());
            } else {
                this.modelService.deployModelByWorkFlowXml(newWorkFlow, bpmnModel, String.valueOf(modelId), tenantId, task.getProcessInstanceId(), version);
            }
            return ApiResponse.success((Object)"1", (String)this.bpmConstantProperties.getAddCustomNodeSuccess());
        }
        catch (PublicClientException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)this.bpmConstantProperties.getErrorAddCustomNode());
        }
    }

    private void saveFormAuth(String processKey, String nodeId, List<String> addNodeIds) {
        if (!this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            return;
        }
        List list = this.sysActFormAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)processKey)).eq(SysActFormAuth::getTaskDefinitionKey, (Object)nodeId));
        ArrayList<SysActFormAuth> addList = new ArrayList<SysActFormAuth>();
        for (SysActFormAuth sysActFormAuth : list) {
            for (String addNodeId : addNodeIds) {
                SysActFormAuth addSysActFormAuth = new SysActFormAuth();
                CopyPropertieUtils.copyProperties((Object)addSysActFormAuth, (Object)sysActFormAuth);
                addSysActFormAuth.setTaskDefinitionKey(addNodeId);
                addSysActFormAuth.setId(null);
                addList.add(addSysActFormAuth);
            }
        }
        this.sysActFormAuthService.saveBatch(addList);
    }

    /*
     * WARNING - void declaration
     */
    private WorkFlow getNewWorkFlow(WorkFlow workFlow, List<String> addNodeIds, Map<String, Object> map) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        List paths = flowModel.getSlots().getPath();
        JSONObject formAddress = null;
        String formDetailAddress = null;
        FlowTodoCondition flowTodoCondition = null;
        String messageType = null;
        ArrayList<FlowVariables> useVariables = new ArrayList();
        List addList = (List)map.get("addList");
        String nextNodeId = "";
        boolean isParallel = false;
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(map.get("nodeId"))) continue;
            nextNodeId = path.getEnd().getKey();
            break;
        }
        if ("".equals(nextNodeId)) {
            throw new PublicClientException(this.bpmConstantProperties.getSubProcessCanNotAddNode());
        }
        ArrayList<Map<String, String>> addIds = new ArrayList<Map<String, String>>();
        for (int i = 0; i < addList.size(); ++i) {
            addIds.add(this.getNewId());
        }
        String newNodeId = (String)((Map)addIds.get(0)).get("nodeId");
        String newPathId = (String)((Map)addIds.get(0)).get("pathId");
        for (FlowObject flowObject : elements) {
            if (flowObject.getId().equals(map.get("nodeId"))) {
                flowTodoCondition = flowObject.getProps().getTodoConfiguration();
                formAddress = flowObject.getProps().getFormAddress();
                useVariables = flowObject.getProps().getUseVariables();
                formDetailAddress = flowObject.getProps().getFormDetailAddress();
                messageType = flowObject.getProps().getMessageType();
            }
            if (!flowObject.getId().equals(nextNodeId) || !BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) && !BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) continue;
            isParallel = true;
            List goOutPath = flowObject.getGoOutPathes();
            goOutPath.add(newPathId);
            for (Map map2 : addIds) {
                goOutPath.add(map2.get("pathId"));
            }
            flowObject.setGoOutPathes(goOutPath);
        }
        if (isParallel && "true".equals(map.get("parallel"))) {
            void var22_28;
            String endPointNodeId = this.getNextParallelNodeId(elements, paths, nextNodeId);
            if (HussarUtils.isEmpty((Object)endPointNodeId)) {
                throw new PublicClientException(this.bpmConstantProperties.getIsNotConfluenceParallel());
            }
            ArrayList<String> nodeIds = new ArrayList<String>();
            List<Map<String, List<FlowSequenceXy>>> pointsList = this.getParallelNewPathPoints(paths, nextNodeId, endPointNodeId, addList.size(), nodeIds, elements);
            boolean bl = false;
            while (var22_28 < pointsList.size()) {
                String nodeId = (String)((Map)addIds.get((int)var22_28)).get("nodeId") + "parallel_node" + (String)nodeIds.get(0);
                addNodeIds.add(nodeId);
                Map<String, List<FlowSequenceXy>> points = pointsList.get((int)var22_28);
                FlowSequenceXy point = points.get("startPoints").get(points.get("startPoints").size() - 1);
                elements.add(this.newNode(nodeId, ((Map)addList.get((int)var22_28)).get("nodeName"), (String)((Map)addIds.get((int)var22_28)).get("endPathId"), ((Map)addList.get((int)var22_28)).get("nodeAssignee"), ((Map)addList.get((int)var22_28)).get("counterSwitch"), ((Map)addList.get((int)var22_28)).get("multiType"), ((Map)addList.get((int)var22_28)).get("multiNumber"), Double.parseDouble(point.getX()), Double.parseDouble(point.getY()), formAddress, useVariables, formDetailAddress, flowTodoCondition, messageType));
                paths.add(this.newPath((String)((Map)addIds.get((int)var22_28)).get("pathId"), nextNodeId, nodeId, 0.0, 0.0, 0, points.get("startPoints")));
                paths.add(this.newPath((String)((Map)addIds.get((int)var22_28)).get("endPathId"), nodeId, endPointNodeId, 0.0, 0.0, 0, points.get("endPoints")));
                ++var22_28;
            }
            workFlow.setData(JSON.toJSONString((Object)flowModel));
            return workFlow;
        }
        double x = 0.0;
        double y = 0.0;
        double d = 0.0;
        String pathId = "";
        int moveWidth = 96;
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(map.get("nodeId"))) continue;
            pathId = path.getId();
            path.getStart().setKey(newNodeId);
            if (!"L".equals(path.getStart().getPort())) continue;
            moveWidth = -moveWidth;
        }
        for (FlowObject flowObject : elements) {
            if (!flowObject.getInstanceKey().equals(map.get("nodeId"))) continue;
            flowObject.getGoOutPathes().set(0, newPathId);
            d = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
            x = Double.parseDouble(flowObject.getLeft());
            if (moveWidth > 0) {
                x += Double.parseDouble(flowObject.getWidth());
            }
            y = Double.parseDouble(flowObject.getTop()) + Double.parseDouble(flowObject.getHeight()) / 2.0;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (FlowObject flowObject : elements) {
            double flowObjectX = Double.parseDouble(flowObject.getLeft()) + Double.parseDouble(flowObject.getWidth()) / 2.0;
            if (moveWidth > 0 && flowObjectX > d || moveWidth < 0 && flowObjectX < d) {
                Object subElement22;
                flowObject.setLeft(String.valueOf(Double.parseDouble(flowObject.getLeft()) + (double)moveWidth));
                if (!"com.jxdinfo.workflow.SubProcess".equals(flowObject.getName())) continue;
                List subElements = flowObject.getSlots().getElement();
                for (Object subElement22 : subElements) {
                    subElement22.setLeft(String.valueOf(Double.parseDouble(subElement22.getLeft()) + (double)moveWidth));
                }
                List subPaths = flowObject.getSlots().getPath();
                subElement22 = subPaths.iterator();
                while (subElement22.hasNext()) {
                    FlowSequence subPath = (FlowSequence)subElement22.next();
                    for (FlowSequenceXy flowSequenceXy : subPath.getPoints()) {
                        flowSequenceXy.setX(String.valueOf(Double.parseDouble(flowSequenceXy.getX()) + (double)moveWidth));
                    }
                }
                continue;
            }
            list.add(flowObject.getId());
        }
        for (FlowSequence path : paths) {
            FlowSequenceXy flowSequenceXy;
            int i;
            boolean isStartNotMove = list.contains(path.getStart().getKey());
            boolean isEndNotMove = list.contains(path.getEnd().getKey());
            if (path.getLineConfig() != null && path.getLineConfig().getX() != null) {
                int moveNum = 2;
                if (isStartNotMove) {
                    --moveNum;
                }
                if (isEndNotMove) {
                    --moveNum;
                }
                if (moveNum > 0) {
                    Double lineConfigX = Double.valueOf(path.getLineConfig().getX());
                    lineConfigX = lineConfigX + (double)(moveWidth / 2 * moveNum);
                    path.getLineConfig().setX(String.valueOf(lineConfigX));
                }
            }
            List listXy = path.getPoints();
            for (i = 0; i < listXy.size(); ++i) {
                if (i == 0 && isStartNotMove || i == listXy.size() - 1 && isEndNotMove) continue;
                flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                if (i != 0 && i != listXy.size() - 1 && (isStartNotMove && ((FlowSequenceXy)listXy.get(0)).getX().equals(flowSequenceXy.getX()) || isEndNotMove && ((FlowSequenceXy)listXy.get(listXy.size() - 1)).getX().equals(flowSequenceXy.getX()) || moveWidth > 0 && Double.parseDouble(flowSequenceXy.getX()) < d || moveWidth < 0 && Double.parseDouble(flowSequenceXy.getX()) > d)) continue;
                flowSequenceXy.setX(String.valueOf(Double.parseDouble(flowSequenceXy.getX()) + (double)moveWidth));
            }
            for (i = 0; i < listXy.size() - 1; ++i) {
                flowSequenceXy = (FlowSequenceXy)listXy.get(i);
                FlowSequenceXy flowSequenceXyNext = (FlowSequenceXy)listXy.get(i + 1);
                if (flowSequenceXy.getX().equals(flowSequenceXyNext.getX()) || flowSequenceXy.getY().equals(flowSequenceXyNext.getY())) continue;
                FlowSequenceXy flowSequenceXyNewPoint1 = new FlowSequenceXy();
                FlowSequenceXy flowSequenceXyNewPoint2 = new FlowSequenceXy();
                flowSequenceXyNewPoint1.setX(flowSequenceXy.getX());
                flowSequenceXyNewPoint2.setX(flowSequenceXyNext.getX());
                double newPointY = (Double.parseDouble(flowSequenceXy.getY()) + Double.parseDouble(flowSequenceXyNext.getY())) / 2.0;
                flowSequenceXyNewPoint1.setY(String.valueOf(newPointY));
                flowSequenceXyNewPoint2.setY(String.valueOf(newPointY));
                listXy.add(i + 1, flowSequenceXyNewPoint1);
                listXy.add(i + 2, flowSequenceXyNewPoint2);
            }
        }
        paths.add(this.newPath(newPathId, (String)map.get("nodeId"), newNodeId, x, y, moveWidth, null));
        x = moveWidth < 0 ? (x += (double)moveWidth) : (x += (double)moveWidth / 2.0);
        addNodeIds.add(newNodeId);
        elements.add(this.newNode(newNodeId, ((Map)addList.get(0)).get("nodeName"), pathId, ((Map)addList.get(0)).get("nodeAssignee"), ((Map)addList.get(0)).get("counterSwitch"), ((Map)addList.get(0)).get("multiType"), ((Map)addList.get(0)).get("multiNumber"), x, y, formAddress, useVariables, formDetailAddress, flowTodoCondition, messageType));
        workFlow.setData(JSON.toJSONString((Object)flowModel));
        return workFlow;
    }

    private String getNextParallelNodeId(List<FlowObject> elements, List<FlowSequence> paths, String nodeId) {
        for (FlowSequence path : paths) {
            if (!path.getStart().getKey().equals(nodeId)) continue;
            String nextNodeId = path.getEnd().getKey();
            for (FlowObject flowObject : elements) {
                if (!flowObject.getId().equals(nextNodeId)) continue;
                if (BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType().equals(flowObject.getName()) || BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType().equals(flowObject.getName())) {
                    return nextNodeId;
                }
                return this.getNextParallelNodeId(elements, paths, nextNodeId);
            }
        }
        return null;
    }

    private List<Map<String, List<FlowSequenceXy>>> getParallelNewPathPoints(List<FlowSequence> paths, String nextNodeId, String endPointNodeId, int num, List<String> nodeIds, List<FlowObject> elements) {
        ArrayList<FlowSequenceXy> newEndPoints;
        ArrayList<FlowSequenceXy> endPoints;
        ArrayList<Map<String, List<FlowSequenceXy>>> list = new ArrayList<Map<String, List<FlowSequenceXy>>>();
        HashMap map = new HashMap();
        FlowSequenceXy start1 = null;
        FlowSequenceXy start2 = null;
        FlowSequenceXy startPoint1 = new FlowSequenceXy();
        FlowSequenceXy startPoint2 = new FlowSequenceXy();
        FlowSequenceXy startPoint3 = new FlowSequenceXy();
        FlowSequenceXy startPoint4 = new FlowSequenceXy();
        FlowSequenceXy end1 = null;
        FlowSequenceXy end2 = null;
        FlowSequenceXy endPoint1 = new FlowSequenceXy();
        FlowSequenceXy endPoint2 = new FlowSequenceXy();
        FlowSequenceXy endPoint3 = new FlowSequenceXy();
        FlowSequenceXy endPoint4 = new FlowSequenceXy();
        FlowSequenceXy startNode1 = new FlowSequenceXy();
        FlowSequenceXy startNode2 = new FlowSequenceXy();
        FlowSequenceXy startNode3 = new FlowSequenceXy();
        FlowSequenceXy endNode1 = new FlowSequenceXy();
        FlowSequenceXy endNode2 = new FlowSequenceXy();
        FlowSequenceXy endNode3 = new FlowSequenceXy();
        for (FlowSequence path : paths) {
            List point;
            if (nextNodeId.equals(path.getStart().getKey())) {
                point = path.getPoints();
                double yChangeLength = 0.0;
                path.getEnd();
                for (FlowObject flowObject : elements) {
                    if (!path.getEnd().getKey().equals(flowObject.getId())) continue;
                    yChangeLength = (Double.valueOf(flowObject.getHeight()) - 48.0) / 2.0;
                }
                if (point.size() > 3) {
                    double addY = Double.parseDouble(((FlowSequenceXy)point.get(2)).getY()) + 75.0 + yChangeLength;
                    if (HussarUtils.isEmpty((Object)startPoint3.getY()) || Double.parseDouble(startPoint3.getY()) < addY) {
                        startPoint1 = (FlowSequenceXy)point.get(0);
                        startPoint2 = (FlowSequenceXy)point.get(1);
                        startPoint3.setX(((FlowSequenceXy)point.get(2)).getX());
                        startPoint3.setY(String.valueOf(addY));
                        startPoint4.setY(String.valueOf(addY));
                    }
                    startPoint4.setX(((FlowSequenceXy)point.get(3)).getX());
                } else if (point.size() == 3) {
                    double addY = Double.parseDouble(((FlowSequenceXy)point.get(2)).getY()) + 75.0 + yChangeLength;
                    if (HussarUtils.isEmpty((Object)startNode3.getY()) || Double.parseDouble(startNode3.getY()) < addY) {
                        startNode1 = (FlowSequenceXy)point.get(0);
                        startNode2.setX(((FlowSequenceXy)point.get(1)).getX());
                        startNode3.setX(((FlowSequenceXy)point.get(2)).getX());
                        startNode2.setY(String.valueOf(addY));
                        startNode3.setY(String.valueOf(addY));
                    }
                } else {
                    start1 = (FlowSequenceXy)point.get(0);
                    start2 = (FlowSequenceXy)point.get(1);
                }
            }
            if (!endPointNodeId.equals(path.getEnd().getKey())) continue;
            if (!path.getStart().getKey().startsWith("jxd_bpm_custom_node")) {
                nodeIds.add(path.getStart().getKey());
            }
            if ((point = path.getPoints()).size() > 3) {
                if (endPoint3.getY() != null && !(Double.valueOf(((FlowSequenceXy)point.get(3)).getY()) > Double.valueOf(endPoint3.getY()))) continue;
                endPoint2.setX(((FlowSequenceXy)point.get(2)).getX());
                endPoint3.setX(((FlowSequenceXy)point.get(2)).getX());
                endPoint3.setY(((FlowSequenceXy)point.get(3)).getY());
                endPoint4 = (FlowSequenceXy)point.get(3);
                continue;
            }
            if (point.size() == 3) {
                if (endNode3.getY() != null && !(Double.valueOf(((FlowSequenceXy)point.get(2)).getY()) > Double.valueOf(endNode3.getY()))) continue;
                endNode2.setX(((FlowSequenceXy)point.get(1)).getX());
                endNode3 = (FlowSequenceXy)point.get(2);
                continue;
            }
            end1 = (FlowSequenceXy)point.get(0);
            end2 = (FlowSequenceXy)point.get(1);
        }
        if (HussarUtils.isNotEmpty((Object)startNode1.getX())) {
            endNode1.setY(startNode3.getY());
            endNode1.setX(String.valueOf(Double.parseDouble(startNode3.getX()) + 48.0));
            endNode2.setY(startNode3.getY());
        }
        if (start1 != null && start2 != null && HussarUtils.isEmpty((Object)startPoint3.getX()) && HussarUtils.isNotEmpty((Object)start1.getX())) {
            startPoint1 = start1;
            startPoint2.setY(start1.getY());
            String midX = String.valueOf((Double.parseDouble(start1.getX()) + Double.parseDouble(start2.getX())) / 2.0);
            startPoint2.setX(midX);
            startPoint3.setX(midX);
            startPoint4.setX(start2.getX());
        }
        if (HussarUtils.isNotEmpty(start1)) {
            double addY = Double.parseDouble(start1.getY()) + 75.0;
            if (HussarUtils.isEmpty((Object)startPoint3.getY()) || Double.parseDouble(startPoint3.getY()) < addY) {
                startPoint3.setY(String.valueOf(addY));
                startPoint4.setY(String.valueOf(addY));
            }
        }
        if (HussarUtils.isNotEmpty((Object)startPoint1.getX())) {
            endPoint1.setY(startPoint4.getY());
            endPoint1.setX(String.valueOf(Double.parseDouble(startPoint4.getX()) + 48.0));
            endPoint2.setY(startPoint4.getY());
        }
        if (HussarUtils.isEmpty((Object)endPoint3.getX()) && end2 != null) {
            endPoint4 = end2;
            endPoint3.setY(end2.getY());
            String midX = String.valueOf((Double.parseDouble(end1.getX()) + Double.parseDouble(end2.getX())) / 2.0);
            endPoint2.setX(midX);
            endPoint3.setX(midX);
        }
        if (HussarUtils.isNotEmpty((Object)startNode2.getY()) && Double.parseDouble(startNode2.getY()) > Double.parseDouble(startPoint3.getY())) {
            ArrayList<FlowSequenceXy> startPoints = new ArrayList<FlowSequenceXy>();
            startPoints.add(startNode1);
            startPoints.add(startNode2);
            startPoints.add(startNode3);
            endPoints = new ArrayList();
            endPoints.add(endNode1);
            endPoints.add(endNode2);
            endPoints.add(endNode3);
            map.put("startPoints", startPoints);
            map.put("endPoints", endPoints);
            list.add(map);
            for (int i = 1; i < num; ++i) {
                ArrayList<FlowSequenceXy> newStartPoints = new ArrayList<FlowSequenceXy>();
                newStartPoints.add(startNode1);
                FlowSequenceXy newStartNode2 = new FlowSequenceXy();
                newStartNode2.setX(startNode2.getX());
                newStartNode2.setY(String.valueOf(Double.parseDouble(startNode2.getY()) + (double)(75 * i)));
                newStartPoints.add(newStartNode2);
                FlowSequenceXy newStartNode3 = new FlowSequenceXy();
                newStartNode3.setX(startNode3.getX());
                newStartNode3.setY(String.valueOf(Double.parseDouble(startNode3.getY()) + (double)(75 * i)));
                newStartPoints.add(newStartNode3);
                newEndPoints = new ArrayList<FlowSequenceXy>();
                FlowSequenceXy newEndNode1 = new FlowSequenceXy();
                newEndNode1.setX(endNode1.getX());
                newEndNode1.setY(String.valueOf(Double.parseDouble(endNode1.getY()) + (double)(75 * i)));
                newEndPoints.add(newEndNode1);
                FlowSequenceXy newEndNode2 = new FlowSequenceXy();
                newEndNode2.setX(endNode2.getX());
                newEndNode2.setY(String.valueOf(Double.parseDouble(endNode2.getY()) + (double)(75 * i)));
                newEndPoints.add(newEndNode2);
                newEndPoints.add(endNode3);
                HashMap<String, ArrayList<FlowSequenceXy>> newMap = new HashMap<String, ArrayList<FlowSequenceXy>>();
                newMap.put("startPoints", newStartPoints);
                newMap.put("endPoints", newEndPoints);
                list.add(newMap);
            }
            return list;
        }
        ArrayList<FlowSequenceXy> startPoints = new ArrayList<FlowSequenceXy>();
        startPoints.add(startPoint1);
        startPoints.add(startPoint2);
        startPoints.add(startPoint3);
        startPoints.add(startPoint4);
        endPoints = new ArrayList<FlowSequenceXy>();
        endPoints.add(endPoint1);
        endPoints.add(endPoint2);
        endPoints.add(endPoint3);
        endPoints.add(endPoint4);
        map.put("startPoints", startPoints);
        map.put("endPoints", endPoints);
        list.add(map);
        for (int i = 1; i < num; ++i) {
            ArrayList<FlowSequenceXy> newStartPoints = new ArrayList<FlowSequenceXy>();
            newStartPoints.add(startPoint1);
            newStartPoints.add(startPoint2);
            FlowSequenceXy newStartPoint3 = new FlowSequenceXy();
            newStartPoint3.setX(startPoint3.getX());
            newStartPoint3.setY(String.valueOf(Double.parseDouble(startPoint3.getY()) + (double)(75 * i)));
            newStartPoints.add(newStartPoint3);
            FlowSequenceXy newStartPoint4 = new FlowSequenceXy();
            newStartPoint4.setX(startPoint4.getX());
            newStartPoint4.setY(String.valueOf(Double.parseDouble(startPoint4.getY()) + (double)(75 * i)));
            newStartPoints.add(newStartPoint4);
            newEndPoints = new ArrayList();
            FlowSequenceXy newEndPoint1 = new FlowSequenceXy();
            newEndPoint1.setX(endPoint1.getX());
            newEndPoint1.setY(String.valueOf(Double.parseDouble(endPoint1.getY()) + (double)(75 * i)));
            newEndPoints.add(newEndPoint1);
            FlowSequenceXy newEndPoint2 = new FlowSequenceXy();
            newEndPoint2.setX(endPoint2.getX());
            newEndPoint2.setY(String.valueOf(Double.parseDouble(endPoint2.getY()) + (double)(75 * i)));
            newEndPoints.add(newEndPoint2);
            newEndPoints.add(endPoint3);
            newEndPoints.add(endPoint4);
            HashMap<String, ArrayList<FlowSequenceXy>> newMap = new HashMap<String, ArrayList<FlowSequenceXy>>();
            newMap.put("startPoints", newStartPoints);
            newMap.put("endPoints", newEndPoints);
            list.add(newMap);
        }
        return list;
    }

    private Map<String, String> getNewId() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nodeId", "jxd_bpm_custom_node_" + (int)(1.0E7 + Math.random() * 9.0E7));
        map.put("pathId", "jxd_bpm_custom_path_" + (int)(1.0E7 + Math.random() * 9.0E7));
        map.put("endPathId", "jxd_bpm_custom_path_" + (int)(1.0E7 + Math.random() * 9.0E7));
        return map;
    }

    private FlowObject newNode(String nodeId, Object nodeName, String pathId, Object assignees, Object counterSwitch, Object multiType, Object multiNumber, double x, double y, JSONObject formAddress, List<FlowVariables> userVariables, String formDetailAddress, FlowTodoCondition flowTodoCondition, String messageType) {
        FlowObject flowObject = new FlowObject();
        flowObject.setInstanceKey(nodeId);
        flowObject.setName(BpmNodeTypeEnum.BPM_USER.getType());
        flowObject.setAlias("");
        flowObject.setWidth(String.valueOf(48));
        flowObject.setHeight(String.valueOf(48));
        flowObject.setLeft(String.valueOf(x));
        flowObject.setTop(String.valueOf(y - 25.0));
        FlowProps flowProps = new FlowProps();
        flowProps.setFormAddress(formAddress);
        flowProps.setFormDetailAddress(formDetailAddress);
        flowProps.setTodoConfiguration(flowTodoCondition);
        flowProps.setFlowName((String)nodeName);
        flowProps.setMessageType(messageType);
        FlowAssignment flowAssignment = new FlowAssignment();
        flowAssignment.setJudgeBackCondition(new ArrayList());
        List<String> assigneeIds = Arrays.asList(((String)assignees).split(","));
        StringBuilder condition = new StringBuilder(" and O.ORGAN_ID IN ('" + assigneeIds.get(0) + "')");
        for (int i = 1; i < assigneeIds.size(); ++i) {
            condition.append(" or O.ORGAN_ID IN ('").append(assigneeIds.get(i)).append("')");
        }
        flowAssignment.setDefaultBackCondtion(condition.toString());
        flowProps.setFlowAssignment(flowAssignment);
        flowProps.setFlowRecipients(new FlowRecipients());
        flowProps.setDueDate("");
        flowProps.setTodoConfiguration(flowTodoCondition);
        flowProps.setFlowSkipRepetition("");
        flowProps.setFlowDefault(false);
        MultiUser multiUser = new MultiUser();
        multiUser.setCountersignNumByRatio(100.0);
        multiUser.setCountersign(false);
        multiUser.setCountersignNumByCount(0);
        multiUser.setCountersignType("radio");
        if (((Boolean)counterSwitch).booleanValue() && HussarUtils.isNotEmpty((Object)multiType) && HussarUtils.isNotEmpty((Object)multiNumber)) {
            multiUser.setCountersign(true);
            multiUser.setCountersignType((String)multiType);
            if ("radio".equals(multiType)) {
                multiUser.setCountersignNumByRatio(Double.parseDouble(String.valueOf(multiNumber)));
            } else {
                multiUser.setCountersignNumByCount(((Integer)multiNumber).intValue());
            }
        }
        flowProps.setFlowCountersign(multiUser);
        flowProps.setUseVariables(userVariables);
        flowObject.setProps(flowProps);
        ArrayList<String> newPath = new ArrayList<String>();
        newPath.add(pathId);
        flowObject.setGoOutPathes(newPath);
        return flowObject;
    }

    private FlowSequence newPath(String pathId, String nodeId, String nextNodeId, double x, double y, int moveWidth, List<FlowSequenceXy> points) {
        FlowSequence flowSequence = new FlowSequence();
        SequenceSourceTarget start = new SequenceSourceTarget();
        SequenceSourceTarget end = new SequenceSourceTarget();
        start.setKey(nodeId);
        end.setKey(nextNodeId);
        if (moveWidth < 0) {
            start.setPort("L");
            end.setPort("R");
        } else {
            start.setPort("R");
            end.setPort("L");
        }
        flowSequence.setStart(start);
        flowSequence.setEnd(end);
        if (HussarUtils.isEmpty(points)) {
            points = new ArrayList<FlowSequenceXy>();
            FlowSequenceXy startXy = new FlowSequenceXy();
            startXy.setX(String.valueOf(x));
            startXy.setY(String.valueOf(y));
            points.add(startXy);
            FlowSequenceXy endXy = new FlowSequenceXy();
            endXy.setX(String.valueOf(x + (double)moveWidth / 2.0));
            endXy.setY(String.valueOf(y));
            points.add(endXy);
            flowSequence.setPoints(points);
        } else {
            ArrayList<FlowSequenceXy> pointList = new ArrayList<FlowSequenceXy>();
            for (FlowSequenceXy flowSequenceXy : points) {
                FlowSequenceXy sequenceXy = new FlowSequenceXy();
                sequenceXy.setX(flowSequenceXy.getX());
                sequenceXy.setY(flowSequenceXy.getY());
                pointList.add(sequenceXy);
            }
            flowSequence.setPoints(pointList);
        }
        flowSequence.setFlowDefault(false);
        flowSequence.setLineConfig(new LineConfig());
        flowSequence.setInstanceKey(pathId);
        flowSequence.setName(BpmNodeTypeEnum.BPM_SEQUENCE.getType());
        flowSequence.setAlias("");
        flowSequence.setWidth("0");
        flowSequence.setHeight("0");
        FlowProps flowProps = new FlowProps();
        flowProps.setFlowName("");
        flowProps.setBackFlowCondition("");
        flowSequence.setProps(flowProps);
        flowSequence.setGoOutPathes(new ArrayList());
        return flowSequence;
    }

    private String getRealTaskId(String taskId) {
        if (taskId == null) {
            return null;
        }
        if (taskId.contains(":")) {
            String[] str = taskId.split(":");
            return str[0];
        }
        return taskId;
    }
}

