/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceRevokeTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessEndCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.RevokeFlagUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.SubProcessEndCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;

public class TaskRejectCmd
implements Command<Void> {
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private RuntimeService runtimeService = (RuntimeService)SpringContextHolder.getApplicationContext().getBean(RuntimeService.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private TaskService taskService = (TaskService)SpringContextHolder.getApplicationContext().getBean(TaskService.class);
    private ISysActHiLineService iSysActHiLineService = (ISysActHiLineService)SpringContextHolder.getApplicationContext().getBean(ISysActHiLineService.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private TaskRejectModel taskRejectModel;

    public TaskRejectCmd(TaskRejectModel taskRejectModel) {
        this.taskRejectModel = taskRejectModel;
    }

    public Void execute(CommandContext commandContext) {
        commandContext.addAttribute("taskSourceFlag", (Object)this.taskRejectModel.getType());
        if (this.taskRejectModel.getTaskId() != null) {
            Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(this.taskRejectModel.getTaskId())).includeTaskLocalVariables()).singleResult();
            if (task == null) {
                throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
            }
            this.taskRejectModel.setTask(task);
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            this.taskRejectModel.setBm(bm);
            if (this.taskRejectModel.getMandator() == null) {
                List identityLinkEntities = ((TaskEntity)task).getIdentityLinkType("candidate");
                commandContext.addAttribute("taskId", (Object)task.getId());
                commandContext.addAttribute("sendUser", (Object)this.taskRejectModel.getUserId());
                String organId = null;
                for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                    if (!identityLinkEntity.getUserId().equals(this.taskRejectModel.getUserId())) continue;
                    organId = identityLinkEntity.getOrganId();
                }
                this.taskRejectModel.setOrganId(organId);
                commandContext.addAttribute("sendUserOrganId", organId);
            }
        } else if (this.taskRejectModel.getHistoryTaskId() != null) {
            this.taskRejectModel.setEndTime(new Date());
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(this.taskRejectModel.getHistoryTaskId())).includeTaskLocalVariables()).singleResult();
            if (historicTaskInstance == null) {
                throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
            }
            this.taskRejectModel.setProcInsId(historicTaskInstance.getProcessInstanceId());
            this.taskRejectModel.setHistoricTaskInstance(historicTaskInstance);
            BpmnModel bm = this.repositoryService.getBpmnModel(historicTaskInstance.getProcessDefinitionId());
            this.taskRejectModel.setBm(bm);
            if (this.revokeHandle(commandContext)) {
                return null;
            }
            commandContext.addAttribute("taskId", (Object)historicTaskInstance.getAssignee());
            commandContext.addAttribute("sendUser", (Object)this.taskRejectModel.getUserId());
            commandContext.addAttribute("sendUserOrganId", (Object)historicTaskInstance.getOrganId());
        }
        this.setTargetNode();
        this.checkTargetNode();
        if (this.taskRejectModel.getHistoryTaskId() == null) {
            this.TaskAssigneeHandle();
        }
        this.subProcessReStartHandle(commandContext);
        this.rejectTypeHandle();
        this.rejectCallActivityHandle(commandContext);
        this.rejectNodeSendUserHandle(commandContext);
        this.rejectExecute(this.taskRejectModel.getUserId(), this.taskRejectModel.getMandator(), this.taskRejectModel.getExecution() == null ? (TaskEntity)this.taskRejectModel.getTask() : null, this.taskRejectModel.getExecution(), this.taskRejectModel.getTargetIds(), this.taskRejectModel.getTaskId(), this.taskRejectModel.getComment(), this.taskRejectModel.getJumpType(), this.taskRejectModel.getType(), this.taskRejectModel.getMap(), this.taskRejectModel, commandContext);
        return null;
    }

    private String getErrorMessage() {
        if ("reject".equals(this.taskRejectModel.getType())) {
            return this.bpmConstantProperties.getNotRejectToTargetNode();
        }
        if ("revoke".equals(this.taskRejectModel.getType())) {
            return this.bpmConstantProperties.getNotRevokeToTargetNode();
        }
        return this.bpmConstantProperties.getNotFreeJumpToTargetNode();
    }

    private void rejectExecute(String userId, String mandator, TaskEntity task, ExecutionEntity execution, String backActivityId, String taskId, String comment, int backType, String type, Map<String, Object> map, TaskRejectModel taskRejectModel, CommandContext commandContext) {
        String executionId;
        ActivityImpl currentActivity;
        String subProcessKey;
        boolean revoke = type.equals("revoke") || type.equals("reject_revoke");
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (newMap.get("appoint_assignee") == null) {
            HashMap appointAssignee = new HashMap();
            newMap.put("appoint_assignee", appointAssignee);
        }
        if (task != null) {
            if (!revoke) {
                if (StringUtils.isNotEmpty((CharSequence)comment) && (type.equals("reject") || type.equals("freejump"))) {
                    CommentEntity commentEntity = new CommentEntity();
                    commentEntity.setUserId(userId);
                    commentEntity.setType("complete");
                    commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
                    commentEntity.setTaskId(task.getId());
                    commentEntity.setProcessInstanceId(null);
                    commentEntity.setAction("AddComment");
                    String eventMessage = comment.replaceAll("\\s+", " ");
                    if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                        eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
                    }
                    commentEntity.setMessage(eventMessage);
                    commentEntity.setFullMessage(comment);
                    commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
                }
                task.setVariableLocalWithOutQuery("taskSourceFlag", (Object)type, true);
                task.setVariableLocalWithOutQuery("is_normal_commit", (Object)false, true);
            }
            subProcessKey = task.getSubProcessKey();
            currentActivity = task.getExecution().getActivity();
            executionId = task.getExecutionId();
        } else {
            currentActivity = execution.getActivity();
            if (execution.getActivity() == null) {
                currentActivity = ((ExecutionEntity)execution.getExecutions().get(0)).getActivity();
            }
            executionId = execution.getId();
            subProcessKey = (String)execution.getVariable("sub_process_key");
        }
        switch (backType) {
            case 2: {
                new MultiInstanceJumpTaskCmd(userId, mandator, executionId, backActivityId, task == null ? null : task.getId(), comment, type, newMap, currentActivity, taskRejectModel).execute(commandContext);
                break;
            }
            case 3: {
                if (!revoke && task != null && HussarUtils.isNotEmpty((Object)userId) && HussarUtils.isEmpty((Object)task.getAssignee()) && task.getAssignee() == null) {
                    task.setAssignee(userId, true, true, taskRejectModel.getOrganId());
                }
                new ParallelJumpTaskCmd(userId, mandator, executionId, backActivityId, comment, type, subProcessKey, newMap, currentActivity, taskRejectModel).execute(commandContext);
                break;
            }
            default: {
                if (!revoke && task != null && StringUtils.isNotEmpty((CharSequence)userId) && task.getAssignee() == null) {
                    task.setAssignee(userId, true, true, taskRejectModel.getOrganId());
                }
                new CommonJumpTaskCmd(userId, mandator, executionId, backActivityId, comment, type, newMap, currentActivity, taskRejectModel).execute(commandContext);
            }
        }
        if (task != null && HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(task.getId());
        }
    }

    private boolean revokeHandle(CommandContext commandContext) {
        HistoricTaskInstance historicTaskInstance = this.taskRejectModel.getHistoricTaskInstance();
        String subProcessKey = historicTaskInstance.getSubProcessKey();
        if (this.taskRejectModel.getUserId() == null || !this.taskRejectModel.getUserId().equals(historicTaskInstance.getAssignee()) && !this.taskRejectModel.getUserId().equals(historicTaskInstance.getOwner())) {
            throw new PublicClientException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u529e\u7406\u6743\u9650\uff01");
        }
        if (HussarUtils.isEmpty((Object)historicTaskInstance.getEndTime())) {
            throw new PublicClientException(this.bpmConstantProperties.getCurrentTaskCannotRevoke());
        }
        String taskSourceFlag = (String)historicTaskInstance.getTaskLocalVariables().get("taskSourceFlag");
        boolean revokeReject = false;
        if ("reject".equals(taskSourceFlag)) {
            revokeReject = true;
            this.taskRejectModel.setType("reject_revoke");
        }
        if ("revoke".equals(taskSourceFlag) || "reject_revoke".equals(taskSourceFlag) || "assignee".equals(taskSourceFlag) || "complete_leap".equals(taskSourceFlag)) {
            throw new PublicClientException(this.bpmConstantProperties.getForbidRevoke());
        }
        this.taskRejectModel.setTargetIds(historicTaskInstance.getTaskDefinitionKey());
        this.taskRejectModel.getMap().put("ADD_HISTORY_TASK_START_TIME", historicTaskInstance.getEndTime());
        this.taskRejectModel.getMap().put("ADD_HISTORY_TASK_END_TIME", this.taskRejectModel.getEndTime());
        this.taskRejectModel.getMap().put("isSubmit", this.taskRejectModel.isSubmit());
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(historicTaskInstance.getProcessInstanceId())).taskVariableValueEquals(revokeReject ? "reject_from" : "complete_from", (Object)historicTaskInstance.getTaskDefinitionKey())).subProcessKeyWithOutMain(subProcessKey)).includeProcessVariables()).includeTaskLocalVariables()).listPage(0, 1);
        if (HussarUtils.isEmpty((Object)taskList)) {
            taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(historicTaskInstance.getProcessInstanceId())).taskVariableValueLike("all_prev_node", "%'" + historicTaskInstance.getTaskDefinitionKey() + "'%")).subProcessKeyWithOutMain(subProcessKey)).includeProcessVariables()).includeTaskLocalVariables()).listPage(0, 1);
        }
        if (HussarUtils.isNotEmpty((Object)taskList)) {
            Task task = (Task)taskList.get(0);
            BpmnModel bm = this.taskRejectModel.getBm();
            Object allPrevNode = task.getTaskLocalVariables().get("all_prev_node");
            if (!revokeReject && historicTaskInstance.getProcessInstanceId().equals(task.getProcessInstanceId()) && HussarUtils.isNotEmpty(allPrevNode) && allPrevNode.toString().contains(",")) {
                this.taskRejectModel.getMap().put("all_prev_node", allPrevNode);
                String prevNode = ((SysActHiLine)this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)task.getProcessInstanceId())).eq(SysActHiLine::getInNode, (Object)task.getTaskDefinitionKey())).orderByDesc(SysActHiLine::getCompleteTime)).get(0)).getOutNode();
                while (!(bm.getFlowElement(prevNode) instanceof ParallelGateway) && !(bm.getFlowElement(prevNode) instanceof InclusiveGateway)) {
                    prevNode = ((SysActHiLine)this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)task.getProcessInstanceId())).eq(SysActHiLine::getInNode, (Object)prevNode)).orderByDesc(SysActHiLine::getCompleteTime)).get(0)).getOutNode();
                }
                this.taskRejectModel.getMap().put("prev_node", prevNode);
            }
            this.taskRejectModel.setTask((Task)taskList.get(0));
            if (!"complete".equals(taskSourceFlag) && this.canNotRejectPrepare(bm, task.getTaskDefinitionKey(), historicTaskInstance.getTaskDefinitionKey(), true) && this.canNotRejectPrepare(bm, task.getTaskDefinitionKey(), historicTaskInstance.getTaskDefinitionKey(), false)) {
                throw new PublicClientException(this.bpmConstantProperties.getNotRevokeToTargetNode());
            }
        } else {
            List executionList = this.runtimeService.createExecutionQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).variableValueLike("all_prev_node", "%'" + historicTaskInstance.getTaskDefinitionKey() + "'%").list();
            if (HussarUtils.isEmpty((Object)executionList)) {
                List list = this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(historicTaskInstance.getProcessInstanceId()).list();
                List callActivityIds = list.stream().map(Execution::getProcessInstanceId).collect(Collectors.toList());
                List callTasks = revokeReject ? ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(callActivityIds)).taskVariableValueEquals("main_reject_from", (Object)historicTaskInstance.getTaskDefinitionKey())).list() : ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(callActivityIds)).taskVariableValueEquals("call_complete_from", (Object)historicTaskInstance.getTaskDefinitionKey())).list();
                String procInstId = ((Task)callTasks.get(0)).getProcessInstanceId();
                for (ProcessInstance processInstance : list) {
                    if (!processInstance.getId().equals(procInstId)) continue;
                    executionList = this.runtimeService.createExecutionQuery().executionId(processInstance.getSuperExecutionId()).list();
                    break;
                }
            }
            ExecutionEntity executionEntity = (ExecutionEntity)executionList.get(0);
            for (Execution execution : executionList) {
                if (execution.getParentId() != null) {
                    executionEntity = (ExecutionEntity)execution;
                }
                if (((ExecutionEntity)execution).isScope() || execution.getActivityId() == null) continue;
                executionEntity = (ExecutionEntity)execution;
                break;
            }
            BpmnModel bm = this.taskRejectModel.getBm();
            if (!historicTaskInstance.getTaskDefinitionKey().equals(executionEntity.getActivityId())) {
                Map variables = executionEntity.getVariablesLocal();
                Object allPrevNode = variables.get("all_prev_node");
                if (HussarUtils.isNotEmpty(allPrevNode) && allPrevNode.toString().contains(",")) {
                    this.taskRejectModel.getMap().put("all_prev_node", allPrevNode);
                    String prevNode = ((SysActHiLine)this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)executionEntity.getProcessInstanceId())).eq(SysActHiLine::getInNode, (Object)executionEntity.getActivityId())).orderByDesc(SysActHiLine::getCompleteTime)).get(0)).getOutNode();
                    while (!(bm.getFlowElement(prevNode) instanceof ParallelGateway) && !(bm.getFlowElement(prevNode) instanceof InclusiveGateway)) {
                        prevNode = ((SysActHiLine)this.iSysActHiLineService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHiLine::getProcessInsId, (Object)executionEntity.getProcessInstanceId())).eq(SysActHiLine::getInNode, (Object)prevNode)).orderByDesc(SysActHiLine::getCompleteTime)).get(0)).getOutNode();
                    }
                    this.taskRejectModel.getMap().put("prev_node", prevNode);
                }
                this.taskRejectModel.setExecution(executionEntity);
            } else {
                List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(historicTaskInstance.getProcessInstanceId())).taskDefinitionKey(historicTaskInstance.getTaskDefinitionKey())).listPage(0, 1);
                if (tasks.size() == 1) {
                    new MultiInstanceRevokeTaskCmd(historicTaskInstance, this.taskRejectModel.getComment(), this.taskRejectModel.getEndTime()).execute(commandContext);
                    this.taskRejectModel.getMap().put("reject_appoint_assignee", historicTaskInstance.getOriginalAssignee());
                    return true;
                }
            }
        }
        if (revokeReject) {
            List historicTaskInstances;
            Map variables;
            List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId())).taskDefinitionKey(historicTaskInstance.getTaskDefinitionKey())).subProcessKeyWithOutMain(subProcessKey)).taskVariableValueEquals("complete_type", (Object)"complete")).taskVariableValueNotEquals("old_appoint_assignee", null)).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
            if (historicTaskInstanceList.size() == 1) {
                String oldAppointAssignee;
                Object oldAppointMessage = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
                if (oldAppointMessage instanceof HashMap) {
                    Map oldAppointAssigneeMap = (Map)oldAppointMessage;
                    oldAppointAssignee = (String)oldAppointAssigneeMap.get(historicTaskInstance.getTaskDefinitionKey());
                } else {
                    oldAppointAssignee = (String)oldAppointMessage;
                }
                if (HussarUtils.isNotEmpty((Object)oldAppointAssignee)) {
                    this.taskRejectModel.getMap().put("reject_appoint_assignee", oldAppointAssignee);
                }
            }
            if (HussarUtils.isNotEmpty((variables = ((HistoricTaskInstance)(historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId())).taskDefinitionKey(historicTaskInstance.getTaskDefinitionKey())).subProcessKeyWithOutMain(subProcessKey)).taskVariableValueEquals("complete_type", (Object)"complete")).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1)).get(0)).getTaskLocalVariables()).get("multi_type")) && HussarUtils.isNotEmpty(variables.get("multi_finish_condition"))) {
                this.taskRejectModel.getMap().put("multi_type", variables.get("multi_type").toString());
                this.taskRejectModel.getMap().put("multi_finish_condition", variables.get("multi_finish_condition").toString());
            }
        } else if (!this.taskRejectModel.isSubmit()) {
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicTaskInstance.getProcessDefinitionId());
            if (definition == null) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessNotFound());
            }
            ActivityImpl currActivity = definition.findActivity(historicTaskInstance.getTaskDefinitionKey());
            if (currActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), Boolean.valueOf(false));
            }
            ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
            if (activityBehavior instanceof MultiInstanceActivityBehavior) {
                this.taskRejectModel.getMap().put("reject_appoint_assignee", historicTaskInstance.getOriginalAssignee());
            } else {
                List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId())).taskDefinitionKey(historicTaskInstance.getTaskDefinitionKey())).subProcessKeyWithOutMain(subProcessKey)).taskVariableValueEquals("complete_type", (Object)"complete")).taskVariableValueNotEquals("old_appoint_assignee", null)).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
                if (historicTaskInstanceList.size() == 1) {
                    String oldAppointAssignee;
                    Object oldAppointMessage = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
                    if (oldAppointMessage instanceof HashMap) {
                        Map oldAppointAssigneeMap = (Map)oldAppointMessage;
                        oldAppointAssignee = (String)oldAppointAssigneeMap.get(historicTaskInstance.getTaskDefinitionKey());
                    } else {
                        oldAppointAssignee = (String)oldAppointMessage;
                    }
                    if (HussarUtils.isNotEmpty((Object)oldAppointAssignee)) {
                        this.taskRejectModel.getMap().put("reject_appoint_assignee", oldAppointAssignee);
                    }
                }
            }
        } else {
            this.taskRejectModel.getMap().put("reject_appoint_assignee", historicTaskInstance.getOriginalAssignee());
        }
        return false;
    }

    private void setTargetNode() {
        if (this.taskRejectModel.getTargetIds() == null) {
            String targetNodeId = null;
            if (this.taskRejectModel.getHistoricTaskInstance() != null) {
                targetNodeId = this.taskRejectModel.getHistoricTaskInstance().getTaskDefinitionKey();
            } else if (this.taskRejectModel.getSubProcessFirst()) {
                if (this.taskRejectModel.getTask().getSubProcessKey() != null) {
                    String subProcessNodeId = this.taskRejectModel.getTask().getSubProcessKey().split(":")[0];
                    BpmnModel bpmnModel = this.taskRejectModel.getBm();
                    SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(subProcessNodeId);
                    for (FlowElement flowElement : subProcess.getFlowElements()) {
                        if (!(flowElement instanceof StartEvent)) continue;
                        targetNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
                        break;
                    }
                } else {
                    ActivityImpl activity = ((TaskEntity)this.taskRejectModel.getTask()).getExecution().getProcessDefinition().getInitial();
                    targetNodeId = ((PvmTransition)activity.getOutgoingTransitions().get(0)).getDestination().getId();
                }
            } else if (this.taskRejectModel.getFirst()) {
                ActivityImpl activity = ((TaskEntity)this.taskRejectModel.getTask()).getExecution().getProcessDefinition().getInitial();
                targetNodeId = ((PvmTransition)activity.getOutgoingTransitions().get(0)).getDestination().getId();
            } else {
                Map map = ((TaskEntity)this.taskRejectModel.getTask()).getVariablesLocal();
                if (map != null) {
                    if (map.get("call_complete_from") != null) {
                        targetNodeId = "main_process_" + map.get("call_complete_from");
                    } else if (map.get("all_prev_node") != null) {
                        targetNodeId = map.get("all_prev_node").toString().replace("'", "");
                    }
                }
                targetNodeId = this.checkRejectActivityId(this.taskRejectModel.getTask(), targetNodeId, this.taskRejectModel.getTask().getTaskDefinitionKey());
            }
            if (HussarUtils.isNotEmpty((Object)targetNodeId)) {
                this.taskRejectModel.setTargetIds(targetNodeId);
            } else {
                throw new PublicClientException(this.getErrorMessage());
            }
        }
    }

    private boolean canNotRejectPrepare(BpmnModel bm, String startNodeId, String nodeId, boolean isPre) {
        Process process = bm.getMainProcess();
        if (process.getFlowElement(nodeId) != null && process.getFlowElement(startNodeId) == null) {
            for (FlowElement flowElement : process.getFlowElements()) {
                if (!(flowElement instanceof SubProcess)) continue;
                for (FlowElement obj : ((SubProcess)flowElement).getFlowElements()) {
                    if (!obj.getId().equals(startNodeId)) continue;
                    startNodeId = flowElement.getId();
                }
            }
        }
        return !this.canReject(bm, startNodeId, nodeId, null, null, isPre);
    }

    private boolean canReject(BpmnModel bm, String startNodeId, String nodeId, List<String> nodes, List<String> freeJumpList, boolean isPre) {
        FlowElement element = bm.getFlowElement(startNodeId);
        ArrayList<String> newNodes = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(nodes)) {
            newNodes.addAll(nodes);
        }
        if (element instanceof ParallelGateway || element instanceof InclusiveGateway) {
            boolean isFreeJump = freeJumpList != null;
            boolean canFreeJump = true;
            for (SequenceFlow sequenceFlow : isPre ? ((Gateway)element).getIncomingFlows() : ((Gateway)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList == null) continue;
                    freeJumpList.add(nodeId);
                    continue;
                }
                newNodes.add(preNode);
                if (this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                if (isFreeJump) {
                    canFreeJump = false;
                    continue;
                }
                return false;
            }
            return canFreeJump;
        }
        if (!(element instanceof StartEvent) && !(element instanceof EndEvent)) {
            for (SequenceFlow sequenceFlow : isPre ? ((FlowNode)element).getIncomingFlows() : ((FlowNode)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList != null) {
                        freeJumpList.add(nodeId);
                    }
                    return true;
                }
                newNodes.add(preNode);
                if (!this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void checkTargetNode() {
        BpmnModel bm;
        String targetIds = this.taskRejectModel.getTargetIds();
        if (targetIds.contains("main_process_")) {
            if (targetIds.contains(",")) {
                for (String targetNodeId : targetIds.split(",")) {
                    if (targetNodeId.contains("main_process_")) continue;
                    throw new PublicClientException(this.getErrorMessage(), Boolean.valueOf(false));
                }
            }
            ExecutionEntity execution = ((TaskEntity)this.taskRejectModel.getTask()).getProcessInstance().getSuperExecution();
            this.taskRejectModel.setExecution(execution);
            String procDefId = execution.getProcessDefinitionId();
            bm = this.repositoryService.getBpmnModel(procDefId);
            this.taskRejectModel.setTargetIds(targetIds.replace("main_process_", ""));
            this.taskRejectModel.setBm(bm);
        } else {
            bm = this.taskRejectModel.getBm();
            Process process = bm.getMainProcess();
            boolean isAllMainNode = true;
            boolean isAllSubProcessNode = true;
            for (String targetNodeId : targetIds.split(",")) {
                if (process.getFlowElement(targetNodeId) != null) {
                    isAllSubProcessNode = false;
                } else {
                    isAllMainNode = false;
                }
                if (isAllMainNode || isAllSubProcessNode) continue;
                throw new PublicClientException(this.getErrorMessage(), Boolean.valueOf(false));
            }
            if (isAllMainNode && this.taskRejectModel.getExecution() == null && this.taskRejectModel.getTask() != null && this.taskRejectModel.getTask().getSubProcessKey() != null) {
                if (!this.taskRejectModel.isCanRejectToMainProcess() && ("reject".equals(this.taskRejectModel.getType()) || "freejump".equals(this.taskRejectModel.getType()))) {
                    throw new PublicClientException(this.getErrorMessage(), Boolean.valueOf(false));
                }
                ExecutionEntity executionEntity = ((TaskEntity)this.taskRejectModel.getTask()).getExecution();
                while (executionEntity.getVariableLocal("sub_process_key") == null) {
                    executionEntity = executionEntity.getParent();
                }
                this.taskRejectModel.setExecution(executionEntity.getParent());
                String jumpStartId = executionEntity.getVariable("sub_process_key").toString().split(":")[0];
                this.taskRejectModel.setJumpStartId(jumpStartId);
            }
        }
        String firstNodeId = null;
        for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
            if (!(flowElement instanceof StartEvent)) continue;
            firstNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
            break;
        }
        String processInstanceId = null;
        String subProcessKey = null;
        if (this.taskRejectModel.getHistoricTaskInstance() != null) {
            processInstanceId = this.taskRejectModel.getHistoricTaskInstance().getProcessInstanceId();
            subProcessKey = this.taskRejectModel.getHistoricTaskInstance().getSubProcessKey();
        } else if (this.taskRejectModel.getExecution() != null) {
            processInstanceId = this.taskRejectModel.getExecution().getProcessInstanceId();
            subProcessKey = (String)this.taskRejectModel.getExecution().getVariable("sub_process_key");
        } else if (this.taskRejectModel.getTask() != null) {
            processInstanceId = this.taskRejectModel.getTask().getProcessInstanceId();
            subProcessKey = this.taskRejectModel.getTask().getSubProcessKey();
        }
        String startUserId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getStartUserId();
        this.taskRejectModel.setProcInsId(processInstanceId);
        this.taskRejectModel.setSubProcessKey(subProcessKey);
        this.taskRejectModel.setFirstNodeId(firstNodeId);
        this.taskRejectModel.setFirst(firstNodeId.equals(this.taskRejectModel.getTargetIds()));
        this.taskRejectModel.setStartUserId(startUserId);
        if (targetIds.contains(",")) {
            if ("reject".equals(this.taskRejectModel.getType())) {
                String taskDefinitionKey;
                String string = taskDefinitionKey = this.taskRejectModel.getExecution() != null ? this.taskRejectModel.getExecution().getActivityId() : this.taskRejectModel.getTask().getTaskDefinitionKey();
                if (!this.canRejectToAnyNode(bm, taskDefinitionKey, targetIds)) {
                    throw new PublicClientException(this.getErrorMessage());
                }
            } else if (!this.canRejectToAnyNodePlus(bm, targetIds)) {
                throw new PublicClientException(this.getErrorMessage());
            }
        } else if (bm.getMainProcess().getFlowElement(targetIds) == null) {
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof SubProcess) || ((SubProcess)flowElement).getFlowElement(targetIds) == null) continue;
                for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                    if (!(element instanceof SequenceFlow) || !((SequenceFlow)element).getTargetRef().equals(targetIds)) continue;
                    if (((SubProcess)flowElement).getFlowElement(((SequenceFlow)element).getSourceRef()) instanceof StartEvent) {
                        this.taskRejectModel.setSubProcessFirst(true);
                    }
                    return;
                }
                return;
            }
        }
    }

    public boolean canRejectToAnyNode(BpmnModel bm, String taskDefinitionKey, String targetNodeIds) {
        if (!targetNodeIds.contains(",")) {
            return true;
        }
        targetNodeIds = targetNodeIds.replace("main_process_", "");
        Process process = bm.getMainProcess();
        boolean isAllMainNode = true;
        boolean isAllSubProcessNode = true;
        for (String targetNodeId : targetNodeIds.split(",")) {
            if (process.getFlowElement(targetNodeId) != null) {
                isAllSubProcessNode = false;
            } else {
                isAllMainNode = false;
            }
            if (isAllMainNode || isAllSubProcessNode) continue;
            return false;
        }
        FlowNode userTask = (FlowNode)bm.getFlowElement(taskDefinitionKey);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(taskDefinitionKey);
        ArrayList<List<String>> lists = new ArrayList<List<String>>();
        this.getAllHisNodeList(bm, userTask.getIncomingFlows(), ids, lists);
        ArrayList<String> targetNodes = new ArrayList<String>(Arrays.asList(targetNodeIds.split(",")));
        for (List list : lists) {
            boolean listContain = false;
            for (String targetNode : targetNodes) {
                if (!list.contains(targetNode)) continue;
                if (listContain) {
                    return false;
                }
                listContain = true;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean canRejectToAnyNodePlus(BpmnModel bm, String targetNodeIds) {
        void var9_16;
        if (!targetNodeIds.contains(",")) {
            return true;
        }
        Process process = bm.getMainProcess();
        boolean isAllMainNode = true;
        boolean isAllSubProcessNode = true;
        for (String string : targetNodeIds.split(",")) {
            if (process.getFlowElement(string) != null) {
                isAllSubProcessNode = false;
            } else {
                isAllMainNode = false;
            }
            if (isAllMainNode || isAllSubProcessNode) continue;
            return false;
        }
        ArrayList<String> targetNodes = new ArrayList<String>(Arrays.asList(targetNodeIds.split(",")));
        ArrayList<Object> targetNodePathList = new ArrayList<Object>();
        for (String string : targetNodes) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(string);
            ArrayList lists = new ArrayList();
            FlowNode userTask = (FlowNode)bm.getFlowElement(string);
            this.getAllHisNodeList(bm, userTask.getIncomingFlows(), ids, lists);
            targetNodePathList.add(lists);
        }
        ArrayList<String> canRejectNodeIds = new ArrayList<String>();
        for (FlowElement flowElement : process.getFlowElements()) {
            if (flowElement instanceof Gateway && !(flowElement instanceof ExclusiveGateway)) {
                canRejectNodeIds.add(flowElement.getId());
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                if (!(element instanceof Gateway) || element instanceof ExclusiveGateway) continue;
                canRejectNodeIds.add(element.getId());
            }
        }
        boolean bl = false;
        while (var9_16 < targetNodePathList.size()) {
            for (void j = var9_16 + true; j < targetNodePathList.size(); ++j) {
                List nodePathList1 = (List)targetNodePathList.get((int)var9_16);
                List nodePathList2 = (List)targetNodePathList.get((int)j);
                for (List path1 : nodePathList1) {
                    block7: for (List path2 : nodePathList2) {
                        for (String node : path1) {
                            if (!path2.contains(node)) continue;
                            if (canRejectNodeIds.contains(node)) continue block7;
                            return false;
                        }
                    }
                }
            }
            ++var9_16;
        }
        return true;
    }

    private void getAllHisNodeList(BpmnModel bm, List<SequenceFlow> incomingFlows, List<String> goneNode, List<List<String>> allHisNode) {
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = bm.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(goneNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            this.getAllHisNodeList(bm, ((FlowNode)flowElement).getIncomingFlows(), goneNodeSave, allHisNode);
        }
    }

    private String checkRejectActivityId(Task task, String backActivityId, String rejectActivityId) {
        if (HussarUtils.isEmpty((Object)backActivityId)) {
            throw new PublicClientException(this.getErrorMessage());
        }
        if (!backActivityId.contains(",")) {
            return backActivityId;
        }
        HashSet<String> backActivityIdSet = new HashSet<String>(Arrays.asList(backActivityId.split(",")));
        if (backActivityIdSet.size() == 1) {
            return (String)backActivityIdSet.iterator().next();
        }
        if (HussarUtils.isEmpty((Object)rejectActivityId)) {
            rejectActivityId = task.getTaskDefinitionKey();
        }
        if (this.canRejectToAnyNode(this.taskRejectModel.getBm(), rejectActivityId, String.join((CharSequence)",", backActivityIdSet))) {
            return String.join((CharSequence)",", backActivityIdSet);
        }
        FlowNode flowNode = (FlowNode)this.taskRejectModel.getBm().getFlowElement(rejectActivityId);
        if ((flowNode = this.getGateway(flowNode, this.taskRejectModel.getBm())) == null) {
            throw new PublicClientException(this.getErrorMessage());
        }
        HashSet<String> nodeIdSet = new HashSet<String>();
        this.getAllFlowNodeFromPerGateWay(flowNode, this.taskRejectModel.getBm(), nodeIdSet);
        backActivityIdSet.retainAll(nodeIdSet);
        if (this.canRejectToAnyNode(this.taskRejectModel.getBm(), rejectActivityId, String.join((CharSequence)",", backActivityIdSet))) {
            return String.join((CharSequence)",", backActivityIdSet);
        }
        throw new PublicClientException(this.getErrorMessage());
    }

    private FlowNode getGateway(FlowNode node, BpmnModel bm) {
        for (SequenceFlow flow : node.getIncomingFlows()) {
            FlowNode flowNode = (FlowNode)bm.getFlowElement(flow.getSourceRef());
            if (flowNode instanceof ParallelGateway || flowNode instanceof InclusiveGateway) {
                return flowNode;
            }
            if ((flowNode = this.getGateway(flowNode, bm)) == null) continue;
            return flowNode;
        }
        return null;
    }

    private void getAllFlowNodeFromPerGateWay(FlowNode node, BpmnModel bm, Set<String> nodeIdSet) {
        for (SequenceFlow flow : node.getIncomingFlows()) {
            FlowNode flowNode = (FlowNode)bm.getFlowElement(flow.getSourceRef());
            if (flowNode instanceof ParallelGateway || flowNode instanceof InclusiveGateway || flowNode instanceof StartEvent) continue;
            nodeIdSet.add(flowNode.getId());
            this.getAllFlowNodeFromPerGateWay(flowNode, bm, nodeIdSet);
        }
    }

    private void TaskAssigneeHandle() {
        BpmnModel bpmnModel;
        FlowElement flowElement;
        String processInstanceId = this.taskRejectModel.getProcInsId();
        String subProcessKey = this.taskRejectModel.getSubProcessKey();
        HashMap<String, Object> map = this.taskRejectModel.getMap();
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (!this.taskRejectModel.isSubmit()) {
            List historicTaskInstanceList;
            if (HussarUtils.isEmpty((Object)this.taskRejectModel.getAssignees()) && !this.taskRejectModel.getTargetIds().contains(",") && (historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(this.taskRejectModel.getTargetIds())).finished().includeTaskLocalVariables()).taskVariableValueNotEquals("old_appoint_assignee", null)).subProcessKey(subProcessKey)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1)).size() == 1) {
                String oldAppointAssignee;
                Object v = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
                if (v instanceof HashMap) {
                    Map oldAppointAssigneeMap = (Map)v;
                    oldAppointAssignee = (String)oldAppointAssigneeMap.get(this.taskRejectModel.getTargetIds());
                } else {
                    oldAppointAssignee = (String)v;
                }
                if (HussarUtils.isNotEmpty((Object)oldAppointAssignee)) {
                    map.put("reject_appoint_assignee", oldAppointAssignee);
                }
            }
            if (this.taskRejectModel.getTargetIds().contains(",")) {
                HashMap<String, String> appointAssignee = (HashMap<String, String>)map.get("appoint_assignee");
                if (appointAssignee == null) {
                    appointAssignee = new HashMap<String, String>();
                }
                for (String targetNodeId : this.taskRejectModel.getTargetIds().split(",")) {
                    String oldAppointAssignee;
                    List historicTaskInstanceList2;
                    if (appointAssignee.containsKey(targetNodeId) || (historicTaskInstanceList2 = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(targetNodeId)).finished().includeTaskLocalVariables()).taskVariableValueNotEquals("old_appoint_assignee", null)).subProcessKey(subProcessKey)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1)).size() != 1) continue;
                    Object oldAppointMessage = ((HistoricTaskInstance)historicTaskInstanceList2.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
                    if (oldAppointMessage instanceof HashMap) {
                        Map oldAppointAssigneeMap = (Map)oldAppointMessage;
                        oldAppointAssignee = (String)oldAppointAssigneeMap.get(targetNodeId);
                    } else {
                        oldAppointAssignee = (String)oldAppointMessage;
                    }
                    if (!HussarUtils.isNotEmpty((Object)oldAppointAssignee)) continue;
                    appointAssignee.put(targetNodeId, oldAppointAssignee);
                }
                map.put("appoint_assignee", appointAssignee);
            }
        }
        if (HussarUtils.isNotEmpty((Object)this.taskRejectModel.getAssignees())) {
            map.put("reject_appoint_assignee", this.taskRejectModel.getAssignees());
        }
        if (HussarUtils.isNotEmpty((Object)this.taskRejectModel.getAssigneeMap())) {
            map.put("appoint_assignee", this.taskRejectModel.getAssigneeMap());
        }
        if (this.taskRejectModel.isSubmit()) {
            String subProcessKeyCondition = subProcessKey;
            Process process = this.taskRejectModel.getBm().getMainProcess();
            if (this.taskRejectModel.getTargetIds().contains(",")) {
                String[] targetNodeIds;
                HashMap<String, String> appointAssignee = (HashMap<String, String>)map.get("appoint_assignee");
                if (appointAssignee == null) {
                    appointAssignee = new HashMap<String, String>();
                }
                if (process.getFlowElement((targetNodeIds = this.taskRejectModel.getTargetIds().split(","))[0]) != null) {
                    subProcessKeyCondition = null;
                }
                for (String targetNodeId : targetNodeIds) {
                    String assignee = this.getTaskCommitUser(this.historyService, processInstanceId, targetNodeId, subProcessKeyCondition);
                    if (!HussarUtils.isNotEmpty((Object)assignee)) continue;
                    appointAssignee.put(targetNodeId, assignee);
                }
                map.put("appoint_assignee", appointAssignee);
            } else {
                String assignee;
                if (process.getFlowElement(this.taskRejectModel.getTargetIds()) != null) {
                    subProcessKeyCondition = null;
                }
                if (HussarUtils.isNotEmpty((Object)(assignee = this.getTaskCommitUser(this.historyService, processInstanceId, this.taskRejectModel.getTargetIds(), subProcessKeyCondition)))) {
                    map.put("reject_appoint_assignee", assignee);
                }
            }
        }
        if (!this.taskRejectModel.getTargetIds().contains(",") && (flowElement = (bpmnModel = this.taskRejectModel.getBm()).getMainProcess().getFlowElement(this.taskRejectModel.getTargetIds())) != null && flowElement instanceof SubProcess && HussarUtils.isNotEmpty(map.get("reject_appoint_assignee"))) {
            String rejectAppointAssignee = (String)map.get("reject_appoint_assignee");
            map.remove("reject_appoint_assignee");
            HashMap<String, String> appointAssignee = new HashMap<String, String>();
            appointAssignee.put("static_appoint_assignee", rejectAppointAssignee);
            map.put("appoint_assignee", appointAssignee);
        }
        this.taskRejectModel.setMap(map);
    }

    private String getTaskCommitUser(HistoryService historyService, String processInsId, String backActivityId, String subProcessKey) {
        List hisTaskList;
        HashSet<String> assignees = new HashSet<String>();
        if (backActivityId.startsWith("main_process_")) {
            backActivityId = backActivityId.substring("main_process_".length());
        }
        if ((hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(backActivityId)).finished().subProcessKeyWithOutMain(subProcessKey)).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).list()) != null && !hisTaskList.isEmpty()) {
            List historicTaskInstanceList;
            block0: for (int i = 0; i < hisTaskList.size(); ++i) {
                String taskSourceFlag = (String)((HistoricTaskInstance)hisTaskList.get(i)).getTaskLocalVariables().get("taskSourceFlag");
                if ("reject".equals(taskSourceFlag) || "revoke".equals(taskSourceFlag) || "reject_revoke".equals(taskSourceFlag)) continue;
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(i);
                Date start = historicTaskInstance.getStartTime();
                assignees.add(historicTaskInstance.getOriginalAssignee());
                for (int j = i + 1; j < hisTaskList.size(); ++j) {
                    historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(j);
                    if (start.getTime() > historicTaskInstance.getEndTime().getTime()) break block0;
                    if (historicTaskInstance.getCreateTime().compareTo(start) < 0) {
                        start = historicTaskInstance.getCreateTime();
                    }
                    assignees.add(historicTaskInstance.getOriginalAssignee());
                }
                break;
            }
            if (assignees.isEmpty() && !(historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(backActivityId)).includeTaskLocalVariables()).taskVariableValueNotEquals("old_appoint_assignee", null)).subProcessKey(subProcessKey)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1)).isEmpty()) {
                Object oldAppoint = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
                if (oldAppoint instanceof Map && ((Map)oldAppoint).get(hisTaskList.get(0)) != null) {
                    return (String)((Map)oldAppoint).get(hisTaskList.get(0));
                }
                return (String)oldAppoint;
            }
        } else {
            List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(backActivityId)).includeTaskLocalVariables()).taskVariableValueNotEquals("old_appoint_assignee", null)).subProcessKey(subProcessKey)).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
            if (!historicTaskInstanceList.isEmpty()) {
                Object oldAppoint = ((HistoricTaskInstance)historicTaskInstanceList.get(0)).getTaskLocalVariables().get("old_appoint_assignee");
                if (oldAppoint instanceof Map && ((Map)oldAppoint).get(hisTaskList.get(0)) != null) {
                    return (String)((Map)oldAppoint).get(hisTaskList.get(0));
                }
                return (String)oldAppoint;
            }
        }
        return String.join((CharSequence)",", assignees);
    }

    private void subProcessReStartHandle(CommandContext commandContext) {
        if (this.taskRejectModel.isSubmit()) {
            ArrayList<String> targetIds = new ArrayList<String>(Arrays.asList(this.taskRejectModel.getTargetIds().split(",")));
            HashMap<String, String> subProcessRejectAppointMsg = new HashMap<String, String>();
            List list = this.historyService.createHistoricActivityInstanceQuery().activityType("startEvent").processInstanceId(this.taskRejectModel.getProcInsId()).list();
            HashMap<String, Integer> subProcessKeyMap = new HashMap<String, Integer>();
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (historicActivityInstance.getSubProcessKey() == null) continue;
                subProcessKeyMap.put(historicActivityInstance.getSubProcessKey(), historicActivityInstance.getCycleCount());
            }
            for (String targetId : targetIds) {
                if (!(this.taskRejectModel.getBm().getFlowElement(targetId) instanceof SubProcess)) continue;
                int cycleCount = 0;
                ArrayList<String> subProcessVariableList = new ArrayList<String>();
                for (String subProcessKey : subProcessKeyMap.keySet()) {
                    if (!subProcessKey.startsWith(targetId + ":")) continue;
                    if (cycleCount < (Integer)subProcessKeyMap.get(subProcessKey)) {
                        subProcessVariableList = new ArrayList();
                        cycleCount = (Integer)subProcessKeyMap.get(subProcessKey);
                    }
                    subProcessVariableList.add(subProcessKey.split(":")[1]);
                }
                subProcessRejectAppointMsg.put(targetId, String.join((CharSequence)",", subProcessVariableList));
            }
            commandContext.addAttribute("subProcessRejectAppointMsg", subProcessRejectAppointMsg);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void rejectTypeHandle() {
        String subProcessKey;
        String taskDefinitionKey;
        String processInstanceId;
        Set<Object> affectedTasks = new HashSet<String>();
        Set<Object> affectedUserTasks = new HashSet<String>();
        int newNum = 1;
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> runningActivityNodeIds = new HashSet<String>();
        if (this.taskRejectModel.getExecution() != null) {
            processInstanceId = this.taskRejectModel.getExecution().getProcessInstanceId();
            taskDefinitionKey = this.taskRejectModel.getExecution().getActivityId();
            if (taskDefinitionKey == null) {
                taskDefinitionKey = ((ExecutionEntity)this.taskRejectModel.getExecution().getExecutions().get(0)).getActivityId();
            }
            if (this.taskRejectModel.getJumpStartId() != null) {
                taskDefinitionKey = this.taskRejectModel.getJumpStartId();
            }
            Map map2 = this.runtimeService.getVariables(this.taskRejectModel.getExecution().getId());
            subProcessKey = (String)map2.get("sub_process_key");
        } else {
            processInstanceId = this.taskRejectModel.getTask().getProcessInstanceId();
            taskDefinitionKey = this.taskRejectModel.getTask().getTaskDefinitionKey();
            subProcessKey = this.taskRejectModel.getTask().getSubProcessKey();
        }
        BpmnModel bm = this.taskRejectModel.getBm();
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("callActivity").list();
        for (Object historicActivityInstance : list) {
            runningActivityNodeIds.add(historicActivityInstance.getActivityId());
        }
        HashSet<String> runningSubProcessNodeIds = new HashSet<String>();
        list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("subProcess").list();
        for (Object historicActivityInstance : list) {
            runningSubProcessNodeIds.add(historicActivityInstance.getActivityId());
        }
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        for (Object execution1 : executions) {
            Map map;
            if (((ExecutionEntity)execution1).getExecutions().size() != 0 || execution1.getActivityId() == null || (map = ((ExecutionEntity)execution1).getVariables()).get("sub_process_key") != null && (subProcessKey == null || !subProcessKey.equals(map.get("sub_process_key")))) continue;
            taskIds.add(execution1.getActivityId());
        }
        taskIds.addAll(runningActivityNodeIds);
        taskIds.addAll(runningSubProcessNodeIds);
        taskIds = new ArrayList(new HashSet(taskIds));
        if (taskIds.size() > 1) {
            Process process = (Process)bm.getProcesses().get(0);
            if (this.taskRejectModel.getFirst()) {
                newNum = 3;
                for (FlowElement flowElement : process.getFlowElements()) {
                    if (taskIds.contains(flowElement.getId())) {
                        if (flowElement instanceof UserTask) {
                            affectedUserTasks.add(flowElement.getId());
                        }
                        affectedTasks.add(flowElement.getId());
                        continue;
                    }
                    if (!(flowElement instanceof SubProcess)) continue;
                    for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                        if (!taskIds.contains(element.getId())) continue;
                        if (element instanceof UserTask) {
                            affectedUserTasks.add(element.getId());
                        }
                        affectedTasks.add(element.getId());
                    }
                }
            } else {
                if (this.taskRejectModel.getTargetIds().contains(",")) {
                    for (String targetNodeId : this.taskRejectModel.getTargetIds().split(",")) {
                        if (!HussarUtils.isEmpty((Object)bm.getFlowElement(targetNodeId))) continue;
                        throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
                    }
                } else if (HussarUtils.isEmpty((Object)bm.getFlowElement(this.taskRejectModel.getTargetIds()))) {
                    throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
                }
                boolean isFindTask = false;
                if (this.taskRejectModel.getTargetIds().contains(",")) {
                    for (String targetNodeId : this.taskRejectModel.getTargetIds().split(",")) {
                        Map<String, Set<String>> map = this.findAffectedTask(bm, targetNodeId, true, taskIds);
                        affectedTasks.addAll((Collection<Object>)map.get("affectedTasks"));
                        affectedUserTasks.addAll((Collection<Object>)map.get("affectedUserTasks"));
                    }
                } else {
                    Map<String, Set<String>> map = this.findAffectedTask(bm, this.taskRejectModel.getTargetIds(), true, taskIds);
                    affectedTasks = map.get("affectedTasks");
                    affectedUserTasks = map.get("affectedUserTasks");
                }
                if (affectedTasks.contains(taskDefinitionKey)) {
                    isFindTask = true;
                    affectedTasks.remove(taskDefinitionKey);
                }
                if (!affectedTasks.isEmpty()) {
                    newNum = 3;
                }
                if (!isFindTask) {
                    void var15_26;
                    HashSet hashSet = new HashSet();
                    if (!affectedTasks.isEmpty()) {
                        Set<Object> set = affectedTasks;
                    }
                    if (this.taskRejectModel.getTargetIds().contains(",")) {
                        for (String string : this.taskRejectModel.getTargetIds().split(",")) {
                            Map<String, Set<String>> map = this.findAffectedTask(bm, string, false, taskIds);
                            affectedTasks.addAll((Collection<Object>)map.get("affectedTasks"));
                            affectedUserTasks.addAll((Collection<Object>)map.get("affectedUserTasks"));
                        }
                    } else {
                        Map<String, Set<String>> map5 = this.findAffectedTask(bm, this.taskRejectModel.getTargetIds(), false, taskIds);
                        affectedTasks = map5.get("affectedTasks");
                        affectedUserTasks = map5.get("affectedUserTasks");
                    }
                    if (affectedTasks.contains(taskDefinitionKey)) {
                        isFindTask = true;
                        affectedTasks.remove(taskDefinitionKey);
                    }
                    if (!affectedTasks.isEmpty()) {
                        newNum = 3;
                    }
                    if (!isFindTask && affectedTasks.size() + var15_26.size() > 0) {
                        throw new PublicClientException(this.bpmConstantProperties.getFreeJumpCannotToAnotherBranch());
                    }
                }
            }
        } else {
            affectedTasks = new HashSet(taskIds);
        }
        HashSet<String> affectedCallActivity = new HashSet<String>();
        for (String string : runningActivityNodeIds) {
            if (!affectedTasks.contains(string)) continue;
            affectedCallActivity.add(string);
        }
        HashSet<String> affectedSubProcess = new HashSet<String>();
        for (String activityId : runningSubProcessNodeIds) {
            if (!affectedTasks.contains(activityId)) continue;
            affectedSubProcess.add(activityId);
        }
        affectedUserTasks.addAll(affectedCallActivity);
        affectedUserTasks.addAll(affectedSubProcess);
        HashMap hashMap = new HashMap();
        for (Execution execution1 : executions) {
            if (((ExecutionEntity)execution1).isScope() || execution1.getActivityId() == null || affectedUserTasks.contains(execution1.getActivityId()) || !affectedTasks.contains(execution1.getActivityId())) continue;
            if (hashMap.get(execution1.getActivityId()) != null) {
                List affectedExecutionList = (List)hashMap.get(execution1.getActivityId());
                affectedExecutionList.add(this.runtimeService.getVariablesLocal(execution1.getId()));
                continue;
            }
            ArrayList<Map> affectedExecutionList = new ArrayList<Map>();
            affectedExecutionList.add(this.runtimeService.getVariablesLocal(execution1.getId()));
            hashMap.put(execution1.getActivityId(), affectedExecutionList);
        }
        Set cancelTaskDefKeys = this.taskRejectModel.getCancelTaskDefKeys();
        for (List variables : hashMap.values()) {
            for (Map map : variables) {
                RevokeFlagUtil.getRevokeFlagTask(map, (Set<String>)cancelTaskDefKeys);
            }
        }
        affectedTasks.add(taskDefinitionKey);
        affectedUserTasks.remove(taskDefinitionKey);
        String affectedUserTaskStr = taskDefinitionKey;
        if (!affectedUserTasks.isEmpty()) {
            StringBuilder affectedUserTaskSb = new StringBuilder(taskDefinitionKey);
            for (String string : affectedUserTasks) {
                affectedUserTaskSb.append(",").append(string);
            }
            affectedUserTaskStr = affectedUserTaskSb.toString();
        }
        if (newNum == 1) {
            void var19_61;
            ExecutionEntity executionEntity = this.taskRejectModel.getExecution();
            if (executionEntity == null) {
                executionEntity = ((TaskEntity)this.taskRejectModel.getTask()).getExecution();
            }
            if (executionEntity.getActivity() == null) {
                void var20_72;
                ExecutionEntity executionEntity2 = executionEntity;
                while (var20_72.getActivity() == null && var20_72.getExecutions() != null) {
                    ExecutionEntity executionEntity3 = (ExecutionEntity)var20_72.getExecutions().get(0);
                }
                ActivityBehavior activityBehavior = var20_72.getActivity().getActivityBehavior();
            } else {
                ActivityBehavior activityBehavior = executionEntity.getActivity().getActivityBehavior();
            }
            if (var19_61 instanceof ParallelMultiInstanceBehavior || var19_61 instanceof SequentialMultiInstanceBehavior) {
                newNum = 2;
            }
        }
        if (newNum != 3) {
            for (String string : affectedTasks) {
                if (!runningActivityNodeIds.contains(string) && !runningSubProcessNodeIds.contains(string)) continue;
                Map map = this.taskRejectModel.getMap();
                map.put("affectedTasks", new ArrayList<Object>(affectedTasks));
                map.put("runningSubProcessNodeIds", runningSubProcessNodeIds);
                map.put("runningActivitiNodeIds", runningActivityNodeIds);
                this.taskRejectModel.setMap(map);
                break;
            }
        }
        this.taskRejectModel.setJumpType(newNum);
        if (newNum == 3) {
            Map map6 = this.taskRejectModel.getMap();
            map6.put("affectedTasks", new ArrayList<Object>(affectedTasks));
            map6.put("reject_from", affectedUserTaskStr);
            map6.put("reject_execution", hashMap);
            map6.put("runningSubProcessNodeIds", runningSubProcessNodeIds);
            map6.put("runningActivitiNodeIds", runningActivityNodeIds);
            map6.put("isSubmit", this.taskRejectModel.isSubmit());
            this.taskRejectModel.setMap(map6);
            if ("freejump".equals(this.taskRejectModel.getType())) {
                ArrayList<String> arrayList = new ArrayList<String>(affectedSubProcess);
                for (String string : affectedSubProcess) {
                    SubProcess subProcess = (SubProcess)bm.getMainProcess().getFlowElement(string);
                    for (FlowElement flowElement : subProcess.getFlowElements()) {
                        if (!(flowElement instanceof UserTask)) continue;
                        arrayList.add(flowElement.getId());
                    }
                }
                String string = this.taskRejectModel.getTask().getProcessInstanceId();
                if (string.equals(this.taskRejectModel.getProcInsId())) {
                    HashSet hashSet = new HashSet(arrayList);
                    String affectedTaskIds = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(this.taskRejectModel.getTask().getProcessInstanceId())).list().stream().filter(o -> hashSet.contains(o.getTaskDefinitionKey())).map(TaskInfo::getId).collect(Collectors.joining(","));
                    this.taskRejectModel.setAllAffectedTaskIds(affectedTaskIds);
                }
            }
        }
    }

    private Map<String, Set<String>> findAffectedTask(BpmnModel bm, String nodeId, boolean isGoToNext, List<String> taskIds) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        HashSet<String> affectedTasks = new HashSet<String>();
        HashSet<String> affectedUserTasks = new HashSet<String>();
        flowElements.add(bm.getFlowElement(nodeId));
        HashSet<FlowElement> list = new HashSet<FlowElement>();
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (!list.add(flowElement)) continue;
            if (taskIds.contains(flowElement.getId())) {
                affectedTasks.add(flowElement.getId());
                if (flowElement instanceof UserTask) {
                    affectedUserTasks.add(flowElement.getId());
                    continue;
                }
            }
            if (flowElement instanceof EndEvent || flowElement instanceof StartEvent || !(flowElement instanceof FlowNode)) continue;
            if (isGoToNext) {
                for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getOutgoingFlows()) {
                    flowElements.add(bm.getFlowElement(sequenceFlow.getTargetRef()));
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getIncomingFlows()) {
                flowElements.add(bm.getFlowElement(sequenceFlow.getSourceRef()));
            }
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("affectedTasks", affectedTasks);
        map.put("affectedUserTasks", affectedUserTasks);
        return map;
    }

    private void rejectCallActivityHandle(CommandContext commandContext) {
        String processInsId = null;
        processInsId = this.taskRejectModel.getExecution() != null ? this.taskRejectModel.getExecution().getProcessInstanceId() : this.taskRejectModel.getTask().getProcessInstanceId();
        List nodeIds = (List)this.taskRejectModel.getMap().get("affectedTasks");
        if (HussarUtils.isNotEmpty((Object)nodeIds)) {
            Set callActivitiNodeIds = (Set)this.taskRejectModel.getMap().get("runningActivitiNodeIds");
            ArrayList<String> ids = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)callActivitiNodeIds)) {
                for (Object nodeId : nodeIds) {
                    if (!callActivitiNodeIds.remove(nodeId)) continue;
                    ids.add((String)nodeId);
                }
            }
            if (HussarUtils.isNotEmpty(ids)) {
                List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).unfinished().activityType("callActivity").list();
                for (HistoricActivityInstance historicActivityInstance : list) {
                    if (!ids.contains(historicActivityInstance.getActivityId())) continue;
                    TaskEngineServiceImpl.getCallRejectList().add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                    new ProcessEndCmd(this.taskRejectModel.getTaskId(), this.taskRejectModel.getUserId(), this.taskRejectModel.getMandator(), this.taskRejectModel.getComment(), historicActivityInstance.getCalledProcessInstanceId(), this.taskRejectModel.getType(), false).execute(commandContext);
                    TaskEngineServiceImpl.getCallRejectList().remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                }
            }
            Set subProcessNodeIds = (Set)this.taskRejectModel.getMap().get("runningSubProcessNodeIds");
            ids = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)subProcessNodeIds)) {
                for (String nodeId : nodeIds) {
                    if (!subProcessNodeIds.remove(nodeId)) continue;
                    ids.add(nodeId);
                }
            }
            if (HussarUtils.isNotEmpty(ids)) {
                List executions = this.runtimeService.createExecutionQuery().variableValueNotEquals("sub_process_key", null).processInstanceId(processInsId).list();
                for (Execution execution : executions) {
                    String subProcessKey = (String)((ExecutionEntity)execution).getVariableLocal("sub_process_key");
                    String nodeId = subProcessKey.split(":")[0];
                    if (!ids.contains(nodeId)) continue;
                    TaskEngineServiceImpl.getSubProcessRejectList().add(processInsId + nodeId);
                    new SubProcessEndCmd(this.taskRejectModel.getTaskId(), this.taskRejectModel.getBm(), this.taskRejectModel.getUserId(), this.taskRejectModel.getMandator(), this.taskRejectModel.getComment(), processInsId, subProcessKey, this.taskRejectModel.getType()).execute(commandContext);
                    TaskEngineServiceImpl.getSubProcessRejectList().remove(processInsId + nodeId);
                }
            }
        }
    }

    private void rejectNodeSendUserHandle(CommandContext commandContext) {
        if ("freejump".equals(this.taskRejectModel.getType())) {
            this.taskRejectModel.getMap().put("sendUser", HussarUtils.isEmpty((Object)this.taskRejectModel.getMandator()) ? this.taskRejectModel.getUserId() : this.taskRejectModel.getMandator());
        } else {
            boolean isInnerSubProcess = this.taskRejectModel.getBm().getMainProcess().getFlowElement(this.taskRejectModel.getTargetIds().split(",")[0]) == null;
            ArrayList<String> targetIds = new ArrayList<String>(Arrays.asList(this.taskRejectModel.getTargetIds().split(",")));
            List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(this.taskRejectModel.getProcInsId())).finished().subProcessKey(isInnerSubProcess ? this.taskRejectModel.getSubProcessKey() : null)).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).list();
            HashMap<String, String> completeFromSendUserMap = new HashMap<String, String>();
            HashMap<String, String> targetNodeMap = new HashMap<String, String>();
            ArrayList<String> completeFromIds = new ArrayList<String>();
            HashMap<String, String> sendUserMap = new HashMap<String, String>();
            for (String targetId : targetIds) {
                String completeFrom = null;
                for (HistoricTaskInstance historicTaskInstance : list) {
                    if (!targetId.equals(historicTaskInstance.getTaskDefinitionKey())) continue;
                    completeFrom = (String)historicTaskInstance.getTaskLocalVariables().get("complete_from");
                    if (completeFrom != null) break;
                    completeFrom = (String)historicTaskInstance.getTaskLocalVariables().get("call_complete_from");
                    break;
                }
                if (completeFrom == null) {
                    FlowElement flowElement = this.taskRejectModel.getBm().getFlowElement(targetId);
                    if (flowElement instanceof SubProcess) {
                        String target = null;
                        for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                            if (!(element instanceof StartEvent)) continue;
                            target = ((SequenceFlow)((StartEvent)element).getOutgoingFlows().get(0)).getTargetRef();
                            break;
                        }
                        for (HistoricTaskInstance historicTaskInstance : list) {
                            if (!target.equals(historicTaskInstance.getTaskDefinitionKey())) continue;
                            completeFrom = (String)historicTaskInstance.getTaskLocalVariables().get("complete_from");
                            if (completeFrom != null) break;
                            completeFrom = (String)historicTaskInstance.getTaskLocalVariables().get("call_complete_from");
                            break;
                        }
                        targetNodeMap.put(targetId, completeFrom);
                        completeFromIds.add(completeFrom);
                        continue;
                    }
                    sendUserMap.put(targetId, this.taskRejectModel.getStartUserId());
                    continue;
                }
                targetNodeMap.put(targetId, completeFrom);
                completeFromIds.add(completeFrom);
            }
            HashMap<String, String> completeFromSendUserOrganMap = new HashMap<String, String>();
            HashMap sendUserOrganMap = new HashMap();
            for (String targetId : completeFromIds) {
                String taskSourceFlag;
                String sendUser = null;
                String organId = null;
                if (this.taskRejectModel.getBm().getFlowElement(targetId) instanceof SubProcess) {
                    for (HistoricTaskInstance historicTaskInstance : list) {
                        if (historicTaskInstance.getSubProcessKey() == null || !historicTaskInstance.getSubProcessKey().startsWith(targetId + ":") || !"complete".equals(taskSourceFlag = (String)historicTaskInstance.getTaskLocalVariables().get("taskSourceFlag")) && !"complete_leap".equals(taskSourceFlag) && !"freejump".equals(taskSourceFlag)) continue;
                        sendUser = historicTaskInstance.getAssignee();
                        organId = historicTaskInstance.getOrganId();
                        break;
                    }
                } else {
                    for (HistoricTaskInstance historicTaskInstance : list) {
                        if (!targetId.equals(historicTaskInstance.getTaskDefinitionKey()) || !"complete".equals(taskSourceFlag = (String)historicTaskInstance.getTaskLocalVariables().get("taskSourceFlag")) && !"complete_leap".equals(taskSourceFlag) && !"freejump".equals(taskSourceFlag)) continue;
                        sendUser = historicTaskInstance.getAssignee();
                        organId = historicTaskInstance.getOrganId();
                        break;
                    }
                }
                completeFromSendUserMap.put(targetId, sendUser);
                completeFromSendUserOrganMap.put(targetId, organId);
            }
            for (String targetNodeId : targetNodeMap.keySet()) {
                sendUserMap.put(targetNodeId, (String)completeFromSendUserMap.get(targetNodeMap.get(targetNodeId)));
                sendUserOrganMap.put(targetNodeId, completeFromSendUserOrganMap.get(targetNodeMap.get(targetNodeId)));
            }
            commandContext.addAttribute("sendUserMap", sendUserMap);
            commandContext.addAttribute("sendUserOrganMap", sendUserOrganMap);
        }
    }
}

