/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;

public class TaskCompleteCmd
implements Command<TaskEntity> {
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ITaskEngineService iTaskEngineService = (ITaskEngineService)SpringContextHolder.getBean(ITaskEngineService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);
    private String taskId;
    private String userId;
    private String mandator;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String comment;
    private IAssigneeChooseService iAssigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);

    public TaskEntity execute(CommandContext commandContext) {
        TaskEntityManager taskEntityManager;
        List childTasks;
        if (this.variables.containsKey("bpm_next_node")) {
            commandContext.addAttribute("bpm_next_node", this.variables.get("bpm_next_node"));
            this.variables.remove("bpm_next_node");
        }
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        String organId = null;
        if (this.mandator == null) {
            List identityLinkEntities = task.getIdentityLinkType("candidate");
            commandContext.addAttribute("taskId", (Object)task.getId());
            commandContext.addAttribute("sendUser", (Object)this.userId);
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                if (!identityLinkEntity.getUserId().equals(this.userId)) continue;
                organId = identityLinkEntity.getOrganId();
            }
            commandContext.addAttribute("sendUserOrganId", (Object)organId);
        } else {
            organId = AnalyticalModelUtil.getOrganId(this.userId, task.getTenantId());
            commandContext.addAttribute("sendUserOrganId", (Object)organId);
        }
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            TaskComment taskComment = new TaskComment();
            taskComment.setUserId(this.userId);
            taskComment.setType("complete");
            taskComment.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            taskComment.setTaskId(this.taskId);
            taskComment.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > 2003) {
                eventMessage = eventMessage.substring(0, 2000) + "...";
            }
            taskComment.setMessage(eventMessage);
            taskComment.setFullMsg(this.comment.getBytes(StandardCharsets.UTF_8));
            ArrayList<String> userIds = new ArrayList<String>();
            userIds.add(this.userId);
            Map deptParams = this.iAssigneeChooseService.getDeptParamsByUserId(this.userId, task.getTenantId());
            taskComment.setUserName((String)deptParams.get("userName"));
            taskComment.setDeptName((String)deptParams.get("organFullName"));
            if (ToolUtil.isNotEmpty(deptParams.get("deptId"))) {
                taskComment.setDeptId(deptParams.get("deptId").toString());
            }
            taskComment.insert();
        }
        this.variables.put("sendUser", HussarUtils.isEmpty((Object)this.mandator) ? this.userId : this.mandator);
        this.variables.put("bpm_submit_source", task.getTaskDefinitionKey());
        task.setVariableLocal("taskSourceFlag", (Object)"complete", true);
        task.getExecution().setVariableLocal("all_prev_node", (Object)("'" + task.getTaskDefinitionKey() + "'"));
        Map<String, Object> appointAssignee = new HashMap();
        if (this.variables.get("appoint_assignee") != null) {
            appointAssignee = (Map)this.variables.get("appoint_assignee");
        }
        if (HussarUtils.isEmpty(appointAssignee.get("static_appoint_assignee"))) {
            appointAssignee.put("static_appoint_assignee", null);
            this.variables.put("appoint_assignee", appointAssignee);
        }
        if (!(childTasks = (taskEntityManager = commandContext.getTaskEntityManager()).findTasksByParentTaskId(this.taskId)).isEmpty()) {
            ArrayList<String> childTaskIds = new ArrayList<String>();
            childTasks.forEach(childTask -> {
                taskEntityManager.deleteTask((TaskEntity)childTask, null, true);
                childTaskIds.add(childTask.getId());
            });
            if (this.dataPushService.isDataPush()) {
                this.dataPushService.deleteMultiTask(childTaskIds);
            }
        }
        if (task.getDelegationState() != null) {
            task.resolve();
        }
        task.fireEvent("beforeComplete");
        if (task.getExecutionId() != null) {
            task.setExecutionVariables(this.variables);
        } else {
            task.setVariables(this.variables);
        }
        ParamModel paramModel = this.getParamModel(task, this.variables);
        Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
        task.complete(this.variables, false, this.mandator);
        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(this.taskId);
        }
        return task;
    }

    public TaskCompleteCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, Map<String, Object> variables) {
        this(taskId, userId);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public TaskCompleteCmd(String taskId, String userId, String comment) {
        this(taskId, userId);
        this.comment = comment;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, String comment, Map<String, Object> variables) {
        this(taskId, userId, comment);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public ParamModel getParamModel(TaskEntity task, Map<String, Object> variables) {
        ParamModel paramModel = new ParamModel();
        paramModel.setCompleteType("complete");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        BpmResponseResult result = this.iTaskEngineService.queryNextNode(null, this.taskId, false, false, null);
        JSONArray jsonArray = result.getResult();
        String nextNodeId = "";
        HashMap<String, String> activityTypeMap = new HashMap<String, String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            nextNodeId = nextNodeId + "," + jsonObject.get((Object)"id").toString();
            activityTypeMap.put(jsonObject.get((Object)"id").toString(), jsonObject.get((Object)"type").toString());
        }
        nextNodeId = nextNodeId.substring(1);
        paramModel.setNextNodeId(nextNodeId);
        paramModel.setNextActivityType(activityTypeMap);
        List<String> nextNodeIdList = Arrays.asList(nextNodeId.split(","));
        HashMap<String, String> assigneeMap = new HashMap<String, String>();
        for (String nextNode : nextNodeIdList) {
            BpmResponseResult result1 = this.iTaskEngineService.queryNextAssigneeByTaskIdAndNodeId(this.taskId, nextNode, "0", null);
            JSONArray assigneeArray = result1.getResult();
            String nextAppointAssignee = "";
            for (int i = 0; i < assigneeArray.size(); ++i) {
                JSONObject jsonObject = assigneeArray.getJSONObject(i);
                nextAppointAssignee = nextAppointAssignee + "," + jsonObject.get((Object)"id").toString();
            }
            if (HussarUtils.isNotEmpty((Object)nextAppointAssignee)) {
                nextAppointAssignee = nextAppointAssignee.substring(1);
            }
            assigneeMap.put(nextNode, nextAppointAssignee);
        }
        paramModel.setNextNodeAssignee(assigneeMap);
        paramModel.setHandler(this.userId);
        paramModel.setLastNodeId(task.getTaskDefinitionKey());
        paramModel.setLastTaskId(task.getId());
        paramModel.setLastNodeName(task.getName());
        paramModel.setLastCompleteType("complete");
        paramModel.setLastNodeHandler(this.userId);
        paramModel.setSendUser(this.userId);
        paramModel.setCreateReason("completeCreate");
        return paramModel;
    }
}

