/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bsp.function.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.function.dto.AddFunctionDto;
import com.jxdinfo.hussar.workflow.engine.bsp.function.dto.EditFunctionDto;
import com.jxdinfo.hussar.workflow.engine.bsp.function.model.SysActFunction;
import com.jxdinfo.hussar.workflow.engine.bsp.function.model.SysActFunctionParm;
import com.jxdinfo.hussar.workflow.engine.bsp.function.service.ISysActFunctionParmService;
import com.jxdinfo.hussar.workflow.engine.bsp.function.service.ISysActFunctionService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u51fd\u6570\u7ba1\u7406"})
@RequestMapping(value={"/bpm/function"})
@HussarTokenDs
public class SysActFunctionController
extends HussarBaseController<SysActFunction, ISysActFunctionService> {
    @Autowired
    private ISysActFunctionService sysActFunctionService;
    @Autowired
    private ISysActFunctionParmService sysActFunctionParmService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u51fd\u6570", notes="\u65b0\u589e\u51fd\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="map", value="\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u51fd\u6570\u7ba1\u7406", eventDesc="\u65b0\u589e\u51fd\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse add(@RequestBody AddFunctionDto addFunctionDto) {
        return this.sysActFunctionService.add(addFunctionDto);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u51fd\u6570", notes="\u4fee\u6539\u51fd\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="map", value="\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u51fd\u6570\u7ba1\u7406", eventDesc="\u4fee\u6539\u51fd\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse update(@RequestBody EditFunctionDto editFunctionDto) {
        if (HussarUtils.isEmpty((Object)editFunctionDto.getId())) {
            throw new PublicClientException(BpmEnum.ERROR_UPDATE.getMessage());
        }
        return this.sysActFunctionService.update(editFunctionDto);
    }

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u83b7\u53d6\u51fd\u6570\u5217\u8868", notes="\u83b7\u53d6\u51fd\u6570\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="functionName", value="\u51fd\u6570\u540d", required=false, paramType="query"), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u6761\u6570", required=false, paramType="query")})
    @AuditLog(moduleName="\u51fd\u6570\u7ba1\u7406", eventDesc="\u83b7\u53d6\u51fd\u6570\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<SysActFunction>> getList(@RequestParam(required=false, defaultValue="") String functionName, @RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="100") int size) {
        Page pages = new Page(page == 0 ? 1L : (long)page, size == 0 ? 10L : (long)size);
        return this.sysActFunctionService.queryFunctionList(pages, functionName);
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u83b7\u53d6\u51fd\u6570\u8be6\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u51fd\u6570\u8be6\u7ec6\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="functionId", value="\u51fd\u6570id", required=true, paramType="query")})
    @AuditLog(moduleName="\u51fd\u6570\u7ba1\u7406", eventDesc="\u83b7\u53d6\u51fd\u6570\u8be6\u7ec6\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysActFunctionParm>> detail(@RequestParam Long functionId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)functionId)) {
            wrapper.eq(SysActFunctionParm::getFunctionId, (Object)functionId);
        }
        return ApiResponse.success((Object)this.sysActFunctionParmService.list((Wrapper)wrapper));
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u51fd\u6570", notes="\u5220\u9664\u51fd\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="functionId", value="\u51fd\u6570id", required=true, paramType="query")})
    @AuditLog(moduleName="\u51fd\u6570\u7ba1\u7406", eventDesc="\u5220\u9664\u51fd\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delete(@RequestBody Long functionId) {
        return this.sysActFunctionService.delete(functionId);
    }

    @PostMapping(value={"/importFunction"})
    @ApiOperation(value="\u5bfc\u5165\u51fd\u6570", notes="\u5bfc\u5165\u51fd\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6", required=true, paramType="query")})
    @AuditLog(moduleName="\u51fd\u6570\u7ba1\u7406", eventDesc="\u5bfc\u5165\u51fd\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse importFunction(MultipartFile file) {
        return this.sysActFunctionService.importFunction(file);
    }

    @PostMapping(value={"/exportFunction"})
    @ApiOperation(value="\u5bfc\u51fa\u51fd\u6570", notes="\u5bfc\u51fa\u51fd\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="functionId", value="\u51fd\u6570id", required=true, paramType="query"), @ApiImplicitParam(name="response", value="\u54cd\u5e94", required=true, paramType="query")})
    @AuditLog(moduleName="\u51fd\u6570\u7ba1\u7406", eventDesc="\u5bfc\u51fa\u51fd\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public void exportFunction(@RequestBody String id, HttpServletResponse response) {
        this.sysActFunctionService.exportFunction(id, response);
    }
}

