/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.dao.ActivityRedisTimerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util.TimeOutHandleUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.workflow.engine.core.util.BpmTenantInfoUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class TimeOutSetListUtil {
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Resource
    private TaskService taskService;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    private static Logger logger = LogManager.getLogger(TimeOutSetListUtil.class);
    @Resource
    private ActivityRedisTimerMapper activityRedisTimerMapper;

    @HussarDs(value="#connName")
    public void setList(SysUser sysUser, String connName) {
        try {
            if (TimeOutHandleUtil.useRedis) {
                try {
                    List timeOutModels = this.activityRedisTimerMapper.selectList(null);
                    for (TimeOutModel timeOutModel : timeOutModels) {
                        timeOutModel.setDataSourceName(connName);
                        this.redisTemplate.opsForValue().set((Object)("bpm_activity:timer:task_Message:" + timeOutModel.getId()), (Object)JSON.toJSONString((Object)timeOutModel));
                        Set oldTask = this.redisTemplate.opsForZSet().rangeByScore((Object)"bpm_activity:timer:score_list", (double)timeOutModel.getDueTime().getTime(), (double)timeOutModel.getDueTime().getTime());
                        if (HussarUtils.isEmpty((Object)oldTask)) {
                            this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)timeOutModel.getId(), (double)timeOutModel.getDueTime().getTime());
                            continue;
                        }
                        this.redisTemplate.opsForZSet().add((Object)"bpm_activity:timer:score_list", (Object)((String)new ArrayList(oldTask).get(0) + "," + timeOutModel.getId()), (double)timeOutModel.getDueTime().getTime());
                    }
                    this.activityRedisTimerMapper.delete(null);
                }
                catch (Exception e) {
                    logger.error("redis\u50a8\u5b58\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25{}", (Object)e.toString());
                }
                return;
            }
            List timeOutModels = this.activityRedisTimerMapper.selectList(null);
            for (TimeOutModel timeOutModel : timeOutModels) {
                timeOutModel.setDataSourceName(connName);
                HussarCacheUtil.put((String)"bpm_timer_activity", (Object)String.valueOf(timeOutModel.getId()), (Object)timeOutModel);
                Long time = timeOutModel.getDueTime().getTime();
                TimeOutHandleUtil.timeOutList.add(time);
                TimeOutHandleUtil.timeOutMap.put(time, TimeOutHandleUtil.timeOutMap.get(time) == null ? String.valueOf(timeOutModel.getId()) : TimeOutHandleUtil.timeOutMap.get(time) + "," + timeOutModel.getId());
            }
        }
        catch (Exception e) {
            String prefix = sysUser.getUserAccount() == null ? "" : "\u79df\u6237" + sysUser.getUserAccount();
            logger.error("{}\u79df\u6237\u5e93\u83b7\u53d6\u8d85\u65f6\u4fe1\u606f\u51fa\u9519\uff1a{}", new Object[]{prefix, e.getMessage()});
        }
    }

    @HussarDs(value="#connName")
    public void timeOutTaskHandler(TimeOutModel timeOutModel, boolean isDelTimeOutTableMessage, String connName) {
        if (!BpmTenantInfoUtils.isMultiTenant()) {
            if (isDelTimeOutTableMessage) {
                this.activityRedisTimerMapper.deleteById(timeOutModel.getId());
            }
            this.handleTimeOutModel(timeOutModel);
        } else {
            try {
                if (!this.sysUserService.testConn(timeOutModel.getDataSourceName())) {
                    logger.error("\u8fde\u63a5\u5bf9\u5e94\u79df\u6237\u5e93\u5931\u8d25\uff0cdataSourceName:{}", (Object)connName);
                    return;
                }
                if (isDelTimeOutTableMessage) {
                    this.activityRedisTimerMapper.deleteById(timeOutModel.getId());
                }
                this.handleTimeOutModel(timeOutModel);
            }
            catch (Exception e) {
                logger.error("\u8fde\u63a5\u5207\u6362\u81f3\u8d85\u65f6\u4efb\u52a1\u6240\u5728\u79df\u6237\u5e93\u5931\u8d25{}", (Object)e.getMessage());
            }
        }
    }

    private void handleTimeOutModel(TimeOutModel timeOutModel) {
        if ("autoHandle".equals(timeOutModel.getTimeOutType())) {
            String assignee = "";
            if (HussarUtils.isNotEmpty((Object)timeOutModel.getAssignee())) {
                String[] assignees;
                for (String user : assignees = timeOutModel.getAssignee().split(",")) {
                    if ("".equals(user)) continue;
                    assignee = user;
                    break;
                }
            }
            try {
                this.taskEngineService.completeTask(String.valueOf(timeOutModel.getId()), assignee, null, true);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u529e\u7406\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("urging".equals(timeOutModel.getTimeOutType())) {
            String userId = null;
            if (HussarUtils.isNotEmpty((Object)timeOutModel.getMap())) {
                Map map = (Map)JSON.toJavaObject((JSON)JSON.parseObject((String)timeOutModel.getMap()), Map.class);
                userId = (String)map.get("sendUser");
            }
            try {
                this.iSysActUrgeTaskService.urgeTaskByTaskId(String.valueOf(timeOutModel.getId()), userId);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u50ac\u529e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("global-urging".equals(timeOutModel.getTimeOutType())) {
            try {
                String processInsId = String.valueOf(timeOutModel.getId());
                String assignee = timeOutModel.getAssignee();
                this.iSysActUrgeTaskService.urgeTask(processInsId, assignee);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u6d41\u7a0b\u50ac\u529e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("global-terminate".equals(timeOutModel.getTimeOutType())) {
            try {
                String assignee;
                Task runningTask;
                String taskId;
                Set<String> userSet;
                String processInsId = String.valueOf(timeOutModel.getId());
                List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).processInstanceId(processInsId)).list();
                if (!tasks.isEmpty() && !(userSet = this.getAssigneeByTaskId(taskId = (runningTask = (Task)tasks.get(0)).getId())).isEmpty() && HussarUtils.isNotEmpty((Object)(assignee = userSet.iterator().next()))) {
                    this.instanceEngineService.endProcess(taskId, assignee, "");
                }
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u6d41\u7a0b\u7ec8\u7ed3\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else if ("receiveTask-autoHandle".equals(timeOutModel.getTimeOutType())) {
            try {
                String executionId = String.valueOf(timeOutModel.getId());
                this.taskEngineService.receiveTaskSignal(executionId, null);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u81ea\u52a8\u529e\u7406\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        } else {
            String outInterface = timeOutModel.getTimeOutType();
            boolean isProcessTimeOut = false;
            if (outInterface.startsWith("global-")) {
                isProcessTimeOut = true;
                outInterface = outInterface.replace("global-", "");
            }
            if (outInterface.startsWith("receiveTask-")) {
                isProcessTimeOut = true;
                outInterface = outInterface.replace("receiveTask-", "");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (!isProcessTimeOut) {
                map.put("taskId", timeOutModel.getId());
                map.put("assignee", timeOutModel.getAssignee());
                map.put("startTime", sdf.format(timeOutModel.getCreateTime()));
            }
            map.put("dueTime", sdf.format(timeOutModel.getDueTime()));
            if (HussarUtils.isNotEmpty((Object)timeOutModel.getMap())) {
                map.putAll((Map)JSON.toJavaObject((JSON)JSON.parseObject((String)timeOutModel.getMap()), Map.class));
            }
            try {
                HttpRequestUtil.getRequestResult(outInterface, map);
            }
            catch (Exception e) {
                logger.error("\u8d85\u65f6\u4efb\u52a1\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksType(taskId);
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }
}

