/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class UnPreemptTaskCmd
extends CommonPrepareCmd {
    protected static DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);
    protected static TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);

    @Override
    protected void execute(CommandContext commandContext, TaskEntity task) {
        task.setPreempted(null);
        List identityLinkEntityList = task.getIdentityLinks();
        Set users = identityLinkEntityList.stream().filter(identityLink -> !identityLink.isEntrust() && "candidate".equals(identityLink.getType())).map(IdentityLinkEntity::getUserId).collect(Collectors.toSet());
        if (!users.isEmpty()) {
            taskEngineMapper.unPreemptDeduplication(users, this.taskId);
        }
        if (identityLinkEntityList.size() > 1) {
            HashSet<String> addUsers = new HashSet<String>();
            ArrayList addUserMaps = new ArrayList();
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntityList) {
                if (!"preempted".equals(identityLinkEntity.getType()) || !identityLinkEntity.isEntrust() && (identityLinkEntity.isEntrust() || users.contains(identityLinkEntity.getUserId()))) continue;
                if (!identityLinkEntity.getUserId().equals(this.userId)) {
                    addUsers.add(identityLinkEntity.getUserId());
                }
                HashMap<String, String> addUserMap = new HashMap<String, String>();
                addUserMap.put("userId", identityLinkEntity.getUserId());
                if (identityLinkEntity.isEntrust()) {
                    addUserMap.put("mandator", identityLinkEntity.getMandator());
                    addUserMap.put("taskState", identityLinkEntity.getTaskState());
                }
                addUserMaps.add(addUserMap);
            }
            if (dataPushService.isDataPush()) {
                String addUser = String.join((CharSequence)",", addUsers);
                dataPushService.entrustDataPush(new DataPush().setUserId(addUser.length() != 0 ? addUser : null).setUserMaps(addUserMaps).setTaskId(this.taskId));
            }
        }
        taskEngineMapper.unPreemptTask(this.taskId);
    }

    @Override
    protected void taskAuthentication(TaskEntity task) {
        super.taskAuthentication(task);
        if (!task.typeOfPreempted()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotPreempt());
        }
    }

    public UnPreemptTaskCmd(String taskId, String userId) {
        super(taskId, userId);
    }

    public UnPreemptTaskCmd(String taskId, String userId, String mandator) {
        super(taskId, userId, mandator);
    }

    public UnPreemptTaskCmd(String taskId, String userId, String mandator, boolean isAuditAuthority) {
        super(taskId, userId, mandator, isAuditAuthority);
    }
}

