/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowListener;
import com.jxdinfo.hussar.workflow.outside.listener.service.WorkflowListenerService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.springframework.stereotype.Component;

@Component(value="DefaultCloudExecutionListener")
public class DefaultExecutionListener
implements ExecutionListener {
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    public void notify(DelegateExecution delegateExecution) throws Exception {
        String beanId = (String)delegateExecution.getVariableLocal("beanId");
        delegateExecution.removeVariableLocal("beanId");
        String processDefinitionId = delegateExecution.getProcessDefinitionId();
        String processDefinitionKey = processDefinitionId.split(":")[0];
        String serviceName = String.valueOf(modelService.getServiceName(processDefinitionKey));
        HashMap<String, String> map = new HashMap<String, String>();
        ExecutionEntity entity = (ExecutionEntity)delegateExecution;
        map.put("nodeId", delegateExecution.getCurrentActivityId());
        map.put("nodeName", delegateExecution.getCurrentActivityName());
        map.put("businessId", delegateExecution.getProcessBusinessKey());
        map.put("processInsId", delegateExecution.getProcessInstanceId());
        map.put("processDefinitionId", delegateExecution.getProcessDefinitionId());
        map.put("processKey", entity.getProcessDefinitionKey());
        map.put("tenantId", delegateExecution.getTenantId());
        for (IdentityLinkEntity identityLinkEntity : ((ExecutionEntity)delegateExecution).getProcessInstance().getIdentityLinks()) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            map.put("starter", identityLinkEntity.getUserId());
            break;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("createTime", simpleDateFormat.format(new Date()));
        map.put("processName", ((ExecutionEntity)delegateExecution).getProcessDefinition().getName());
        if (beanId != null) {
            try {
                if (!this.lcdpBpmProperties.isStartAlone()) {
                    HussarWorkflowListener workflowListenerVisitor = (HussarWorkflowListener)SpringContextHolder.getBean((String)beanId);
                    workflowListenerVisitor.notify(map);
                    return;
                }
                map.put("beanId", beanId);
                WorkflowListenerService workflowListenerService = (WorkflowListenerService)SpringContextHolder.getBean(WorkflowListenerService.class);
                workflowListenerService.executeListener(map, serviceName);
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorExecutionListener());
            }
        }
    }
}

