/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.task.Task;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"springContextHolder"})
@Component
public class AnalyticalModelUtil {
    private static RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
    private static IAssigneeChooseService iAssigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);
    private static ISysActEntrustService sysActEntrustService = (ISysActEntrustService)SpringContextHolder.getBean(ISysActEntrustService.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    private static HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
    private static SysActAssigneeService sysActAssigneeService = (SysActAssigneeService)SpringContextHolder.getBean(SysActAssigneeService.class);
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private static final String STARTER = "starter";
    private static final String SEND_USER = "sendUser";

    public static Set<String> getCandidateUser(BpmnModel bm, ActivityExecution execution, boolean flag, String tenantId) {
        HashSet<String> users = AnalyticalModelUtil.getConfigUser(bm, execution, flag, tenantId, null);
        if (HussarUtils.isEmpty(users)) {
            return new HashSet<String>();
        }
        String processKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        ArrayList<String> result = new ArrayList<String>(users);
        users = new HashSet();
        Map userMap = sysActEntrustService.queryByUsers(result, processKey);
        if (!result.isEmpty()) {
            for (String id : result) {
                if (HussarUtils.isNotEmpty(userMap.get(id))) {
                    users.add((String)userMap.get(id));
                    continue;
                }
                users.add(id);
            }
        }
        return users;
    }

    public static Map<String, String> getEntrustCandidateUser(BpmnModel bm, String taskDefinitionKey, ActivityExecution execution, boolean flag, String tenantId) {
        return AnalyticalModelUtil.getEntrustCandidateUser(bm, taskDefinitionKey, execution, flag, null, tenantId, null);
    }

    public static Map<String, String> getEntrustCandidateUser(BpmnModel bm, String taskDefinitionKey, ActivityExecution execution, boolean flag, Set<String> set, String tenantId, List<String> messageType) {
        Set<String> users = AnalyticalModelUtil.getConfigUser(bm, execution, flag, tenantId, messageType);
        if (HussarUtils.isEmpty(users) && execution.getProcessInstance().getSuperExecutionId() == null && Context.getCommandContext().getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceCountByQueryCriteria(new HistoricTaskInstanceQueryImpl().processInstanceId(execution.getProcessInstanceId())) == 0L) {
            users = Collections.singleton(Authentication.getAuthenticatedUserId());
        }
        if (HussarUtils.isEmpty(users)) {
            return new HashMap<String, String>();
        }
        String processKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        Map userMap = sysActEntrustService.queryByUsers(users, processKey, taskDefinitionKey);
        for (String userId : users) {
            if (!userMap.containsKey(userId)) {
                userMap.put(userId, null);
                if (set == null) continue;
                set.add(userId);
                continue;
            }
            if (set == null) continue;
            set.add((String)userMap.get(userId));
        }
        return userMap;
    }

    private static HashSet<String> getConfigUser(BpmnModel bm, ActivityExecution execution, boolean flag, String tenantId, List<String> messageType) {
        JSONObject inExpressions;
        String defaultAssign;
        String appointAssignees;
        Map map;
        String activityId = execution.getActivity().getId();
        HashSet<String> users = new HashSet<String>();
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getExtensionElements();
        String allowSetParticipantRepetition = "";
        if (extensionElementsNode.get("allowSetParticipant") != null) {
            List list = (List)((ExtensionElement)((List)extensionElementsNode.get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant");
            String string = allowSetParticipantRepetition = HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : "true";
        }
        if (!"false".equals(allowSetParticipantRepetition)) {
            String appointAssignees2;
            map = execution.getVariableLocal("appoint_assignee") == null ? new HashMap() : (Map)execution.getVariableLocal("appoint_assignee");
            boolean isLocal = true;
            if (HussarUtils.isEmpty(map) && execution.getVariable("appoint_assignee") != null) {
                isLocal = false;
                map = (Map)execution.getVariable("appoint_assignee");
            }
            if (HussarUtils.isNotEmpty((Object)(appointAssignees2 = (String)map.get(activityId)))) {
                if (isLocal) {
                    execution.removeVariableLocal("appoint_assignee");
                }
                users = new HashSet<String>(Arrays.asList(appointAssignees2.split(",")));
                return users;
            }
            String staticAppointAssignees = (String)map.get("static_appoint_assignee");
            if (HussarUtils.isNotEmpty((Object)staticAppointAssignees)) {
                if (isLocal) {
                    execution.removeVariableLocal("appoint_assignee");
                }
                users = new HashSet<String>(Arrays.asList(staticAppointAssignees.split(",")));
                return users;
            }
            String rejectAssignees = execution.getVariableLocal("reject_appoint_assignee") == null ? "" : (String)execution.getVariableLocal("reject_appoint_assignee");
            isLocal = true;
            if (HussarUtils.isEmpty((Object)rejectAssignees) && execution.getVariable("reject_appoint_assignee") != null) {
                isLocal = false;
                rejectAssignees = (String)execution.getVariable("reject_appoint_assignee");
            }
            if (HussarUtils.isNotEmpty((Object)rejectAssignees)) {
                if (isLocal) {
                    execution.removeVariableLocal("reject_appoint_assignee");
                } else {
                    execution.removeVariable("reject_appoint_assignee");
                }
                users = new HashSet<String>(Arrays.asList(rejectAssignees.split(",")));
                return users;
            }
        }
        if (HussarUtils.isEmpty(users) && HussarUtils.isNotEmpty((Object)(appointAssignees = (String)(map = execution.getVariable("public_appoint_assignee") == null ? new HashMap() : (Map)execution.getVariable("public_appoint_assignee")).get(activityId)))) {
            users = new HashSet<String>(Arrays.asList(appointAssignees.split(",")));
            return users;
        }
        boolean flowStarter = Boolean.parseBoolean(((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("flowStarter")).get(0)).getAttributes().get("flowStarter")).get(0)).getValue());
        String userId = AnalyticalModelUtil.getFlowStarter(execution);
        if (flowStarter) {
            users.add(userId);
            return users;
        }
        Map modelAssignee = sysActAssigneeService.getAssignee(execution.getProcessDefinitionId().split(":")[0], activityId, false, messageType);
        if (HussarUtils.isNotEmpty((Object)modelAssignee)) {
            defaultAssign = (String)modelAssignee.get("defaultAssign");
            inExpressions = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionAssign")), (Feature[])new Feature[]{Feature.OrderedField});
        } else {
            defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign");
            inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign");
        }
        Map<String, Object> assignmentNodeMap = new HashMap<String, Object>();
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
            assignmentNodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, activityId, execution.getProcessInstanceId(), execution.getVariable(SEND_USER) != null ? execution.getVariable(SEND_USER).toString() : null);
        }
        users = AnalyticalModelUtil.getAssigneeByConfiguration(tenantId, execution, userId, defaultAssign, inExpressions, assignmentNodeMap);
        return users;
    }

    private static Map<String, Object> getAssignmentNodeMap(BpmnModel bm, String activityId, String processInsId, String sendUser) {
        ArrayList<String> list;
        HashMap<String, Object> assignmentNodeMap = new HashMap<String, Object>();
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getExtensionElements();
        if (HussarUtils.isEmpty((Object)extensionElementsNode)) {
            return assignmentNodeMap;
        }
        String assignmentNode = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("assignmentnode")).get(0)).getAttributes().get("assignmentnode")).get(0)).getValue();
        if (HussarUtils.isNotEmpty((Object)assignmentNode) && !(list = new ArrayList<String>(new HashSet<String>(Arrays.asList(assignmentNode.split(","))))).isEmpty()) {
            for (String node : list) {
                if (processInsId == null) {
                    assignmentNodeMap.put(node, "");
                    continue;
                }
                List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(node)).finished().includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).list();
                List unfinishedTask = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(node)).unfinished().list();
                boolean isUnfinished = !unfinishedTask.isEmpty();
                StringBuilder assignee = new StringBuilder();
                if (hisTaskList != null && !hisTaskList.isEmpty()) {
                    block1: for (int i = 0; i < hisTaskList.size(); ++i) {
                        String taskSourceFlag = (String)((HistoricTaskInstance)hisTaskList.get(i)).getTaskLocalVariables().get("taskSourceFlag");
                        if ("reject".equals(taskSourceFlag) || "revoke".equals(taskSourceFlag) || "reject_revoke".equals(taskSourceFlag)) continue;
                        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(i);
                        Date start = historicTaskInstance.getStartTime();
                        if (isUnfinished) {
                            start = ((HistoricTaskInstance)unfinishedTask.get(0)).getStartTime();
                        } else {
                            assignee.append(historicTaskInstance.getOriginalAssignee());
                        }
                        for (int j = i + (isUnfinished ? 0 : 1); j < hisTaskList.size(); ++j) {
                            historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(j);
                            if (start.getTime() > historicTaskInstance.getEndTime().getTime()) break block1;
                            if (historicTaskInstance.getCreateTime().compareTo(start) < 0) {
                                start = historicTaskInstance.getCreateTime();
                            }
                            if (assignee.length() > 0) {
                                assignee.append(",");
                            }
                            assignee.append(historicTaskInstance.getOriginalAssignee());
                        }
                        break;
                    }
                }
                if (isUnfinished && sendUser != null) {
                    if (assignee.length() > 0) {
                        assignee.append(",");
                    }
                    assignee.append(sendUser);
                }
                if (HussarUtils.isNotEmpty((Object)assignee.toString())) {
                    assignmentNodeMap.put(node, assignee.toString());
                    continue;
                }
                assignmentNodeMap.put(node, "");
            }
        }
        return assignmentNodeMap;
    }

    private static JSONObject getConditionAssign(BpmnModel bm, String activityId, String type) {
        JSONObject inExpressions = new JSONObject(true);
        Map extensionAttribute = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getAttributes();
        List inCandidate = (List)extensionAttribute.get(type);
        if (inCandidate != null && !inCandidate.isEmpty()) {
            inExpressions = ((ExtensionAttribute)inCandidate.get(0)).getValue() == null ? null : JSON.parseObject((String)((ExtensionAttribute)inCandidate.get(0)).getValue());
        }
        return inExpressions;
    }

    private static String getDefaultAssign(BpmnModel bm, String activityId, String type) {
        String defaultAssign = "";
        Map extensionAttribute = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getAttributes();
        List defaultCandidate = (List)extensionAttribute.get(type);
        if (defaultCandidate != null && !defaultCandidate.isEmpty()) {
            defaultAssign = ((ExtensionAttribute)defaultCandidate.get(0)).getValue() == null ? "" : ((ExtensionAttribute)defaultCandidate.get(0)).getValue();
        }
        return defaultAssign;
    }

    private static String getCallMessage(BpmnModel bm, String activityId, String name) {
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId).getExtensionElements();
        if (HussarUtils.isNotEmpty((Object)extensionElementsNode) && extensionElementsNode.get(name) != null && HussarUtils.isNotEmpty((Object)((ExtensionElement)((List)extensionElementsNode.get(name)).get(0)).getAttributes())) {
            return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get(name)).get(0)).getAttributes().get(name)).get(0)).getValue();
        }
        return "";
    }

    private static String getFlowStarter(ActivityExecution execution) {
        HistoricProcessInstance historicProcessInstance;
        String userId = "";
        List identityLink = ((ExecutionEntity)execution).getIdentityLinks();
        for (IdentityLinkEntity il : identityLink) {
            if (!STARTER.equals(il.getType())) continue;
            userId = il.getUserId() == null ? "" : il.getUserId();
            break;
        }
        if ("".equals(userId) && HussarUtils.isNotEmpty((Object)(historicProcessInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(execution.getProcessInstanceId()).singleResult())) && HussarUtils.isNotEmpty((Object)historicProcessInstance.getStartUserId())) {
            userId = historicProcessInstance.getStartUserId();
        }
        return userId;
    }

    public static Map<String, Object> getCcUser(BpmnModel bm, ActivityExecution execution, String tenantId) {
        String sendUserId;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set ccUsers = execution.getVariable("cc_user") == null ? new HashSet() : (Set)execution.getVariable("cc_user");
        String string = sendUserId = execution.getVariable(SEND_USER) == null ? "" : (String)execution.getVariable(SEND_USER);
        if (ccUsers != null && !ccUsers.isEmpty()) {
            execution.removeVariable("cc_user");
        } else {
            JSONObject inExpressions;
            String defaultAssign;
            String activityId = execution.getActivity().getId();
            String userId = AnalyticalModelUtil.getFlowStarter(execution);
            Map modelAssignee = sysActAssigneeService.getAssignee(execution.getProcessDefinitionId().split(":")[0], activityId, true, null);
            if (HussarUtils.isNotEmpty((Object)modelAssignee)) {
                defaultAssign = (String)modelAssignee.get("defaultCcAssign");
                inExpressions = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionCcAssign")), (Feature[])new Feature[]{Feature.OrderedField});
            } else {
                defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultCcAssign");
                inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionCcAssign");
            }
            Map<String, Object> assignmentNodeMap = new HashMap<String, Object>();
            if (!HussarUtils.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
                assignmentNodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, activityId, execution.getProcessInstanceId(), execution.getVariable(SEND_USER).toString());
            }
            ccUsers = AnalyticalModelUtil.getAssigneeByConfiguration(tenantId, execution, userId, defaultAssign, inExpressions, assignmentNodeMap);
        }
        map.put("ccUser", ccUsers);
        map.put("ccSendUser", sendUserId);
        return map;
    }

    private static HashSet<String> getAssigneeByConfiguration(String tenantId, ActivityExecution execution, String userId, String defaultAssign, JSONObject conditionAssign, Map<String, Object> assignmentNodeMap) {
        Map<String, Object> formData = execution.getVariables();
        if (formData != null && !formData.isEmpty()) {
            formData.putAll(assignmentNodeMap);
        } else {
            formData = assignmentNodeMap;
        }
        String processKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        return AnalyticalModelUtil.getNextAssigneeByConfiguration(tenantId, processKey, userId, defaultAssign, conditionAssign, formData, AnalyticalModelUtil.getProcessInfo(execution));
    }

    public static Map<String, String> getCallActivityAssignee(BpmnModel bm, ActivityExecution execution, Map<String, Object> map) {
        String userId = AnalyticalModelUtil.getFlowStarter(execution);
        String activityId = execution.getCurrentActivityId();
        String callAssignee = AnalyticalModelUtil.getCallMessage(bm, activityId, "conditionCallAssign");
        String callProcessKey = AnalyticalModelUtil.getCallMessage(bm, activityId, "conditionCallProcessKey");
        JSONObject conditionCallAssignee = JSON.parseObject((String)callAssignee, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject conditionCallProcessKey = JSON.parseObject((String)callProcessKey, (Feature[])new Feature[]{Feature.OrderedField});
        String defaultCallAssign = AnalyticalModelUtil.getCallMessage(bm, activityId, "defaultCallAssignee");
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{defaultCallAssign, conditionCallAssignee})) {
            Map<String, Object> assignmentNodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, execution.getCurrentActivityId(), execution.getProcessInstanceId(), execution.getVariable(SEND_USER).toString());
            map.putAll(assignmentNodeMap);
        }
        AnalyticalModelUtil.setBpmWorkflowVariable(execution.getTenantId(), userId, defaultCallAssign, conditionCallAssignee, map);
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        if (conditionCallAssignee != null && !conditionCallAssignee.isEmpty()) {
            for (Object k : conditionCallAssignee.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                HashMap<String, String> result = new HashMap<String, String>();
                if (HussarUtils.isNotEmpty((Object)conditionCallAssignee.get(k))) {
                    List users = iAssigneeChooseService.getCandidateUser(AnalyticalModelUtil.replaceNextBuiltinVariable((String)conditionCallAssignee.get(k), userId, execution.getTenantId(), map), String.valueOf(modelService.getServiceName(execution.getProcessDefinitionId().split(":")[0])), execution.getTenantId(), (Integer)execution.getVariables().get("security_level"), AnalyticalModelUtil.getProcessInfo(execution));
                    result.put("assignee", String.join((CharSequence)",", users));
                }
                result.put("processKey", (String)conditionCallProcessKey.get(k));
                return result;
            }
        }
        String defaultCallProcessKey = AnalyticalModelUtil.getCallMessage(bm, activityId, "defaultCallProcessKey");
        HashMap<String, String> result = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)defaultCallAssign)) {
            List users = iAssigneeChooseService.getCandidateUser(AnalyticalModelUtil.replaceNextBuiltinVariable(defaultCallAssign, userId, execution.getTenantId(), map), String.valueOf(modelService.getServiceName(execution.getProcessDefinitionId().split(":")[0])), execution.getTenantId(), (Integer)execution.getVariables().get("security_level"), AnalyticalModelUtil.getProcessInfo(execution));
            result.put("assignee", String.join((CharSequence)",", users));
        }
        result.put("processKey", defaultCallProcessKey);
        return result;
    }

    public static Map<String, String> getToDoConfiguration(String processDefinitionId, String taskDefinitionKey) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String todo = "";
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        if (HussarUtils.isNotEmpty((Object)taskDefinitionKey)) {
            Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(taskDefinitionKey).getExtensionElements();
            todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
            map.put("todoConfiguration", todo);
        }
        Map extensionElements = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        if (HussarUtils.isEmpty((Object)todo)) {
            todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElements.get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
            if (HussarUtils.isNotEmpty((Object)todo)) {
                map.put("todoConfiguration", todo);
            } else {
                map.put("todoConfiguration", "");
            }
        }
        return map;
    }

    public static String getTodo(Map<String, Object> variables, String todoConfig) {
        if (HussarUtils.isEmpty((Object)todoConfig)) {
            return "";
        }
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = AnalyticalModelUtil.getVariables(variables);
        ValueExpression valueExpression = factory.createValueExpression((ELContext)context, todoConfig, String.class);
        return valueExpression.getValue((ELContext)context) == null ? "" : valueExpression.getValue((ELContext)context).toString();
    }

    private static void setBpmWorkflowVariable(String tenantId, String userId, String defaultAssign, JSONObject conditionAssign, Map<String, Object> map) {
        boolean isGetFlowStarterDept = false;
        boolean isGetFlowSameLevelDept = false;
        boolean isGetFlowParentDept = false;
        boolean isGetFlowSubmiterDept = false;
        boolean isGetFlowSubmiterSameLevelDept = false;
        boolean isGetFlowSubmiterParentDept = false;
        if (defaultAssign.contains("flow_starter_dept")) {
            isGetFlowStarterDept = true;
        } else if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_starter_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_starter_dept")) continue;
                isGetFlowStarterDept = true;
                break;
            }
        }
        if (isGetFlowStarterDept) {
            map.put("flow_starter_dept", iAssigneeChooseService.getStarterDept(userId, tenantId));
        }
        if (defaultAssign.contains("flow_sameLevel_dept")) {
            isGetFlowSameLevelDept = true;
        } else if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_sameLevel_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_sameLevel_dept")) continue;
                isGetFlowSameLevelDept = true;
                break;
            }
        }
        if (isGetFlowSameLevelDept) {
            map.put("flow_sameLevel_dept", iAssigneeChooseService.getSameLevelDeptIdByUserId(userId, tenantId));
        }
        if (defaultAssign.contains("flow_parent_dept")) {
            isGetFlowParentDept = true;
        } else if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_parent_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_parent_dept")) continue;
                isGetFlowParentDept = true;
                break;
            }
        }
        if (isGetFlowParentDept) {
            map.put("flow_parent_dept", iAssigneeChooseService.getParentDeptIdByUserId(userId, tenantId));
        }
        if (defaultAssign.contains("flow_submiter_dept")) {
            isGetFlowSubmiterDept = true;
        } else if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_submiter_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_submiter_dept")) continue;
                isGetFlowSubmiterDept = true;
                break;
            }
        }
        if (isGetFlowSubmiterDept) {
            map.put("flow_submiter_dept", iAssigneeChooseService.getDeptIdByUserIds(map.get(SEND_USER).toString(), tenantId));
        }
        if (defaultAssign.contains("flow_submiter_sameLevel_dept")) {
            isGetFlowSubmiterSameLevelDept = true;
        } else if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_submiter_sameLevel_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_submiter_sameLevel_dept")) continue;
                isGetFlowSubmiterSameLevelDept = true;
                break;
            }
        }
        if (isGetFlowSubmiterSameLevelDept) {
            map.put("flow_submiter_sameLevel_dept", iAssigneeChooseService.getSameLevelDeptIdByUserIds(map.get(SEND_USER).toString(), tenantId));
        }
        if (defaultAssign.contains("flow_submiter_parent_dept")) {
            isGetFlowSubmiterParentDept = true;
        } else if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("flow_submiter_parent_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_submiter_parent_dept")) continue;
                isGetFlowSubmiterParentDept = true;
                break;
            }
        }
        if (isGetFlowSubmiterParentDept) {
            map.put("flow_submiter_parent_dept", iAssigneeChooseService.getParentDeptIdByUserIds(map.get(SEND_USER).toString(), tenantId));
        }
    }

    private static HashSet<String> getNextAssigneeByConfiguration(String tenantId, String processKey, String userId, String defaultAssign, JSONObject conditionAssign, Map<String, Object> map, Map<String, String> processInfo) {
        String realSql;
        HashSet<String> users = new HashSet<String>();
        boolean condition = false;
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        StringBuilder sql = new StringBuilder();
        AnalyticalModelUtil.setBpmWorkflowVariable(tenantId, userId, defaultAssign, conditionAssign, map);
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                condition = true;
                String con = (String)conditionAssign.get((Object)k.toString());
                sql.append(con);
                break;
            }
        }
        if (!condition) {
            if (HussarUtils.isNotEmpty((Object)defaultAssign) && !"null".equals(defaultAssign)) {
                sql.append(defaultAssign);
            } else {
                return users;
            }
        }
        if (HussarUtils.isEmpty((Object)(realSql = sql.toString())) || "null".equals(realSql)) {
            return users;
        }
        String serviceName = String.valueOf(modelService.getServiceName(processKey));
        List list = iAssigneeChooseService.getCandidateUser(AnalyticalModelUtil.replaceNextBuiltinVariable(realSql, userId, tenantId, map), serviceName, tenantId, (Integer)map.get("security_level"), processInfo);
        if (list == null || list.isEmpty()) {
            return users;
        }
        users.addAll(list);
        return users;
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (!map.containsKey("bpm_submit_source")) {
            map.put("bpm_submit_source", "");
        }
        for (String k : map.keySet()) {
            if (map.get(k.toString()) != null) {
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
                continue;
            }
            context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), Object.class));
        }
        return context;
    }

    private static String replaceNextBuiltinVariable(String sql, String starterUserId, String tenantId, Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            for (Map.Entry<String, Object> key : map.entrySet()) {
                if (sql.contains("(${" + key.getKey() + "})") && key.getValue() == null) {
                    newMap.put(key.getKey(), "null");
                    continue;
                }
                if (sql.contains("('${" + key.getKey() + "}')")) {
                    newMap.put(key.getKey(), String.valueOf(key.getValue()).replace(",", "','"));
                    continue;
                }
                newMap.put(key.getKey(), key.getValue());
            }
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newMap);
        ValueExpression e = factory.createValueExpression((ELContext)context, sql, String.class);
        String finalSql = e.getValue((ELContext)context).toString();
        finalSql = finalSql.replace("'null'", "null");
        return "and (" + finalSql.replaceFirst("and", "") + ")";
    }

    public static String queryFirstNodeAssigneeConfig(String userId, String tenantId, String processDefinitionId, String businessId, Map<String, Object> variables) {
        Map<String, Object> result;
        HashMap<String, Object> newVariables;
        JSONObject conditionAssign;
        String defaultAssign;
        List sequenceFlowList;
        String targetRef;
        FlowElement flowElement;
        StringBuilder sql = new StringBuilder();
        String taskDefinitionKey = "";
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        boolean condition = false;
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        Process process = bm.getMainProcess();
        Collection flowElements = process.getFlowElements();
        StartEvent startEvent = new StartEvent();
        for (FlowElement flowElement2 : flowElements) {
            if (!(flowElement2 instanceof StartEvent)) continue;
            startEvent = (StartEvent)flowElement2;
            break;
        }
        if ((flowElement = process.getFlowElement(targetRef = ((SequenceFlow)(sequenceFlowList = startEvent.getOutgoingFlows()).get(0)).getTargetRef())) instanceof UserTask) {
            taskDefinitionKey = flowElement.getId();
        }
        if (flowElement instanceof ExclusiveGateway) {
            taskDefinitionKey = AnalyticalModelUtil.getFirstNode(flowElement, process, variables);
        }
        if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
            return "";
        }
        Map modelAssignee = sysActAssigneeService.getAssignee(processDefinitionId.split(":")[0], taskDefinitionKey, false, null);
        if (HussarUtils.isNotEmpty((Object)modelAssignee)) {
            defaultAssign = (String)modelAssignee.get("defaultAssign");
            conditionAssign = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionAssign")), (Feature[])new Feature[]{Feature.OrderedField});
        } else {
            defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, taskDefinitionKey, "defaultAssign");
            conditionAssign = AnalyticalModelUtil.getConditionAssign(bm, taskDefinitionKey, "conditionAssign");
        }
        if (HussarUtils.isEmpty((Object)defaultAssign) && HussarUtils.isEmpty((Object)conditionAssign)) {
            return "";
        }
        boolean isGetFlowStarterDept = false;
        boolean isRequestVisit = false;
        if (defaultAssign.contains("$")) {
            isRequestVisit = true;
        }
        if (defaultAssign.contains("flow_starter_dept")) {
            isGetFlowStarterDept = true;
        }
        if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                if (isGetFlowStarterDept && isRequestVisit) break;
                if (!isRequestVisit && (k.toString().contains("$") || ((String)conditionAssign.get((Object)k.toString())).contains("$"))) {
                    isRequestVisit = true;
                }
                if (isGetFlowStarterDept || !k.toString().contains("flow_starter_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_starter_dept")) continue;
                isGetFlowStarterDept = true;
            }
        }
        HashMap<String, Object> hashMap = newVariables = variables == null ? new HashMap<String, Object>() : variables;
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{defaultAssign, conditionAssign})) {
            Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, taskDefinitionKey, null, "");
            newVariables.putAll(nodeMap);
        }
        if (isRequestVisit && HussarUtils.isNotEmpty(result = CommonCodeUtil.getGodAxeResult(tenantId, taskDefinitionKey, businessId, processDefinitionId))) {
            newVariables.putAll(result);
        }
        if (isGetFlowStarterDept) {
            newVariables.put("flow_starter_dept", iAssigneeChooseService.getStarterDept(userId, tenantId));
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newVariables);
        if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                condition = true;
                String con = (String)conditionAssign.get((Object)k.toString());
                sql.append(con);
                break;
            }
        }
        if (!condition) {
            if (HussarUtils.isNotEmpty((Object)defaultAssign) && !"null".equals(defaultAssign)) {
                sql.append(defaultAssign);
            } else {
                return "";
            }
        }
        String finalSql = "";
        if (HussarUtils.isNotEmpty((Object)sql)) {
            finalSql = AnalyticalModelUtil.replaceNextBuiltinVariable(sql.toString(), userId, tenantId, newVariables);
        }
        return finalSql;
    }

    private static boolean getResultByELAndFormData(String el, Map<String, Object> formData) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        for (Map.Entry<String, Object> k : formData.entrySet()) {
            if (k.getValue() != null) {
                context.setVariable(k.getKey(), factory.createValueExpression(k.getValue(), k.getValue().getClass()));
                continue;
            }
            context.setVariable(k.toString(), factory.createValueExpression(k.getValue(), Object.class));
        }
        ValueExpression e = factory.createValueExpression((ELContext)context, el, Boolean.TYPE);
        return (Boolean)e.getValue((ELContext)context);
    }

    private static String getFirstNode(FlowElement flowElement, Process process, Map<String, Object> variables) {
        SequenceFlow sequenceFlow;
        String targetRef;
        FlowElement fe;
        String taskDefinitionKey = "";
        ExclusiveGateway exclusiveGateway = (ExclusiveGateway)flowElement;
        String flow = exclusiveGateway.getDefaultFlow();
        List sf = exclusiveGateway.getOutgoingFlows();
        for (SequenceFlow s : sf) {
            String ce = s.getConditionExpression();
            if (!HussarUtils.isNotEmpty((Object)ce) || !AnalyticalModelUtil.getResultByELAndFormData(ce, variables)) continue;
            flow = s.getId();
            break;
        }
        if (HussarUtils.isNotEmpty((Object)flow) && (fe = process.getFlowElement(targetRef = (sequenceFlow = (SequenceFlow)process.getFlowElement(flow)).getTargetRef())) instanceof UserTask) {
            taskDefinitionKey = fe.getId();
        }
        return taskDefinitionKey;
    }

    public static Set<String> getNextCandidateUser(String processInsId, String processDefinitionId, BpmnModel bm, String activityId, String tenantId, Map<String, Object> map, Task task) {
        String processKey = processDefinitionId.split(":")[0];
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        HashSet<String> users = new HashSet<String>();
        FlowElement flowElement = ((Process)bm.getProcesses().get(0)).getFlowElement(activityId);
        if (flowElement == null) {
            throw new PublicClientException(bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
        }
        if (flowElement instanceof ReceiveTask || flowElement instanceof ServiceTask) {
            return users;
        }
        Map extensionElementsNode = flowElement.getExtensionElements();
        if (!extensionElementsNode.isEmpty()) {
            Map<String, Object> result;
            JSONObject inExpressions;
            String defaultAssign;
            Map modelAssignee = sysActAssigneeService.getAssignee(processKey, activityId, false, null);
            if (HussarUtils.isNotEmpty((Object)modelAssignee)) {
                defaultAssign = (String)modelAssignee.get("defaultAssign");
                inExpressions = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionAssign")), (Feature[])new Feature[]{Feature.OrderedField});
            } else {
                defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign");
                inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign");
            }
            String businessId = null;
            String startUserId = HussarUtils.isEmpty(newMap.get("userId")) ? "" : (String)newMap.get("userId");
            newMap.put(SEND_USER, startUserId);
            if (processInsId != null) {
                HistoricProcessInstance hpi = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
                businessId = hpi.getBusinessKey();
                startUserId = hpi.getStartUserId();
            }
            if (!HussarUtils.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
                Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(bm, activityId, processInsId, "");
                newMap.putAll(nodeMap);
            }
            if (AnalyticalModelUtil.isGetVisitor(defaultAssign, inExpressions) && HussarUtils.isNotEmpty(result = CommonCodeUtil.getGodAxeResult(tenantId, activityId, businessId, processDefinitionId))) {
                newMap.putAll(result);
            }
            users = AnalyticalModelUtil.getNextAssigneeByConfiguration(tenantId, processKey, startUserId, defaultAssign, inExpressions, newMap, AnalyticalModelUtil.getProcessInfo(task, flowElement, processDefinitionId));
        }
        return users;
    }

    private static Map<String, String> getProcessInfo(Task task, FlowElement flowElement, String processDefId) {
        HashMap<String, String> processInfo = new HashMap<String, String>();
        processInfo.put("workflowTaskDefinitionKey", flowElement.getId());
        processInfo.put("workflowTaskDefinitionName", flowElement.getName());
        if (task != null) {
            processInfo.put("workflowProcessKey", task.getProcessDefinitionId().split(":")[0]);
            processInfo.put("workflowProcessInsId", task.getProcessInstanceId());
            processInfo.put("workflowProcessDefinitionId", task.getProcessDefinitionId());
        } else if (processDefId != null) {
            processInfo.put("workflowProcessDefinitionId", processDefId);
            processInfo.put("workflowProcessKey", processDefId.split(":")[0]);
        }
        return processInfo;
    }

    private static Map<String, String> getProcessInfo(ActivityExecution execution) {
        HashMap<String, String> processInfo = new HashMap<String, String>();
        processInfo.put("workflowProcessKey", execution.getProcessDefinitionId().split(":")[0]);
        processInfo.put("workflowProcessInsId", execution.getProcessInstanceId());
        processInfo.put("workflowProcessDefinitionId", execution.getProcessDefinitionId());
        processInfo.put("workflowBusinessId", execution.getProcessBusinessKey());
        processInfo.put("workflowTaskDefinitionKey", execution.getCurrentActivityId());
        processInfo.put("workflowTaskDefinitionName", execution.getCurrentActivityName());
        return processInfo;
    }

    private static boolean isGetVisitor(String defaultAssign, JSONObject conditionAssign) {
        if (defaultAssign.contains("$")) {
            return true;
        }
        if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("$") && !((String)conditionAssign.get((Object)k.toString())).contains("$")) continue;
                return true;
            }
        }
        return false;
    }

    private AnalyticalModelUtil() {
    }
}

