/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.model.AlternativeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.service.IAlternativeTaskService;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.MultiUser;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.User")
public class UserTaskVisitor
implements FormObjectVisitor {
    @Autowired
    private IAlternativeTaskService alternativeTaskService;

    @Override
    public void visit(FlowObject flowObject, Process process, FlowModel flowModel, Integer procVersion) {
        String dueDate;
        UserTask userTask = new UserTask();
        FlowProps flowProps = flowObject.getProps();
        userTask.setName(flowProps.getFlowName());
        userTask.setId(flowObject.getId());
        userTask.setDocumentation(flowProps.getFlowDescription());
        JSONObject jsonObject = flowProps.getFormAddress();
        if (jsonObject != null) {
            JSONObject object = new JSONObject();
            for (String key : jsonObject.keySet()) {
                object.put(key, jsonObject.getJSONObject(key).get((Object)"url"));
            }
            userTask.setFormKey(JSON.toJSONString((Object)object));
        }
        if (HussarUtils.isNotEmpty((Object)(dueDate = flowProps.getDueDate()))) {
            userTask.setDueDate(dueDate);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
        FormBpmnUtil.getFunctionMessage(flowObject.getProps(), map, functionUserVariables);
        FormBpmnUtil.assigneeInstall(flowObject, userTask, map);
        FormBpmnUtil.ccInstall(flowObject, userTask, map);
        FormBpmnUtil.extendHandle(flowObject, userTask);
        if (HussarUtils.isNotEmpty((Object)flowObject.getProps().getFlowCountersign())) {
            this.counterSign(flowObject, userTask);
        }
        ArrayList<String> pathIds = new ArrayList<String>();
        List flowSequences = flowModel.getSlots().getPath();
        for (FlowSequence flowSequence : flowSequences) {
            pathIds.add(flowSequence.getId());
        }
        FormBpmnUtil.addTaskListener(userTask, flowObject);
        ArrayList<FlowVariables> useVariables = flowProps.getUseVariables();
        List modelUseVariables = flowModel.getProps().getUseVariables();
        boolean flag = false;
        if (HussarUtils.isNotEmpty((Object)modelUseVariables)) {
            flag = true;
        }
        if (HussarUtils.isEmpty((Object)useVariables)) {
            useVariables = new ArrayList<FlowVariables>();
        }
        if (HussarUtils.isNotEmpty(functionUserVariables)) {
            useVariables.addAll(functionUserVariables);
        }
        FormBpmnUtil.addExeListener((FlowElement)userTask, useVariables, pathIds, flag);
        FormBpmnUtil.addExecutionListener(userTask, null, null, null, flowObject);
        process.addFlowElement((FlowElement)userTask);
        if (procVersion != null && "1".equals(flowProps.getIsApprovalNode())) {
            this.alternativeTaskService.save((Object)new AlternativeTask(process.getId(), procVersion, flowObject.getId(), flowProps.getFlowName(), flowProps.getEditNodeName(), JSON.toJSONBytes((Object)flowObject, (SerializerFeature[])new SerializerFeature[0])));
        }
    }

    private void counterSign(FlowObject flowObject, UserTask userTask) {
        MultiUser multiUser = flowObject.getProps().getFlowCountersign();
        if (multiUser.isCountersign()) {
            MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
            multiInstanceLoopCharacteristics.setSequential(false);
            multiInstanceLoopCharacteristics.setInputDataItem("multi");
            if ("radio".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances/nrOfInstances >= " + multiUser.getCountersignNumByRatio() / 100.0 + " }");
            }
            if ("count".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances == " + multiUser.getCountersignNumByCount() + " }");
            }
            userTask.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        }
    }
}

