/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processgroup.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.model.SysActProcessDept;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.ISysActProcessDeptService;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.ProcessGroupInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.dao.ProcessGroupMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.model.ProcessGroup;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.service.IProcessGroupService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessGroupServiceImpl
extends HussarServiceImpl<ProcessGroupMapper, ProcessGroup>
implements IProcessGroupService {
    @Resource
    private ProcessGroupMapper processGroupMapper;
    @Autowired
    private ISysActProcessDeptService processDeptService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    public static final String UNKNOWN_DEPT_NAME = "?";

    public ApiResponse<IPage<ProcessGroupInfo>> getProcessGroupList(Page<ProcessGroupInfo> page, ProcessGroupInfo processGroupInfo) {
        if (HussarUtils.isEmpty((Object)processGroupInfo.getProcessKey())) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        List processDeptList = this.processDeptService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessDept::getProcessKey, (Object)processGroupInfo.getProcessKey()));
        ArrayList<String> deptIdList = new ArrayList<String>();
        for (SysActProcessDept processDept : processDeptList) {
            deptIdList.add(processDept.getDeptId());
        }
        Map deptMap = this.assigneeChooseService.getUserListByUserId(deptIdList, null);
        Map groupDeptMap = processDeptList.stream().collect(Collectors.groupingBy(SysActProcessDept::getProcGroupNumber, Collectors.mapping(SysActProcessDept::getDeptId, Collectors.toList())));
        Page processGroupPage = new Page(page.getCurrent(), page.getSize());
        List processGroupInfos = ((Page)this.page((IPage)processGroupPage, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessGroup::getProcessKey, (Object)processGroupInfo.getProcessKey())).like(HussarUtils.isNotEmpty((Object)processGroupInfo.getGroupName()), ProcessGroup::getGroupName, (Object)processGroupInfo.getGroupName())).orderByAsc(ProcessGroup::getGroupName))).getRecords().stream().map(processGroup -> {
            ProcessGroupInfo groupInfo = this.getProcessGroupInfo((ProcessGroup)processGroup);
            groupInfo.setDeptId((List)groupDeptMap.get(groupInfo.getGroupNumber()));
            if (HussarUtils.isNotEmpty((Object)groupInfo.getDeptId())) {
                List groupDeptIdList = groupInfo.getDeptId();
                groupDeptIdList.sort(String::compareTo);
                groupInfo.setDeptName(groupDeptIdList.stream().map(deptId -> {
                    String deptName = (String)deptMap.get(deptId);
                    return deptName == null ? UNKNOWN_DEPT_NAME : deptName;
                }).collect(Collectors.toList()));
            }
            return groupInfo;
        }).collect(Collectors.toList());
        return ApiResponse.success((Object)page.setRecords(processGroupInfos).setTotal(processGroupPage.getTotal()));
    }

    public ApiResponse<ProcessGroupInfo> getProcessGroupInfo(ProcessGroupInfo processGroupInfo) {
        if (HussarUtils.isEmpty((Object)processGroupInfo.getGroupNumber())) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        ProcessGroup processGroup = (ProcessGroup)this.getOne((Wrapper)new LambdaQueryWrapper().eq(ProcessGroup::getGroupNumber, (Object)processGroupInfo.getGroupNumber()));
        if (HussarUtils.isEmpty((Object)processGroup)) {
            throw new PublicClientException("\u6d41\u7a0b\u7ec4\u4e0d\u5b58\u5728\uff01");
        }
        List processDeptList = this.processDeptService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessDept::getProcGroupNumber, (Object)processGroupInfo.getGroupNumber()));
        List deptIdList = processDeptList.stream().map(SysActProcessDept::getDeptId).sorted().collect(Collectors.toList());
        Map deptMap = this.assigneeChooseService.getUserListByUserId(deptIdList, null);
        List deptNames = deptIdList.stream().map(deptId -> {
            String deptName = (String)deptMap.get(deptId);
            return deptName == null ? UNKNOWN_DEPT_NAME : deptName;
        }).collect(Collectors.toList());
        ProcessGroupInfo returnProcessGroupInfo = this.getProcessGroupInfo(processGroup);
        returnProcessGroupInfo.setDeptId(deptIdList).setDeptName(deptNames);
        return ApiResponse.success((Object)returnProcessGroupInfo);
    }

    private ProcessGroupInfo getProcessGroupInfo(ProcessGroup processGroup) {
        return new ProcessGroupInfo().setGroupName(processGroup.getGroupName()).setProcessKey(processGroup.getProcessKey()).setProcGroupId(processGroup.getProcGroupId()).setGroupNumber(processGroup.getGroupNumber()).setMainProcDefId(processGroup.getMainProcDefId());
    }

    public ApiResponse<String> updateProcessGroup(ProcessGroupInfo processGroupInfo) {
        if (HussarUtils.isEmpty((Object)processGroupInfo.getGroupNumber())) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (HussarUtils.isAllEmpty((Object[])new Object[]{processGroupInfo.getGroupName(), processGroupInfo.getDeptId(), processGroupInfo.getMainProcDefId()})) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        ProcessGroup processGroup = (ProcessGroup)this.getOne((Wrapper)new LambdaQueryWrapper().eq(ProcessGroup::getGroupNumber, (Object)processGroupInfo.getGroupNumber()));
        if (processGroup == null) {
            return ApiResponse.success((String)"");
        }
        if (HussarUtils.isNotEmpty((Object)processGroupInfo.getDeptId())) {
            if (HussarUtils.isEmpty((Object)processGroupInfo.getProcessKey())) {
                throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
            }
            this.judgeProcessDept(processGroup.getProcessKey(), processGroupInfo.getGroupNumber(), processGroupInfo.getDeptId());
            this.processDeptService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessDept::getProcGroupNumber, (Object)processGroupInfo.getGroupNumber()));
            this.processDeptService.saveBatch((Collection)processGroupInfo.getDeptId().stream().map(deptId -> {
                SysActProcessDept processDept = new SysActProcessDept();
                processDept.setProcessKey(processGroupInfo.getProcessKey());
                processDept.setProcGroupNumber(processGroupInfo.getGroupNumber());
                processDept.setDeptId(deptId);
                return processDept;
            }).collect(Collectors.toList()));
        }
        if (HussarUtils.isNotEmpty((Object)processGroupInfo.getGroupName()) || HussarUtils.isNotEmpty((Object)processGroupInfo.getMainProcDefId())) {
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(HussarUtils.isNotEmpty((Object)processGroupInfo.getGroupName()), ProcessGroup::getGroupName, (Object)processGroupInfo.getGroupName())).set(HussarUtils.isNotEmpty((Object)processGroupInfo.getMainProcDefId()), ProcessGroup::getMainProcDefId, (Object)processGroupInfo.getMainProcDefId())).eq(ProcessGroup::getGroupNumber, (Object)processGroupInfo.getGroupNumber()));
        }
        return ApiResponse.success((String)"");
    }

    public ApiResponse<String> addProcessGroup(ProcessGroupInfo processGroupInfo) {
        if (HussarUtils.isEmpty((Object)processGroupInfo.getProcessKey()) || HussarUtils.isEmpty((Object)processGroupInfo.getGroupNumber())) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (HussarUtils.isEmpty((Object)processGroupInfo.getDeptId())) {
            throw new PublicClientException("\u6240\u9009\u90e8\u95e8\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        List processGroupList = this.list((Wrapper)new LambdaQueryWrapper().eq(ProcessGroup::getGroupNumber, (Object)processGroupInfo.getGroupNumber()));
        if (!processGroupList.isEmpty()) {
            throw new PublicClientException("\u8be5\u5206\u7ec4\u5df2\u521b\u5efa\uff01");
        }
        this.judgeProcessDept(processGroupInfo.getProcessKey(), null, processGroupInfo.getDeptId());
        this.save((BaseEntity)new ProcessGroup().setGroupName(processGroupInfo.getGroupName()).setGroupNumber(processGroupInfo.getGroupNumber()).setProcessKey(processGroupInfo.getProcessKey()).setMainProcDefId(processGroupInfo.getMainProcDefId()));
        this.processDeptService.saveBatch((Collection)processGroupInfo.getDeptId().stream().map(deptId -> {
            SysActProcessDept processDept = new SysActProcessDept();
            processDept.setProcessKey(processGroupInfo.getProcessKey());
            processDept.setProcGroupNumber(processGroupInfo.getGroupNumber());
            processDept.setDeptId(deptId);
            return processDept;
        }).collect(Collectors.toList()));
        return ApiResponse.success((String)"");
    }

    public ApiResponse<String> judgeProcessDept(ProcessGroupInfo processGroupInfo) {
        if (HussarUtils.isEmpty((Object)processGroupInfo.getProcessKey()) || HussarUtils.isEmpty((Object)processGroupInfo.getDeptId())) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        this.judgeProcessDept(processGroupInfo.getProcessKey(), processGroupInfo.getGroupNumber(), processGroupInfo.getDeptId());
        return ApiResponse.success((String)"");
    }

    private void judgeProcessDept(String processKey, String groupNumber, List<String> deptList) {
        List processDeptList = this.processDeptService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessDept::getProcessKey, (Object)processKey)).in(SysActProcessDept::getDeptId, deptList)).ne(HussarUtils.isNotEmpty((Object)groupNumber), SysActProcessDept::getProcGroupNumber, (Object)groupNumber));
        if (!processDeptList.isEmpty()) {
            Map deptNameMap = this.assigneeChooseService.getUserListByUserId(deptList, null);
            Map<String, List<SysActProcessDept>> groupDeptMap = processDeptList.stream().collect(Collectors.groupingBy(SysActProcessDept::getProcGroupNumber));
            List groupList = this.list((Wrapper)new LambdaQueryWrapper().in(ProcessGroup::getGroupNumber, groupDeptMap.keySet()));
            groupList.sort(Comparator.comparing(ProcessGroup::getProcGroupId));
            StringBuilder stringBuilder = new StringBuilder();
            for (ProcessGroup processGroup : groupList) {
                stringBuilder.append("\u5206\u7ec4[").append(processGroup.getGroupName()).append("]\u5df2\u5305\u542b\u90e8\u95e8[");
                List<SysActProcessDept> processDepts = groupDeptMap.get(processGroup.getGroupNumber());
                if (processDepts.size() > 1) {
                    processDepts.sort(Comparator.comparing(SysActProcessDept::getDeptId));
                }
                stringBuilder.append(processDepts.stream().map(dept -> {
                    String deptName = (String)deptNameMap.get(dept.getDeptId());
                    return deptName == null ? UNKNOWN_DEPT_NAME : deptName;
                }).collect(Collectors.joining(","))).append("]").append(";\n");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
            }
            throw new PublicClientException(stringBuilder.toString());
        }
    }

    public boolean canDeleteProcess(String processKey, String processDefinitionId, IProcessGroupService.DeleteProcessFunction deleteFunction) {
        ProcessGroup processGroup;
        ProcessExtendProperties processExtendProperties;
        if (HussarUtils.isEmpty((Object)processKey)) {
            processKey = processDefinitionId.split(":")[0];
        }
        if ((processExtendProperties = this.processDefinitionsService.getProcessExtendProperties(processDefinitionId)).getProcGroupNumber() != null && (processGroup = (ProcessGroup)this.getOne((Wrapper)new LambdaQueryWrapper().eq(ProcessGroup::getGroupNumber, (Object)processExtendProperties.getProcGroupNumber()))) != null && Objects.equals(processGroup.getMainProcDefId(), processDefinitionId)) {
            int procDefNumber = this.processGroupMapper.getProcDefNumber(processKey, processGroup.getGroupNumber());
            if (procDefNumber <= 1) {
                boolean isDeleteSuccess = deleteFunction.deleteProcess();
                this.removeById((BaseEntity)processGroup);
                this.processDeptService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessDept::getProcGroupNumber, (Object)processGroup.getGroupNumber()));
                return isDeleteSuccess;
            }
            throw new PublicClientException("\u4e0d\u53ef\u5220\u9664\u4e3b\u7248\u672c\u6d41\u7a0b");
        }
        return deleteFunction.deleteProcess();
    }

    public void deleteProcessModel(String processKey) {
        this.remove((Wrapper)new LambdaQueryWrapper().eq(ProcessGroup::getProcessKey, (Object)processKey));
        this.processDeptService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessDept::getProcessKey, (Object)processKey));
    }
}

