/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.definition.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.model.ProcessGroup;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.service.IProcessGroupService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessDefinitionsServiceImpl
implements ProcessDefinitionsService {
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private DruidProperties druidProperties;
    @Autowired
    private IProcessGroupService processGroupService;

    public IPage<DefinitionModel> queryProcessDefinitionsList(String definitionName, String procGroupNumber, Page<DefinitionModel> page) {
        ProcessGroup processGroup;
        List<DefinitionModel> instList = this.processDefinitionsMapper.getList(page, definitionName, procGroupNumber);
        if (HussarUtils.isNotEmpty((Object)procGroupNumber) && (processGroup = (ProcessGroup)this.processGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessGroup::getProcessKey, (Object)definitionName)).eq(ProcessGroup::getGroupNumber, (Object)procGroupNumber))) != null && processGroup.getMainProcDefId() != null) {
            for (DefinitionModel definitionModel : instList) {
                if (!definitionModel.getId().equals(processGroup.getMainProcDefId())) continue;
                definitionModel.setMain("1");
                break;
            }
        }
        page.setRecords(instList);
        return page;
    }

    public IPage<DefinitionModel> queryMainProcessDefinitionsList(String definitionName, String procGroupNumber, Page<DefinitionModel> page) {
        ProcessGroup processGroup;
        List<DefinitionModel> instList = this.processDefinitionsMapper.getList(page, definitionName, procGroupNumber);
        List<Object> mainList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)procGroupNumber) && (processGroup = (ProcessGroup)this.processGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessGroup::getProcessKey, (Object)definitionName)).eq(ProcessGroup::getGroupNumber, (Object)procGroupNumber))) != null && processGroup.getMainProcDefId() != null) {
            mainList = instList.stream().filter(s -> s.getId().equals(processGroup.getMainProcDefId())).collect(Collectors.toList());
        }
        page.setRecords(mainList);
        return page;
    }

    public DefinitionModel getMainOrNew(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new PublicClientException(this.bpmConstantProperties.getProcessKeyError(), Boolean.valueOf(false));
    }

    public ApiResponse<String> setMain(String procDefId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(procDefId);
        if (processDefinition == null) {
            throw new PublicClientException("\u672a\u53d1\u73b0\u8be5\u6d41\u7a0b\u5b9a\u4e49\uff01");
        }
        ProcessExtendProperties processExtendProperties = this.getProcessExtendProperties(procDefId);
        String procGroupNumber = processExtendProperties.getProcGroupNumber();
        ProcessGroup processGroup = (ProcessGroup)this.processGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessGroup::getProcessKey, (Object)processDefinition.getKey())).eq(ProcessGroup::getGroupNumber, (Object)procGroupNumber));
        if (processGroup == null) {
            throw new PublicClientException("\u672a\u53d1\u73b0\u6d41\u7a0b\u5206\u7ec4");
        }
        this.processGroupService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ProcessGroup::getProcGroupId, (Object)processGroup.getProcGroupId())).set(ProcessGroup::getMainProcDefId, (Object)procDefId));
        return ApiResponse.success((String)"");
    }

    public void canModelDeleteWithVersion(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list.size() == 1) {
            throw new PublicClientException(this.bpmConstantProperties.getNotDeleteTheOnlyProcessDefinition(), Boolean.valueOf(false));
        }
    }

    public int setNotMain(String processKey) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, null, 0);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        Long deploymentId = definitionModel.getDeploymentId();
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, processKey);
        return num;
    }

    public ApiResponse<String> cancelMain(String processKey, String id) {
        throw new PublicClientException("\u4e0d\u652f\u6301");
    }

    public int updateProcessName(String id, String processName) {
        return this.processDefinitionsMapper.updateProcessName(id, processName);
    }

    public List<ProcessDefinitionModel> queryProcessDefListOfMainVersion(String processName) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> newList = new ArrayList<ProcessDefinitionModel>();
        for (ProcessDefinitionModel oldPro : list) {
            boolean flag = false;
            for (ProcessDefinitionModel newPro : newList) {
                if (!HussarUtils.equals((Object)oldPro.getKey(), (Object)newPro.getKey())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            newList.add(oldPro);
        }
        return newList;
    }

    public int setVersionTemporary(String id) {
        return this.processDefinitionsMapper.setVersionTemporary(id);
    }

    public void editTemporaryDefId(String defId, Long processInsId, String version) {
        this.processDefinitionsMapper.updateActInst(defId, processInsId, version);
        this.processDefinitionsMapper.updateExecution(defId, processInsId, version);
        this.processDefinitionsMapper.updateProcDef(defId, processInsId, Long.parseLong(version));
        this.processDefinitionsMapper.updateTask(defId, processInsId, version);
        this.processDefinitionsMapper.updateTaskInst(defId, processInsId, version);
        this.processDefinitionsMapper.updateProcInst(defId, processInsId, version);
    }

    public void editTemporaryDefId(String defId, String processInsId, String version) {
        this.editTemporaryDefId(defId, Long.parseLong(processInsId), version);
    }

    public int queryLatestVersion(String processKey) {
        List processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().list();
        if (HussarUtils.isNotEmpty((Object)processDefinition)) {
            return ((ProcessDefinition)processDefinition.get(0)).getVersion();
        }
        return 0;
    }

    public void setProcessExtendProperties(String procDefId, ProcessExtendProperties processExtendProperties) {
        this.processDefinitionsMapper.setProcessExtendProperties(procDefId, processExtendProperties);
    }

    public ProcessExtendProperties getProcessExtendProperties(String procDefId) {
        ProcessExtendProperties processExtendProperties = this.processDefinitionsMapper.getProcessExtendProperties(procDefId);
        return processExtendProperties == null ? new ProcessExtendProperties() : processExtendProperties;
    }
}

