/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.dao.AssigneeChooseMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.dao.SysActProcessDeptMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.model.SysActProcessDept;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.ISysActProcessDeptService;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.ProcessGroupInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.model.ProcessGroup;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.service.IProcessGroupService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActProcessDeptServiceImpl
extends HussarServiceImpl<SysActProcessDeptMapper, SysActProcessDept>
implements ISysActProcessDeptService {
    @Resource
    private AssigneeChooseMapper assigneeChooseMapper;
    @Resource
    private SysActProcessDeptMapper sysActProcessDeptMapper;
    @Autowired
    private IProcessGroupService processGroupService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessDefinitionsMapper processDefinitionsMapper;

    public int getProcessVersion(String deptId, String processKey) {
        ProcessDefinition processDefinitionByDeptId = this.getProcessDefinitionByDeptId(deptId, processKey);
        return processDefinitionByDeptId.getVersion();
    }

    public String getProcessDefId(String deptId, String processKey) {
        ProcessDefinition processDefinitionByDeptId = this.getProcessDefinitionByDeptId(deptId, processKey);
        return processDefinitionByDeptId.getId();
    }

    private ProcessDefinition getProcessDefinitionByDeptId(String deptId, String processKey) {
        if (HussarUtils.isEmpty((Object)deptId)) {
            throw new PublicClientException("\u672a\u627e\u5230\u7528\u6237\u6240\u5728\u90e8\u95e8\u4e0b\u6d41\u7a0b\uff01");
        }
        SysActProcessDept sysActProcessDept = this.sysActProcessDeptMapper.getSysActProcessDeptByProcessKeyAndDeptId(processKey, deptId);
        if (HussarUtils.isNotEmpty((Object)sysActProcessDept)) {
            ProcessGroup processGroup = (ProcessGroup)this.processGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessGroup::getGroupNumber, (Object)sysActProcessDept.getProcGroupNumber())).eq(ProcessGroup::getProcessKey, (Object)sysActProcessDept.getProcessKey()));
            if (HussarUtils.isEmpty((Object)processGroup.getMainProcDefId())) {
                String parentId = this.assigneeChooseMapper.getParentId(deptId);
                return this.getProcessDefinitionByDeptId(parentId, processKey);
            }
            ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processGroup.getMainProcDefId());
            if (processDefinition == null) {
                List<DefinitionModel> definitionModels = this.processDefinitionsMapper.getList((Page<DefinitionModel>)new Page(1L, 1L), processKey, processGroup.getGroupNumber());
                if (definitionModels.isEmpty()) {
                    this.processGroupService.removeById((Object)processGroup);
                    String parentId = this.assigneeChooseMapper.getParentId(deptId);
                    return this.getProcessDefinitionByDeptId(parentId, processKey);
                }
                String procDefId = definitionModels.get(0).getId();
                this.processGroupService.updateProcessGroup(new ProcessGroupInfo().setProcessKey(processKey).setGroupNumber(processGroup.getGroupNumber()).setMainProcDefId(procDefId));
                processDefinition = this.repositoryService.getProcessDefinition(procDefId);
            }
            return processDefinition;
        }
        String parentId = this.assigneeChooseMapper.getParentId(deptId);
        return this.getProcessDefinitionByDeptId(parentId, processKey);
    }
}

