/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.model.AlternativeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.service.IAlternativeTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.model.SysActCcTaskConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.service.ISysActCcTaskConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysBpmService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.model.SysActProcessDept;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.ISysActProcessDeptService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="sysBpmServiceImpl")
public class SysBpmServiceImpl
implements SysBpmService {
    @Resource
    private SysActFormAuthService sysActFormAuthService;
    @Resource
    private SysActAssigneeService sysActAssigneeService;
    @Resource
    private ModelService modelService;
    @Resource
    private ISysActCcTaskConfigService sysActCcTaskConfigService;
    @Resource
    private IAlternativeTaskService alternativeTaskService;
    @Resource
    private ISysActProcessDeptService sysActProcessDeptService;

    public Boolean actFormAuthBatchImport(List<SysActFormAuth> actFormAuths) {
        ArrayList<SysActFormAuth> insertOrUpdateList = new ArrayList<SysActFormAuth>();
        for (SysActFormAuth actFormAuth : actFormAuths) {
            if (HussarUtils.isEmpty((Object)actFormAuth.getProcessKey())) continue;
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)actFormAuth.getProcessKey());
            if (HussarUtils.isNotEmpty((Object)actFormAuth.getTaskDefinitionKey())) {
                queryWrapper.eq(SysActFormAuth::getTaskDefinitionKey, (Object)actFormAuth.getTaskDefinitionKey());
            } else {
                queryWrapper.isNull(SysActFormAuth::getTaskDefinitionKey);
            }
            SysActFormAuth oldActAssignees = (SysActFormAuth)this.sysActFormAuthService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isEmpty((Object)oldActAssignees)) {
                actFormAuth.setId(null);
            } else {
                actFormAuth.setId(oldActAssignees.getId());
            }
            insertOrUpdateList.add(actFormAuth);
        }
        return this.sysActFormAuthService.saveOrUpdateBatch(insertOrUpdateList);
    }

    public Boolean actAssigneeBatchImport(List<SysActAssignee> actAssignees) {
        ArrayList<SysActAssignee> addList = new ArrayList<SysActAssignee>();
        QueryChainWrapper queryWrapper = this.sysActAssigneeService.query();
        for (SysActAssignee sysActAssignee : actAssignees) {
            String procDefKey = sysActAssignee.getProcDefKey();
            String taskDefKey = sysActAssignee.getTaskDefKey();
            String contentType = sysActAssignee.getContentType();
            queryWrapper = (QueryChainWrapper)queryWrapper.or();
            queryWrapper = (QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_KEY", (Object)procDefKey)).eq((Object)"TASK_DEF_KEY", (Object)taskDefKey)).eq((Object)"CONTENT_TYPE", (Object)contentType);
        }
        List sameList = queryWrapper.list();
        ArrayList<SysActAssignee> updateList = new ArrayList<SysActAssignee>();
        for (SysActAssignee sysActAssignee : actAssignees) {
            boolean isadd = true;
            for (SysActAssignee actAssignee : sameList) {
                if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !sysActAssignee.getTaskDefKey().equals(actAssignee.getTaskDefKey()) || !sysActAssignee.getContentType().equals(actAssignee.getContentType())) continue;
                sysActAssignee.setId(actAssignee.getId());
                updateList.add(sysActAssignee);
                isadd = false;
                break;
            }
            if (!isadd) continue;
            addList.add(sysActAssignee);
        }
        Boolean isSave = this.sysActAssigneeService.saveBatch(addList);
        Boolean isUpdate = this.sysActAssigneeService.updateBatchById(updateList);
        boolean result = false;
        if (isSave.booleanValue() && isUpdate.booleanValue()) {
            result = true;
        }
        return result;
    }

    public Boolean actCcTaskConfigBatchImport(List<SysActCcTaskConfig> actCcTaskConfigs) {
        return this.sysActCcTaskConfigService.saveOrUpdateBatch(actCcTaskConfigs);
    }

    public Boolean alternativeTaskBatchImport(List<AlternativeTask> alternativeTasks) {
        ArrayList addList = new ArrayList();
        QueryChainWrapper queryWrapper = this.alternativeTaskService.query();
        for (AlternativeTask alternativeTask2 : alternativeTasks) {
            String processKey = alternativeTask2.getProcessKey();
            Integer version = alternativeTask2.getProcessDefinitionVersion();
            String taskDefinitionKey = alternativeTask2.getTaskDefinitionKey();
            queryWrapper = (QueryChainWrapper)queryWrapper.or();
            queryWrapper = (QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_KEY", (Object)processKey)).eq((Object)"PROC_DEF_VER", (Object)version)).eq((Object)"TASK_DEF_KEY", (Object)taskDefinitionKey);
        }
        List sameList = queryWrapper.list();
        ArrayList updateList = new ArrayList();
        alternativeTasks.forEach(alternativeTask -> {
            boolean isadd = true;
            for (AlternativeTask task : sameList) {
                if (!alternativeTask.getProcessKey().equals(task.getProcessKey()) || !alternativeTask.getProcessDefinitionVersion().equals(task.getProcessDefinitionVersion()) || !alternativeTask.getTaskDefinitionKey().equals(task.getTaskDefinitionKey())) continue;
                alternativeTask.setAlternativeTaskId(task.getAlternativeTaskId());
                updateList.add(alternativeTask);
                isadd = false;
                break;
            }
            if (isadd) {
                addList.add(alternativeTask);
            }
        });
        Boolean isSave = this.alternativeTaskService.saveBatch(addList);
        Boolean isUpdate = this.alternativeTaskService.updateBatchById(updateList);
        return isSave != false && isUpdate != false;
    }

    public Boolean actProcessDeptBatchImport(List<SysActProcessDept> actProcessDepts) {
        ArrayList addList = new ArrayList();
        QueryChainWrapper queryWrapper = this.sysActProcessDeptService.query();
        for (SysActProcessDept sysActProcessDept2 : actProcessDepts) {
            String processKey = sysActProcessDept2.getProcessKey();
            String deptId = sysActProcessDept2.getDeptId();
            queryWrapper = (QueryChainWrapper)queryWrapper.or();
            queryWrapper = (QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROCESS_KEY", (Object)processKey)).eq((Object)"DEPT_ID", (Object)deptId);
        }
        List sameList = queryWrapper.list();
        ArrayList updateList = new ArrayList();
        actProcessDepts.forEach(sysActProcessDept -> {
            boolean isadd = true;
            for (SysActProcessDept activitiDept : sameList) {
                if (!sysActProcessDept.getProcessKey().equals(activitiDept.getProcessKey()) || !sysActProcessDept.getDeptId().equals(activitiDept.getDeptId())) continue;
                sysActProcessDept.setId(activitiDept.getId());
                updateList.add(sysActProcessDept);
                isadd = false;
                break;
            }
            if (isadd) {
                addList.add(sysActProcessDept);
            }
        });
        Boolean isSave = this.sysActProcessDeptService.saveBatch(addList);
        Boolean isUpdate = this.sysActProcessDeptService.updateBatchById(updateList);
        return isSave != false && isUpdate != false;
    }

    public List<SysActFormAuth> actFormAuthExportData(List<String> keys) {
        return this.sysActFormAuthService.list((Wrapper)new LambdaQueryWrapper().in(SysActFormAuth::getProcessKey, keys));
    }

    public List<SysActCcTaskConfig> actCcTaskConfigExportData(List<String> keys) {
        return this.sysActCcTaskConfigService.list((Wrapper)new LambdaQueryWrapper().in(SysActCcTaskConfig::getProcDefKey, keys));
    }

    public List<AlternativeTask> actAlternativeTaskExportData(List<String> keys) {
        return this.alternativeTaskService.list((Wrapper)new LambdaQueryWrapper().in(AlternativeTask::getProcessKey, keys));
    }

    public List<SysActProcessDept> actProcessDeptExportData(List<String> keys) {
        return this.sysActProcessDeptService.list((Wrapper)new LambdaQueryWrapper().in(SysActProcessDept::getProcessKey, keys));
    }

    public List<SysActAssignee> actAssigneeExportData(List<String> keys) {
        return this.sysActAssigneeService.list((Wrapper)new LambdaQueryWrapper().in(SysActAssignee::getProcDefKey, keys));
    }

    public Boolean importModel(String tenantId, File file, List<String> list) {
        return this.modelService.importModel(tenantId, file, list);
    }

    public String exportAllFileModel(String tenantId, String keys, File file) {
        return this.modelService.exportAllFileModel(tenantId, keys, file);
    }

    public void actExtendPropertiesImport(List<SysActExtendProperties> list) {
        for (SysActExtendProperties sysActExtendProperties : list) {
            sysActExtendProperties.insertOrUpdate();
        }
    }

    public List<SysActExtendProperties> actExtendPropertiesExportData(List<String> keys) {
        ArrayList<SysActExtendProperties> list = new ArrayList<SysActExtendProperties>();
        for (String key : keys) {
            List sysActExtendProperties = new SysActExtendProperties().selectList((Wrapper)new LambdaQueryWrapper().like(SysActExtendProperties::getProcDefId, (Object)key));
            if (!HussarUtils.isNotEmpty((Object)sysActExtendProperties)) continue;
            list.addAll(sysActExtendProperties);
        }
        return list;
    }
}

