/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.DownloadFilesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ExportModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.service.IProcessGroupService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.AheadAction;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.PostAction;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.UpdateByteArrayModelMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.model.UpdateByteArrayModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.util.XmlUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ModelServiceImpl
extends ServiceImpl<ModelMapper, ModelBuild>
implements ModelService {
    private static Logger logger = LoggerFactory.getLogger(ModelServiceImpl.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private ModelMapper modelMapper;
    @Resource
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Resource
    private Bpm2XMLMapper bpm2XMLMapper;
    @Resource
    private UpdateByteArrayModelMapper updateByteArrayModelMapper;
    @Autowired
    private IProcessGroupService processGroupService;
    private static final String USERTASK_NAME = "com.jxdinfo.workflow.User";
    private static final String SUFFIX = ".bpmn20.xml";

    public String deployModel(Long modelId, String tenantId, int procVersion) {
        try {
            Model modelData = this.repositoryService.getModel(String.valueOf(modelId));
            byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
            if (bytes == null) {
                logger.error("\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
                return null;
            }
            JsonNode editNode = new ObjectMapper().readTree(bytes);
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editNode);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            String processName = modelData.getName() + SUFFIX;
            Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).tenantId(tenantId).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy(Integer.valueOf(procVersion));
            modelData.setDeploymentId(deployment.getId());
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelData.getKey(), tenantId, Integer.valueOf(procVersion));
            modelData.setCategory(workFlow.getCategory());
            modelData.setBusinessModelId(workFlow.getBusinessModuleId() == null ? null : Long.valueOf(workFlow.getBusinessModuleId()));
            this.repositoryService.saveModel(modelData);
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(modelData.getDeploymentId()).processDefinitionVersion(Integer.valueOf(procVersion)).singleResult();
            this.saveModelExtendProperties(workFlow, processDefinition.getId());
            workFlow.setProcDefId(processDefinition.getId());
            this.sysActProcessFileService.updateFile(workFlow, tenantId);
            return processDefinition.getId();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String deployModel(String modelId, String tenantId) {
        return this.deployModel(Long.parseLong(modelId), tenantId, 0);
    }

    public ModelBuild queryModel(Long modelId) {
        return this.modelMapper.queryModel(modelId);
    }

    public ModelBuild queryModel(String modelId) {
        return this.modelMapper.queryModel(Long.parseLong(modelId));
    }

    public List<ModelBuild> queryModelByTag(String tag) {
        return this.modelMapper.queryModelByTage(tag);
    }

    public void addNodeSaveModelExtendProperties(WorkFlow workFlow, String processDefId) {
        this.saveModelExtendProperties(workFlow, processDefId);
    }

    public void deployModelByWorkFlowXml(WorkFlow workFlow, BpmnModel bpmnModel, String modelId, String tenantId, String processInsId, String version) {
        Model modelData = this.repositoryService.getModel(modelId);
        String processName = modelData.getName() + SUFFIX;
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).tenantId(tenantId).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy(false);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        this.saveModelExtendProperties(workFlow, processDefinition.getId());
        workFlow.setProcDefId(processDefinition.getId());
        this.sysActProcessFileService.addFile(workFlow, tenantId);
        this.processDefinitionsService.setVersionTemporary(processDefinition.getId());
        this.saveProcessExtendProperties(processDefinition.getId(), workFlow);
        this.processDefinitionsService.editTemporaryDefId(processDefinition.getId(), processInsId, version);
        this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processDefinition.getId()));
    }

    private void saveModelExtendProperties(WorkFlow workFlow, String processId) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List flowObjects = flowModel.getSlots().getElement() != null ? flowModel.getSlots().getElement() : new ArrayList();
        ArrayList<Object> sysActExtendProperties = new ArrayList<Object>();
        for (FlowObject flowObject : flowObjects) {
            AheadAction aheadAction;
            if (!USERTASK_NAME.equals(flowObject.getName())) continue;
            FlowProps flowProps = flowObject.getProps();
            SysActExtendProperties approvalExtends = new SysActExtendProperties();
            approvalExtends.setApprovalType(flowProps.getApprovalType());
            approvalExtends.setAdaptApprover(flowProps.getAdaptApprover());
            approvalExtends.setAddApprovalNode(flowProps.getAddApprovalNode());
            approvalExtends.setSetApprovalRemind(flowProps.getSetApprovalRemind());
            approvalExtends.setInitApprovalDisplay(flowProps.getInitApprovalDisplay());
            approvalExtends.setAddApprovalNodeAfterOther(flowProps.getAddApprovalNodeAfterOther());
            approvalExtends.setAdaptSubsequentApprover(flowProps.getAdaptSubsequentApprover());
            approvalExtends.setTaskDefKey(flowObject.getInstanceKey());
            approvalExtends.setTaskDefName(flowProps.getFlowName());
            approvalExtends.setAllowEditForm(flowProps.getAllowEditForm());
            approvalExtends.setProcDefId(processId);
            approvalExtends.setAllowAlterTaskToOther(flowProps.getAllowAlterTaskToOther());
            approvalExtends.setAllowAlterTask(flowProps.getAllowAlterTask());
            approvalExtends.setAlterNodeRelation(flowProps.getAlterNodeRelation());
            approvalExtends.setAttachmentType(flowProps.getAttachmentType());
            approvalExtends.setNumberOfAttachment(flowProps.getNumberOfAttachment());
            approvalExtends.setApproveOption(flowProps.getApproveOption());
            approvalExtends.setNumberOfApprover(flowProps.getNumberOfApprover());
            PostAction postAction = flowProps.getPostAction();
            if (postAction != null && (aheadAction = postAction.getAheadAction()) != null) {
                if (aheadAction.getFormAddress() != null) {
                    approvalExtends.setAheadActionFormAddress(aheadAction.getFormAddress().get((Object)"url") != null ? JSON.toJSONString((Object)aheadAction.getFormAddress().get((Object)"url")) : null);
                    approvalExtends.setAheadActionFormName(aheadAction.getFormAddress().get((Object)"desc") != null ? String.valueOf(aheadAction.getFormAddress().get((Object)"desc")) : null);
                }
                approvalExtends.setAheadActionFormType(aheadAction.getFormType());
                approvalExtends.setAheadActionIsUsed(aheadAction.getUsed() != null ? aheadAction.getUsed() : false);
            }
            JSONObject jSONObject = flowProps.getFormAddress();
            JSONObject object = new JSONObject();
            if (jSONObject != null) {
                for (String key : jSONObject.keySet()) {
                    object.put(key, jSONObject.getJSONObject(key).get((Object)"url"));
                }
            }
            approvalExtends.setFormDetailKey(jSONObject != null ? JSON.toJSONString((Object)object) : null);
            sysActExtendProperties.add(approvalExtends);
        }
        if (!sysActExtendProperties.isEmpty()) {
            ArrayList<SysActExtendProperties> addList = new ArrayList<SysActExtendProperties>();
            ArrayList<SysActExtendProperties> updateList = new ArrayList<SysActExtendProperties>();
            QueryChainWrapper queryWrapper = this.iSysActExtendPropertiesService.query();
            for (SysActExtendProperties sysActExtendProperties2 : sysActExtendProperties) {
                String string = sysActExtendProperties2.getProcDefId();
                String taskDefKey = sysActExtendProperties2.getTaskDefKey();
                queryWrapper = (QueryChainWrapper)queryWrapper.or();
                queryWrapper = (QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_ID", (Object)string)).eq((Object)"TASK_DEF_KEY", (Object)taskDefKey);
            }
            List sameList = queryWrapper.list();
            for (SysActExtendProperties sysActExtendProperties3 : sysActExtendProperties) {
                boolean isadd = true;
                for (SysActExtendProperties actExtendProperties : sameList) {
                    if (!sysActExtendProperties3.getProcDefId().equals(actExtendProperties.getProcDefId()) || !sysActExtendProperties3.getTaskDefKey().equals(actExtendProperties.getTaskDefKey())) continue;
                    sysActExtendProperties3.setId(actExtendProperties.getId());
                    updateList.add(sysActExtendProperties3);
                    isadd = false;
                    break;
                }
                if (!isadd) continue;
                addList.add(sysActExtendProperties3);
            }
            this.iSysActExtendPropertiesService.saveBatch(addList);
            this.iSysActExtendPropertiesService.updateBatchById(updateList);
        }
    }

    private void saveProcessExtendProperties(String processId, WorkFlow workFlow) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        FlowProps flowProps = flowModel.getProps();
        ProcessExtendProperties processExtendProperties = new ProcessExtendProperties();
        processExtendProperties.setAllowNullApprover(flowProps.getAllowNullApprover());
        processExtendProperties.setCopyAttachmentAtRectification(flowProps.getCopyAttachmentAtRectification());
        processExtendProperties.setMustUploadAttachment(flowProps.getMustUploadAttachment());
        processExtendProperties.setRuleOfHiApproverAtApproval(Integer.valueOf(flowProps.getRuleOfHiApproverAtApproval()));
        processExtendProperties.setRectificationBeanId(flowProps.getRectificationBeanId());
        JSONObject viewFormAddressJsonObject = JSON.parseObject((String)flowProps.getFlowFormDetailAddress());
        JSONObject viewFormAddressObject = new JSONObject();
        if (viewFormAddressJsonObject != null) {
            for (String key : viewFormAddressJsonObject.keySet()) {
                viewFormAddressObject.put(key, viewFormAddressJsonObject.getJSONObject(key).get((Object)"url"));
            }
        }
        processExtendProperties.setViewFormAddress(viewFormAddressJsonObject != null ? JSON.toJSONString((Object)viewFormAddressObject) : null);
        JSONObject editFormAddressJsonObject = JSON.parseObject((String)flowProps.getFlowFormAddress());
        JSONObject editFormAddressObject = new JSONObject();
        if (editFormAddressJsonObject != null) {
            for (String key : editFormAddressJsonObject.keySet()) {
                editFormAddressObject.put(key, editFormAddressJsonObject.getJSONObject(key).get((Object)"url"));
            }
        }
        processExtendProperties.setEditFormAddress(editFormAddressJsonObject != null ? JSON.toJSONString((Object)editFormAddressObject) : null);
        this.processDefinitionsService.setProcessExtendProperties(processId, processExtendProperties);
    }

    private String getFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue();
    }

    public IPage<ModelBuild> queryModelList(String modelName, Page<ModelBuild> page) {
        try {
            List<ModelBuild> list = this.modelMapper.queryModelList(page, modelName);
            page.setRecords(list);
            return page;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }

    public IPage<ModelBuild> queryModelLists(String modelName, String businessModuleId, Page<ModelBuild> page) {
        try {
            List<ModelBuild> list = this.modelMapper.queryModelLists(page, modelName, businessModuleId);
            page.setRecords(list);
            return page;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }

    public ApiResponse<String> deleteModel(String tenantId, Long modelId) {
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(modelId, null))) {
            String processKey = this.modelMapper.getIdentityById(modelId);
            this.repositoryService.deleteModel(String.valueOf(modelId));
            this.sysActAssigneeService.delAssignee(processKey);
            this.modelMapper.deleteModelDef(modelId, null);
            this.sysActProcessFileService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getModelId, (Object)modelId));
            this.processGroupService.deleteProcessModel(processKey);
            return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        throw new PublicClientException(BpmEnum.DELETE_RUNNING_FAIL.getMessage());
    }

    public ApiResponse<String> deleteModel(String tenantId, String modelId) {
        return this.deleteModel(tenantId, Long.parseLong(modelId));
    }

    public ApiResponse<String> deleteModelWithVersion(String tenantId, String processDefId) {
        String procDefKey = processDefId.split(":")[0];
        this.processDefinitionsService.canModelDeleteWithVersion(procDefKey);
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(null, processDefId))) {
            this.processGroupService.canDeleteProcess(procDefKey, processDefId, () -> {
                this.modelMapper.deleteModelDef(null, processDefId);
                this.sysActProcessFileService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)processDefId));
                return true;
            });
            return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        throw new PublicClientException(BpmEnum.DELETE_RUNNING_FAIL.getMessage());
    }

    public ApiResponse<String> deleteModelByLogic(Long modelId, String isDelete) {
        String message = "";
        message = this.modelMapper.updateIsDelete(modelId, isDelete) > 0 ? BpmEnum.DELETE_SUCCESS.getMessage() : BpmEnum.DELETE_FAIL.getMessage();
        return ApiResponse.success((String)message);
    }

    public ApiResponse<String> deleteModelWithVersionByLogic(String tenantId, String processDefId, String isDeleteVersion) {
        String message = "";
        message = this.processGroupService.canDeleteProcess(null, processDefId, () -> this.modelMapper.updateIsDeleteVersion(processDefId, isDeleteVersion) > 0) ? BpmEnum.DELETE_SUCCESS.getMessage() : BpmEnum.DELETE_FAIL.getMessage();
        return ApiResponse.success((String)message);
    }

    public String getIdByIdentity(String identity) {
        return this.modelMapper.getIdByIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> unZipFile(String zipFile, String filePath, HttpServletRequest request) {
        String clientChartSet = request.getCharacterEncoding();
        ArrayList<String> resultList = new ArrayList<String>();
        InputStream in = null;
        OutputStream out = null;
        try {
            File pathFile = new File(filePath);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            long time = System.currentTimeMillis();
            ZipFile zip = new ZipFile(zipFile, "UTF-8");
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String zipEntryName = entry.getName();
                in = zip.getInputStream(entry);
                String outPath = (filePath + time + File.separator + new String(zipEntryName.getBytes(clientChartSet))).replaceAll("\\*", File.separator);
                File file = new File(outPath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                resultList.add(outPath);
                out = new FileOutputStream(outPath);
                byte[] buf1 = new byte[1024];
                while ((len = in.read(buf1)) > 0) {
                    out.write(buf1, 0, len);
                }
                in.close();
                out.close();
            }
            zip.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return resultList;
    }

    private List<String> getAllFile(File file) {
        if (file == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!file.exists()) {
            return list;
        }
        for (File f : file.listFiles()) {
            String suffix;
            if (f.isDirectory()) {
                list.addAll(this.getAllFile(f));
                continue;
            }
            if (f.getPath().lastIndexOf(46) <= 0 || !"xml".equals(suffix = f.getPath().substring(f.getPath().lastIndexOf(46) + 1)) && !"lcdpbpm".equals(suffix)) continue;
            list.add(f.getPath());
        }
        return list;
    }

    public List<ModelBuild> getAllModel() {
        return this.modelMapper.getAllModel();
    }

    public ApiResponse<String> importModel(String tenantId, MultipartFile file, HttpServletRequest request) {
        InputStream in = null;
        FileOutputStream out = null;
        String fileName = System.currentTimeMillis() + ".zip";
        try {
            in = file.getInputStream();
            File files = new File(this.hussarConfig.getFileUploadPath() + File.separator + fileName);
            if (!files.getParentFile().exists()) {
                files.getParentFile().mkdirs();
            }
            try {
                boolean isCreateNewFile = files.createNewFile();
                if (!isCreateNewFile) {
                    logger.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
                    throw new PublicClientException(BpmEnum.UPLOAD_PATH_ERROR.getMessage());
                }
            }
            catch (IOException e) {
                throw new PublicClientException(BpmEnum.UPLOAD_PATH_ERROR.getMessage());
            }
            out = new FileOutputStream(files);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
            in.close();
            List<String> fileList = this.unZipFile(this.hussarConfig.getFileUploadPath() + File.separator + fileName, this.hussarConfig.getFileUploadPath(), request);
            for (String s : fileList) {
                if ("xml".equals(s.substring(s.length() - 3))) continue;
                files = new File(s);
                Map map = (Map)JSON.parseObject((String)FileUtils.readFileToString((File)files, (String)"UTF-8"), Map.class);
                if (!HussarUtils.equals((Object)"lcdpbpm", map.get("export_type"))) {
                    logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u538b\u7f29\u6587\u4ef6");
                    throw new PublicClientException(BpmEnum.ERROR_IMPORT.getMessage());
                }
                JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(map.get("file")));
                ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
                ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
                for (Object o : jsonArray) {
                    SysActProcessFile sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class);
                    SysActProcessFile oldSysActProcessFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)sysActProcessFile.getProcessKey())).eq(SysActProcessFile::getType, (Object)sysActProcessFile.getType()));
                    if (HussarUtils.isNotEmpty((Object)oldSysActProcessFile)) {
                        sysActProcessFile.setId(oldSysActProcessFile.getId());
                    } else {
                        sysActProcessFile.setId(null);
                    }
                    sysActProcessFile.setVersion(Integer.valueOf(0));
                    sysActProcessFile.setTenantId(tenantId);
                    if ("wfd".equals(sysActProcessFile.getType())) {
                        wfdList.add(sysActProcessFile);
                        continue;
                    }
                    metaList.add(sysActProcessFile);
                }
                ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
                addList.addAll(wfdList);
                addList.addAll(metaList);
                this.sysActProcessFileService.saveOrUpdateBatch(addList);
            }
            for (String s : fileList) {
                if (!"xml".equals(s.substring(s.length() - 3))) continue;
                in = new FileInputStream(s);
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                XMLStreamReader xtr = xif.createXMLStreamReader(in);
                BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
                String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
                String identityId = this.modelMapper.getIdByIdentity(modelKey);
                Model modelData = null;
                if (HussarUtils.isEmpty((Object)identityId)) {
                    modelData = this.repositoryService.newModel();
                    ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                    modelObjectNode.put("name", impModelName);
                    modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                    modelObjectNode.put("revision", 1);
                    modelData.setMetaInfo(modelObjectNode.toString());
                    modelData.setName(impModelName);
                    modelData.setKey(modelKey);
                    modelData.setTenantId(tenantId);
                    this.repositoryService.saveModel(modelData);
                }
                ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
                jsonConverter.updateConvertersToBpmnMap();
                jsonConverter.updateConvertersToJsonMap();
                ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
                identityId = identityId == null ? modelData.getId() : identityId;
                this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
                WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelKey, tenantId, Integer.valueOf(0));
                workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
                this.deployModel(Long.parseLong(identityId), tenantId, Integer.parseInt(workFlow.getVersion()));
            }
            ApiResponse apiResponse = ApiResponse.success((String)BpmEnum.IMPORT_SUCCESS.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(BpmEnum.ERROR_IMPORT.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean importModel(String tenantId, File file, List<String> coverList) {
        InputStream in = null;
        try {
            File f = null;
            List<String> fileList = this.getAllFile(file);
            if (fileList == null) {
                logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u6587\u4ef6");
                throw new NullPointerException("\u9519\u8bef\u6587\u4ef6\u5939");
            }
            for (String s : fileList) {
                if ("xml".equals(s.substring(s.length() - 3))) continue;
                f = new File(s);
                Map map = (Map)JSON.parseObject((String)FileUtils.readFileToString((File)f, (String)"UTF-8"), Map.class);
                if (!HussarUtils.equals((Object)"lcdpbpm", map.get("export_type"))) {
                    logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u6587\u4ef6");
                    Boolean bl = false;
                    return bl;
                }
                JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(map.get("file")));
                ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
                ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
                if (!HussarUtils.isNotEmpty((Object)jsonArray)) continue;
                for (Object o : jsonArray) {
                    SysActProcessFile sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class);
                    SysActProcessFile oldSysActProcessFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)sysActProcessFile.getProcessKey())).eq(SysActProcessFile::getType, (Object)sysActProcessFile.getType()));
                    if (HussarUtils.isNotEmpty((Object)oldSysActProcessFile)) {
                        sysActProcessFile.setId(oldSysActProcessFile.getId());
                    } else {
                        sysActProcessFile.setId(null);
                    }
                    sysActProcessFile.setVersion(Integer.valueOf(0));
                    sysActProcessFile.setTenantId(tenantId);
                    if ("wfd".equals(sysActProcessFile.getType())) {
                        wfdList.add(sysActProcessFile);
                        continue;
                    }
                    metaList.add(sysActProcessFile);
                }
                ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
                addList.addAll(wfdList);
                addList.addAll(metaList);
                this.sysActProcessFileService.saveOrUpdateBatch(addList);
            }
            for (String s : fileList) {
                if (!"xml".equals(s.substring(s.length() - 3))) continue;
                in = new FileInputStream(s);
                try {
                    XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                    XMLStreamReader xtr = xif.createXMLStreamReader(in);
                    BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                    String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
                    String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
                    String identityId = this.modelMapper.getIdByIdentity(modelKey);
                    if (HussarUtils.isNotEmpty((Object)identityId)) {
                        if (HussarUtils.isNotEmpty(coverList.stream().filter(modelKey::equals).findFirst().orElse(null))) {
                            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
                            updateByteArrayModel.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
                            updateByteArrayModel.setId(this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId)));
                            this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
                            continue;
                        }
                    }
                    if (HussarUtils.isEmpty((Object)identityId)) {
                        Model modelData = this.repositoryService.newModel();
                        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                        modelObjectNode.put("name", impModelName);
                        modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                        modelObjectNode.put("revision", 1);
                        modelData.setMetaInfo(modelObjectNode.toString());
                        modelData.setName(impModelName);
                        modelData.setKey(modelKey);
                        this.repositoryService.saveModel(modelData);
                        identityId = modelData.getId();
                    }
                    ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
                    jsonConverter.updateConvertersToBpmnMap();
                    jsonConverter.updateConvertersToJsonMap();
                    ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
                    this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
                    WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelKey, tenantId, Integer.valueOf(0));
                    if (workFlow == null) {
                        logger.error("{} \u6570\u636e\u7f3a\u5931", (Object)modelKey);
                        throw new NullPointerException(modelKey + "\u6570\u636e\u7f3a\u5931");
                    }
                    workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
                    this.sysActProcessFileService.updateFile(workFlow, tenantId);
                    this.deployModel(Long.parseLong(identityId), tenantId, Integer.parseInt(workFlow.getVersion()));
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String exportAllFileModel(String tenantId, String keys, File file) {
        ByteArrayInputStream in = null;
        List<ExportModel> models = this.modelMapper.getModelWithKey(Arrays.asList(keys.split(",")));
        if (HussarUtils.isEmpty(models)) {
            return file.getPath();
        }
        try {
            HashMap fileMap = new HashMap();
            for (ExportModel model : models) {
                if (HussarUtils.isEmpty((Object)model.getDeploymentId())) continue;
                ArrayList files = new ArrayList();
                if (HussarUtils.isNotEmpty(fileMap.get(model.getName()))) {
                    files.addAll((Collection)fileMap.get(model.getName()));
                }
                fileMap.put(model.getName(), files);
                in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(model.getDeploymentId(), model.getName() + SUFFIX);
                String filename = model.getName() + "_" + model.getBusinessId() + "/" + model.getName() + "_" + model.getDeploymentId() + SUFFIX;
                File xmlFile = new File(file, filename);
                FileUtils.copyInputStreamToFile((InputStream)in, (File)xmlFile);
                in.close();
            }
            List list = null;
            list = this.sysActProcessFileService.exportFileListByKeys(Arrays.asList(keys.split(",")), tenantId);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("file", list);
            data.put("export_type", "lcdpbpm");
            File lcdpbpm = new File(file, "workflow_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss_SSS") + ".lcdpbpm");
            if (!lcdpbpm.isFile()) {
                try {
                    FileUtils.write((File)lcdpbpm, (CharSequence)JSON.toJSONString(data), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return file.getPath();
    }

    public Map<String, byte[]> exportModel(List<String> processDefinitionIds) {
        HashMap<String, byte[]> models = new HashMap<String, byte[]>();
        processDefinitionIds.forEach(o -> {
            try {
                InputStream inputStream = this.repositoryService.getProcessModel(String.valueOf(o));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                int length = 0;
                byte[] bytes = new byte[1024];
                while ((length = inputStream.read(bytes)) != -1) {
                    byteArrayOutputStream.write(bytes, 0, length);
                }
                if (byteArrayOutputStream.size() != 0) {
                    models.put(String.valueOf(o), byteArrayOutputStream.toByteArray());
                }
                inputStream.close();
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return models;
    }

    public void exportAllFileModel(String tenantId, String modelId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        ZipOutputStream zipOutputStream = null;
        ByteArrayInputStream in = null;
        List<String> str = Arrays.asList(modelId.split(","));
        List<Long> cdids = str.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List<ExportModel> models = this.modelMapper.getModelWithVersion(cdids);
        try {
            response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
            response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
            HashMap fileMap = new HashMap();
            zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
            for (ExportModel model : models) {
                ArrayList files = new ArrayList();
                if (HussarUtils.isNotEmpty(fileMap.get(model.getName()))) {
                    files.addAll((Collection)fileMap.get(model.getName()));
                }
                fileMap.put(model.getName(), files);
                in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(model.getDeploymentId(), model.getName() + SUFFIX);
                String filename = model.getName() + "_" + model.getBusinessId() + "/" + model.getName() + "_" + model.getDeploymentId() + SUFFIX;
                ZipEntry zipEntry = new ZipEntry(filename);
                zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
                IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
                in.close();
            }
            this.toFileZip(tenantId, modelId, null, zipOutputStream);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFileZip(String tenantId, String modelId, String procId, ZipOutputStream out) {
        List list;
        ZipOutputStream zipOutputStream = null;
        if (HussarUtils.isNotEmpty((Object)modelId)) {
            List<String> models = Arrays.asList(modelId.split(","));
            list = this.sysActProcessFileService.exportFileList(models, tenantId);
        } else {
            list = this.sysActProcessFileService.exportFile(procId, tenantId);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("file", list);
        data.put("export_type", "lcdpbpm");
        zipOutputStream = out;
        try {
            zipOutputStream.putNextEntry((java.util.zip.ZipEntry)new ZipEntry("workflow_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".lcdpbpm"));
            ByteArrayInputStream in = new ByteArrayInputStream(JSON.toJSONBytes(data, (SerializerFeature[])new SerializerFeature[0]));
            IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
            in.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public ApiResponse<String> validationProcess(String processKey, String businessId, String userId, Map<String, Object> variables, String tenantId) {
        BpmResponseResult startResult;
        String newUserId = userId;
        if (HussarUtils.isEmpty((Object)userId)) {
            newUserId = "superadmin";
        }
        if (HussarUtils.equals((Object)"0", (Object)(startResult = this.instanceEngineService.validationStartProcess(processKey, newUserId, businessId, tenantId, variables)).getCode())) {
            throw new PublicClientException(startResult.getMsg());
        }
        return this.complete(startResult, variables, true);
    }

    private ApiResponse<String> complete(BpmResponseResult bpmResponseResult, Map<String, Object> variables, boolean isStart) {
        for (int i = 0; i < bpmResponseResult.getResult().size(); ++i) {
            BpmResponseResult completeResult;
            String taskDefinitionName = bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskDefinitionName").toString();
            if (HussarUtils.equals((Object)"\u7ed3\u675f", (Object)taskDefinitionName)) {
                return ApiResponse.success((Object)"", (String)BpmEnum.PROCESS_END.getMessage());
            }
            ArrayList<String> userIdList = new ArrayList<String>((HashSet)bpmResponseResult.getResult().getJSONObject(i).get((Object)"userId"));
            String taskId = bpmResponseResult.getResult().getJSONObject(i).get((Object)"taskId").toString();
            if (userIdList.isEmpty()) {
                if (isStart) {
                    userIdList.add("superadmin");
                } else {
                    throw new PublicClientException("'" + taskDefinitionName + "'\u8282\u70b9\u6ca1\u6709\u53c2\u4e0e\u8005");
                }
            }
            if (HussarUtils.equals((Object)"0", (Object)(completeResult = this.taskEngineService.completeTask(taskId, (String)userIdList.get(0), variables, true)).getCode())) {
                throw new PublicClientException(completeResult.getMsg());
            }
            this.complete(completeResult, variables, false);
        }
        return ApiResponse.success((Object)"", (String)"");
    }

    public ApiResponse<JSONArray> doneList(String businessId, String tenantId) {
        BpmResponseResult bpmResponseResult = this.instanceEngineService.getDoneProcessTrace(businessId, tenantId);
        if (HussarUtils.equals((Object)bpmResponseResult.getCode(), (Object)"1")) {
            return ApiResponse.success((Object)bpmResponseResult.getResult());
        }
        throw new PublicClientException(bpmResponseResult.getMsg());
    }

    public String getRealVersion(String processDefId) {
        return this.modelMapper.getRealVersion(processDefId);
    }

    public String getRealProcessDefinitionId(String processKey, String realVersion) {
        return this.modelMapper.getRealProcessDefinitionId(processKey, realVersion);
    }

    public String getServiceName(String processKey) {
        return this.modelMapper.getServiceName(processKey).get(0);
    }

    public int updateCategory(String identity, String category) {
        return this.modelMapper.updateCategory(identity, category);
    }

    public void downloadFiles(DownloadFilesDto downloadFilesDto, HttpServletResponse response) {
        String tenantId = BaseSecurityUtil.getUser().getStringTenantId();
        String deploymentId = downloadFilesDto.getDeploymentId() == null ? "" : downloadFilesDto.getDeploymentId();
        String resourceName = downloadFilesDto.getResourceName() == null ? "" : downloadFilesDto.getResourceName();
        DefinitionModel processDefinitionModel = this.processDefinitionsMapper.getById(deploymentId);
        String key = processDefinitionModel.getId();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
        response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
        HashMap fileMap = new HashMap();
        ArrayList files = new ArrayList();
        fileMap.put(processDefinitionModel.getName(), files);
        String filename = processDefinitionModel.getName() + "_" + key.split(":")[0] + "/" + key.replace(":", "_") + SUFFIX;
        ZipEntry zipEntry = new ZipEntry(filename);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
             ByteArrayInputStream in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(deploymentId, resourceName);){
            zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
            IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
            this.toFileZip(tenantId, null, key, zipOutputStream);
        }
        catch (IOException e) {
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }

    public Map<String, String> selectModelNames(List<String> processKey) {
        List<ExportModel> nameList = this.modelMapper.selectModelNames(processKey);
        HashMap<String, String> modelNames = new HashMap<String, String>();
        for (ExportModel exportModel : nameList) {
            modelNames.put(exportModel.getBusinessId(), exportModel.getName());
        }
        return modelNames;
    }
}

