/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmFormdesignProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.AdjustWorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.ISysActProcessDeptService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.ProcessGroupInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.model.ProcessGroup;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.service.IProcessGroupService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.AheadAction;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowFunctionConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.PostAction;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.Bpm2XMLService;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.manage.bpm.model.service.GodAxeModelService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.EngineServices;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GodAxeModelServiceImpl
implements GodAxeModelService {
    private static final Logger logger = LoggerFactory.getLogger(GodAxeModelServiceImpl.class);
    private static final String USERTASK_NAME = "com.jxdinfo.workflow.User";
    private Bpm2XMLService bpm2XMLService;
    private RepositoryService repositoryService;
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    private BpmConstantProperties bpmConstantProperties;
    private ModelService modelService;
    private SysActProcessFileService sysActProcessFileService;
    private ProcessDefinitionsService processDefinitionsService;
    private ITaskEngineService taskEngineService;
    private LcdpBpmProperties lcdpBpmProperties;
    private SysActAssigneeService sysActAssigneeService;
    private SysActFormAuthService sysActFormAuthService;
    private BpmFormdesignProperties bpmFormdesignProperties;
    private ISysActProcessDeptService iSysActProcessDeptService;
    @Autowired
    private IProcessGroupService processGroupService;
    @Autowired
    private EngineServices engineServices;

    @Autowired
    public GodAxeModelServiceImpl(Bpm2XMLService bpm2XMLService, ModelService modelService, RepositoryService repositoryService, SysActProcessFileService sysActProcessFileService, BpmConstantProperties bpmConstantProperties, ProcessDefinitionsService processDefinitionsService, ISysActExtendPropertiesService iSysActExtendPropertiesService, ITaskEngineService iTaskEngineService, LcdpBpmProperties lcdpBpmProperties, SysActAssigneeService sysActAssigneeService, SysActFormAuthService sysActFormAuthService, BpmFormdesignProperties bpmFormdesignProperties, ISysActProcessDeptService iSysActProcessDeptService) {
        this.bpm2XMLService = bpm2XMLService;
        this.modelService = modelService;
        this.repositoryService = repositoryService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.bpmConstantProperties = bpmConstantProperties;
        this.processDefinitionsService = processDefinitionsService;
        this.iSysActExtendPropertiesService = iSysActExtendPropertiesService;
        this.taskEngineService = iTaskEngineService;
        this.lcdpBpmProperties = lcdpBpmProperties;
        this.sysActAssigneeService = sysActAssigneeService;
        this.sysActFormAuthService = sysActFormAuthService;
        this.bpmFormdesignProperties = bpmFormdesignProperties;
        this.iSysActProcessDeptService = iSysActProcessDeptService;
    }

    public ApiResponse<String> saveAndPublish(WorkFlow workFlow, String tenantId, boolean isOverride) {
        return this.saveWorkflow(workFlow, tenantId, true, isOverride);
    }

    public ApiResponse<Integer> getLatestVersion(String processKey) {
        return ApiResponse.success((Object)this.sysActProcessFileService.getLatestVersion(processKey));
    }

    public ApiResponse<Boolean> existDuplicateProcessKey(String processKey) {
        return ApiResponse.success((Object)this.sysActProcessFileService.existDuplicateProcessKey(processKey));
    }

    public void saveAssignee(WorkFlow workFlow) {
        int procVersion = Integer.parseInt(workFlow.getVersion());
        if (this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            String identityKey = workFlow.getIdentity();
            if (HussarUtils.isEmpty((Object)workFlow.getData())) {
                return;
            }
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
            if (HussarUtils.isEmpty((Object)flowModel.getSlots())) {
                return;
            }
            List flowObjects = flowModel.getSlots().getElement() != null ? flowModel.getSlots().getElement() : new ArrayList();
            List flowSequences = flowModel.getSlots().getPath() != null ? flowModel.getSlots().getPath() : new ArrayList();
            String startTaskKey = null;
            block0: for (Object flowObject : flowObjects) {
                if (!"com.jxdinfo.workflow.Start".equals(flowObject.getName())) continue;
                String outPath = (String)flowObject.getGoOutPathes().get(0);
                for (FlowSequence flowSequence : flowSequences) {
                    if (!outPath.equals(flowSequence.getInstanceKey())) continue;
                    startTaskKey = flowSequence.getEnd().getKey();
                    break block0;
                }
            }
            ArrayList<SysActAssignee> list = new ArrayList<SysActAssignee>();
            for (FlowObject flowObject : flowObjects) {
                if (!USERTASK_NAME.equals(flowObject.getName())) continue;
                if (flowObject.getInstanceKey().equals(startTaskKey)) {
                    SysActAssignee startTaskModel = new SysActAssignee();
                    startTaskModel.setProcDefKey(identityKey);
                    startTaskModel.setContentType("defaultAssign");
                    startTaskModel.setMessageType(flowObject.getProps().getMessageType());
                    list.add(startTaskModel);
                }
                List flowFunctionConfigs = flowObject.getProps().getFlowFunctionConfig();
                HashMap<String, String> functionMap = new HashMap<String, String>();
                if (HussarUtils.isNotEmpty((Object)flowFunctionConfigs)) {
                    Iterator iterator = flowFunctionConfigs.iterator();
                    while (iterator.hasNext()) {
                        FlowFunctionConfig flowFunctionConfig = (FlowFunctionConfig)iterator.next();
                        functionMap.put(flowFunctionConfig.getId(), flowFunctionConfig.getValue().substring(2, flowFunctionConfig.getValue().length() - 2));
                    }
                }
                SysActAssignee assigneeModel = new SysActAssignee();
                assigneeModel.setProcDefKey(identityKey);
                assigneeModel.setContentType("assign_model");
                assigneeModel.setTaskDefKey(flowObject.getInstanceKey());
                assigneeModel.setMessageType(flowObject.getProps().getMessageType());
                assigneeModel.setContent(JSON.toJSONString((Object)flowObject.getProps().getFlowAssignment()).getBytes(StandardCharsets.UTF_8));
                list.add(assigneeModel);
                SysActAssignee ccAssigneeModel = new SysActAssignee();
                ccAssigneeModel.setProcDefKey(identityKey);
                ccAssigneeModel.setContentType("cc_assign_model");
                ccAssigneeModel.setTaskDefKey(flowObject.getInstanceKey());
                ccAssigneeModel.setContent(JSON.toJSONString((Object)flowObject.getProps().getFlowRecipients()).getBytes(StandardCharsets.UTF_8));
                list.add(ccAssigneeModel);
                SysActAssignee modelAssignee = new SysActAssignee();
                modelAssignee.setProcDefKey(identityKey);
                modelAssignee.setContentType("defaultAssign");
                modelAssignee.setMessageType(flowObject.getProps().getMessageType());
                modelAssignee.setTaskDefKey(flowObject.getInstanceKey());
                String assignee = flowObject.getProps().getFlowAssignment().getDefaultBackCondtion();
                if (HussarUtils.isNotEmpty((Object)assignee)) {
                    for (Map.Entry entry : functionMap.entrySet()) {
                        assignee = assignee.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    }
                }
                modelAssignee.setContent(assignee == null ? "".getBytes(StandardCharsets.UTF_8) : assignee.getBytes(StandardCharsets.UTF_8));
                list.add(modelAssignee);
                SysActAssignee conditionAssignee = new SysActAssignee();
                conditionAssignee.setProcDefKey(identityKey);
                conditionAssignee.setContentType("conditionAssign");
                conditionAssignee.setMessageType(flowObject.getProps().getMessageType());
                conditionAssignee.setTaskDefKey(flowObject.getInstanceKey());
                List judgeBackConditions = flowObject.getProps().getFlowAssignment().getJudgeBackCondition();
                String condAssignee = null;
                if (HussarUtils.isNotEmpty((Object)judgeBackConditions)) {
                    HashMap<String, String> condition = new HashMap<String, String>();
                    for (JudgeBackCondition judgeBackCondition : judgeBackConditions) {
                        condition.put(judgeBackCondition.getConditionBackExpression(), judgeBackCondition.getJudgeSpellCondition());
                    }
                    condAssignee = JSON.toJSONString(condition);
                    if (HussarUtils.isNotEmpty((Object)condAssignee)) {
                        for (Map.Entry entry : functionMap.entrySet()) {
                            condAssignee = condAssignee.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                        }
                    }
                }
                conditionAssignee.setContent(condAssignee == null ? "".getBytes(StandardCharsets.UTF_8) : condAssignee.getBytes(StandardCharsets.UTF_8));
                list.add(conditionAssignee);
                SysActAssignee ccAssignee = new SysActAssignee();
                ccAssignee.setProcDefKey(identityKey);
                ccAssignee.setContentType("defaultCcAssign");
                ccAssignee.setTaskDefKey(flowObject.getInstanceKey());
                String ccAssigneeValue = flowObject.getProps().getFlowRecipients().getDefaultCcCondtion();
                if (HussarUtils.isNotEmpty((Object)ccAssigneeValue)) {
                    for (Map.Entry entry2 : functionMap.entrySet()) {
                        ccAssigneeValue = ccAssigneeValue.replace((CharSequence)entry2.getKey(), (CharSequence)entry2.getValue());
                    }
                }
                ccAssignee.setContent(ccAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccAssigneeValue.getBytes(StandardCharsets.UTF_8));
                list.add(ccAssignee);
                SysActAssignee sysActAssignee = new SysActAssignee();
                sysActAssignee.setProcDefKey(identityKey);
                sysActAssignee.setContentType("conditionCcAssign");
                sysActAssignee.setTaskDefKey(flowObject.getInstanceKey());
                List judgeCcBackConditions = flowObject.getProps().getFlowRecipients().getJudgeCcCondition();
                String ccConditionAssigneeValue = null;
                if (HussarUtils.isNotEmpty((Object)judgeCcBackConditions)) {
                    HashMap<String, String> condition = new HashMap<String, String>();
                    for (JudgeBackCondition judgeBackCondition : judgeCcBackConditions) {
                        condition.put(judgeBackCondition.getConditionBackExpression(), judgeBackCondition.getJudgeSpellCondition());
                    }
                    ccConditionAssigneeValue = JSON.toJSONString(condition);
                    if (HussarUtils.isNotEmpty((Object)ccConditionAssigneeValue)) {
                        for (Map.Entry entry : functionMap.entrySet()) {
                            ccConditionAssigneeValue = ccConditionAssigneeValue.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                        }
                    }
                }
                sysActAssignee.setContent(ccConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                list.add(sysActAssignee);
            }
            ArrayList<SysActAssignee> addList = new ArrayList<SysActAssignee>();
            QueryChainWrapper queryWrapper = this.sysActAssigneeService.query();
            for (SysActAssignee sysActAssignee : list) {
                String procDefKey = sysActAssignee.getProcDefKey();
                String taskDefKey = sysActAssignee.getTaskDefKey();
                String contentType = sysActAssignee.getContentType();
                queryWrapper = (QueryChainWrapper)queryWrapper.or();
                if (HussarUtils.isEmpty((Object)taskDefKey)) {
                    queryWrapper = (QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_KEY", (Object)procDefKey)).isNull((Object)"TASK_DEF_KEY")).eq((Object)"CONTENT_TYPE", (Object)contentType)).eq((Object)"PROC_VER", (Object)procVersion);
                    continue;
                }
                queryWrapper = (QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_KEY", (Object)procDefKey)).eq((Object)"TASK_DEF_KEY", (Object)taskDefKey)).eq((Object)"CONTENT_TYPE", (Object)contentType)).eq((Object)"PROC_VER", (Object)procVersion);
            }
            List sameList = queryWrapper.list();
            ArrayList<SysActAssignee> updateList = new ArrayList<SysActAssignee>();
            for (SysActAssignee sysActAssignee : list) {
                sysActAssignee.setProcVer(procVersion);
                boolean isadd = true;
                for (SysActAssignee actAssignee : sameList) {
                    if (HussarUtils.isEmpty((Object)sysActAssignee.getTaskDefKey())) {
                        if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !HussarUtils.isEmpty((Object)actAssignee.getTaskDefKey()) || !sysActAssignee.getContentType().equals(actAssignee.getContentType())) continue;
                        sysActAssignee.setId(actAssignee.getId());
                        updateList.add(sysActAssignee);
                        isadd = false;
                        break;
                    }
                    if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !sysActAssignee.getTaskDefKey().equals(actAssignee.getTaskDefKey()) || !sysActAssignee.getContentType().equals(actAssignee.getContentType())) continue;
                    sysActAssignee.setId(actAssignee.getId());
                    updateList.add(sysActAssignee);
                    isadd = false;
                    break;
                }
                if (!isadd) continue;
                addList.add(sysActAssignee);
            }
            this.sysActAssigneeService.updateBatchById(updateList);
            this.sysActAssigneeService.saveBatch(addList);
        }
    }

    public ApiResponse<String> saveWorkflow(WorkFlow workFlow, String tenantId, boolean isPublish, boolean isOverride) {
        return this.saveWorkflow(workFlow, tenantId, isPublish, isOverride, null, null);
    }

    public synchronized ApiResponse<String> saveWorkflow(WorkFlow workFlow, String tenantId, boolean isPublish, boolean isOverride, List<String> deptIdList, String groupName) {
        try {
            Long modelId;
            int procVersion = Integer.parseInt(workFlow.getVersion());
            WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(procVersion));
            if (!isPublish) {
                if (HussarUtils.isEmpty((Object)oldWorkFlow)) {
                    ModelBuild modelBuild = (ModelBuild)this.modelService.getOne((Wrapper)new LambdaQueryWrapper().eq(ModelBuild::getProcessKey, (Object)workFlow.getIdentity()));
                    if (HussarUtils.isNotEmpty((Object)modelBuild)) {
                        workFlow.setModelId(Long.valueOf(Long.parseLong(modelBuild.getModelId())));
                    }
                    this.sysActProcessFileService.addFile(workFlow, tenantId);
                }
                this.saveAssignee(workFlow);
                return ApiResponse.success((Object)"", (String)this.bpmConstantProperties.getSuccessSave());
            }
            String groupNumber = workFlow.getGroupNumber();
            Integer groupVersion = workFlow.getGroupVersion();
            if (HussarUtils.isEmpty((Object)groupNumber) || HussarUtils.isEmpty((Object)groupVersion)) {
                return ApiResponse.fail((String)"\u5206\u7ec4\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            ProcessGroup processGroup = (ProcessGroup)this.processGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessGroup::getGroupNumber, (Object)groupNumber)).eq(ProcessGroup::getProcessKey, (Object)workFlow.getIdentity()));
            if (processGroup == null) {
                if (HussarUtils.isEmpty(deptIdList)) {
                    return ApiResponse.fail((String)"\u5206\u7ec4\u6240\u5c5e\u90e8\u95e8\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                }
                this.processGroupService.addProcessGroup(new ProcessGroupInfo().setGroupName(groupName).setProcessKey(workFlow.getIdentity()).setGroupNumber(groupNumber).setDeptId(deptIdList));
            }
            if (HussarUtils.isEmpty((Object)oldWorkFlow.getData())) {
                ModelBuild modelBuild = (ModelBuild)this.modelService.getOne((Wrapper)new LambdaQueryWrapper().eq(ModelBuild::getProcessKey, (Object)workFlow.getIdentity()));
                if (HussarUtils.isNotEmpty((Object)modelBuild)) {
                    workFlow.setModelId(Long.valueOf(Long.parseLong(modelBuild.getModelId())));
                }
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
            }
            if (HussarUtils.isEmpty((Object)(modelId = this.bpm2XMLService.formDataToXml(tenantId, workFlow.getIdentity(), procVersion)))) {
                return ApiResponse.fail((String)this.bpmConstantProperties.getErrorSave());
            }
            workFlow.setModelId(modelId);
            this.sysActProcessFileService.updateFile(workFlow, tenantId);
            String processId = this.modelService.deployModel(modelId, tenantId, procVersion);
            this.processGroupService.updateProcessGroup(new ProcessGroupInfo().setGroupNumber(groupNumber).setProcessKey(workFlow.getIdentity()).setMainProcDefId(processId));
            this.saveProcessExtendProperties(processId, workFlow);
            return ApiResponse.success((Object)processId, (String)this.bpmConstantProperties.getSuccessSave());
        }
        catch (BpmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)e.getDetail());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
        }
    }

    public ApiResponse<String> deleteModel(String identity, String tenantId) {
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identity, tenantId, Integer.valueOf(0));
        Long modelId = workFlow.getModelId();
        if (HussarUtils.isNotEmpty((Object)modelId)) {
            this.repositoryService.deleteModel(String.valueOf(modelId));
        }
        return ApiResponse.success((Object)"", (String)this.bpmConstantProperties.getDeleteSuccess());
    }

    public ApiResponse<String> validationProcess(String processKey, String businessId, String userId, Map<String, Object> variables, String tenantId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (variables != null) {
            for (Map.Entry<String, Object> vo : variables.entrySet()) {
                map.put(vo.getKey(), ((JSONObject)vo.getValue()).get((Object)"checkData"));
            }
        }
        return this.modelService.validationProcess(processKey, businessId, userId, map, tenantId);
    }

    public ApiResponse<String> updateMeta(String identity, String name, String category, String tenantId) {
        try {
            if (this.modelService.updateCategory(identity, category) > 0) {
                this.sysActProcessFileService.updateMetaByIdentity(identity, name, category, tenantId);
            }
            return ApiResponse.success((Object)"", (String)this.bpmConstantProperties.getSuccessUpdate());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public synchronized ApiResponse<String> updateProcess(AdjustWorkFlow workFlow, String tenantId) {
        try {
            int procVersion = Integer.parseInt(workFlow.getVersion());
            WorkFlow oldWorkFlow = this.sysActProcessFileService.getFileByProcessKey(workFlow.getIdentity(), tenantId, Integer.valueOf(procVersion));
            ProcessDefinition processDefinition = (ProcessDefinition)this.engineServices.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(workFlow.getIdentity()).processDefinitionVersion(Integer.valueOf(procVersion)).singleResult();
            if (HussarUtils.isNotEmpty((Object)oldWorkFlow) && HussarUtils.isNotEmpty((Object)oldWorkFlow.getData()) && HussarUtils.isNotEmpty((Object)oldWorkFlow.getProcDefId()) && processDefinition != null && processDefinition.getId().equals(workFlow.getProcDefId())) {
                String processDefId = oldWorkFlow.getProcDefId();
                workFlow.setModelId(oldWorkFlow.getModelId());
                Map<String, Object> nodeMessage = this.getRejectFromList((WorkFlow)workFlow, oldWorkFlow);
                Map delNodeName = (Map)nodeMessage.get("delNodeName");
                Map changeNodeName = (Map)nodeMessage.get("changeNodeName");
                Map result = this.taskEngineService.updateRejectForm(nodeMessage);
                Integer numAll = ((Set)((Map)result.get("delNode")).get("")).size();
                if (numAll == 0) {
                    this.sysActProcessFileService.updateFile((WorkFlow)workFlow, tenantId);
                    this.saveProcessExtendProperties(processDefId, (WorkFlow)workFlow);
                    this.bpm2XMLService.updateModel(workFlow.getIdentity(), tenantId, procVersion);
                    this.saveModelExtendProperties(workFlow.getName(), (WorkFlow)workFlow);
                    return ApiResponse.success((Object)"", (String)BpmEnum.SUCCESS_SAVE.getMessage());
                }
                ((Map)result.get("delNode")).remove("");
                Map delNode = (Map)result.get("delNode");
                Map changeNode = (Map)result.get("changeNode");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\u672c\u6b21\u5fae\u8c03\u5f71\u54cd\u4e86").append(numAll).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c\u3002\u5176\u4e2d\uff1a");
                for (String key : delNode.keySet()) {
                    stringBuilder.append("\u5220\u9664\u8282\u70b9").append(HussarUtils.isNotEmpty(delNodeName.get(key)) ? (String)delNodeName.get(key) : key).append("\u5f71\u54cd\u4e86");
                    stringBuilder.append(((Set)delNode.get(key)).size()).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c;");
                }
                for (String key : changeNode.keySet()) {
                    stringBuilder.append("\u4fee\u6539\u8282\u70b9").append(HussarUtils.isNotEmpty(changeNodeName.get(key)) ? (String)changeNodeName.get(key) : key).append("\u7684\u4f1a\u7b7e\u7c7b\u578b\u5f71\u54cd\u4e86");
                    stringBuilder.append(((Set)changeNode.get(key)).size()).append("\u6761\u6d41\u7a0b\u7684\u8fd0\u884c;");
                }
                String message = stringBuilder.substring(0, stringBuilder.toString().length() - 1) + "\u3002";
                return ApiResponse.fail((String)message);
            }
            if (processDefinition != null) {
                throw new PublicClientException("\u6d41\u7a0b\u6a21\u578b\u7248\u672c\u9519\u8bef\uff01");
            }
            return this.saveWorkflow((WorkFlow)workFlow, tenantId, true, true, workFlow.getDeptIdList(), workFlow.getGroupName());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    private Map<String, Object> getRejectFromList(WorkFlow workFlow, WorkFlow oldWorkFlow) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List elements = flowModel.getSlots().getElement();
        String newTableName = null;
        List processVariables = flowModel.getProps().getUseVariables();
        HashSet<String> processVariableNames = new HashSet<String>();
        if (processVariables != null) {
            for (FlowVariables flowVariables : processVariables) {
                processVariableNames.add(flowVariables.getVariable());
                if (newTableName != null || flowVariables.getTable() == null) continue;
                newTableName = flowVariables.getTable();
            }
        }
        HashMap nodeVariableMap = new HashMap();
        HashMap<String, String> callActivityTables = new HashMap<String, String>();
        HashMap<String, FlowObject> nodeIds = new HashMap<String, FlowObject>();
        HashSet<String> aheadActionNodeSet = new HashSet<String>();
        HashSet<String> oldAheadActionNodeSet = new HashSet<String>();
        for (FlowObject flowObject : elements) {
            AheadAction aheadAction;
            if (!USERTASK_NAME.equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName()) && !"com.jxdinfo.workflow.SubProcess".equals(flowObject.getName())) continue;
            HashSet<String> nodeVariableNames = new HashSet<String>();
            PostAction postAction = flowObject.getProps().getPostAction();
            if (postAction != null && (aheadAction = postAction.getAheadAction()) != null && aheadAction.getUsed() != null && aheadAction.getUsed().booleanValue()) {
                aheadActionNodeSet.add(flowObject.getId());
            }
            ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
            FormBpmnUtil.getFunctionMessage(flowObject.getProps(), new HashMap<String, String>(), functionUserVariables);
            ArrayList<FlowVariables> nodeVariables = flowObject.getProps().getUseVariables();
            if (nodeVariables == null) {
                nodeVariables = new ArrayList<FlowVariables>();
            }
            nodeVariables.addAll(functionUserVariables);
            for (FlowVariables flowVariables : nodeVariables) {
                nodeVariableNames.add(flowVariables.getVariable());
                if (newTableName != null || flowVariables.getTable() == null) continue;
                newTableName = flowVariables.getTable();
            }
            nodeVariableNames.addAll(processVariableNames);
            if (!nodeVariableNames.isEmpty()) {
                nodeVariableMap.put(flowObject.getId(), nodeVariableNames);
            }
            if ("com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) {
                callActivityTables.put(flowObject.getId(), flowObject.getProps().getCallActivityTable() != null ? flowObject.getProps().getCallActivityTable().getTableId() : "");
            }
            nodeIds.put(flowObject.getId(), flowObject);
        }
        FlowModel oldFlowModel = (FlowModel)JSON.parseObject((String)oldWorkFlow.getData(), FlowModel.class);
        List oldElements = oldFlowModel.getSlots().getElement();
        List oldProcessVariables = oldFlowModel.getProps().getUseVariables();
        HashSet<String> oldProcessVariableNames = new HashSet<String>();
        String oldTableName = null;
        if (oldProcessVariables != null) {
            for (FlowVariables flowVariables : oldProcessVariables) {
                oldProcessVariableNames.add(flowVariables.getVariable());
                if (oldTableName != null || flowVariables.getTable() == null) continue;
                oldTableName = flowVariables.getTable();
            }
        }
        HashMap oldNodeVariableMap = new HashMap();
        HashMap<String, String> oldCallActivityTables = new HashMap<String, String>();
        HashSet<String> delNodeIds = new HashSet<String>();
        HashSet<String> changeNodeIds = new HashSet<String>();
        HashMap<String, String> delNodeName = new HashMap<String, String>();
        HashMap<String, String> changeNodeName = new HashMap<String, String>();
        for (FlowObject flowObject : oldElements) {
            if (!USERTASK_NAME.equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName()) && !"com.jxdinfo.workflow.SubProcess".equals(flowObject.getName())) continue;
            if (nodeIds.containsKey(flowObject.getId())) {
                AheadAction aheadAction;
                HashSet<String> oldNodeVariableNames = new HashSet<String>();
                PostAction postAction = flowObject.getProps().getPostAction();
                if (postAction != null && (aheadAction = postAction.getAheadAction()) != null && aheadAction.getUsed() != null && aheadAction.getUsed().booleanValue()) {
                    oldAheadActionNodeSet.add(flowObject.getId());
                }
                ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
                FormBpmnUtil.getFunctionMessage(flowObject.getProps(), new HashMap<String, String>(), functionUserVariables);
                ArrayList<FlowVariables> nodeVariables = flowObject.getProps().getUseVariables();
                if (nodeVariables == null) {
                    nodeVariables = new ArrayList<FlowVariables>();
                }
                nodeVariables.addAll(functionUserVariables);
                for (FlowVariables flowVariables : nodeVariables) {
                    oldNodeVariableNames.add(flowVariables.getVariable());
                    if (oldTableName != null || flowVariables.getTable() == null) continue;
                    oldTableName = flowVariables.getTable();
                }
                oldNodeVariableNames.addAll(oldProcessVariableNames);
                if (!oldNodeVariableNames.isEmpty()) {
                    oldNodeVariableMap.put(flowObject.getId(), oldNodeVariableNames);
                }
                if ("com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) {
                    oldCallActivityTables.put(flowObject.getId(), flowObject.getProps().getCallActivityTable() != null ? flowObject.getProps().getCallActivityTable().getTableId() : "");
                }
                FlowObject newFlowObject = (FlowObject)nodeIds.get(flowObject.getId());
                if (!flowObject.getName().equals(newFlowObject.getName())) {
                    changeNodeIds.add(flowObject.getId());
                    changeNodeName.put(flowObject.getId(), flowObject.getProps().getFlowName());
                    continue;
                }
                if (flowObject.getProps().getFlowCountersign() == null || newFlowObject.getProps().getFlowCountersign() == null || !flowObject.getProps().getFlowCountersign().isCountersign() != newFlowObject.getProps().getFlowCountersign().isCountersign()) continue;
                changeNodeIds.add(flowObject.getId());
                changeNodeName.put(flowObject.getId(), flowObject.getProps().getFlowName());
                continue;
            }
            delNodeIds.add(flowObject.getId());
            delNodeName.put(flowObject.getId(), flowObject.getProps().getFlowName());
        }
        if (oldAheadActionNodeSet.addAll(aheadActionNodeSet)) {
            throw new PublicClientException("\u672c\u6b21\u4fee\u6539\u6dfb\u52a0\u4e86\u524d\u7f6e\u52a8\u4f5c\uff0c\u9700\u8981\u53d1\u5e03\u65b0\u7248\u672c!");
        }
        if (newTableName != null && !newTableName.equals(oldTableName)) {
            throw new PublicClientException(this.bpmConstantProperties.getErrUpdateProcessWithVariables());
        }
        for (String nodeId : callActivityTables.keySet()) {
            if (((String)callActivityTables.get(nodeId)).equals(oldCallActivityTables.get(nodeId))) continue;
            throw new PublicClientException(this.bpmConstantProperties.getErrUpdateProcessWithVariables());
        }
        for (String nodeId : nodeVariableMap.keySet()) {
            if (this.bpmFormdesignProperties.getOfflineLr().booleanValue()) {
                if (oldNodeVariableMap.get(nodeId) != null) continue;
                throw new PublicClientException(this.bpmConstantProperties.getErrUpdateProcessWithVariables());
            }
            Set nodeVariableNames = (Set)nodeVariableMap.get(nodeId);
            nodeVariableNames.removeAll(oldNodeVariableMap.get(nodeId) != null ? (Collection)oldNodeVariableMap.get(nodeId) : new HashSet());
            if (nodeVariableNames.isEmpty()) continue;
            throw new PublicClientException(this.bpmConstantProperties.getErrUpdateProcessWithVariables());
        }
        map.put("delNodeName", delNodeName);
        map.put("delNodeIds", delNodeIds);
        map.put("nodeIds", nodeIds);
        map.put("changeNodeName", changeNodeName);
        map.put("changeNodeIds", changeNodeIds);
        map.put("procDefId", workFlow.getProcDefId());
        return map;
    }

    private void saveModelExtendProperties(String name, WorkFlow workFlow) {
        String procDefId = workFlow.getProcDefId();
        this.processDefinitionsService.updateProcessName(procDefId, name);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        List flowObjects = flowModel.getSlots().getElement() != null ? flowModel.getSlots().getElement() : new ArrayList();
        ArrayList<Object> sysActExtendProperties = new ArrayList<Object>();
        for (FlowObject flowObject : flowObjects) {
            AheadAction aheadAction;
            if (!USERTASK_NAME.equals(flowObject.getName())) continue;
            FlowProps flowProps = flowObject.getProps();
            SysActExtendProperties approvalExtends = new SysActExtendProperties();
            approvalExtends.setApprovalType(flowProps.getApprovalType());
            approvalExtends.setAdaptApprover(flowProps.getAdaptApprover());
            approvalExtends.setAddApprovalNode(flowProps.getAddApprovalNode());
            approvalExtends.setSetApprovalRemind(flowProps.getSetApprovalRemind());
            approvalExtends.setInitApprovalDisplay(flowProps.getInitApprovalDisplay());
            approvalExtends.setAddApprovalNodeAfterOther(flowProps.getAddApprovalNodeAfterOther());
            approvalExtends.setAdaptSubsequentApprover(flowProps.getAdaptSubsequentApprover());
            approvalExtends.setTaskDefKey(flowObject.getInstanceKey());
            approvalExtends.setIsWorkday(flowProps.getIsWorkday());
            approvalExtends.setAllowEditForm(flowProps.getAllowEditForm());
            approvalExtends.setTaskDefName(flowProps.getFlowName());
            approvalExtends.setProcDefId(procDefId);
            approvalExtends.setAllowAlterTaskToOther(flowProps.getAllowAlterTaskToOther());
            approvalExtends.setAllowAlterTask(flowProps.getAllowAlterTask());
            approvalExtends.setAlterNodeRelation(flowProps.getAlterNodeRelation());
            approvalExtends.setAttachmentType(flowProps.getAttachmentType());
            approvalExtends.setNumberOfAttachment(flowProps.getNumberOfAttachment());
            approvalExtends.setApproveOption(flowProps.getApproveOption());
            approvalExtends.setNumberOfApprover(flowProps.getNumberOfApprover());
            PostAction postAction = flowProps.getPostAction();
            if (postAction != null && (aheadAction = postAction.getAheadAction()) != null) {
                if (aheadAction.getFormAddress() != null) {
                    approvalExtends.setAheadActionFormAddress(aheadAction.getFormAddress().get((Object)"url") != null ? JSON.toJSONString((Object)aheadAction.getFormAddress().get((Object)"url")) : null);
                    approvalExtends.setAheadActionFormName(aheadAction.getFormAddress().get((Object)"desc") != null ? String.valueOf(aheadAction.getFormAddress().get((Object)"desc")) : null);
                }
                approvalExtends.setAheadActionFormType(aheadAction.getFormType());
                approvalExtends.setAheadActionIsUsed(aheadAction.getUsed() != null ? aheadAction.getUsed() : false);
            }
            JSONObject jSONObject = flowProps.getFormAddress();
            JSONObject object = new JSONObject();
            if (jSONObject != null) {
                for (String key : jSONObject.keySet()) {
                    object.put(key, jSONObject.getJSONObject(key).get((Object)"url"));
                }
            }
            approvalExtends.setFormDetailKey(jSONObject != null ? JSON.toJSONString((Object)object) : null);
            sysActExtendProperties.add(approvalExtends);
        }
        if (!sysActExtendProperties.isEmpty()) {
            ArrayList<SysActExtendProperties> addList = new ArrayList<SysActExtendProperties>();
            ArrayList<SysActExtendProperties> updateList = new ArrayList<SysActExtendProperties>();
            QueryChainWrapper queryWrapper = this.iSysActExtendPropertiesService.query();
            for (SysActExtendProperties sysActExtendProperties2 : sysActExtendProperties) {
                String string = sysActExtendProperties2.getProcDefId();
                String taskDefKey = sysActExtendProperties2.getTaskDefKey();
                queryWrapper = (QueryChainWrapper)queryWrapper.or();
                queryWrapper = (QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_ID", (Object)string)).eq((Object)"TASK_DEF_KEY", (Object)taskDefKey);
            }
            List sameList = queryWrapper.list();
            for (SysActExtendProperties sysActExtendProperties3 : sysActExtendProperties) {
                boolean isadd = true;
                for (SysActExtendProperties actExtendProperties : sameList) {
                    if (!sysActExtendProperties3.getProcDefId().equals(actExtendProperties.getProcDefId()) || !sysActExtendProperties3.getTaskDefKey().equals(actExtendProperties.getTaskDefKey())) continue;
                    sysActExtendProperties3.setId(actExtendProperties.getId());
                    updateList.add(sysActExtendProperties3);
                    isadd = false;
                    break;
                }
                if (!isadd) continue;
                addList.add(sysActExtendProperties3);
            }
            this.iSysActExtendPropertiesService.saveBatch(addList);
            this.iSysActExtendPropertiesService.updateBatchById(updateList);
        }
    }

    private void saveProcessExtendProperties(String processId, WorkFlow workFlow) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        FlowProps flowProps = flowModel.getProps();
        ProcessExtendProperties processExtendProperties = new ProcessExtendProperties();
        processExtendProperties.setAllowNullApprover(flowProps.getAllowNullApprover());
        processExtendProperties.setCopyAttachmentAtRectification(flowProps.getCopyAttachmentAtRectification());
        processExtendProperties.setMustUploadAttachment(flowProps.getMustUploadAttachment());
        processExtendProperties.setRuleOfHiApproverAtApproval(Integer.valueOf(flowProps.getRuleOfHiApproverAtApproval()));
        processExtendProperties.setRectificationBeanId(flowProps.getRectificationBeanId());
        processExtendProperties.setProcGroupNumber(workFlow.getGroupNumber());
        processExtendProperties.setGroupVersion(workFlow.getGroupVersion());
        JSONObject viewFormAddressJsonObject = JSON.parseObject((String)flowProps.getFlowFormDetailAddress());
        JSONObject viewFormAddressObject = new JSONObject();
        if (viewFormAddressJsonObject != null) {
            for (String key : viewFormAddressJsonObject.keySet()) {
                viewFormAddressObject.put(key, viewFormAddressJsonObject.getJSONObject(key).get((Object)"url"));
            }
        }
        processExtendProperties.setViewFormAddress(viewFormAddressJsonObject != null ? JSON.toJSONString((Object)viewFormAddressObject) : null);
        JSONObject editFormAddressJsonObject = JSON.parseObject((String)flowProps.getFlowFormAddress());
        JSONObject editFormAddressObject = new JSONObject();
        if (editFormAddressJsonObject != null) {
            for (String key : editFormAddressJsonObject.keySet()) {
                editFormAddressObject.put(key, editFormAddressJsonObject.getJSONObject(key).get((Object)"url"));
            }
        }
        processExtendProperties.setEditFormAddress(editFormAddressJsonObject != null ? JSON.toJSONString((Object)editFormAddressObject) : null);
        this.processDefinitionsService.setProcessExtendProperties(processId, processExtendProperties);
    }

    public ApiResponse<Boolean> existDuplicateDept(String deptId, String processKey, int version) {
        return ApiResponse.success((Object)false);
    }

    private String getFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue();
    }

    public WorkFlow getFileByProcessKey(String processKey, String tenantId, Integer version) {
        return this.sysActProcessFileService.getFileByProcessKey(processKey, tenantId, version);
    }

    public ApiResponse<String> updateWorkflowProcessKey(String processKey, String oldProcessKey) {
        if (this.lcdpBpmProperties.isModifyConfigurationOnline() && HussarUtils.isEmpty((Object)this.modelService.getIdByIdentity(processKey))) {
            this.sysActFormAuthService.copyAuth(processKey, oldProcessKey);
            this.sysActAssigneeService.copyAssignee(processKey, oldProcessKey);
        }
        return ApiResponse.success((Object)"", (String)"");
    }

    public ApiResponse<String> updateWorkflowProcessKey(String processKey, int version, String oldProcessKey, int oldVersion, boolean isDelete) {
        if (this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            this.sysActFormAuthService.copyAuth(processKey, version, oldProcessKey, oldVersion);
            this.sysActAssigneeService.copyAssignee(processKey, version, oldProcessKey, oldVersion);
            if (isDelete && HussarUtils.isEmpty((Object)this.sysActProcessFileService.getFileByProcessKey(oldProcessKey, BaseSecurityUtil.getUser().getStringTenantId(), Integer.valueOf(oldVersion)).getProcDefId())) {
                this.sysActFormAuthService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)oldProcessKey)).eq(SysActFormAuth::getProcVer, (Object)oldVersion));
                this.sysActAssigneeService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)oldProcessKey)).eq(SysActAssignee::getProcVer, (Object)oldVersion));
                this.sysActProcessFileService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)oldProcessKey)).eq(SysActProcessFile::getVersion, (Object)oldVersion));
            }
        }
        return ApiResponse.success((Object)"", (String)"");
    }
}

