/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class TaskCompleteListener
implements ActivitiEventListener {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    private static Logger logger = LogManager.getLogger(TaskCompleteListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        TaskEntity taskEntity = (TaskEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        HistoricTaskInstanceEntity historicTaskInstanceEntity = Context.getCommandContext().getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(taskEntity.getId());
        String date = new SimpleDateFormat("yyMMddHHmmss", Locale.CHINESE).format(new Date());
        String randomStr = String.format("%02d", (int)(Math.random() * 100.0));
        historicTaskInstanceEntity.setApprovalNumber(date + randomStr);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "taskCompleteEnd");
        map.put("taskId", taskEntity.getId());
        map.put("taskName", taskEntity.getName());
        map.put("businessId", taskEntity.getProcessInstance().getBusinessKey());
        map.put("processInsId", taskEntity.getProcessInstanceId());
        map.put("processDefinitionId", taskEntity.getProcessDefinitionId());
        map.put("processKey", taskEntity.getProcessDefinitionId().split(":")[0]);
        map.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
        map.put("tenantId", taskEntity.getTenantId());
        map.put("formKey", taskEntity.getFormKey());
        map.put("userId", taskEntity.getAssignee());
        map.put("sendUser", taskEntity.getVariable("sendUser"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("startDate", simpleDateFormat.format(taskEntity.getCreateTime()));
        map.put("endDate", simpleDateFormat.format(new Date()));
        map.put("url", taskEntity.getFormKey());
        map.put("description", taskEntity.getVariable("todoConfiguration"));
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(Long.parseLong(taskEntity.getId()));
        ArrayList comments = new ArrayList();
        if (HussarUtils.isNotEmpty(comments)) {
            map.put("comment", this.taskEngineMapper.getTaskComments(taskIds).get(0).get("comments"));
        }
        map.put("processName", taskEntity.getProcessInstance().getProcessDefinition().getName());
        List identityLinkEntityList = taskEntity.getProcessInstance().getIdentityLinks();
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntityList) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            map.put("starter", identityLinkEntity.getUserId());
        }
        CommonCodeUtil.triggerEventHandleClass(map);
        this.sysActUrgeTaskMapper.deleteByTaskId(Long.parseLong(taskEntity.getId()));
    }

    public boolean isFailOnException() {
        logger.error("\u4efb\u52a1\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

