/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.ApprovalUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.model.SubCandidate;
import com.jxdinfo.hussar.workflow.engine.bpm.subcandidate.service.ISubCandidateService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.BuildDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendUserTaskActivityBehavior
extends UserTaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_MSG = "Expression did not resolve to a string or collection of strings";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendUserTaskActivityBehavior.class);
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getApplicationContext().getBean(ISysActCcTaskService.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)SpringContextHolder.getApplicationContext().getBean(ActivityRedisTimerService.class);
    private ICandidateUserService candidateUserService = (ICandidateUserService)SpringContextHolder.getApplicationContext().getBean(ICandidateUserService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ISysActEntrustService entrustService = (ISysActEntrustService)SpringContextHolder.getApplicationContext().getBean(ISysActEntrustService.class);
    private BpmMsgPushService msgPushService = (BpmMsgPushService)SpringContextHolder.getApplicationContext().getBean(BpmMsgPushService.class);
    private ISubCandidateService subCandidateService = (ISubCandidateService)SpringContextHolder.getApplicationContext().getBean(ISubCandidateService.class);
    private ISysActExtendPropertiesService sysActExtendPropertiesService = (ISysActExtendPropertiesService)SpringContextHolder.getApplicationContext().getBean(ISysActExtendPropertiesService.class);
    private ISysCalendarRefService sysCalendarRefService = (ISysCalendarRefService)SpringContextHolder.getApplicationContext().getBean(ISysCalendarRefService.class);
    private ProcessDefinitionsService processDefinitionsService = (ProcessDefinitionsService)SpringContextHolder.getApplicationContext().getBean(ProcessDefinitionsService.class);

    public ExtendUserTaskActivityBehavior(String userTaskId, TaskDefinition taskDefinition) {
        super(userTaskId, taskDefinition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(ActivityExecution execution) throws Exception {
        Object category;
        Object priority;
        Set<Expression> activeCandidateGroupExpressions;
        Set<Expression> activeCandidateUserExpressions;
        Expression activeOwnerExpression;
        Expression activeAssigneeExpression;
        Expression activeFormKeyExpression;
        Expression activeCategoryExpression;
        Expression activePriorityExpression;
        Expression activeDueDateExpression;
        Expression activeDescriptionExpression;
        Expression activeNameExpression;
        TaskEntity task = TaskEntity.createAndInsert((ActivityExecution)execution);
        task.setExecution((DelegateExecution)execution);
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = Context.getBpmnOverrideElementProperties((String)this.userTaskId, (String)execution.getProcessDefinitionId());
            activeNameExpression = this.getActiveValue(this.taskDefinition.getNameExpression(), "userTaskName", taskElementProperties);
            this.taskDefinition.setNameExpression(activeNameExpression);
            activeDescriptionExpression = this.getActiveValue(this.taskDefinition.getDescriptionExpression(), "userTaskDescription", taskElementProperties);
            this.taskDefinition.setDescriptionExpression(activeDescriptionExpression);
            activeDueDateExpression = this.getActiveValue(this.taskDefinition.getDueDateExpression(), "userTaskDueDate", taskElementProperties);
            this.taskDefinition.setDueDateExpression(activeDueDateExpression);
            activePriorityExpression = this.getActiveValue(this.taskDefinition.getPriorityExpression(), "userTaskPriority", taskElementProperties);
            this.taskDefinition.setPriorityExpression(activePriorityExpression);
            activeCategoryExpression = this.getActiveValue(this.taskDefinition.getCategoryExpression(), "userTaskCategory", taskElementProperties);
            this.taskDefinition.setCategoryExpression(activeCategoryExpression);
            activeFormKeyExpression = this.getActiveValue(this.taskDefinition.getFormKeyExpression(), "userTaskFormKey", taskElementProperties);
            this.taskDefinition.setFormKeyExpression(activeFormKeyExpression);
            Expression activeSkipExpression = this.getActiveValue(this.taskDefinition.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            this.taskDefinition.setSkipExpression(activeSkipExpression);
            activeAssigneeExpression = this.getActiveValue(this.taskDefinition.getAssigneeExpression(), "userTaskAssignee", taskElementProperties);
            this.taskDefinition.setAssigneeExpression(activeAssigneeExpression);
            activeOwnerExpression = this.getActiveValue(this.taskDefinition.getOwnerExpression(), "userTaskOwner", taskElementProperties);
            this.taskDefinition.setOwnerExpression(activeOwnerExpression);
            activeCandidateUserExpressions = this.getActiveValueSet(this.taskDefinition.getCandidateUserIdExpressions(), "userTaskCandidateUsers", taskElementProperties);
            this.taskDefinition.setCandidateUserIdExpressions(activeCandidateUserExpressions);
            activeCandidateGroupExpressions = this.getActiveValueSet(this.taskDefinition.getCandidateGroupIdExpressions(), "userTaskCandidateGroups", taskElementProperties);
            this.taskDefinition.setCandidateGroupIdExpressions(activeCandidateGroupExpressions);
        } else {
            activeNameExpression = this.taskDefinition.getNameExpression();
            activeDescriptionExpression = this.taskDefinition.getDescriptionExpression();
            activeDueDateExpression = this.taskDefinition.getDueDateExpression();
            activePriorityExpression = this.taskDefinition.getPriorityExpression();
            activeCategoryExpression = this.taskDefinition.getCategoryExpression();
            activeFormKeyExpression = this.taskDefinition.getFormKeyExpression();
            activeAssigneeExpression = this.taskDefinition.getAssigneeExpression();
            activeOwnerExpression = this.taskDefinition.getOwnerExpression();
            activeCandidateUserExpressions = this.taskDefinition.getCandidateUserIdExpressions();
            activeCandidateGroupExpressions = this.taskDefinition.getCandidateGroupIdExpressions();
        }
        task.setTaskDefinition(this.taskDefinition);
        if (activeNameExpression != null) {
            String name;
            try {
                name = (String)activeNameExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                name = activeNameExpression.getExpressionText();
                LOGGER.warn("property not found in task name expression {}", (Object)e.getMessage());
            }
            task.setName(name);
        }
        if (activeDescriptionExpression != null) {
            String description;
            try {
                description = (String)activeDescriptionExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                description = activeDescriptionExpression.getExpressionText();
                LOGGER.warn("property not found in task description expression {}", (Object)e.getMessage());
            }
            task.setDescription(description);
        }
        if (activeDueDateExpression != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(SysActExtendProperties::getProcDefId, (Object)task.getProcessDefinitionId())).eq(SysActExtendProperties::getTaskDefKey, (Object)task.getTaskDefinitionKey());
            List sysActExtendProperties = this.sysActExtendPropertiesService.list((Wrapper)queryWrapper);
            String isWorkday = "0";
            if (sysActExtendProperties != null && sysActExtendProperties.size() != 0) {
                isWorkday = ((SysActExtendProperties)sysActExtendProperties.get(0)).getIsWorkday();
            }
            if ("1".equals(isWorkday)) {
                Instant instant = task.getCreateTime().toInstant();
                ZoneOffset zoneOffset = ZoneOffset.of("+8");
                LocalDateTime startTime = instant.atZone(zoneOffset).toLocalDateTime();
                LocalDateTime tempDueDate = this.sysCalendarRefService.getEndDateDefult(startTime, activeDueDateExpression.getExpressionText(), true);
                instant = tempDueDate.toInstant(zoneOffset);
                Date dueDate = Date.from(instant);
                task.setDueDate(dueDate);
            } else {
                Object dueDate = activeDueDateExpression.getValue((VariableScope)execution);
                if (dueDate != null) {
                    if (dueDate instanceof Date) {
                        task.setDueDate((Date)dueDate);
                    } else {
                        if (!(dueDate instanceof String)) throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
                        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.taskDefinition.getBusinessCalendarNameExpression().getValue((VariableScope)execution).toString());
                        task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
                    }
                }
            }
        }
        if (activePriorityExpression != null && (priority = activePriorityExpression.getValue((VariableScope)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority).intValue());
                }
                catch (NumberFormatException e) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else {
                if (!(priority instanceof Number)) throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + activePriorityExpression.getExpressionText());
                task.setPriority(((Number)priority).intValue());
            }
        }
        if (activeCategoryExpression != null && (category = activeCategoryExpression.getValue((VariableScope)execution)) != null) {
            if (!(category instanceof String)) throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + activeCategoryExpression.getExpressionText());
            task.setCategory((String)category);
        }
        if (activeFormKeyExpression != null) {
            Object formKey = activeFormKeyExpression.getValue((VariableScope)execution);
            if (formKey != null) {
                JSONObject formKeyObject = JSON.parseObject((String)((String)formKey));
                if (formKeyObject.get((Object)"web").equals("")) {
                    ProcessExtendProperties processExtendProperties = this.processDefinitionsService.getProcessExtendProperties(execution.getProcessDefinitionId());
                    task.setFormKey(processExtendProperties.getEditFormAddress());
                } else {
                    if (!(formKey instanceof String)) throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + activeFormKeyExpression.getExpressionText());
                    task.setFormKey((String)formKey);
                }
            }
        } else {
            ProcessExtendProperties processExtendProperties = this.processDefinitionsService.getProcessExtendProperties(execution.getProcessDefinitionId());
            task.setFormKey(processExtendProperties.getEditFormAddress());
        }
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> messageType = new ArrayList<String>();
        boolean skipUserTask = this.setAssignments(activeAssigneeExpression, activeOwnerExpression, activeCandidateUserExpressions, activeCandidateGroupExpressions, task, execution, users, messageType);
        task.fireEvent("create");
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)task));
        }
        if (skipUserTask) {
            task.setVariableLocal("sendUser", (Object)task.getAssignee());
            task.setVariableLocal("taskSourceFlag", (Object)"skip");
            task.setApprovalType("skip");
            String todoConfiguration = task.getVariable("todoConfiguration") == null ? "" : task.getVariable("todoConfiguration");
            task.setVariablesLocal(execution.getVariablesLocal());
            task.setVariableLocal("todoConfiguration", (Object)String.valueOf(todoConfiguration));
            task.complete(null, false);
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setUserId(String.join((CharSequence)",", users));
                dataPush.setTenantId(task.getTenantId());
                dataPush.setEndDate(new Date());
                this.dataPushService.completeDataPush(dataPush);
            }
        }
        if (!("revoke".equals(Context.getCommandContext().getAttribute("taskSourceFlag")) || skipUserTask || "main_process_start".equals(Context.getCommandContext().getAttribute("taskSourceFlag")))) {
            ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
            BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
            bpmActMsgDetail.setProcessKey(task.getProcessInstance().getProcessDefinitionKey());
            bpmActMsgDetail.setProcessName(task.getProcessInstance().getProcessDefinition().getName());
            bpmActMsgDetail.setProcessDefinitionId(task.getProcessDefinitionId());
            bpmActMsgDetail.setTaskDefKey(task.getTaskDefinitionKey());
            bpmActMsgDetail.setTaskDefName(task.getName());
            bpmActMsgDetail.setReceive(users);
            bpmActMsgDetail.setProcessVer(task.getProcessDefinitionId().split(":")[1]);
            bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty(messageType) ? (String)messageType.get(0) : null);
            if ("reject".equals(Context.getCommandContext().getAttribute("taskSourceFlag"))) {
                bpmActMsgDetail.setSceneCode("reject");
            } else {
                bpmActMsgDetail.setSceneCode("todo");
            }
            bpmActMsgDetailList.add(bpmActMsgDetail);
            this.msgPushService.pushMessage(bpmActMsgDetailList);
        }
        task.fireEvent("start");
    }

    private boolean setAssignments(Expression assigneeExpression, Expression ownerExpression, Set<Expression> candidateUserExpressions, Set<Expression> candidateGroupExpressions, TaskEntity task, ActivityExecution execution, List<String> userList, List<String> messageType) {
        Object value;
        Map identityLinks;
        Map extensionElementsNode;
        String skipRepetition;
        Map<String, Object> ccUsersMessage;
        if ("callActivity".equals(execution.getActivity().getProperty("type")) && "parallel".equals(execution.getActivity().getProperty("multiInstance"))) {
            return false;
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (assigneeExpression != null) {
            Object assigneeExpressionValue = assigneeExpression.getValue((VariableScope)execution);
            String assigneeValue = null;
            if (assigneeExpressionValue != null) {
                assigneeValue = assigneeExpressionValue.toString();
            }
            task.setAssignee(assigneeValue, true, false);
        }
        if (ownerExpression != null) {
            Iterator<Expression> ownerExpressionValue = ownerExpression.getValue((VariableScope)execution);
            String ownerValue = null;
            if (ownerExpressionValue != null) {
                ownerValue = ownerExpressionValue.toString();
            }
            task.setOwner(ownerValue);
        }
        if (candidateGroupExpressions != null && !candidateGroupExpressions.isEmpty()) {
            for (Expression groupIdExpr : candidateGroupExpressions) {
                Object value2 = groupIdExpr.getValue((VariableScope)execution);
                if (value2 instanceof String) {
                    List<String> candidates = this.extractCandidates((String)value2);
                    task.addCandidateGroups(candidates);
                    continue;
                }
                if (value2 instanceof Collection) {
                    task.addCandidateGroups((Collection)value2);
                    continue;
                }
                throw new ActivitiIllegalArgumentException(ERROR_MSG);
            }
        }
        this.setVariables(task, execution.getVariables());
        HashSet<String> mainTaskUser = new HashSet<String>();
        HashSet<String> subTaskUser = new HashSet<String>();
        List<ApprovalUser> approvalUsers = AnalyticalModelUtil.getEntrustCandidateUser(bm, task.getTaskDefinitionKey(), execution, false, mainTaskUser, subTaskUser, execution.getTenantId(), messageType);
        if (approvalUsers.isEmpty()) {
            throw new PublicClientException("\u672a\u6307\u5b9a\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005\uff01");
        }
        userList.addAll(mainTaskUser);
        FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(execution.getActivity().getId());
        List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
        if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy) && HussarUtils.isNotEmpty((Object)((ExtensionElement)timeOutStrategy.get(0)).getAttributes())) {
            TimeOutModel timeOutModel = new TimeOutModel();
            timeOutModel.setId(Long.valueOf(Long.parseLong(task.getId())));
            timeOutModel.setCreateTime(task.getCreateTime());
            timeOutModel.setDueTime(task.getDueDate());
            StringBuilder stringBuilder = new StringBuilder();
            if (HussarUtils.isNotEmpty(mainTaskUser)) {
                for (String user : mainTaskUser) {
                    stringBuilder.append(user).append(",");
                }
                timeOutModel.setAssignee(stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1));
            }
            timeOutModel.setTimeOutType(((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue());
            timeOutModel.setTenantId(execution.getTenantId());
            if (timeOutModel.getTimeOutType().startsWith("http") || "urging".equals(timeOutModel.getTimeOutType())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", task.getName());
                map.put("processInsId", task.getProcessInstanceId());
                map.put("processDefinitionId", task.getProcessDefinitionId());
                map.put("taskDefinitionKey", task.getTaskDefinitionKey());
                map.put("formKey", task.getFormKey());
                map.put("businessId", execution.getProcessBusinessKey());
                map.put("processName", ((ExecutionEntity)execution).getProcessDefinition().getName());
                map.put("todoConfiguration", task.getVariable("todoConfiguration"));
                map.put("sendUser", task.getVariable("sendUser"));
                timeOutModel.setMap(JSON.toJSONString(map));
            }
            this.activityRedisTimer.addTimeOutModel(timeOutModel);
        }
        if (HussarUtils.isNotEmpty(ccUsersMessage = AnalyticalModelUtil.getCcUser(bm, execution, execution.getTenantId()))) {
            Set ccUsers = (Set)ccUsersMessage.get("ccUser");
            String sendUserId = (String)ccUsersMessage.get("ccSendUser");
            if (HussarUtils.isNotEmpty((Object)ccUsers) && HussarUtils.isNotEmpty((Object)sendUserId)) {
                this.ccTask((Task)task, ccUsers, sendUserId, execution);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(skipRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)(extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey()).getExtensionElements()).get("skiprepetition")).get(0)).getAttributes().get("skiprepetition")).get(0)).getValue()))) {
            boolean flag = false;
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().unfinished().desc()).listPage(0, 1);
            if (hisTaskList != null && !hisTaskList.isEmpty()) {
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
                Map map = historicTaskInstance.getTaskLocalVariables();
                if (map != null && !map.isEmpty()) {
                    boolean bl = flag = map.get("is_normal_commit") == null || (Boolean)map.get("is_normal_commit") != false;
                }
                if (flag) {
                    List<String> skipList = Arrays.asList(skipRepetition.split(","));
                    if (skipList.contains("1") && (mainTaskUser == null || mainTaskUser.isEmpty())) {
                        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                            this.activityRedisTimer.delTimeOutModel(task.getId());
                        }
                        return true;
                    }
                    if (skipList.contains("2") && HussarUtils.isNotEmpty((Object)hisTaskList)) {
                        String lastAssign = historicTaskInstance.getOriginalAssignee();
                        if (mainTaskUser != null && mainTaskUser.contains(lastAssign)) {
                            task.setAssignee(lastAssign);
                            if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
                                this.activityRedisTimer.delTimeOutModel(task.getId());
                            }
                            return true;
                        }
                    }
                }
            } else {
                List<String> skipList = Arrays.asList(skipRepetition.split(","));
                if (skipList.contains("1") && (mainTaskUser == null || mainTaskUser.isEmpty())) {
                    return true;
                }
            }
        }
        String delayToAssign = "";
        if (extensionElementsNode.get("delayToAssign") != null) {
            List list = (List)((ExtensionElement)((List)extensionElementsNode.get("delayToAssign")).get(0)).getAttributes().get("delayToAssign");
            String string = delayToAssign = HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : "false";
        }
        if (mainTaskUser != null && !mainTaskUser.isEmpty()) {
            if (!"true".equals(delayToAssign)) {
                approvalUsers.stream().filter(approvalUser -> "1".equals(approvalUser.getIsMain())).forEach(approvalUser -> task.addCandidateUser(AnalyticalModelUtil.getIdentityLinkEntityByApprovalUser(approvalUser)));
            } else {
                String taskId = task.getId();
                this.candidateUserService.saveBatch((Collection)approvalUsers.stream().filter(approvalUser -> "1".equals(approvalUser.getIsMain())).map(approvalUser -> {
                    CandidateUser candidateUser = new CandidateUser();
                    candidateUser.setTaskId(taskId);
                    candidateUser.setAssignee(approvalUser.getOwner() == null ? approvalUser.getUserId() : approvalUser.getOwner());
                    candidateUser.setDeptId(approvalUser.getDeptId());
                    candidateUser.setPostId(approvalUser.getPostId());
                    return candidateUser;
                }).collect(Collectors.toList()));
            }
        }
        if (!subTaskUser.isEmpty()) {
            List subCandidates = approvalUsers.stream().filter(approvalUser -> "0".equals(approvalUser.getIsMain())).map(approvalUser -> new SubCandidate(approvalUser, task.getId(), task.getProcessInstanceId())).collect(Collectors.toList());
            this.subCandidateService.saveBatch((Collection)subCandidates);
            this.dataPushService.addSubTask(BuildDataPush.forSubTask((List<SubCandidate>)subCandidates, task));
        }
        if (candidateUserExpressions != null && !candidateUserExpressions.isEmpty()) {
            for (Expression userIdExpr : candidateUserExpressions) {
                Object value3 = userIdExpr.getValue((VariableScope)execution);
                if (value3 instanceof String) {
                    List<String> candiates = this.extractCandidates((String)value3);
                    task.addCandidateUsers(candiates);
                    continue;
                }
                if (value3 instanceof Collection) {
                    task.addCandidateUsers((Collection)value3);
                    continue;
                }
                throw new ActivitiException(ERROR_MSG);
            }
        }
        if (!this.taskDefinition.getCustomUserIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomUserIdentityLinkExpressions();
            for (Map.Entry identityLink : identityLinks.entrySet()) {
                for (Expression idExpression : (Set)identityLink.getValue()) {
                    value = idExpression.getValue((VariableScope)execution);
                    if (value instanceof String) {
                        List<String> userIds = this.extractCandidates((String)value);
                        for (String userId : userIds) {
                            task.addUserIdentityLink(userId, (String)identityLink.getKey());
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator userIdSet = ((Collection)value).iterator();
                        while (userIdSet.hasNext()) {
                            task.addUserIdentityLink((String)userIdSet.next(), (String)identityLink.getKey());
                        }
                        continue;
                    }
                    throw new ActivitiException(ERROR_MSG);
                }
            }
        }
        if (!this.taskDefinition.getCustomGroupIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomGroupIdentityLinkExpressions();
            for (Map.Entry identityLink : identityLinks.entrySet()) {
                for (Expression idExpression : (Set)identityLink.getValue()) {
                    value = idExpression.getValue((VariableScope)execution);
                    if (value instanceof String) {
                        List<String> groupIds = this.extractCandidates((String)value);
                        for (String groupId : groupIds) {
                            task.addGroupIdentityLink(groupId, (String)identityLink.getKey());
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator groupIdSet = ((Collection)value).iterator();
                        while (groupIdSet.hasNext()) {
                            task.addGroupIdentityLink((String)groupIdSet.next(), (String)identityLink.getKey());
                        }
                        continue;
                    }
                    throw new ActivitiException(ERROR_MSG);
                }
            }
        }
        return false;
    }

    private void setVariables(TaskEntity task, Map<String, Object> variables) {
        Map<String, String> map = AnalyticalModelUtil.getToDoConfiguration(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (map.isEmpty()) {
            return;
        }
        Map processMap = task.getProcessVariables();
        Map taskMap = task.getTaskLocalVariables();
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        if (variables != null) {
            newVariables.putAll(variables);
        }
        newVariables.putAll(processMap);
        newVariables.putAll(taskMap);
        String todo = !newVariables.isEmpty() ? AnalyticalModelUtil.getTodo(newVariables, map.get("todoConfiguration")) : map.get("todoConfiguration");
        task.setVariableLocal("todoConfiguration", (Object)todo);
        task.setVariableLocal("all_prev_node", newVariables.get("all_prev_node"));
        if (newVariables.containsKey("reject_to")) {
            task.removeVariable("reject_from");
            task.removeVariable("reject_to");
            task.setVariableLocal("reject_from", newVariables.get("reject_from"));
            task.setVariableLocal("reject_to", newVariables.get("reject_to"));
            if (newVariables.containsKey("reject_execution")) {
                task.removeVariable("reject_execution");
                task.setVariableLocal("reject_execution", newVariables.get("reject_execution"));
            }
        }
    }

    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (!((ExecutionEntity)execution).getTasks().isEmpty()) {
            throw new ActivitiException("UserTask should not be signalled before complete");
        }
        this.leave(execution);
    }

    private void ccTask(Task task, Set<String> users, String userId, ActivityExecution execution) {
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        if (processInstance != null) {
            for (String user : users) {
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                sysActCcTask.setTaskName(task.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(userId);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(task.getFormKey());
                sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                sysActCcTask.setReadStatus("0");
                Map map = ((TaskEntity)task).getVariables();
                if (HussarUtils.isNotEmpty((Object)map)) {
                    sysActCcTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActCcTask);
            }
        }
        if (!list.isEmpty()) {
            this.iSysActCcTaskService.saveBatch(list);
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }

    protected Expression getActiveValue(Expression originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        Object activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideValueNode.asText());
        }
        return activeValue;
    }

    protected Set<Expression> getActiveValueSet(Set<Expression> originalValues, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValuesNode;
        Set<Expression> activeValues = originalValues;
        if (taskElementProperties != null && (overrideValuesNode = taskElementProperties.get(propertyName)) != null) {
            if (overrideValuesNode.isNull() || !overrideValuesNode.isArray() || overrideValuesNode.isEmpty()) {
                activeValues = null;
            } else {
                ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
                activeValues = new HashSet<Expression>();
                for (JsonNode valueNode : overrideValuesNode) {
                    activeValues.add(expressionManager.createExpression(valueNode.asText()));
                }
            }
        }
        return activeValues;
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }
}

