/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.datapush.service;

import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.TaskDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.UserDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataPushService {
    private static final Logger logger = LoggerFactory.getLogger(DataPushService.class);
    @Autowired
    List<DataPushListener> dataPushListeners;

    public boolean isDataPush() {
        return true;
    }

    public void addDataPush(DataPush dataPush, List<UserDataPush> userDataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addTask(dataPush, userDataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void completeDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.completeTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void entrustDataPush(DataPush dataPush) {
        this.entrustDataPush(dataPush, null);
    }

    public void entrustDataPush(DataPush dataPush, List<UserDataPush> addUserList) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.entrustTask(dataPush, addUserList);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void rejectDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.rejectTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void revokeDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.revokeTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void freeJumpDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.freeJumpTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addUserDataPush(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addUser(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteMultiTask(List<String> taskIds) {
        try {
            DataPush dataPush = new DataPush();
            dataPush.setTaskIds(taskIds);
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteMultiTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addCcTask(List<DataPush> dataPushes) {
        if (this.isDataPush()) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.addCcTask(dataPushes);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void readCcTask(List<DataPush> dataPushes) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.readCcTask(dataPushes);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteCcTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.deleteCcTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addUrgeTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.addUrgeTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void endProcess(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.endProcess(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void transferTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.transferTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void reTransferTask(DataPush dataPush) {
        try {
            for (DataPushListener dataPushListener : this.dataPushListeners) {
                dataPushListener.reTransferTask(dataPush);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void updatePendingTask(List<TaskDataPush> dataPushList, DataPush dataPush) {
        if (this.isDataPush()) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.updatePendingTask(dataPushList, dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updatePendingTaskUser(List<TaskDataPush> deleteDataPushList, List<TaskDataPush> addDataPushList, DataPush dataPush) {
        if (this.isDataPush()) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.updatePendingTaskUser(deleteDataPushList, addDataPushList, dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addSubTask(List<TaskDataPush> dataPushList) {
        if (this.isDataPush()) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.addSubTask(dataPushList);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void completeSubTask(DataPush dataPush) {
        if (this.isDataPush()) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.completeSubTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateSubTask(List<TaskDataPush> deleteDataPushList, List<TaskDataPush> addDataPushList, DataPush dataPush) {
        if (this.isDataPush()) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.updateSubTask(deleteDataPushList, addDataPushList, dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void createProcess(DataPush dataPush) {
        if (this.isDataPush()) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.createProcess(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateProcess(DataPush dataPush) {
        if (this.isDataPush()) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.updateProcess(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void assigneeUpdate(DataPush dataPush) {
        if (this.isDataPush()) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.assigneeUpdate(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

