/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.archive.provider.ArchiveReadonlyContext;
import com.jxdinfo.hussar.archive.provider.ArchiveServiceMetadata;
import com.jxdinfo.hussar.archive.provider.ArchiveServiceProvider;
import com.jxdinfo.hussar.archive.provider.ArchiveServiceResult;
import com.jxdinfo.hussar.archive.provider.ArchiveWritableContext;
import com.jxdinfo.hussar.archive.utils.MigrationJsonUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.model.AlternativeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.service.IAlternativeTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.model.BpmBusinessModule;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.service.ISysBusinessModuleService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.model.SysActCcTaskConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.service.ISysActCcTaskConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActPostAction;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActPostActionService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.DumpAndLoadMetadata;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.model.SysActProcessDept;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.ISysActProcessDeptService;
import com.jxdinfo.hussar.workflow.engine.bpm.processextend.service.IProcdefService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.model.ProcessGroup;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.service.IProcessGroupService;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.UpdateByteArrayModelMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.model.UpdateByteArrayModel;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DumpAndLoadServiceImpl
implements ArchiveServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(DumpAndLoadServiceImpl.class);
    private static final String WORKFLOWNAME = "name";
    private static final String VERSION = "version";
    private static final String BUSINESSMODULEIDS = "businessModuleIds";
    private static final String VERSIONS = "versions";
    private static final String WORKFLOWNAMES = "names";
    private static final DumpAndLoadMetadata METADATA = new DumpAndLoadMetadata();
    @Resource
    private ModelService modelService;
    @Autowired
    private IProcdefService procdefService;
    @Autowired
    private ISysActExtendPropertiesService sysActExtendPropertiesService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private SysActFormAuthService sysActFormAuthService;
    @Autowired
    private ISysActCcTaskConfigService sysActCcTaskConfigService;
    @Autowired
    private IAlternativeTaskService alternativeTaskService;
    @Autowired
    private IProcessGroupService processGroupService;
    @Autowired
    private ISysActProcessDeptService sysActProcessDeptService;
    @Autowired
    private ISysBusinessModuleService sysBusinessModuleService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private UpdateByteArrayModelMapper updateByteArrayModelMapper;
    @Autowired
    private Bpm2XMLMapper bpm2XMLMapper;
    @Autowired
    private ISysActPostActionService iSysActPostActionService;

    public ArchiveServiceMetadata metadata() {
        return METADATA;
    }

    public ArchiveServiceResult<Object> dump(ArchiveWritableContext context, Map<String, Object> parameters) {
        ArrayList<String> fileNames = new ArrayList<String>();
        HashMap map = new HashMap();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            List workflowInfos = (List)entry.getValue();
            HashMap<String, Object> fileInfo = new HashMap<String, Object>();
            ArrayList<String> versions = new ArrayList<String>();
            ArrayList<String> processDefinitionIds = new ArrayList<String>();
            List businessModuleIds = new ArrayList();
            HashMap<String, String> versionToNameMap = new HashMap<String, String>();
            String filePrefix = key;
            if (HussarUtils.isEmpty((Object)workflowInfos)) continue;
            businessModuleIds = (List)((Map)workflowInfos.get(0)).get(BUSINESSMODULEIDS);
            for (Map workflowInfo : workflowInfos) {
                String fileName = String.valueOf(workflowInfo.get(WORKFLOWNAME));
                String version = String.valueOf(workflowInfo.get(VERSION));
                String processDefinitionId = this.modelService.getRealProcessDefinitionId(key, version);
                processDefinitionIds.add(processDefinitionId);
                versions.add(version);
                versionToNameMap.put(version, fileName);
            }
            fileInfo.put(VERSIONS, versions);
            fileInfo.put(WORKFLOWNAMES, versionToNameMap);
            fileInfo.put("myKey", key);
            List processExtendProperties = this.procdefService.list((Wrapper)new LambdaQueryWrapper().in(ProcessExtendProperties::getId, processDefinitionIds));
            Map processModel = this.modelService.exportModel(processDefinitionIds);
            List sysActProcessFiles = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().in(SysActProcessFile::getProcessId, processDefinitionIds));
            List sysActExtendProperties = this.sysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().in(SysActExtendProperties::getProcDefId, processDefinitionIds));
            List sysActPostActions = this.iSysActPostActionService.list((Wrapper)new LambdaQueryWrapper().in(SysActPostAction::getProcDefId, processDefinitionIds));
            ArrayList sysActAssignees = new ArrayList();
            versions.forEach(o -> {
                List assignees = this.sysActAssigneeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)key)).eq(SysActAssignee::getProcVer, (Object)String.valueOf(o)));
                if (HussarUtils.isNotEmpty((Object)assignees)) {
                    sysActAssignees.addAll(assignees);
                }
            });
            ArrayList sysActFormAuths = new ArrayList();
            versions.forEach(o -> {
                List formAuths = this.sysActFormAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)key)).eq(SysActFormAuth::getProcVer, (Object)String.valueOf(o)));
                if (HussarUtils.isNotEmpty((Object)formAuths)) {
                    sysActFormAuths.addAll(formAuths);
                }
            });
            ArrayList sysActCcTaskConfigs = new ArrayList();
            versions.forEach(o -> {
                List ccTaskConfigs = this.sysActCcTaskConfigService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTaskConfig::getProcDefKey, (Object)key)).eq(SysActCcTaskConfig::getProcVersion, (Object)String.valueOf(o)));
                if (HussarUtils.isNotEmpty((Object)ccTaskConfigs)) {
                    sysActCcTaskConfigs.addAll(ccTaskConfigs);
                }
            });
            ArrayList alternativeTasks = new ArrayList();
            versions.forEach(o -> {
                List tasks = this.alternativeTaskService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AlternativeTask::getProcessKey, (Object)key)).eq(AlternativeTask::getProcessDefinitionVersion, (Object)String.valueOf(o)));
                if (HussarUtils.isNotEmpty((Object)tasks)) {
                    alternativeTasks.addAll(tasks);
                }
            });
            List procGroupNumbers = processExtendProperties.stream().map(ProcessExtendProperties::getProcGroupNumber).distinct().collect(Collectors.toList());
            List processGroups = this.processGroupService.list((Wrapper)new LambdaQueryWrapper().in(ProcessGroup::getGroupNumber, procGroupNumbers));
            List sysActProcessDepts = this.sysActProcessDeptService.list((Wrapper)new LambdaQueryWrapper().in(SysActProcessDept::getProcGroupNumber, procGroupNumbers));
            List bpmBusinessModules = this.sysBusinessModuleService.list((Wrapper)new LambdaQueryWrapper().in(BpmBusinessModule::getBusinessModuleId, businessModuleIds));
            ModelBuild modelBuild = (ModelBuild)this.modelService.getOne((Wrapper)new LambdaQueryWrapper().eq(ModelBuild::getProcessKey, (Object)key));
            context.setPayloadOfByteArray(filePrefix + "-\u6d41\u7a0b\u62d3\u5c55.json", MigrationJsonUtils.toByteArray((Object)processExtendProperties));
            context.setPayloadOfByteArray(filePrefix + ".bpmn20.xml", MigrationJsonUtils.toByteArray((Object)processModel));
            context.setPayloadOfByteArray(filePrefix + "-\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", MigrationJsonUtils.toByteArray((Object)sysActProcessFiles));
            context.setPayloadOfByteArray(filePrefix + "-\u6269\u5c55\u5c5e\u6027.json", MigrationJsonUtils.toByteArray((Object)sysActExtendProperties));
            context.setPayloadOfByteArray(filePrefix + "-\u540e\u7f6e\u52a8\u4f5c.json", MigrationJsonUtils.toByteArray((Object)sysActPostActions));
            context.setPayloadOfByteArray(filePrefix + "-\u53c2\u4e0e\u8005.json", MigrationJsonUtils.toByteArray(sysActAssignees));
            context.setPayloadOfByteArray(filePrefix + "-\u6743\u9650.json", MigrationJsonUtils.toByteArray(sysActFormAuths));
            context.setPayloadOfByteArray(filePrefix + "-\u6284\u9001\u914d\u7f6e.json", MigrationJsonUtils.toByteArray(sysActCcTaskConfigs));
            context.setPayloadOfByteArray(filePrefix + "-\u5907\u9009\u8282\u70b9.json", MigrationJsonUtils.toByteArray(alternativeTasks));
            context.setPayloadOfByteArray(filePrefix + "-\u6d41\u7a0b\u5206\u7ec4.json", MigrationJsonUtils.toByteArray((Object)processGroups));
            context.setPayloadOfByteArray(filePrefix + "-\u6d41\u7a0b\u90e8\u95e8.json", MigrationJsonUtils.toByteArray((Object)sysActProcessDepts));
            context.setPayloadOfByteArray(filePrefix + "\u4e1a\u52a1\u6a21\u5757.json", MigrationJsonUtils.toByteArray((Object)bpmBusinessModules));
            context.setPayloadOfByteArray(filePrefix + "\u6d41\u7a0b\u6a21\u578b.json", MigrationJsonUtils.toByteArray((Object)modelBuild));
            fileNames.add(filePrefix + "-\u6d41\u7a0b\u62d3\u5c55.json");
            fileNames.add(filePrefix + ".bpmn20.xml");
            fileNames.add(filePrefix + "-\u6d41\u7a0b\u6587\u4ef6.lcdpbpm");
            fileNames.add(filePrefix + "-\u6269\u5c55\u5c5e\u6027.json");
            fileNames.add(filePrefix + "-\u540e\u7f6e\u52a8\u4f5c.json");
            fileNames.add(filePrefix + "-\u53c2\u4e0e\u8005.json");
            fileNames.add(filePrefix + "-\u6743\u9650.json");
            fileNames.add(filePrefix + "-\u6284\u9001\u914d\u7f6e.json");
            fileNames.add(filePrefix + "-\u5907\u9009\u8282\u70b9.json");
            fileNames.add(filePrefix + "-\u6d41\u7a0b\u5206\u7ec4.json");
            fileNames.add(filePrefix + "-\u6d41\u7a0b\u90e8\u95e8.json");
            fileNames.add(filePrefix + "\u4e1a\u52a1\u6a21\u5757.json");
            fileNames.add(filePrefix + "\u6d41\u7a0b\u6a21\u578b.json");
            map.put(key, fileInfo);
        }
        context.setAttribute("workFlows", map);
        context.setAttribute("fileNames", fileNames);
        return ArchiveServiceResult.success();
    }

    public ArchiveServiceResult<Object> preload(ArchiveReadonlyContext context, Map<String, Object> parameters) {
        return ArchiveServiceResult.success();
    }

    public ArchiveServiceResult<Object> load(ArchiveReadonlyContext context, Map<String, Object> parameters) {
        ArrayList formAuthTable = new ArrayList();
        ArrayList assigneeTable = new ArrayList();
        HashMap xmls = new HashMap();
        ArrayList processFileTable = new ArrayList();
        ArrayList processDefinitionTable = new ArrayList();
        ArrayList processGroupTable = new ArrayList();
        ArrayList processDeptTable = new ArrayList();
        ArrayList businessModuleTable = new ArrayList();
        ArrayList expandPropertiesTable = new ArrayList();
        ArrayList sysActPostActionTable = new ArrayList();
        ArrayList ccTaskConfigTable = new ArrayList();
        ArrayList alternativeTable = new ArrayList();
        ArrayList<ModelBuild> modelBuild = new ArrayList<ModelBuild>();
        ArrayList processKeys = new ArrayList();
        HashMap processKeyToVersions = new HashMap();
        Map workFlowInfos = (Map)context.getAttribute("workFlows");
        workFlowInfos.forEach((k, v) -> {
            processKeys.add(String.valueOf(k));
            processKeyToVersions.put(String.valueOf(k), (List)((Map)v).get(VERSIONS));
        });
        List fileNames = (List)context.getAttribute("fileNames");
        for (String fileName : fileNames) {
            if (fileName.endsWith("-\u6743\u9650.json")) {
                List sysActFormAuths = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<List<SysActFormAuth>>(){});
                if (sysActFormAuths == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                formAuthTable.addAll(sysActFormAuths);
            }
            if (fileName.endsWith("-\u53c2\u4e0e\u8005.json")) {
                List sysActAssignees = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<List<SysActAssignee>>(){});
                if (sysActAssignees == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                assigneeTable.addAll(sysActAssignees);
            }
            if (fileName.endsWith(".bpmn20.xml")) {
                Map temp = (Map)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<Map<String, byte[]>>(){});
                if (temp == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                xmls.putAll(temp);
            }
            if (fileName.endsWith("-\u6d41\u7a0b\u6587\u4ef6.lcdpbpm")) {
                List sysActProcessFiles = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<List<SysActProcessFile>>(){});
                if (sysActProcessFiles == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                processFileTable.addAll(sysActProcessFiles);
            }
            if (fileName.endsWith("-\u6d41\u7a0b\u62d3\u5c55.json")) {
                List processExtendProperties = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<List<ProcessExtendProperties>>(){});
                if (processExtendProperties == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                processDefinitionTable.addAll(processExtendProperties);
            }
            if (fileName.endsWith("-\u6d41\u7a0b\u5206\u7ec4.json")) {
                List processGroups = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<List<ProcessGroup>>(){});
                if (processGroups == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                processGroupTable.addAll(processGroups);
            }
            if (fileName.endsWith("-\u6d41\u7a0b\u90e8\u95e8.json")) {
                List sysActProcessDepts = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<List<SysActProcessDept>>(){});
                if (sysActProcessDepts == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                processDeptTable.addAll(sysActProcessDepts);
            }
            if (fileName.endsWith("\u4e1a\u52a1\u6a21\u5757.json")) {
                List bpmBusinessModules = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<List<BpmBusinessModule>>(){});
                if (bpmBusinessModules == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                businessModuleTable.addAll(bpmBusinessModules);
            }
            if (fileName.endsWith("-\u6269\u5c55\u5c5e\u6027.json")) {
                List sysActExtendProperties = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<List<SysActExtendProperties>>(){});
                if (sysActExtendProperties == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                expandPropertiesTable.addAll(sysActExtendProperties);
            }
            if (fileName.endsWith("-\u540e\u7f6e\u52a8\u4f5c.json")) {
                List sysActPostActions = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<List<SysActPostAction>>(){});
                if (sysActPostActions == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                sysActPostActionTable.addAll(sysActPostActions);
            }
            if (fileName.endsWith("-\u6284\u9001\u914d\u7f6e.json")) {
                List sysActCcTaskConfigs = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<List<SysActCcTaskConfig>>(){});
                if (sysActCcTaskConfigs == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                ccTaskConfigTable.addAll(sysActCcTaskConfigs);
            }
            if (fileName.endsWith("-\u5907\u9009\u8282\u70b9.json")) {
                List alternativeTasks = (List)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<List<AlternativeTask>>(){});
                if (alternativeTasks == null) {
                    logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                    return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                }
                alternativeTable.addAll(alternativeTasks);
            }
            if (!fileName.endsWith("\u6d41\u7a0b\u6a21\u578b.json")) continue;
            ModelBuild model = (ModelBuild)MigrationJsonUtils.parse((String)context.getPayloadAsString(fileName), (TypeReference)new TypeReference<ModelBuild>(){});
            if (model == null) {
                logger.error("{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
                return ArchiveServiceResult.fail((String)"{}\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Object)fileName);
            }
            modelBuild.add(model);
        }
        this.sysBusinessModuleService.saveOrUpdateBatch(businessModuleTable);
        ArrayList oldProcessDefIds = new ArrayList();
        HashMap newProcessDefIds = new HashMap();
        processKeys.forEach(o -> {
            List versions = (List)processKeyToVersions.get(String.valueOf(o));
            versions.forEach(v -> {
                boolean isNewVersion = false;
                Long count = this.procdefService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessExtendProperties::getProcessKey, o)).eq(ProcessExtendProperties::getVersion, v));
                isNewVersion = count <= 0L;
                ArrayList<Object> processDefId = new ArrayList<Object>();
                processDefId.add(this.saveWorkflow(processFileTable, assigneeTable, processGroupTable, expandPropertiesTable, sysActPostActionTable, formAuthTable, alternativeTable, processDeptTable, ccTaskConfigTable, processDefinitionTable, "0", (String)o, (String)v, xmls, (List<ModelBuild>)modelBuild, isNewVersion).getData());
                if (HussarUtils.isNotEmpty(processDefId)) {
                    ProcessExtendProperties processExtendProperties = new ProcessExtendProperties();
                    List ownProcessExtendProperties = processDefinitionTable.stream().filter(p -> p.getId().equals(processDefId.get(0))).collect(Collectors.toList());
                    processExtendProperties.setAllowNullApprover(((ProcessExtendProperties)ownProcessExtendProperties.get(0)).getAllowNullApprover());
                    processExtendProperties.setMustUploadAttachment(((ProcessExtendProperties)ownProcessExtendProperties.get(0)).getMustUploadAttachment());
                    processExtendProperties.setCopyAttachmentAtRectification(((ProcessExtendProperties)ownProcessExtendProperties.get(0)).getCopyAttachmentAtRectification());
                    processExtendProperties.setRuleOfHiApproverAtApproval(((ProcessExtendProperties)ownProcessExtendProperties.get(0)).getRuleOfHiApproverAtApproval());
                    processExtendProperties.setRectificationBeanId(((ProcessExtendProperties)ownProcessExtendProperties.get(0)).getRectificationBeanId());
                    processExtendProperties.setViewFormAddress(((ProcessExtendProperties)ownProcessExtendProperties.get(0)).getViewFormAddress());
                    processExtendProperties.setEditFormAddress(((ProcessExtendProperties)ownProcessExtendProperties.get(0)).getEditFormAddress());
                    processExtendProperties.setProcGroupNumber(((ProcessExtendProperties)ownProcessExtendProperties.get(0)).getProcGroupNumber());
                    processExtendProperties.setGroupVersion(((ProcessExtendProperties)ownProcessExtendProperties.get(0)).getGroupVersion());
                    this.procdefService.update((Object)processExtendProperties, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ProcessExtendProperties::getProcessKey, o)).eq(ProcessExtendProperties::getVersion, v));
                    String newProcessDefId = ((ProcessExtendProperties)this.procdefService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessExtendProperties::getProcessKey, o)).eq(ProcessExtendProperties::getVersion, v))).getId();
                    oldProcessDefIds.add(processDefId.get(0));
                    if (HussarUtils.isNotEmpty((Object)newProcessDefId)) {
                        List ownSysActPostActions;
                        List ownExtendProperties;
                        newProcessDefIds.put(processDefId.get(0), newProcessDefId);
                        SysActProcessFile wfdFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, o)).eq(SysActProcessFile::getVersion, v)).eq(SysActProcessFile::getType, (Object)"wfd"));
                        SysActProcessFile metaFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, o)).eq(SysActProcessFile::getVersion, v)).eq(SysActProcessFile::getType, (Object)"meta"));
                        if (HussarUtils.isNotEmpty((Object)wfdFile)) {
                            wfdFile.setProcessId(newProcessDefId);
                            this.sysActProcessFileService.update((Object)wfdFile, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysActProcessFile::getProcessKey, o)).eq(SysActProcessFile::getVersion, v)).eq(SysActProcessFile::getType, (Object)"wfd"));
                        }
                        if (HussarUtils.isNotEmpty((Object)metaFile)) {
                            metaFile.setProcessId(newProcessDefId);
                            this.sysActProcessFileService.update((Object)metaFile, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysActProcessFile::getProcessKey, o)).eq(SysActProcessFile::getVersion, v)).eq(SysActProcessFile::getType, (Object)"meta"));
                        }
                        if (HussarUtils.isNotEmpty((Object)(ownExtendProperties = this.sysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, processDefId.get(0)))))) {
                            ownExtendProperties.forEach(i -> i.setProcDefId(newProcessDefId));
                            this.sysActExtendPropertiesService.updateBatchById((Collection)ownExtendProperties);
                        }
                        if (HussarUtils.isNotEmpty((Object)(ownSysActPostActions = this.iSysActPostActionService.list((Wrapper)new LambdaQueryWrapper().eq(SysActPostAction::getProcDefId, processDefId.get(0)))))) {
                            ownSysActPostActions.forEach(i -> i.setProcDefId(newProcessDefId));
                            this.iSysActPostActionService.updateBatchById((Collection)ownSysActPostActions);
                        }
                    }
                }
            });
        });
        oldProcessDefIds.forEach(old -> {
            List ownProcessGroups = this.processGroupService.list((Wrapper)new LambdaQueryWrapper().eq(ProcessGroup::getMainProcDefId, old));
            if (HussarUtils.isNotEmpty((Object)ownProcessGroups) && HussarUtils.isNotEmpty(newProcessDefIds.get(old))) {
                ownProcessGroups.forEach(i -> i.setMainProcDefId((String)newProcessDefIds.get(old)));
                this.processGroupService.updateBatchById((Collection)ownProcessGroups);
            }
        });
        return ArchiveServiceResult.success();
    }

    private synchronized ApiResponse<String> saveWorkflow(List<SysActProcessFile> sysActProcessFiles, List<SysActAssignee> sysActAssignees, List<ProcessGroup> processGroups, List<SysActExtendProperties> sysActExtendProperties, List<SysActPostAction> sysActPostActions, List<SysActFormAuth> sysActFormAuths, List<AlternativeTask> alternativeTasks, List<SysActProcessDept> sysActProcessDepts, List<SysActCcTaskConfig> ccTaskConfigs, List<ProcessExtendProperties> processExtendProperties, String tenantId, String processKey, String version, Map<String, byte[]> xlms, List<ModelBuild> modelBuild, boolean isNewVersion) {
        try {
            WorkFlow workFlow = this.saveOrUpdateWorkFlow(sysActProcessFiles, processKey, version);
            List ownAssignees = sysActAssignees.stream().filter(o -> String.valueOf(o.getProcDefKey()).equals(processKey) && String.valueOf(o.getProcVer()).equals(version)).collect(Collectors.toList());
            this.sysActAssigneeService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)processKey));
            this.sysActAssigneeService.saveOrUpdateBatch(ownAssignees);
            String groupNumber = workFlow.getGroupNumber();
            List ownProcessGroups = processGroups.stream().filter(o -> o.getGroupNumber().equals(groupNumber)).collect(Collectors.toList());
            this.processGroupService.saveOrUpdateBatch(ownProcessGroups);
            ModelBuild ownModelBuild = (ModelBuild)modelBuild.stream().filter(o -> o.getProcessKey().equals(processKey)).collect(Collectors.toList()).get(0);
            ownModelBuild.setModelKey(null);
            this.modelService.saveOrUpdate((Object)ownModelBuild);
            if (isNewVersion) {
                BpmnModel bpmnModel = this.getBpmnModel(xlms.get(workFlow.getProcDefId()));
                ExtendBpmnJsonConverter child = new ExtendBpmnJsonConverter();
                child.updateConvertersToBpmnMap();
                child.updateConvertersToJsonMap();
                ObjectNode editorNode = child.convertToJson(bpmnModel);
                this.repositoryService.createDeployment().name(workFlow.getName()).addBpmnModel(workFlow.getName() + ".bpmn20.xml", bpmnModel).tenantId(tenantId).deploy(Integer.valueOf(version));
                ModelBuild tempMode = (ModelBuild)this.modelService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ModelBuild::getModelId, (Object)workFlow.getModelId())).select(new SFunction[]{ModelBuild::getEditorSourceValueId, ModelBuild::getModelId}));
                String editorSourceValueId = tempMode.getEditorSourceValueId();
                UpdateByteArrayModel byteArrayModel = (UpdateByteArrayModel)this.updateByteArrayModelMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UpdateByteArrayModel::getId, (Object)editorSourceValueId)).select(new SFunction[]{UpdateByteArrayModel::getId}));
                if (HussarUtils.isEmpty((Object)byteArrayModel)) {
                    this.modelService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ModelBuild::getModelId, (Object)workFlow.getModelId())).set(ModelBuild::getEditorSourceValueId, null));
                }
            } else {
                UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
                updateByteArrayModel.setBytes(xlms.get(workFlow.getProcDefId()));
                updateByteArrayModel.setId(this.bpm2XMLMapper.getUpdateModelByProcDefId(workFlow.getProcDefId()));
                this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
            }
            List ownExtendProperties = sysActExtendProperties.stream().filter(o -> o.getProcDefId().equals(workFlow.getProcDefId())).collect(Collectors.toList());
            this.sysActExtendPropertiesService.saveOrUpdateBatch(ownExtendProperties);
            List ownSysActPostActions = sysActPostActions.stream().filter(o -> o.getProcDefId().equals(workFlow.getProcDefId())).collect(Collectors.toList());
            String postProcDefId = workFlow.getIdentity() + ":" + workFlow.getVersion() + ":";
            this.iSysActPostActionService.remove((Wrapper)new LambdaQueryWrapper().like(SysActPostAction::getProcDefId, (Object)postProcDefId));
            this.iSysActPostActionService.saveOrUpdateBatch(ownSysActPostActions);
            List ownSysActFormAuth = sysActFormAuths.stream().filter(o -> String.valueOf(o.getProcessKey()).equals(processKey) && String.valueOf(o.getProcVer()).equals(version)).collect(Collectors.toList());
            this.sysActFormAuthService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)workFlow.getIdentity()));
            this.sysActFormAuthService.saveOrUpdateBatch(ownSysActFormAuth);
            List ownAlternativeTasks = alternativeTasks.stream().filter(o -> String.valueOf(o.getProcessKey()).equals(processKey) && String.valueOf(o.getProcessDefinitionVersion()).equals(version)).collect(Collectors.toList());
            this.alternativeTaskService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AlternativeTask::getProcessKey, (Object)processKey)).eq(AlternativeTask::getProcessDefinitionVersion, (Object)version));
            this.alternativeTaskService.saveOrUpdateBatch(ownAlternativeTasks);
            List groupNumbers = processExtendProperties.stream().filter(o -> String.valueOf(o.getProcessKey()).equals(processKey) && String.valueOf(o.getVersion()).equals(version)).map(ProcessExtendProperties::getProcGroupNumber).collect(Collectors.toList());
            List ownSysActProcessDept = sysActProcessDepts.stream().filter(o -> String.valueOf(o.getProcessKey()).equals(processKey) && String.valueOf(o.getProcGroupNumber()).equals(groupNumbers.get(0))).collect(Collectors.toList());
            this.sysActProcessDeptService.saveOrUpdateBatch(ownSysActProcessDept);
            List ownCcTaskConfigs = ccTaskConfigs.stream().filter(o -> String.valueOf(o.getProcDefKey()).equals(processKey) && String.valueOf(o.getProcVersion()).equals(version)).collect(Collectors.toList());
            this.sysActCcTaskConfigService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTaskConfig::getProcDefKey, (Object)processKey)).eq(SysActCcTaskConfig::getProcVersion, (Object)version));
            this.sysActCcTaskConfigService.saveOrUpdateBatch(ownCcTaskConfigs);
            return ApiResponse.success((Object)workFlow.getProcDefId(), (String)this.bpmConstantProperties.getSuccessSave());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
        }
    }

    private WorkFlow saveOrUpdateWorkFlow(List<SysActProcessFile> sysActProcessFiles, String processKey, String version) {
        List ownProcessFiles = sysActProcessFiles.stream().filter(o -> String.valueOf(o.getProcessKey()).equals(processKey) && String.valueOf(o.getVersion()).equals(version)).collect(Collectors.toList());
        SysActProcessFile wfdFile = new SysActProcessFile();
        SysActProcessFile metaFile = new SysActProcessFile();
        String procDefId = null;
        for (SysActProcessFile processFile : ownProcessFiles) {
            if (HussarUtils.equals((Object)"wfd", (Object)processFile.getType())) {
                wfdFile = processFile;
                this.sysActProcessFileService.saveOrUpdate((Object)wfdFile, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)processKey)).eq(SysActProcessFile::getVersion, (Object)version)).eq(SysActProcessFile::getType, (Object)"wfd"));
                continue;
            }
            metaFile = processFile;
            this.sysActProcessFileService.saveOrUpdate((Object)metaFile, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)processKey)).eq(SysActProcessFile::getVersion, (Object)version)).eq(SysActProcessFile::getType, (Object)"meta"));
        }
        wfdFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)processKey)).eq(SysActProcessFile::getVersion, (Object)version)).eq(SysActProcessFile::getType, (Object)"wfd"));
        metaFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessKey, (Object)processKey)).eq(SysActProcessFile::getVersion, (Object)version)).eq(SysActProcessFile::getType, (Object)"meta"));
        procDefId = metaFile.getProcessId();
        String wfdInfo = null;
        if (HussarUtils.isNotEmpty((Object)wfdFile)) {
            wfdInfo = wfdFile.getContent() == null ? null : new String(wfdFile.getContent(), StandardCharsets.UTF_8);
        }
        String metaInfo = null;
        if (HussarUtils.isNotEmpty((Object)metaFile)) {
            String string = metaInfo = metaFile.getContent() == null ? null : new String(metaFile.getContent(), StandardCharsets.UTF_8);
        }
        if (HussarUtils.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            workFlow.setVersion(String.valueOf(version));
            workFlow.setProcDefId(procDefId);
            return workFlow;
        }
        return null;
    }

    private BpmnModel getBpmnModel(byte[] xml) {
        BpmnModel bpmnModel = new BpmnModel();
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml);
            BpmnXMLConverter converter = new BpmnXMLConverter();
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(inputStream);
            bpmnModel = converter.convertToBpmnModel(reader);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return bpmnModel;
    }
}

