/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.utils.CcTaskUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.model.SysActCcTaskConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.service.ISysActCcTaskConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.InstanceEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.processapprovefile.service.ISysActProcessApproveFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.ProcessState;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiProcessStartedEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ProcessCreateListener
implements ActivitiEventListener {
    private static Logger logger = LogManager.getLogger(ProcessCreateListener.class);
    @Resource
    private InstanceEngineMapper instanceEngineMapper;
    @Autowired
    private ISysActCcTaskConfigService sysActCcTaskConfigService;
    @Autowired
    private ISysActCcTaskService sysActCcTaskService;
    @Lazy
    @Autowired
    private IFlowTaskService flowTaskService;
    @Lazy
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Lazy
    @Autowired
    private ISysActProcessApproveFileService processApproveFileService;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;

    public void onEvent(ActivitiEvent activitiEvent) {
        List<SysActCcTask> ccTaskList;
        String originalProcessInsId;
        ExecutionEntity entity = (ExecutionEntity)((ActivitiProcessStartedEventImpl)activitiEvent).getEntity();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCreateEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("createTime", simpleDateFormat.format(new Date()));
        map.put("tenantId", entity.getTenantId());
        map.put("businessId", entity.getBusinessKey());
        map.put("processInsId", entity.getProcessInstanceId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        List linkEntityList = entity.getIdentityLinks();
        if (!linkEntityList.isEmpty()) {
            map.put("starter", ((IdentityLinkEntity)linkEntityList.get(0)).getUserId());
        }
        CommonCodeUtil.triggerEventHandleClass(map);
        if (entity.getProcessInstance().getSuperExecution() == null) {
            Context.getCommandContext().addAttribute("taskSourceFlag", (Object)"main_process_start");
        }
        if (HussarUtils.isNotEmpty((Object)(originalProcessInsId = this.instanceEngineMapper.selectOriginalProcessInstId(entity.getBusinessKey())))) {
            HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(entity.getProcessInstanceId());
            historicProcessInstance.setOriginalProcInstId(Long.valueOf(Long.parseLong(originalProcessInsId)));
            this.flowTaskService.eliminateRemindersByProcessInstanceId(originalProcessInsId);
        }
        String sendId = map.get("starter").toString();
        Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionById(entity.getProcessDefinitionId());
        ProcessDefinition processDefinition = (ProcessDefinition)ProcessEngines.getDefaultProcessEngine().getRepositoryService().createProcessDefinitionQuery().processDefinitionId(entity.getProcessDefinitionId()).singleResult();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysActCcTaskConfig::getProcDefKey, (Object)entity.getProcessDefinitionKey())).eq(SysActCcTaskConfig::getProcVersion, (Object)(processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion()))).eq(SysActCcTaskConfig::getChanceType, (Object)"cc_after_process_start");
        List sysActCcTaskConfigList = this.sysActCcTaskConfigService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)sysActCcTaskConfigList) && HussarUtils.isNotEmpty(ccTaskList = CcTaskUtil.getCcTaskList(entity, sysActCcTaskConfigList, sendId, sendId))) {
            this.sysActCcTaskService.saveBatch(ccTaskList);
            ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
            for (SysActCcTask sysActCcTask : ccTaskList) {
                ArrayList<String> userIds = new ArrayList<String>();
                userIds.add(sysActCcTask.getReceiveUser());
                Map list1 = this.iAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(userIds);
                sysActCcTask.setPostId(((UserDepartmentAndPostModel)list1.get(sysActCcTask.getReceiveUser())).getPostId());
                sysActCcTask.setPostOrganId(((UserDepartmentAndPostModel)list1.get(sysActCcTask.getReceiveUser())).getDepartmentId());
                sysActCcTask.setPostUnitId(((UserDepartmentAndPostModel)list1.get(sysActCcTask.getReceiveUser())).getUnitId());
                if (!this.dataPushService.isDataPush()) continue;
                DataPush dataPush = new DataPush();
                dataPush.setDataPushId(sysActCcTask.getId().toString());
                dataPush.setTaskId(sysActCcTask.getTaskId() != null ? sysActCcTask.getTaskId().toString() : null);
                dataPush.setUserId(sysActCcTask.getReceiveUser());
                dataPush.setSendUser(sysActCcTask.getSendUser());
                dataPush.setStartDate((Date)sysActCcTask.getSendTime());
                dataPush.setProcessInsId(sysActCcTask.getProcessInsId().toString());
                dataPush.setBusinessKey(sysActCcTask.getBusinessId());
                dataPush.setTaskDefinitionKey(sysActCcTask.getTaskDefKey());
                dataPush.setUrl(sysActCcTask.getFormKey());
                dataPush.setProcessKey(sysActCcTask.getProcDefKey());
                dataPush.setDeptId(sysActCcTask.getPostOrganId());
                dataPush.setUnitId(sysActCcTask.getPostUnitId());
                dataPush.setPostId(sysActCcTask.getPostId());
                dataPushes.add(dataPush);
            }
            if (this.dataPushService.isDataPush()) {
                this.dataPushService.addCcTask(dataPushes);
            }
        }
        Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(entity.getProcessInstanceId()).setProcessState(ProcessState.RUNNING.getValue());
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u542f\u52a8\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

