/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.task.IdentityLink;

public class TaskCompleteCmd
implements Command<TaskEntity> {
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ITaskEngineService iTaskEngineService = (ITaskEngineService)SpringContextHolder.getBean(ITaskEngineService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);
    private String taskId;
    private String userId;
    private String mandator;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String comment;
    private String approvalType;
    private IdentityLink identityLink;

    public TaskEntity execute(CommandContext commandContext) {
        TaskEntityManager taskEntityManager;
        List childTasks;
        commandContext.addAttribute("approvalType", (Object)this.approvalType);
        if (this.variables.containsKey("bpm_next_node")) {
            commandContext.addAttribute("bpm_next_node", this.variables.get("bpm_next_node"));
            this.variables.remove("bpm_next_node");
        }
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (this.identityLink != null) {
            task.setPostId(this.identityLink.getPostId());
            task.setDeptId(this.identityLink.getDeptId());
            task.setUnitId(this.identityLink.getUnitId());
        }
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(this.taskId);
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        this.variables.put("sendUser", HussarUtils.isEmpty((Object)this.mandator) ? this.userId : this.mandator);
        this.variables.put("bpm_submit_source", task.getTaskDefinitionKey());
        task.setVariableLocal("taskSourceFlag", (Object)"complete", true);
        task.getExecution().setVariableLocal("all_prev_node", (Object)("'" + task.getTaskDefinitionKey() + "'"));
        Map<String, Object> appointAssignee = new HashMap();
        if (this.variables.get("appoint_assignee") != null) {
            appointAssignee = (Map)this.variables.get("appoint_assignee");
        }
        if (HussarUtils.isEmpty(appointAssignee.get("static_appoint_assignee"))) {
            appointAssignee.put("static_appoint_assignee", null);
            this.variables.put("appoint_assignee", appointAssignee);
        }
        if (!(childTasks = (taskEntityManager = commandContext.getTaskEntityManager()).findTasksByParentTaskId(this.taskId)).isEmpty()) {
            ArrayList<String> childTaskIds = new ArrayList<String>();
            childTasks.forEach(childTask -> {
                taskEntityManager.deleteTask((TaskEntity)childTask, null, true);
                childTaskIds.add(childTask.getId());
            });
            if (this.dataPushService.isDataPush()) {
                this.dataPushService.deleteMultiTask(childTaskIds);
            }
        }
        if (task.getDelegationState() != null) {
            task.resolve();
        }
        task.fireEvent("beforeComplete");
        if (task.getExecutionId() != null) {
            task.setExecutionVariables(this.variables);
        } else {
            task.setVariables(this.variables);
        }
        ParamModel paramModel = this.getParamModel(task, this.variables);
        Context.getCommandContext().addAttribute("info", (Object)paramModel);
        task.setApprovalType(this.approvalType);
        task.complete(this.variables, false, this.mandator);
        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(this.taskId);
        }
        return task;
    }

    public String getApprovalType() {
        return this.approvalType;
    }

    public TaskCompleteCmd setApprovalType(String approvalType) {
        this.approvalType = approvalType;
        return this;
    }

    public TaskCompleteCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, Map<String, Object> variables) {
        this(taskId, userId);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public TaskCompleteCmd(String taskId, String userId, String comment) {
        this(taskId, userId);
        this.comment = comment;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, String comment, Map<String, Object> variables) {
        this(taskId, userId, comment);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public TaskCompleteCmd setIdentityLink(IdentityLink identityLink) {
        this.identityLink = identityLink;
        return this;
    }

    public ParamModel getParamModel(TaskEntity task, Map<String, Object> variables) {
        ParamModel paramModel = new ParamModel();
        String completeType = ((VariableInstanceEntity)task.getVariableInstanceEntities().get("complete_type")).getTextValue();
        paramModel.setCompleteType(completeType);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        BpmResponseResult result = this.iTaskEngineService.queryNextNode(null, this.taskId, false, false, null);
        JSONArray jsonArray = result.getResult();
        String nextNodeId = "";
        HashMap<String, String> activityTypeMap = new HashMap<String, String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            nextNodeId = nextNodeId + "," + jsonObject.get((Object)"id").toString();
            activityTypeMap.put(jsonObject.get((Object)"id").toString(), jsonObject.get((Object)"type").toString());
        }
        nextNodeId = nextNodeId.substring(1);
        paramModel.setNextNodeId(nextNodeId);
        paramModel.setNextActivityType(activityTypeMap);
        List<String> nextNodeIdList = Arrays.asList(nextNodeId.split(","));
        HashMap<String, String> assigneeMap = new HashMap<String, String>();
        for (String nextNode : nextNodeIdList) {
            BpmResponseResult result1 = this.iTaskEngineService.queryNextAssigneeByTaskIdAndNodeId(this.taskId, nextNode, "0", null);
            JSONArray assigneeArray = result1.getResult();
            String nextAppointAssignee = "";
            for (int i = 0; i < assigneeArray.size(); ++i) {
                JSONObject jsonObject = assigneeArray.getJSONObject(i);
                nextAppointAssignee = nextAppointAssignee + "," + jsonObject.get((Object)"id").toString();
            }
            if (HussarUtils.isNotEmpty((Object)nextAppointAssignee)) {
                nextAppointAssignee = nextAppointAssignee.substring(1);
            }
            assigneeMap.put(nextNode, nextAppointAssignee);
        }
        paramModel.setNextNodeAssignee(assigneeMap);
        paramModel.setHandler(this.userId);
        paramModel.setLastNodeId(task.getTaskDefinitionKey());
        paramModel.setLastTaskId(task.getId());
        paramModel.setLastNodeName(task.getName());
        paramModel.setLastCompleteType(completeType);
        paramModel.setLastNodeHandler(this.userId);
        paramModel.setSendUser(this.userId);
        paramModel.setCreateReason("completeCreate");
        paramModel.setApprovalType(this.approvalType);
        paramModel.setComment(this.comment);
        return paramModel;
    }
}

