/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiTaskinstMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiTaskinst;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.vo.PersonnelQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.ProcessInstanceHistoryTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowEventsServiceImpl
implements FlowEventsService {
    private final TaskService taskService;
    private final ITaskEngineService taskEngineService;
    private final RepositoryService repositoryService;
    private final IFlowTaskService flowTaskService;
    private static final Logger logger = LoggerFactory.getLogger(FlowEventsServiceImpl.class);
    @Autowired
    private ISysActUrgeTaskService urgeTaskService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private BpmActHiTaskinstMapper bpmActHiTaskinstMapper;

    public FlowEventsServiceImpl(TaskService taskService, ITaskEngineService iTaskEngineService, RuntimeService runtimeService, RepositoryService repositoryService, IFlowTaskService flowTaskService) {
        this.taskService = taskService;
        this.taskEngineService = iTaskEngineService;
        this.repositoryService = repositoryService;
        this.flowTaskService = flowTaskService;
    }

    public ApiResponse<Page<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, String userId, String processKey, String definitionKey, List<String> processKeys, String message, String sendUserId, String startTime, String endTime, String tenantId, String timeoutState, String sortOrder, String sortColumn) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(message);
        flowTaskQueryModel.setSendUserId(sendUserId);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        flowTaskQueryModel.setTimeoutState(timeoutState);
        flowTaskQueryModel.setSortOrder(sortOrder);
        flowTaskQueryModel.setSortColumn(sortColumn);
        return this.flowTaskService.todoList(pages, flowTaskQueryModel, tenantId);
    }

    public ApiResponse<List<TaskManagerQueryVo>> pendingApprovalList(String userId, String tenantId) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, null, null);
        return this.flowTaskService.pendingApprovalList(flowTaskQueryModel, tenantId);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, String userId, String processKey, String definitionKey, List<String> processKeys, String message, String sendUserId, String startTime, String endTime, String tenantId) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(message);
        flowTaskQueryModel.setSendUserId(sendUserId);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        return this.flowTaskService.doneList(pages, flowTaskQueryModel, tenantId);
    }

    public JSONArray flowType() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"IS_DELETE", (Object)"0");
        List models = this.modelService.list((Wrapper)queryWrapper);
        JSONArray jsonArray = new JSONArray();
        if (models != null) {
            for (ModelBuild model : models) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("id", model.getProcessKey());
                tmpMap.put("name", model.getName());
                jsonArray.add(tmpMap);
            }
        }
        return jsonArray;
    }

    public ApiResponse<String> revokeTask(String historicTaskId, String userId) {
        BpmResponseResult check = this.taskEngineService.withdrawState(historicTaskId);
        if (check.getCode().equals("0")) {
            throw new PublicClientException(check.getMsg());
        }
        if (!((Boolean)check.getResult().get(0)).booleanValue()) {
            throw new PublicClientException("\u5f53\u524d\u8282\u70b9\u4e0d\u80fd\u64a4\u56de");
        }
        BpmResponseResult bpmResponseResult = this.taskEngineService.revokeTask(historicTaskId, userId, "", true, null);
        if (bpmResponseResult.getCode().equals("0")) {
            throw new PublicClientException(bpmResponseResult.getMsg());
        }
        return ApiResponse.success((String)bpmResponseResult.getMsg());
    }

    public ApiResponse<String> urgeTask(String processInsId, String userId) {
        return ApiResponse.success((String)this.urgeTaskService.urgeTask(processInsId, userId));
    }

    public ApiResponse<Page<TaskManagerQueryVo>> rectificationList(Page<FlowTask> pages, String userId, String processKey, String definitionKey, List<String> processKeys, String message, String sendUserId, String startTime, String endTime, String tenantId) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(message);
        flowTaskQueryModel.setSendUserId(sendUserId);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        return this.flowTaskService.rectificationList(pages, flowTaskQueryModel, tenantId);
    }

    public ApiResponse<ProcessInstanceHistoryTaskVo> processInstanceHistoryTaskList(String businessId, String userId) {
        return this.flowTaskService.processInstanceHistoryTaskList(businessId, userId);
    }

    public ApiResponse<List<PersonnelQueryVo>> getPersonnelByDepartmentId(String organType, String departmentId) {
        return this.flowTaskService.getPersonnelByDepartmentId(organType, departmentId);
    }

    public ApiResponse<List<PersonnelQueryVo>> getPersonnelByUserName(String userName) {
        return this.flowTaskService.getPersonnelByUserName(userName);
    }

    public ApiResponse<String> eliminateReminders(String taskId) {
        return this.flowTaskService.eliminateReminders(taskId);
    }

    public ApiResponse<String> unifiedEliminateReminders(String processInstanceId) {
        BpmActHiTaskinst bpmActHiTaskinst = (BpmActHiTaskinst)((Object)this.bpmActHiTaskinstMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BpmActHiTaskinst::getProcInstId, (Object)processInstanceId)).eq(BpmActHiTaskinst::getApprovalType, (Object)"rectification")).eq(BpmActHiTaskinst::getIsEliminateReminders, (Object)"0")));
        return this.flowTaskService.eliminateReminders(bpmActHiTaskinst.getId().toString());
    }
}

