/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.utils.CcTaskUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.dao.SysActCcTaskConfigMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.model.SysActCcTaskConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowlog.model.UserLog;
import com.jxdinfo.hussar.workflow.engine.bpm.flowlog.service.IBpmLogService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActCcTaskServiceImpl
extends HussarServiceImpl<SysActCcTaskMapper, SysActCcTask>
implements ISysActCcTaskService {
    @Resource
    SysActCcTaskMapper sysActCcTaskMapper;
    @Autowired
    IAssigneeChooseService iAssigneeChooseService;
    @Resource
    SysActCcTaskConfigMapper sysActCcTaskConfigMapper;
    @Autowired
    ISysActCcTaskService sysActCcTaskService;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    DataPushService dataPushService;
    @Autowired
    private IBpmLogService iBpmLogService;
    private static Logger logger = LoggerFactory.getLogger(SysActCcTaskServiceImpl.class);

    public ApiResponse<Page<SysActCcTask>> query(Page<SysActCcTask> pages, String userId, String processKey, String sendUser, String startTime, String endTime, String tenantId, String tag) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<SysActCcTask> sysActCcTasks = this.sysActCcTaskMapper.queryOutside(pages, userId, processKey, sendUser, start, end, tag);
        if (sysActCcTasks != null && !sysActCcTasks.isEmpty()) {
            List users = sysActCcTasks.stream().map(SysActCcTask::getSendUser).collect(Collectors.toList());
            HashMap map = this.iAssigneeChooseService.getUserListByUserId(users, tenantId);
            if (map == null) {
                map = new HashMap();
            }
            for (SysActCcTask sysActCcTask : sysActCcTasks) {
                JSONObject object;
                String userName = (String)map.get(sysActCcTask.getSendUser());
                sysActCcTask.setSendUserName(userName);
                String formDetailKey = sysActCcTask.getFormDetailKey();
                if (!HussarUtils.isNotEmpty((Object)formDetailKey) || !HussarUtils.isNotEmpty((Object)(object = JSON.parseObject((String)formDetailKey)))) continue;
                sysActCcTask.setWebFormDetailKey(object.getString("web"));
                sysActCcTask.setMobileFormDetailKey(object.getString("mobile"));
            }
        }
        pages.setRecords(sysActCcTasks);
        return ApiResponse.success(pages);
    }

    public ApiResponse<Page<SysActCcTask>> getPage(Page<SysActCcTask> pages, String startTime, String endTime, String tenantId, String readStatus) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isNull((Object)user)) {
            throw new HussarException("\u7528\u6237\u672a\u767b\u5f55");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<SysActCcTask> sysActCcTasks = this.sysActCcTaskMapper.getPage(pages, String.valueOf(user.getId()), start, end, readStatus);
        if (HussarUtils.isNotEmpty(sysActCcTasks)) {
            List users = sysActCcTasks.stream().map(SysActCcTask::getSendUser).collect(Collectors.toList());
            HashMap map = this.iAssigneeChooseService.getUserListByUserId(users, tenantId);
            Map departmentAndPostMap = this.iAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(users);
            if (map == null) {
                map = new HashMap();
            }
            for (SysActCcTask sysActCcTask : sysActCcTasks) {
                String userName = (String)map.get(sysActCcTask.getSendUser());
                sysActCcTask.setSendUserName(userName);
                sysActCcTask.setStartUser(userName);
                UserDepartmentAndPostModel userDepartmentAndPostModel = (UserDepartmentAndPostModel)departmentAndPostMap.get(sysActCcTask.getSendUser());
                if (!HussarUtils.isNotEmpty((Object)userDepartmentAndPostModel)) continue;
                sysActCcTask.setDepartmentName(userDepartmentAndPostModel.getDepartmentName());
                sysActCcTask.setUnit(userDepartmentAndPostModel.getUnitName());
            }
        }
        pages.setRecords(sysActCcTasks);
        return ApiResponse.success(pages);
    }

    public ApiResponse<Page<SysActCcTask>> getPageRemote(Page<SysActCcTask> pages, String startTime, String endTime, String tenantId, String readStatus, String userId) {
        if (userId == null || userId.equals("")) {
            throw new HussarException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<SysActCcTask> sysActCcTasks = this.sysActCcTaskMapper.getPage(pages, userId, start, end, readStatus);
        if (HussarUtils.isNotEmpty(sysActCcTasks)) {
            List users = sysActCcTasks.stream().map(SysActCcTask::getSendUser).collect(Collectors.toList());
            HashMap map = this.iAssigneeChooseService.getUserListByUserId(users, tenantId);
            Map departmentAndPostMap = this.iAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(users);
            if (map == null) {
                map = new HashMap();
            }
            for (SysActCcTask sysActCcTask : sysActCcTasks) {
                String userName = (String)map.get(sysActCcTask.getSendUser());
                sysActCcTask.setSendUserName(userName);
                sysActCcTask.setStartUser(userName);
                UserDepartmentAndPostModel userDepartmentAndPostModel = (UserDepartmentAndPostModel)departmentAndPostMap.get(sysActCcTask.getSendUser());
                if (!HussarUtils.isNotEmpty((Object)userDepartmentAndPostModel)) continue;
                sysActCcTask.setDepartmentName(userDepartmentAndPostModel.getDepartmentName());
                sysActCcTask.setUnit(userDepartmentAndPostModel.getUnitName());
            }
        }
        pages.setRecords(sysActCcTasks);
        return ApiResponse.success(pages);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> read(SysActCcTask sysActCcTaskParam) {
        SysActCcTask sysActCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectById(sysActCcTaskParam.getId());
        if (HussarUtils.isNull((Object)sysActCcTask)) {
            throw new HussarException("\u6284\u9001\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List unReadList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId())).eq(SysActCcTask::getReceiveUser, (Object)sysActCcTask.getReceiveUser()));
        Timestamp timestamp = new Timestamp(new Date().getTime());
        for (SysActCcTask actCcTask : unReadList) {
            actCcTask.setReadStatus("1");
            actCcTask.setReadTime(timestamp);
        }
        if (this.updateBatchById(unReadList)) {
            if (this.dataPushService.isDataPush()) {
                ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
                for (SysActCcTask actCcTask : unReadList) {
                    DataPush dataPush = new DataPush();
                    dataPush.setDataPushId(sysActCcTask.getId().toString());
                    dataPush.setTaskId(sysActCcTask.getTaskId() != null ? sysActCcTask.getTaskId().toString() : null);
                    dataPush.setUserId(sysActCcTask.getReceiveUser());
                    dataPush.setSendUser(sysActCcTask.getSendUser());
                    dataPush.setStartDate((Date)sysActCcTask.getSendTime());
                    dataPush.setProcessInsId(sysActCcTask.getProcessInsId().toString());
                    dataPush.setBusinessKey(sysActCcTask.getBusinessId());
                    dataPush.setTaskDefinitionKey(sysActCcTask.getTaskDefKey());
                    dataPush.setUrl(sysActCcTask.getFormKey());
                    dataPush.setProcessKey(sysActCcTask.getProcDefKey());
                    dataPush.setDeptId(sysActCcTask.getPostOrganId());
                    dataPush.setUnitId(sysActCcTask.getPostUnitId());
                    dataPushes.add(dataPush);
                }
                this.dataPushService.readCcTask(dataPushes);
            }
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> reply(SysActCcTask sysActCcTaskParam) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isNull((Object)user)) {
            throw new HussarException("\u7528\u6237\u672a\u767b\u5f55");
        }
        if (HussarUtils.isEmpty((Object)sysActCcTaskParam.getReplyContent())) {
            throw new HussarException("\u56de\u590d\u5185\u5bb9\u4e3a\u7a7a");
        }
        List allCcTaskListToUser = this.sysActCcTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTask::getReceiveUser, (Object)user.getId())).eq(SysActCcTask::getIsNeedReply, (Object)"1")).eq(SysActCcTask::getProcessInsId, (Object)sysActCcTaskParam.getProcessInsId())).isNull(SysActCcTask::getReplyContent)).orderByDesc(SysActCcTask::getSendTime));
        if (HussarUtils.isEmpty((Object)allCcTaskListToUser)) {
            throw new HussarException("\u6ca1\u6709\u53ef\u56de\u590d\u7684\u6284\u9001\u6570\u636e");
        }
        SysActCcTask sysActCcTask = (SysActCcTask)allCcTaskListToUser.get(0);
        sysActCcTask.setReplyContent(sysActCcTaskParam.getReplyContent());
        sysActCcTask.setReadTime(new Timestamp(new Date().getTime()));
        ProcessEngine defaultProcessEngine = ProcessEngines.getDefaultProcessEngine();
        HistoryService historyService = defaultProcessEngine.getHistoryService();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(sysActCcTask.getBusinessId()).singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)defaultProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        List ccTaskConfigList = this.sysActCcTaskConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTaskConfig::getProcDefKey, (Object)sysActCcTask.getProcDefKey())).eq(SysActCcTaskConfig::getChanceType, (Object)"cc_after_process_all_reply")).eq(SysActCcTaskConfig::getProcVersion, (Object)(processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion())));
        if ("0".equals(sysActCcTask.getIsNeedReply()) || "1".equals(sysActCcTask.getIsReplySend())) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        if (HussarUtils.isEmpty((Object)ccTaskConfigList)) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        Long count = this.sysActCcTaskMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId())).eq(SysActCcTask::getIsReplySend, (Object)"0")).isNull(SysActCcTask::getReplyContent)).ne(SysActCcTask::getId, (Object)sysActCcTask.getId())).eq(SysActCcTask::getIsNeedReply, (Object)"1"));
        if (count > 0L) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        List<SysActCcTask> resultCcTaskList = CcTaskUtil.getCcTaskList(sysActCcTask, ccTaskConfigList, processInstance.getStartUserId());
        if (HussarUtils.isNotEmpty(resultCcTaskList)) {
            this.sysActCcTaskService.saveBatch(resultCcTaskList);
        }
        this.sysActCcTaskMapper.updateById(sysActCcTask);
        return ApiResponse.success((Object)true);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> replyRemote(SysActCcTask sysActCcTaskParam, String userId) {
        if (HussarUtils.isEmpty((Object)sysActCcTaskParam.getReplyContent())) {
            throw new HussarException("\u56de\u590d\u5185\u5bb9\u4e3a\u7a7a");
        }
        List allCcTaskListToUser = this.sysActCcTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTask::getReceiveUser, (Object)userId)).eq(SysActCcTask::getIsNeedReply, (Object)"1")).eq(SysActCcTask::getProcessInsId, (Object)sysActCcTaskParam.getProcessInsId())).isNull(SysActCcTask::getReplyContent)).orderByDesc(SysActCcTask::getSendTime));
        if (HussarUtils.isEmpty((Object)allCcTaskListToUser)) {
            throw new HussarException("\u6ca1\u6709\u53ef\u56de\u590d\u7684\u6284\u9001\u6570\u636e");
        }
        SysActCcTask sysActCcTask = (SysActCcTask)allCcTaskListToUser.get(0);
        sysActCcTask.setReplyContent(sysActCcTaskParam.getReplyContent());
        sysActCcTask.setReadTime(new Timestamp(new Date().getTime()));
        ProcessEngine defaultProcessEngine = ProcessEngines.getDefaultProcessEngine();
        HistoryService historyService = defaultProcessEngine.getHistoryService();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(sysActCcTask.getBusinessId()).singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)defaultProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        List ccTaskConfigList = this.sysActCcTaskConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTaskConfig::getProcDefKey, (Object)sysActCcTask.getProcDefKey())).eq(SysActCcTaskConfig::getChanceType, (Object)"cc_after_process_all_reply")).eq(SysActCcTaskConfig::getProcVersion, (Object)(processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion())));
        if ("0".equals(sysActCcTask.getIsNeedReply()) || "1".equals(sysActCcTask.getIsReplySend())) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        if (HussarUtils.isEmpty((Object)ccTaskConfigList)) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        Long count = this.sysActCcTaskMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId())).eq(SysActCcTask::getIsReplySend, (Object)"0")).isNull(SysActCcTask::getReplyContent)).ne(SysActCcTask::getId, (Object)sysActCcTask.getId())).eq(SysActCcTask::getIsNeedReply, (Object)"1"));
        if (count > 0L) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        List<SysActCcTask> resultCcTaskList = CcTaskUtil.getCcTaskList(sysActCcTask, ccTaskConfigList, processInstance.getStartUserId());
        if (HussarUtils.isNotEmpty(resultCcTaskList)) {
            this.sysActCcTaskService.saveBatch(resultCcTaskList);
        }
        this.sysActCcTaskMapper.updateById(sysActCcTask);
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<List<SysActCcTask>> getCcTaskUserList(String processInsId) {
        List postOrganIdList;
        List postIdList;
        List departmentIdAndPostList;
        if (HussarUtils.isEmpty((Object)processInsId)) {
            return ApiResponse.success(new ArrayList());
        }
        List<SysActCcTask> sysActCcTaskList = this.sysActCcTaskMapper.getCcTaskUserList(processInsId);
        if (HussarUtils.isEmpty(sysActCcTaskList)) {
            return ApiResponse.success(new ArrayList());
        }
        List receiveUserIdList = sysActCcTaskList.stream().map(SysActCcTask::getReceiveUser).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
        Map userIdList = this.iAssigneeChooseService.getUserListByUserId(receiveUserIdList, "");
        List departmentIdAndPostListOfMain = this.iAssigneeChooseService.getDepartmentIdAndPost(null, null, receiveUserIdList);
        for (SysActCcTask sysActCcTask : sysActCcTaskList) {
            if ("1".equals(sysActCcTask.getIsNeedReply()) && HussarUtils.isEmpty((Object)sysActCcTask.getReplyContent())) {
                sysActCcTask.setIsNeedReply("1");
            } else {
                sysActCcTask.setIsNeedReply("0");
            }
            sysActCcTask.setReceiveName((String)userIdList.get(sysActCcTask.getReceiveUser()));
            for (Map map : departmentIdAndPostListOfMain) {
                if (!String.valueOf(map.get("userId")).equals(sysActCcTask.getReceiveUser())) continue;
                sysActCcTask.setDepartmentName((String)map.get("departmentName"));
                sysActCcTask.setPostName((String)map.get("postName"));
            }
            ArrayList<String> postUnitId = new ArrayList<String>();
            postUnitId.add(sysActCcTask.getPostUnitId());
            Map unit = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(postUnitId);
            sysActCcTask.setUnit((String)this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(postUnitId).get(sysActCcTask.getPostUnitId()));
        }
        List partCcTasks = sysActCcTaskList.stream().filter(s -> HussarUtils.isNotEmpty((Object)s.getPostId()) && HussarUtils.isNotEmpty((Object)s.getPostOrganId())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(partCcTasks) && HussarUtils.isNotEmpty((Object)(departmentIdAndPostList = this.iAssigneeChooseService.getDepartmentIdAndPost(postIdList = partCcTasks.stream().map(SysActCcTask::getPostId).collect(Collectors.toList()), postOrganIdList = partCcTasks.stream().map(SysActCcTask::getPostOrganId).collect(Collectors.toList()), null)))) {
            for (SysActCcTask sysActCcTask : partCcTasks) {
                for (Map map : departmentIdAndPostList) {
                    if (!String.valueOf(map.get("postId")).equals(sysActCcTask.getPostId()) || !String.valueOf(map.get("postOrganId")).equals(sysActCcTask.getPostOrganId())) continue;
                    sysActCcTask.setDepartmentName((String)map.get("departmentName"));
                    sysActCcTask.setPostName((String)map.get("postName"));
                }
            }
        }
        return ApiResponse.success(sysActCcTaskList);
    }

    @HussarTransactional
    public ApiResponse<SysActCcTask> saveCcTask(SysActCcTask sysActCcTask) {
        QueryWrapper beforWrapper = new QueryWrapper();
        beforWrapper.lambda().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId());
        List beforList = this.sysActCcTaskService.list((Wrapper)beforWrapper);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId())).eq(SysActCcTask::getReceiveUser, (Object)sysActCcTask.getReceiveUser());
        List ccTaskList = this.sysActCcTaskService.list((Wrapper)queryWrapper);
        if (ccTaskList.size() > 0) {
            return ApiResponse.success((int)10001, (String)"\u5b58\u5728\u91cd\u590d\u7684\u6284\u9001\u4fe1\u606f\uff0c\u6dfb\u52a0\u5931\u8d25");
        }
        ProcessEngine defaultProcessEngine = ProcessEngines.getDefaultProcessEngine();
        HistoryService historyService = defaultProcessEngine.getHistoryService();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(sysActCcTask.getProcessInsId().toString()).singleResult();
        if (HussarUtils.isNull((Object)processInstance)) {
            throw new HussarException("\u83b7\u53d6\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
        }
        ProcessDefinition processDefinition = (ProcessDefinition)defaultProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        if (HussarUtils.isNull((Object)processDefinition)) {
            throw new HussarException("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f\u5931\u8d25");
        }
        sysActCcTask.setProcDefKey(processDefinition.getKey());
        DefinitionModel definitionModel = this.processDefinitionsMapper.getDefinitionModel(sysActCcTask.getProcDefKey(), processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion(), "0");
        if (HussarUtils.isNull((Object)definitionModel)) {
            throw new HussarException("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f\u5931\u8d25");
        }
        sysActCcTask.setProcName(definitionModel.getName());
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isNull((Object)shiroUser)) {
            throw new HussarException("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4fe1\u606f\u5931\u8d25");
        }
        Long id = shiroUser.getId();
        sysActCcTask.setSendUser(id.toString());
        sysActCcTask.setSendUserName(shiroUser.getUserName());
        sysActCcTask.setSendTime(new Timestamp(new Date().getTime()));
        sysActCcTask.setFormKey(definitionModel.getViewFormAddress());
        sysActCcTask.setBusinessId(processInstance.getBusinessKey());
        sysActCcTask.setReadStatus("0");
        sysActCcTask.setIsNeedReply("1");
        sysActCcTask.setIsReplySend("1");
        if (HussarUtils.isEmpty((Object)sysActCcTask.getPostId())) {
            sysActCcTask.setPostId(null);
        }
        if (HussarUtils.isEmpty((Object)sysActCcTask.getPostOrganId())) {
            sysActCcTask.setPostOrganId(null);
        }
        ArrayList<UserLog> userList = new ArrayList<UserLog>();
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("procDefId", processInstance.getProcessDefinitionId());
        UserLog userLog = new UserLog();
        userLog.setUserId(sysActCcTask.getReceiveUser());
        userLog.setDeptId(sysActCcTask.getPostOrganId());
        userLog.setUnitId(sysActCcTask.getPostUnitId());
        userLog.setPostId(sysActCcTask.getPostId());
        userList.add(userLog);
        this.iBpmLogService.saveBpmLog(BaseSecurityUtil.getUser(), sysActCcTask.getBusinessId(), processInstance.getId(), null, null, "4", null, userList, info);
        boolean flag = this.sysActCcTaskService.save((Object)sysActCcTask);
        if (flag) {
            if (this.dataPushService.isDataPush()) {
                ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
                DataPush dataPush = new DataPush();
                dataPush.setDataPushId(sysActCcTask.getId().toString());
                dataPush.setTaskId(sysActCcTask.getTaskId() != null ? sysActCcTask.getTaskId().toString() : null);
                dataPush.setUserId(sysActCcTask.getReceiveUser());
                dataPush.setSendUser(sysActCcTask.getSendUser());
                dataPush.setStartDate((Date)sysActCcTask.getSendTime());
                dataPush.setProcessInsId(sysActCcTask.getProcessInsId().toString());
                dataPush.setBusinessKey(sysActCcTask.getBusinessId());
                dataPush.setTaskDefinitionKey(sysActCcTask.getTaskDefKey());
                dataPush.setUrl(sysActCcTask.getFormKey());
                dataPush.setProcessKey(sysActCcTask.getProcDefKey());
                dataPush.setDeptId(sysActCcTask.getPostOrganId());
                dataPush.setUnitId(sysActCcTask.getPostUnitId());
                dataPush.setPostId(sysActCcTask.getPostId());
                dataPushes.add(dataPush);
                this.dataPushService.addCcTask(dataPushes);
            }
            return ApiResponse.success((Object)sysActCcTask);
        }
        return ApiResponse.success((Object)new SysActCcTask());
    }

    @HussarTransactional
    public ApiResponse<SysActCcTask> saveCcTaskRemote(SysActCcTask sysActCcTask, String userId, String userName) {
        QueryWrapper beforWrapper = new QueryWrapper();
        beforWrapper.lambda().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId());
        List beforList = this.sysActCcTaskService.list((Wrapper)beforWrapper);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId())).eq(SysActCcTask::getReceiveUser, (Object)sysActCcTask.getReceiveUser());
        List ccTaskList = this.sysActCcTaskService.list((Wrapper)queryWrapper);
        if (ccTaskList.size() > 0) {
            return ApiResponse.success((int)10001, (String)"\u5b58\u5728\u91cd\u590d\u7684\u6284\u9001\u4fe1\u606f\uff0c\u6dfb\u52a0\u5931\u8d25");
        }
        ProcessEngine defaultProcessEngine = ProcessEngines.getDefaultProcessEngine();
        HistoryService historyService = defaultProcessEngine.getHistoryService();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(sysActCcTask.getProcessInsId().toString()).singleResult();
        if (HussarUtils.isNull((Object)processInstance)) {
            throw new HussarException("\u83b7\u53d6\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
        }
        ProcessDefinition processDefinition = (ProcessDefinition)defaultProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        if (HussarUtils.isNull((Object)processDefinition)) {
            throw new HussarException("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f\u5931\u8d25");
        }
        sysActCcTask.setProcDefKey(processDefinition.getKey());
        DefinitionModel definitionModel = this.processDefinitionsMapper.getDefinitionModel(sysActCcTask.getProcDefKey(), processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion(), "0");
        if (HussarUtils.isNull((Object)definitionModel)) {
            throw new HussarException("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f\u5931\u8d25");
        }
        sysActCcTask.setProcName(definitionModel.getName());
        sysActCcTask.setSendUser(userId);
        sysActCcTask.setSendUserName(userName);
        sysActCcTask.setSendTime(new Timestamp(new Date().getTime()));
        sysActCcTask.setFormKey(definitionModel.getViewFormAddress());
        sysActCcTask.setBusinessId(processInstance.getBusinessKey());
        sysActCcTask.setReadStatus("0");
        sysActCcTask.setIsNeedReply("1");
        sysActCcTask.setIsReplySend("1");
        if (HussarUtils.isEmpty((Object)sysActCcTask.getPostId())) {
            sysActCcTask.setPostId(null);
        }
        if (HussarUtils.isEmpty((Object)sysActCcTask.getPostOrganId())) {
            sysActCcTask.setPostOrganId(null);
        }
        ArrayList<UserLog> userList = new ArrayList<UserLog>();
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("procDefId", processInstance.getProcessDefinitionId());
        UserLog userLog = new UserLog();
        userLog.setUserId(sysActCcTask.getReceiveUser());
        userLog.setDeptId(sysActCcTask.getPostOrganId());
        userLog.setUnitId(sysActCcTask.getPostUnitId());
        userLog.setPostId(sysActCcTask.getPostId());
        userList.add(userLog);
        this.iBpmLogService.saveBpmLog(BaseSecurityUtil.getUser(), sysActCcTask.getBusinessId(), processInstance.getId(), null, null, "4", null, userList, info);
        boolean flag = this.sysActCcTaskService.save((Object)sysActCcTask);
        if (flag) {
            if (this.dataPushService.isDataPush()) {
                ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
                DataPush dataPush = new DataPush();
                dataPush.setDataPushId(sysActCcTask.getId().toString());
                dataPush.setTaskId(sysActCcTask.getTaskId() != null ? sysActCcTask.getTaskId().toString() : null);
                dataPush.setUserId(sysActCcTask.getReceiveUser());
                dataPush.setSendUser(sysActCcTask.getSendUser());
                dataPush.setStartDate((Date)sysActCcTask.getSendTime());
                dataPush.setProcessInsId(sysActCcTask.getProcessInsId().toString());
                dataPush.setBusinessKey(sysActCcTask.getBusinessId());
                dataPush.setTaskDefinitionKey(sysActCcTask.getTaskDefKey());
                dataPush.setUrl(sysActCcTask.getFormKey());
                dataPush.setProcessKey(sysActCcTask.getProcDefKey());
                dataPush.setDeptId(sysActCcTask.getPostOrganId());
                dataPush.setUnitId(sysActCcTask.getPostUnitId());
                dataPushes.add(dataPush);
                this.dataPushService.addCcTask(dataPushes);
            }
            return ApiResponse.success((Object)sysActCcTask);
        }
        return ApiResponse.success((Object)new SysActCcTask());
    }

    public void buildCcTaskList(List<SysActCcTask> sysActCcTasks, ProcessInstance processInstance, String userId, String userName) {
        ProcessDefinition processDefinition = (ProcessDefinition)ProcessEngines.getDefaultProcessEngine().getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        DefinitionModel definitionModel = this.processDefinitionsMapper.getDefinitionModel(processInstance.getProcessDefinitionKey(), processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion(), "0");
        HashSet userSet = new HashSet();
        sysActCcTasks.removeIf(sysActCcTask -> !userSet.add(sysActCcTask.getReceiveUser()));
        for (SysActCcTask sysActCcTask2 : sysActCcTasks) {
            sysActCcTask2.setProcessInsId(Long.valueOf(processInstance.getId()));
            sysActCcTask2.setProcName(definitionModel.getName());
            sysActCcTask2.setSendUser(userId);
            sysActCcTask2.setUserCode(userId);
            sysActCcTask2.setSendUserName(userName);
            sysActCcTask2.setSendTime(new Timestamp(new Date().getTime()));
            sysActCcTask2.setFormKey(definitionModel.getViewFormAddress());
            sysActCcTask2.setBusinessId(processInstance.getBusinessKey());
            sysActCcTask2.setReadStatus("0");
            sysActCcTask2.setIsNeedReply("1");
            sysActCcTask2.setIsReplySend("1");
            if (HussarUtils.isEmpty((Object)sysActCcTask2.getPostId())) {
                sysActCcTask2.setPostId(null);
            }
            if (!HussarUtils.isEmpty((Object)sysActCcTask2.getPostOrganId())) continue;
            sysActCcTask2.setPostOrganId(null);
        }
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteCcTask(SysActCcTask sysActCcTask) {
        QueryWrapper beforWrapper = new QueryWrapper();
        beforWrapper.lambda().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId());
        List beforList = this.sysActCcTaskService.list((Wrapper)beforWrapper);
        ProcessEngine defaultProcessEngine = ProcessEngines.getDefaultProcessEngine();
        HistoryService historyService = defaultProcessEngine.getHistoryService();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(sysActCcTask.getProcessInsId().toString()).singleResult();
        SysActCcTask actCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectById(sysActCcTask.getId());
        if (HussarUtils.isNull((Object)actCcTask)) {
            throw new HussarException("\u8be5\u6284\u9001\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        int i = this.sysActCcTaskMapper.deleteById(sysActCcTask.getId());
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setDataPushId(sysActCcTask.getId().toString());
            this.dataPushService.deleteCcTask(dataPush);
        }
        return ApiResponse.success((Object)(i > 0 ? 1 : 0));
    }

    String getUnitNameByUserId(String userId, String postOrganId) {
        HashMap<String, String> organTree = new HashMap<String, String>();
        HashMap<String, String> organMap = new HashMap<String, String>();
        Map unitMap = new HashMap();
        String organId = "";
        organId = HussarUtils.isEmpty((Object)postOrganId) ? this.iAssigneeChooseService.getDeptIdByUserIds(userId, null) : postOrganId;
        String childrenId = organId;
        List organs = this.iAssigneeChooseService.getAllOrgans();
        if (organs != null && organs.size() != 0) {
            for (Map organ : organs) {
                organMap.put(String.valueOf(organ.get("ORGAN_ID")), String.valueOf(organ.get("PARENT_ID")));
            }
        }
        if (organMap != null && organMap.size() != 0) {
            organTree.put(userId, organId);
            while (!"11".equals(organMap.get(organId)) && organMap.get(organId) != null) {
                organTree.put(organId, (String)organMap.get(organId));
                childrenId = organId;
                organId = (String)organMap.get(organId);
            }
            ArrayList<String> childrenIds = new ArrayList<String>();
            childrenIds.add(childrenId);
            unitMap = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(childrenIds);
        }
        return (String)unitMap.get(childrenId);
    }
}

