/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.definition.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessDefinitionsServiceImpl
implements ProcessDefinitionsService {
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    RepositoryService repositoryService;
    @Resource
    private DruidProperties druidProperties;

    public IPage<DefinitionModel> queryProcessDefinitionsList(String definitionName, Page<DefinitionModel> page) {
        ArrayList<String> departmentIds = new ArrayList<String>();
        Map departmentMap = new HashMap();
        List<DefinitionModel> instList = this.processDefinitionsMapper.getList(page, definitionName);
        if (instList != null && instList.size() != 0) {
            for (DefinitionModel definitionModel : instList) {
                if (definitionModel.getDepartmentId() == null || definitionModel.getDepartmentId().length() == 0) continue;
                departmentIds.add(definitionModel.getDepartmentId());
            }
        }
        departmentMap = this.assigneeChooseService.getDepartmentNameBydepartmentIds(departmentIds);
        if (instList != null && instList.size() != 0) {
            for (DefinitionModel definitionModel : instList) {
                if (definitionModel.getDepartmentId() == null || definitionModel.getDepartmentId().length() == 0) continue;
                definitionModel.setDepartmentName((String)departmentMap.get(definitionModel.getDepartmentId()));
            }
        }
        page.setRecords(instList);
        return page;
    }

    public DefinitionModel getMainOrNew(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new PublicClientException(this.bpmConstantProperties.getProcessKeyError(), Boolean.valueOf(false));
    }

    public ApiResponse<String> setMain(String processKey, String id) {
        throw new PublicClientException("\u4e0d\u652f\u6301");
    }

    public void canModelDeleteWithVersion(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list.size() == 1) {
            throw new PublicClientException(this.bpmConstantProperties.getNotDeleteTheOnlyProcessDefinition(), Boolean.valueOf(false));
        }
    }

    public int setNotMain(String processKey) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, null, 0);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        Long deploymentId = definitionModel.getDeploymentId();
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, processKey);
        return num;
    }

    public ApiResponse<String> cancelMain(String processKey, String id) {
        throw new PublicClientException("\u4e0d\u652f\u6301");
    }

    public int updateProcessName(String id, String processName) {
        return this.processDefinitionsMapper.updateProcessName(id, processName);
    }

    public List<ProcessDefinitionModel> queryProcessDefListOfMainVersion(String processName) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> newList = new ArrayList<ProcessDefinitionModel>();
        for (ProcessDefinitionModel oldPro : list) {
            boolean flag = false;
            for (ProcessDefinitionModel newPro : newList) {
                if (!HussarUtils.equals((Object)oldPro.getKey(), (Object)newPro.getKey())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            newList.add(oldPro);
        }
        return newList;
    }

    public int setVersionTemporary(String id) {
        return this.processDefinitionsMapper.setVersionTemporary(id);
    }

    public void editTemporaryDefId(String defId, Long processInsId, String version) {
        this.processDefinitionsMapper.updateActInst(defId, processInsId, version);
        this.processDefinitionsMapper.updateExecution(defId, processInsId, version);
        this.processDefinitionsMapper.updateProcDef(defId, processInsId, Long.parseLong(version));
        this.processDefinitionsMapper.updateTask(defId, processInsId, version);
        this.processDefinitionsMapper.updateTaskInst(defId, processInsId, version);
        this.processDefinitionsMapper.updateProcInst(defId, processInsId, version);
    }

    public void editTemporaryDefId(String defId, String processInsId, String version) {
        this.editTemporaryDefId(defId, Long.parseLong(processInsId), version);
    }

    public int queryLatestVersion(String processKey) {
        List processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().list();
        if (HussarUtils.isNotEmpty((Object)processDefinition)) {
            return ((ProcessDefinition)processDefinition.get(0)).getVersion();
        }
        return 0;
    }

    public void setProcessExtendProperties(String procDefId, ProcessExtendProperties processExtendProperties) {
        this.processDefinitionsMapper.setProcessExtendProperties(procDefId, processExtendProperties);
    }

    public ProcessExtendProperties getProcessExtendProperties(String procDefId) {
        ProcessExtendProperties processExtendProperties = this.processDefinitionsMapper.getProcessExtendProperties(procDefId);
        return processExtendProperties == null ? new ProcessExtendProperties() : processExtendProperties;
    }
}

