/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.dao.SysActCcTaskConfigMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.model.SysActCcTaskConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.service.ISysActCcTaskConfigService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActCcTaskConfigServiceImpl
extends HussarServiceImpl<SysActCcTaskConfigMapper, SysActCcTaskConfig>
implements ISysActCcTaskConfigService {
    @Autowired
    IAssigneeChooseService iAssigneeChooseService;

    @HussarTransactional
    public ApiResponse<Boolean> saveCcTaskConfig(SysActCcTaskConfig sysActCcTaskConfig) {
        SecurityUser user;
        List oldList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTaskConfig::getProcDefKey, (Object)sysActCcTaskConfig.getProcDefKey())).eq(SysActCcTaskConfig::getProcVersion, (Object)sysActCcTaskConfig.getProcVersion()));
        if (HussarUtils.isNotEmpty((Object)oldList)) {
            String newDepartmentId = sysActCcTaskConfig.getDepartmentId();
            Object[] deptIdList = newDepartmentId.split(",");
            Arrays.sort(deptIdList);
            for (SysActCcTaskConfig ccTaskConfig : oldList) {
                String departmentId = ccTaskConfig.getDepartmentId();
                Object[] oldDeptIdList = departmentId.split(",");
                Arrays.sort(oldDeptIdList);
                if (!Arrays.equals(oldDeptIdList, deptIdList) || !sysActCcTaskConfig.getToUserType().equals(ccTaskConfig.getToUserType()) || !sysActCcTaskConfig.getChanceType().equals(ccTaskConfig.getChanceType()) || !sysActCcTaskConfig.getPostId().equals(ccTaskConfig.getPostId())) continue;
                return ApiResponse.success((String)"\u4e0d\u53ef\u6dfb\u52a0\u76f8\u540c\u7684\u6570\u636e");
            }
        }
        if (HussarUtils.isNotEmpty((Object)(user = BaseSecurityUtil.getUser()))) {
            sysActCcTaskConfig.setCreator(user.getId());
        }
        sysActCcTaskConfig.setCreateTime(new Timestamp(new Date().getTime()));
        this.save((BaseEntity)sysActCcTaskConfig);
        return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteCcTaskConfig(SysActCcTaskConfig sysActCcTaskConfig) {
        if (HussarUtils.isEmpty((Object)sysActCcTaskConfig.getId())) {
            throw new HussarException("\u64cd\u4f5c\u5931\u8d25");
        }
        this.removeById(sysActCcTaskConfig.getId());
        return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    public ApiResponse<List<SysActCcTaskConfig>> getCcTaskConfigList(String procDefKey, String procVersion) {
        List postIds;
        Object postNames;
        List ccTaskConfigs = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTaskConfig::getProcDefKey, (Object)procDefKey)).eq(SysActCcTaskConfig::getProcVersion, (Object)procVersion));
        if (HussarUtils.isEmpty((Object)ccTaskConfigs)) {
            return ApiResponse.success(new ArrayList());
        }
        List postIdList = ccTaskConfigs.stream().map(SysActCcTaskConfig::getPostId).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
        List departmentIdList = ccTaskConfigs.stream().map(SysActCcTaskConfig::getDepartmentId).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
        List creatorList = ccTaskConfigs.stream().map(SysActCcTaskConfig::getCreator).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(postIdList) && HussarUtils.isNotEmpty((Object)(postNames = this.iAssigneeChooseService.getPostNameBypostIds(postIds = postIdList.stream().map(String::valueOf).distinct().collect(Collectors.toList()))))) {
            for (SysActCcTaskConfig ccTaskConfig : ccTaskConfigs) {
                String postName = HussarUtils.isNull(postNames.get(String.valueOf(ccTaskConfig.getPostId()))) ? "" : (String)postNames.get(String.valueOf(ccTaskConfig.getPostId()));
                ccTaskConfig.setPostName(postName);
            }
        }
        if (HussarUtils.isNotEmpty(departmentIdList)) {
            List userIds;
            Map userList;
            ArrayList<String> allDepartmentIdList = new ArrayList<String>();
            for (String departmentId : departmentIdList) {
                String[] split = departmentId.split(",");
                List<String> partDepartmentIdList = Arrays.asList(split);
                allDepartmentIdList.addAll(partDepartmentIdList);
            }
            List resultList = allDepartmentIdList.stream().distinct().collect(Collectors.toList());
            Map departmentNames = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(resultList);
            if (HussarUtils.isNotEmpty((Object)departmentNames)) {
                for (SysActCcTaskConfig ccTaskConfig : ccTaskConfigs) {
                    if (HussarUtils.isEmpty((Object)ccTaskConfig.getDepartmentId())) continue;
                    String[] split = ccTaskConfig.getDepartmentId().split(",");
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < split.length; ++i) {
                        if (HussarUtils.isNull(departmentNames.get(split[i]))) continue;
                        if (i == split.length - 1) {
                            sb.append((String)departmentNames.get(split[i]));
                            continue;
                        }
                        sb.append((String)departmentNames.get(split[i])).append(",");
                    }
                    ccTaskConfig.setDepartmentName(sb.toString());
                }
            }
            if (HussarUtils.isNotEmpty(creatorList) && HussarUtils.isNotEmpty((Object)(userList = this.iAssigneeChooseService.getUserListByUserId(userIds = creatorList.stream().map(String::valueOf).distinct().collect(Collectors.toList()), "")))) {
                for (SysActCcTaskConfig ccTaskConfig : ccTaskConfigs) {
                    if (HussarUtils.isEmpty((Object)ccTaskConfig.getCreator())) continue;
                    ccTaskConfig.setCreatorName(HussarUtils.isNull(userList.get(String.valueOf(ccTaskConfig.getCreator()))) ? "" : (String)userList.get(String.valueOf(ccTaskConfig.getCreator())));
                }
            }
        }
        return ApiResponse.success((Object)ccTaskConfigs);
    }
}

