/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.businessmodule.controller;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.model.BpmBusinessModule;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.model.BpmBusinessModuleTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.model.BpmModuleTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.model.SysDepartment;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.service.ISysBusinessModuleService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bpm/businessModule"})
public class BusinessModuleController {
    @Resource
    private ISysBusinessModuleService sysBusinessModuleService;
    @Resource
    private BpmConstantProperties bpmConstantProperties;

    @GetMapping(value={"/businessModuleTree"})
    @ApiOperation(value="\u4e1a\u52a1\u6a21\u5757\u6811", notes="\u4e1a\u52a1\u6a21\u5757\u6811")
    @AuditLog(moduleName="\u4e1a\u52a1\u6a21\u5757\u6811", eventDesc="\u4e1a\u52a1\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmBusinessModuleTreeModel>> getBusinessModuleTree() {
        return this.sysBusinessModuleService.getBusinessModuleTree();
    }

    @GetMapping(value={"/bpmModuleTree"})
    @ApiOperation(value="\u6d41\u7a0b\u4e1a\u52a1\u6a21\u5757\u6811", notes="\u6d41\u7a0b\u4e1a\u52a1\u6a21\u5757\u6811")
    @AuditLog(moduleName="\u6d41\u7a0b\u4e1a\u52a1\u6a21\u5757\u6811", eventDesc="\u6d41\u7a0b\u4e1a\u52a1\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmModuleTreeModel>> getBpmModuleTree() {
        return this.sysBusinessModuleService.getBpmModuleTree();
    }

    @GetMapping(value={"/getDepartmentList"})
    @AuditLog(moduleName="\u67e5\u627e\u5355\u4f4d\u4fe1\u606f", eventDesc="\u67e5\u627e\u5355\u4f4d\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysDepartment>> getDepartmentList() {
        return this.sysBusinessModuleService.getDepartmentList();
    }

    @GetMapping(value={"/delete"})
    @AuditLog(moduleName="\u5220\u9664\u4e1a\u52a1\u6a21\u5757", eventDesc="\u5220\u9664\u4e1a\u52a1\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> delete(@RequestParam(value="businessModuleId") Long businessModuleId) throws Exception {
        return this.sysBusinessModuleService.delete(businessModuleId);
    }

    @PostMapping(value={"/add"})
    @AuditLog(moduleName="\u65b0\u589e\u4e1a\u52a1\u6a21\u5757", eventDesc="\u65b0\u589e\u4e1a\u52a1\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> add(@RequestBody BpmBusinessModule bpmBusinessModule) {
        if (bpmBusinessModule.getParentId() == null) {
            bpmBusinessModule.setParentId(Long.valueOf(-1L));
        }
        if (this.sysBusinessModuleService.save((Object)bpmBusinessModule)) {
            return ApiResponse.success((String)this.bpmConstantProperties.getSuccessInsert());
        }
        return ApiResponse.fail((String)this.bpmConstantProperties.getErrorInsert());
    }

    @PostMapping(value={"/update"})
    @AuditLog(moduleName="\u4fee\u6539\u4e1a\u52a1\u6a21\u5757", eventDesc="\u4fee\u6539\u4e1a\u52a1\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> update(@RequestBody BpmBusinessModule bpmBusinessModule) {
        if (bpmBusinessModule.getParentId() == null) {
            bpmBusinessModule.setParentId(Long.valueOf(-1L));
        }
        if (this.sysBusinessModuleService.updateById((Object)bpmBusinessModule)) {
            return ApiResponse.success((String)this.bpmConstantProperties.getSuccessUpdate());
        }
        return ApiResponse.fail((String)this.bpmConstantProperties.getErrorUpdate());
    }

    @GetMapping(value={"/queryById"})
    @AuditLog(moduleName="\u4fee\u6539\u65f6\u56de\u663e", eventDesc="\u4fee\u6539\u65f6\u56de\u663e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<BpmBusinessModuleTreeModel> queryById(@RequestParam(value="businessModuleId") Long businessModuleId) {
        if (HussarUtils.isEmpty((Object)businessModuleId)) {
            throw new BaseException("id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.sysBusinessModuleService.queryById(businessModuleId);
    }

    @GetMapping(value={"/listBusinessModule"})
    @ApiOperation(value="\u67e5\u8be2\u4e1a\u52a1\u6a21\u578b", notes="\u67e5\u8be2\u4e1a\u52a1\u6a21\u578b")
    @AuditLog(moduleName="\u67e5\u8be2\u4e1a\u52a1\u6a21\u578b", eventDesc="\u67e5\u8be2\u4e1a\u52a1\u6a21\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmBusinessModule>> listBusinessModule() {
        List businessModules = this.sysBusinessModuleService.list();
        return ApiResponse.success((Object)businessModules);
    }
}

