/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.mq.service.impl;

import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.workflow.engine.bpm.mq.dto.BpmMessageDto;
import com.jxdinfo.hussar.workflow.engine.bpm.mq.service.BpmRabbitMqService;
import javax.annotation.Resource;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.stereotype.Service;

@Service
public class BpmRabbitMqServiceImpl
implements BpmRabbitMqService {
    public String routingKey;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private SeqBuilder seqBuilder;

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void send(BpmMessageDto bpmMessage) {
        this.setBpmMessageKeyTo(bpmMessage);
        this.rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        this.rabbitTemplate.convertAndSend("bpmDirectExchange", this.routingKey, (Object)bpmMessage);
    }

    private void setBpmMessageKeyTo(BpmMessageDto bpmMessage) {
        Sequence sequence = this.seqBuilder.build();
        String bpmMessageKey = String.valueOf(sequence.nextValue());
        bpmMessage.setBpmMessageKey(bpmMessageKey);
    }
}

