/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.model.AlternativeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.service.IAlternativeTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.GetTaskConfigureDetailDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IDefinitionEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.vo.TaskConfigureDetailVo;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.ISysActProcessDeptService;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.service.IProcessGroupService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.ApprovalTypeEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class DefinitionEngineServiceImpl
implements IDefinitionEngineService {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    private ModelMapper modelMapper;
    @Autowired
    private ISysActExtendPropertiesService extendPropertiesService;
    @Autowired
    private IAlternativeTaskService alternativeTaskService;
    @Autowired
    private ISysActProcessDeptService processDeptService;
    @Autowired
    private IProcessGroupService processGroupService;

    public BpmResponseResult queryProcessName(String processKey) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        object.put("processName", (Object)this.processDefinitionsService.getMainOrNew(processKey).getName());
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public int queryLatestVersion(String processKey) {
        return this.processDefinitionsService.queryLatestVersion(processKey);
    }

    public BpmResponseResult queryProcessDefListOfMainVersion(String processName) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        List deployments = this.processDefinitionsService.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
        for (ProcessDefinitionModel item : deployments) {
            if (item.getResourceName() != null) {
                String[] sourceArr = item.getResourceName().split("/");
                item.setResourceName(sourceArr[sourceArr.length - 1]);
            } else {
                item.setResourceName("");
            }
            if (item.getDiagramResourceName() != null) {
                String[] diagramArr = item.getDiagramResourceName().split("/");
                item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
            } else {
                item.setDiagramResourceName("");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = sdf.parse(item.getDeploymentTime());
                String timeStr = sdf.format(date);
                item.setDeploymentTime(timeStr);
                result.add(item);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        object.put("data", result);
        object.put("count", (Object)result.size());
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessDefList(String processName, String tag) {
        JSONArray json = new JSONArray();
        List<ProcessDefinitionModel> deployments = this.processDefinitionsMapper.queryProcessDefListByProcessName(processName, tag);
        ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
        for (ProcessDefinitionModel deployment : deployments) {
            ProcessDefinitionModel item = new ProcessDefinitionModel();
            ArrayList<Map<String, String>> processDept = this.processDefinitionsMapper.queryProcessDept(deployment.getKey(), deployment.getVersion());
            item.setProcessDept(processDept);
            item.setId(deployment.getId());
            item.setProcessName(deployment.getProcessName());
            item.setVersion(deployment.getVersion());
            item.setIsSuspended(deployment.getIsSuspended());
            item.setDescription(deployment.getDescription());
            item.setCategory(deployment.getCategory());
            item.setDeploymentId(deployment.getDeploymentId());
            if (deployment.getIsDeleteVersion().equals("0")) {
                item.setIsEnable("0");
                item.setIsDeleteVersion("0");
            } else if (deployment.getIsDeleteVersion().equals("1")) {
                item.setIsEnable("");
                item.setIsDeleteVersion("1");
            } else if (deployment.getIsDeleteVersion().equals("2")) {
                item.setIsEnable("1");
                item.setIsDeleteVersion("0");
            }
            if (deployment.getResourceName() != null) {
                String[] sourceArr = deployment.getResourceName().split("/");
                item.setResourceName(sourceArr[sourceArr.length - 1]);
            } else {
                item.setResourceName("");
            }
            if (deployment.getDiagramResourceName() != null) {
                String[] diagramArr = deployment.getDiagramResourceName().split("/");
                item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
            } else {
                item.setDiagramResourceName("");
            }
            Deployment deploymentTime = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deployment.getDeploymentId()).singleResult();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeStr = sdf.format(deploymentTime.getDeploymentTime());
            item.setDeploymentTime(timeStr);
            result.add(item);
        }
        json.add(result);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult activateProcessDefinitionById(String processDefinitionId) {
        this.repositoryService.activateProcessDefinitionById(processDefinitionId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult suspendProcessDefinitionById(String processDefinitionId) {
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessDefinition(String processDefinitionId) {
        if (processDefinitionId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(String.valueOf(processDefinitionId)).singleResult();
        if (HussarUtils.isEmpty((Object)processDefinition)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(null, processDefinitionId))) {
            this.processGroupService.canDeleteProcess(processDefinition.getKey(), processDefinition.getId(), () -> {
                this.repositoryService.deleteDeployment(processDefinition.getDeploymentId());
                return true;
            });
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getDeleteRunningFail(), null);
    }

    public BpmResponseResult queryProcess(String tag) {
        JSONArray json = new JSONArray();
        List<ModelBuild> models = this.modelMapper.queryModelByTage(tag);
        if (models != null) {
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            for (ModelBuild model : models) {
                JSONObject object = new JSONObject();
                byte[] arg0 = this.repositoryService.getModelEditorSource(model.getModelId());
                try {
                    String temp = new String(arg0, StandardCharsets.UTF_8).replace("undefined", "");
                    JsonNode editorNode = new ObjectMapper().readTree(temp.getBytes(StandardCharsets.UTF_8));
                    BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
                    Process process = bpmnModel.getMainProcess();
                    object.put("id", (Object)process.getId());
                    object.put("name", (Object)process.getName());
                    object.put("is_Delete", (Object)model.getIsDelete());
                    json.add((Object)object);
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessLink(String processKey, String departmentId) {
        JSONArray json = new JSONArray();
        String processDefinitionId = this.processDeptService.getProcessDefId(departmentId, processKey);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                json.add((Object)object);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
    }

    public BpmResponseResult queryStartFormUrl(String processKey, String departmentId) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        String processDefinitionId = this.processDeptService.getProcessDefId(departmentId, processKey);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            String formUrl = ((StartEvent)flowElement).getFormKey();
            jsonObject.put("formUrl", (Object)formUrl);
            jsonArray.add((Object)jsonObject);
            break;
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public boolean queryIsPublish(String processKey) {
        List list = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).list();
        return list != null && !list.isEmpty();
    }

    public BpmResponseResult judgeProcessName(String processName) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        boolean isRepeat = false;
        long num = this.repositoryService.createModelQuery().modelName(processName).count();
        if (num > 0L) {
            isRepeat = true;
        }
        jsonObject.put("isRepeat", (Object)isRepeat);
        jsonArray.add((Object)jsonObject);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult judgeProcDefKey(String procDefKey) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        boolean isRepeat = false;
        long num = this.repositoryService.createModelQuery().modelKey(procDefKey).count();
        if (num > 0L) {
            isRepeat = true;
        }
        jsonObject.put("isRepeat", (Object)isRepeat);
        jsonArray.add((Object)jsonObject);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public List<TaskConfigureDetailVo> getTaskConfigureDetail(GetTaskConfigureDetailDto getTaskConfigureDetailDto) {
        if (getTaskConfigureDetailDto == null) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        String procDefId = getTaskConfigureDetailDto.getProcDefId();
        String taskName = getTaskConfigureDetailDto.getTaskName();
        if (HussarUtils.isEmpty((Object)procDefId)) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(procDefId);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        Map extendPropertiesMap = this.extendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)procDefId)).stream().collect(Collectors.toMap(SysActExtendProperties::getTaskDefKey, Function.identity(), (o1, o2) -> o1));
        Map<String, String> alternativeTaskMap = this.alternativeTaskService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AlternativeTask::getProcessKey, (Object)processDefinition.getKey())).eq(AlternativeTask::getProcessDefinitionVersion, (Object)processDefinition.getVersion())).stream().collect(Collectors.toMap(AlternativeTask::getTaskDefinitionKey, AlternativeTask::getTaskDefinitionName, (o1, o2) -> o1));
        Function<UserTask, TaskConfigureDetailVo> buildByBpmnModel = userTask -> {
            TaskConfigureDetailVo taskConfigureDetailVo = new TaskConfigureDetailVo();
            if (userTask.getLoopCharacteristics() != null) {
                taskConfigureDetailVo.multi();
            }
            if (userTask.getDueDate() != null) {
                Period period = Period.parse((String)userTask.getDueDate());
                taskConfigureDetailVo.buildStrDueDate(period.getMonths(), period.getDays(), period.getHours(), period.getMinutes());
            }
            taskConfigureDetailVo.setTaskDefKey(userTask.getId());
            taskConfigureDetailVo.setTaskName(userTask.getName());
            return taskConfigureDetailVo;
        };
        Function<TaskConfigureDetailVo, TaskConfigureDetailVo> buildByAlternativeTask = taskConfigureDetailVo -> {
            taskConfigureDetailVo.setIsAlterTask(alternativeTaskMap.containsKey(taskConfigureDetailVo.getTaskDefKey()) ? "1" : "0");
            return taskConfigureDetailVo;
        };
        Function<TaskConfigureDetailVo, TaskConfigureDetailVo> buildByExtendProperties = taskConfigureDetailVo -> {
            SysActExtendProperties sysActExtendProperties = (SysActExtendProperties)extendPropertiesMap.get(taskConfigureDetailVo.getTaskDefKey());
            if (sysActExtendProperties != null) {
                taskConfigureDetailVo.setApprovalType(ApprovalTypeEnum.getStrApprovalType((String)sysActExtendProperties.getApprovalType()));
                taskConfigureDetailVo.setIsWorkDay(sysActExtendProperties.getIsWorkday());
                String allowAlterTask = sysActExtendProperties.getAllowAlterTask();
                if (HussarUtils.isNotEmpty((Object)allowAlterTask)) {
                    taskConfigureDetailVo.setAlterTasks(Arrays.stream(allowAlterTask.split(",")).map(alternativeTaskMap::get).filter(Objects::nonNull).collect(Collectors.joining(",")));
                }
            }
            taskConfigureDetailVo.setApprovalNum(sysActExtendProperties.getNumberOfApprover().toString());
            taskConfigureDetailVo.setApproveFileNum(sysActExtendProperties.getNumberOfAttachment().toString());
            return taskConfigureDetailVo;
        };
        return flowElements.stream().filter(flowElement -> flowElement instanceof UserTask && (HussarUtils.isEmpty((Object)taskName) || flowElement.getName().contains(taskName))).map(flowElement -> (UserTask)flowElement).map(buildByBpmnModel.andThen(buildByAlternativeTask).andThen(buildByExtendProperties)).sorted((task1, task2) -> {
            String taskDefKey1 = task1.getTaskDefKey();
            String taskDefKey2 = task2.getTaskDefKey();
            int compare = Integer.compare(taskDefKey1.length(), taskDefKey2.length());
            return compare != 0 ? compare : taskDefKey1.compareTo(taskDefKey2);
        }).collect(Collectors.toList());
    }
}

