/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.taskmanage.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.model.vo.PersonnelQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.ProcessInstanceHistoryTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5f85\u529e\u7ba1\u7406"})
@RequestMapping(value={"/bpm/toDoManage"})
public class ToDoManageController {
    @Autowired
    private FlowEventsService flowEventsService;

    @GetMapping(value={"/queryProcess"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b", notes="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b")
    @AuditLog(moduleName="\u5f85\u529e\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<JSONArray> queryProcess() {
        try {
            return ApiResponse.success((Object)this.flowEventsService.flowType());
        }
        catch (Exception exception) {
            throw new PublicClientException("");
        }
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5f85\u529e\u67e5\u8be2", notes="\u5f85\u529e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u5f85\u529e\u7ba1\u7406", eventDesc="\u5f85\u529e\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<TaskManagerQueryVo>> list(Page<FlowTask> pages, TaskManageQueryDto taskManageQueryDto) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        String processKey = taskManageQueryDto.getProcessKey();
        String userId = String.valueOf(securityUser.getId());
        String sendUserId = taskManageQueryDto.getSendUserId();
        String message = taskManageQueryDto.getMessage();
        String startTime = taskManageQueryDto.getStartTime();
        String endTime = taskManageQueryDto.getEndTime();
        String timeoutState = taskManageQueryDto.getTimeoutState();
        String sortOrder = taskManageQueryDto.getSortOrder();
        String sortColumn = taskManageQueryDto.getSortColumn();
        return this.flowEventsService.todoList(pages, userId, processKey, null, null, message, sendUserId, startTime, endTime, securityUser.getStringTenantId(), timeoutState, sortOrder, sortColumn);
    }

    @GetMapping(value={"/pendingApprovalList"})
    @ApiOperation(value="\u5f85\u5ba1\u67e5\u8be2", notes="\u5f85\u5ba1\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u5f85\u529e\u7ba1\u7406", eventDesc="\u5f85\u529e\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<TaskManagerQueryVo>> pendingApprovalList(TaskManageQueryDto taskManageQueryDto) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        String userId = String.valueOf(securityUser.getId());
        return this.flowEventsService.pendingApprovalList(userId, securityUser.getStringTenantId());
    }

    @GetMapping(value={"/processInstanceHistoryTaskList"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9e\u4f8b\u5386\u53f2\u4efb\u52a1\u67e5\u8be2", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5386\u53f2\u4efb\u52a1\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", value="\u4e1a\u52a1 ID", required=true, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u5b9e\u4f8b\u5386\u53f2\u4efb\u52a1\u7ba1\u7406", eventDesc="\u6d41\u7a0b\u5b9e\u4f8b\u5386\u53f2\u4efb\u52a1\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ProcessInstanceHistoryTaskVo> processInstanceHistoryTaskList(String businessId) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        String userId = String.valueOf(securityUser.getUserId());
        return this.flowEventsService.processInstanceHistoryTaskList(businessId, userId);
    }

    @GetMapping(value={"/personnelOfDepartmentList"})
    @ApiOperation(value="\u4eba\u5458\u4fe1\u606f\u67e5\u8be2", notes="\u4eba\u5458\u4fe1\u606f\u67e5\u8be2")
    @AuditLog(moduleName="\u4eba\u5458\u4fe1\u606f\u7ba1\u7406", eventDesc="\u4eba\u5458\u4fe1\u606f\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<PersonnelQueryVo>> personnelOfDepartmentList(@RequestParam(value="organType") String organType) {
        Long departmentId = BaseSecurityUtil.getUser().getDeptId();
        return this.flowEventsService.getPersonnelByDepartmentId(organType, String.valueOf(departmentId));
    }

    @GetMapping(value={"/getPersonnelByUserName"})
    @ApiOperation(value="\u4eba\u5458\u4fe1\u606f\u67e5\u8be2", notes="\u4eba\u5458\u4fe1\u606f\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="\u4eba\u5458\u59d3\u540d", required=false, paramType="query")})
    @AuditLog(moduleName="\u4eba\u5458\u4fe1\u606f\u7ba1\u7406", eventDesc="\u4eba\u5458\u4fe1\u606f\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<PersonnelQueryVo>> getPersonnelByUserName(@RequestParam(value="userName", required=false) String userName) {
        return this.flowEventsService.getPersonnelByUserName(userName);
    }
}

