/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.dto.TaskCommentDto;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.service.TaskCommentService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.vo.TaskCommentVO;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.service.BpmActPendingTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dao.ProcessInstMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.EndProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.RestartProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.vo.ProcessInstVo;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessInstServiceImpl
extends ServiceImpl<ProcessInstMapper, ProcessInst>
implements ProcessInstService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Resource
    private ProcessInstMapper processInstMapper;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private TaskCommentService taskCommentService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Resource
    private BpmActPendingTaskService bpmActPendingTaskService;
    private static final Logger logger = LoggerFactory.getLogger(ProcessInstService.class);

    public IPage<ProcessInst> getProcessList(Page<ProcessInst> page, ProcessListDto processListDto) {
        List<ProcessInst> instList = this.processInstMapper.getListMySql(page, processListDto);
        HashSet<Long> procInstIds = new HashSet<Long>();
        for (ProcessInst processInst : instList) {
            procInstIds.add(Long.parseLong(processInst.getProcessInsId()));
        }
        if (!instList.isEmpty()) {
            List<ProcessInstVo> nodeList = this.processInstMapper.getNodeNames(procInstIds);
            HashMap<Long, Set> nodeMap = new HashMap<Long, Set>();
            for (ProcessInstVo node : nodeList) {
                Long procInstId = 0L;
                procInstId = node.getProcessInsId();
                Set set = (Set)nodeMap.get(procInstId);
                set = set == null ? new HashSet() : set;
                set.add(node.getActName());
                nodeMap.put(procInstId, set);
            }
            for (ProcessInst processInst : instList) {
                Set nodeNames = (Set)nodeMap.get(Long.parseLong(processInst.getProcessInsId()));
                if (nodeNames == null || nodeNames.isEmpty()) continue;
                processInst.setNames(String.join((CharSequence)",", nodeNames));
            }
        }
        page.setRecords(instList);
        return page;
    }

    public ApiResponse<String> suspendProcessInstanceById(String processInstCode) {
        try {
            this.runtimeService.suspendProcessInstanceById(processInstCode);
            return ApiResponse.success((String)BpmEnum.HANGUP_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.HANGUP_FAIL.getMessage());
        }
    }

    public ApiResponse<String> activateProcessById(String processInstCode) {
        try {
            this.runtimeService.activateProcessInstanceById(processInstCode);
            return ApiResponse.success((String)BpmEnum.ACTIVE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.ACTIVE_FAIL.getMessage());
        }
    }

    public ApiResponse<String> deleteProcessInstance(String processInsId) {
        try {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
            StringBuilder taskIds = new StringBuilder();
            for (Task task : tasks) {
                taskIds.append(",").append(task.getId());
            }
            if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
                this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
            }
            this.runtimeService.deleteProcessInstance(processInsId, "");
            LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
            urgeQueryWrapper.eq(SysActUrgeTask::getProcessInsId, (Object)Long.parseLong(processInsId));
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
            this.historyService.deleteHistoricProcessInstance(processInsId);
            LambdaQueryWrapper lineQueryWrapper = new LambdaQueryWrapper();
            lineQueryWrapper.eq(SysActHiLine::getProcessInsId, (Object)Long.parseLong(processInsId));
            this.iSysActHiLineService.remove((Wrapper)lineQueryWrapper);
            LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
            ccQueryWrapper.eq(SysActCcTask::getProcessInsId, (Object)Long.parseLong(processInsId));
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessInsId(processInsId);
                this.dataPushService.deleteDataPush(dataPush);
            }
            this.bpmActPendingTaskService.endProcessUpdatePendingTasks(processInsId);
            return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.DELETE_FAIL.getMessage());
        }
    }

    public ApiResponse<String> deleteFinishedProcessInstance(String processInstCode) {
        try {
            this.historyService.deleteHistoricProcessInstance(processInstCode);
            LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
            ccQueryWrapper.eq(SysActCcTask::getProcessInsId, (Object)processInstCode);
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessInsId(processInstCode);
                this.dataPushService.deleteDataPush(dataPush);
            }
            return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new PublicClientException(BpmEnum.DELETE_FAIL.getMessage());
        }
    }

    public ApiResponse<String> deleteProcessInstanceByLogic(String processInstId, String isDeleteProcinst) {
        String message = "";
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstId)).list();
        message = this.processInstMapper.updateIsDeleteProcinst(processInstId, isDeleteProcinst) > 0 ? BpmEnum.DELETE_SUCCESS.getMessage() : BpmEnum.DELETE_FAIL.getMessage();
        if (tasks != null) {
            for (Task task : tasks) {
                this.activityRedisTimerService.delTimeOutModel(task.getId());
            }
        }
        return ApiResponse.success((String)message);
    }

    public ApiResponse<List<TaskCommentVO>> getProcessDetailList(ProcessDto processDto) {
        String processInsId = processDto.getProcessInsId();
        String businessId = processDto.getBusinessId();
        String tenantId = processDto.getTenantId();
        ArrayList<TaskCommentVO> taskComments = new ArrayList<TaskCommentVO>();
        if (HussarUtils.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return ApiResponse.fail((String)this.bpmConstantProperties.getProcessInsIdNull());
            }
        }
        BpmResponseResult obj = this.instanceEngineService.getAllProcessTraceForComment(processInsId, tenantId);
        JSONArray result = obj.getResult();
        for (int i = 0; i < result.size(); ++i) {
            String taskId = result.getJSONObject(i).getString("taskId");
            String time = result.getJSONObject(i).getString("endTime");
            if (HussarUtils.isEmpty((Object)time)) continue;
            List comments = this.taskService.getTaskComments(taskId, "complete");
            if (HussarUtils.isNotEmpty((Object)comments)) {
                for (Comment comment : comments) {
                    TaskCommentVO taskCommentVO = new TaskCommentVO();
                    taskCommentVO.setId(comment.getId());
                    taskCommentVO.setTaskId(taskId);
                    taskCommentVO.setTime(comment.getTime());
                    taskCommentVO.setFullMessage(comment.getFullMessage());
                    taskCommentVO.setActivityName(result.getJSONObject(i).getString("activityName"));
                    taskCommentVO.setUserName(result.getJSONObject(i).getString("assignee"));
                    taskComments.add(taskCommentVO);
                }
                continue;
            }
            TaskCommentVO taskCommentVO = new TaskCommentVO();
            taskCommentVO.setId(null);
            taskCommentVO.setTaskId(taskId);
            String endTime = result.getJSONObject(i).getString("endTime");
            Date date = null;
            try {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endTime);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new PublicClientException(this.bpmConstantProperties.getErrorDateTransfer());
            }
            taskCommentVO.setTime(date);
            taskCommentVO.setFullMessage(result.getJSONObject(i).getString("comments"));
            taskCommentVO.setActivityName(result.getJSONObject(i).getString("activityName"));
            taskCommentVO.setUserName(result.getJSONObject(i).getString("assignee"));
            taskComments.add(taskCommentVO);
        }
        return ApiResponse.success(taskComments);
    }

    public ApiResponse<String> updateComments(List<TaskCommentDto> taskComments) {
        try {
            ArrayList<TaskComment> taskCommentList;
            if (HussarUtils.isNotEmpty(taskComments)) {
                taskCommentList = new ArrayList<TaskComment>();
                for (TaskCommentDto taskCommentDto : taskComments) {
                    String taskId = taskCommentDto.getTaskId();
                    String fullMessage = taskCommentDto.getFullMessage();
                    TaskComment taskComment = new TaskComment(taskId, fullMessage.getBytes());
                    if (HussarUtils.isEmpty((Object)taskCommentDto.getId())) {
                        HistoricTaskInstance hisTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
                        taskComment.setUserId(hisTask.getAssignee());
                    }
                    taskComment.setId(taskCommentDto.getId());
                    taskCommentList.add(taskComment);
                }
            } else {
                return ApiResponse.success((String)this.bpmConstantProperties.getUpdatedMessageIsNull());
            }
            this.taskCommentService.saveOrUpdateBatch(taskCommentList);
            return ApiResponse.success((String)BpmEnum.SUCCESS_UPDATE.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(BpmEnum.ERROR_UPDATE.getMessage());
        }
    }

    public BpmResponseResult endProcessByProcessInsId(EndProcessDto endProcessDto) {
        String processInsId = endProcessDto.getProcessInsId();
        String userId = endProcessDto.getUserId();
        return this.instanceEngineService.endProcessByProcessInsId(processInsId, userId, null);
    }

    public BpmResponseResult reStartProcess(RestartProcessDto restartProcessDto) {
        String processInsId = restartProcessDto.getProcessInsId();
        String userId = restartProcessDto.getUserId();
        String businessId = restartProcessDto.getBusinessId();
        String assignee = restartProcessDto.getAssignee();
        String taskDefinitionKey = restartProcessDto.getTaskDefinitionKey();
        boolean isSubmit = restartProcessDto.getSubmit();
        return this.taskEngineService.reStartProcess(processInsId, businessId, taskDefinitionKey, userId, assignee, isSubmit, null);
    }

    public ProcessInst getProcessInstByOriginalProcInstId(String rectificationProcInstId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ProcessInst::getRectificationBusinessKey, (Object)rectificationProcInstId);
        ProcessInst processInst = (ProcessInst)this.processInstMapper.selectOne((Wrapper)lambdaQueryWrapper);
        return processInst;
    }
}

