/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.ApprovalUser;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.PendingListDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.dao.BpmActPendingTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.dto.PendingTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.model.BpmActPendingTask;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.service.BpmActPendingTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.ISysActProcessDeptService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.el.SqlConditionHandleService;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpmActPendingTaskServiceImpl
extends HussarServiceImpl<BpmActPendingTaskMapper, BpmActPendingTask>
implements BpmActPendingTaskService {
    private static final Logger logger = LoggerFactory.getLogger(BpmActPendingTaskServiceImpl.class);
    private static final Pattern BPM_NEXT_NODE_REGEX = Pattern.compile("bpm_next_node [!=]= '([^'])*'");
    private static final List<String> ACTIVITY_TYPES = Arrays.asList("userTask", "receiveTask", "callActivity");
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private BpmConstantProperties bpmConstantProperties;
    @Resource
    private IAssigneeChooseService iAssigneeChooseService;
    @Resource
    private BpmActPendingTaskMapper bpmActPendingTaskMapper;
    @Resource
    private ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    private ISysActProcessDeptService iSysActProcessDeptService;
    @Autowired
    private SqlConditionHandleService sqlConditionHandleService;
    @Autowired
    private ISysActEntrustService sysActEntrustService;
    @Autowired
    private ISysActExtendPropertiesService extendPropertiesService;

    public ApiResponse<Page<PendingTaskVo>> queryList(PendingListDto pendingListDto) {
        Page pages = new Page((long)pendingListDto.getPage().intValue(), (long)pendingListDto.getSize().intValue());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = HussarUtils.isNotEmpty((Object)pendingListDto.getStartTime()) ? format.parse(pendingListDto.getStartTime()) : null;
            endTime = HussarUtils.isNotEmpty((Object)pendingListDto.getEndTime()) ? format.parse(pendingListDto.getEndTime()) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<PendingTaskVo> pendingTaskVoList = this.bpmActPendingTaskMapper.query((Page<PendingTaskVo>)pages, pendingListDto.getUserId(), pendingListDto.getProcessKey(), pendingListDto.getStartTime(), startTime, endTime, pendingListDto.getTodoConfiguration());
        HashSet<String> userIdSet = new HashSet<String>();
        for (PendingTaskVo pendingTaskVo : pendingTaskVoList) {
            userIdSet.add(pendingTaskVo.getAssignee());
            userIdSet.add(pendingTaskVo.getStartUser());
            if (HussarUtils.isNotEmpty((Object)pendingTaskVo.getAssignedUser())) {
                userIdSet.add(pendingTaskVo.getAssignedUser());
            }
            if (!HussarUtils.isNotEmpty((Object)pendingTaskVo.getOwner())) continue;
            userIdSet.add(pendingTaskVo.getOwner());
        }
        Map map = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userIdSet), "");
        for (PendingTaskVo pendingTaskVo : pendingTaskVoList) {
            pendingTaskVo.setAssigneeName((String)map.get(pendingTaskVo.getAssignee()));
            pendingTaskVo.setStartUserName((String)map.get(pendingTaskVo.getStartUser()));
            if (HussarUtils.isNotEmpty((Object)pendingTaskVo.getAssignedUser())) {
                pendingTaskVo.setStartUserName((String)map.get(pendingTaskVo.getAssignedUser()));
            }
            if (HussarUtils.isNotEmpty((Object)pendingTaskVo.getOwner())) {
                pendingTaskVo.setOwnerName((String)map.get(pendingTaskVo.getOwner()));
            }
            if (pendingTaskVo.getOwner().equals(pendingTaskVo.getAssignee())) continue;
            pendingTaskVo.setTaskName(pendingTaskVo.getTaskName() + "(" + pendingTaskVo.getOwnerName() + ")");
        }
        return ApiResponse.success((Object)pages.setRecords(pendingTaskVoList));
    }

    public ApiResponse<JSONArray> getPendingTask(String businessId, String taskId) {
        if (HussarUtils.isEmpty((Object)taskId) && HussarUtils.isNotEmpty((Object)businessId)) {
            return ApiResponse.success();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)businessId)) {
            queryWrapper.eq(BpmActPendingTask::getBusinessId, (Object)businessId);
        } else {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (HussarUtils.isEmpty((Object)task)) {
                throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound());
            }
            queryWrapper.eq(BpmActPendingTask::getProcInstId, (Object)task.getProcessInstanceId());
        }
        List pendingTasks = this.list((Wrapper)queryWrapper);
        Map map = this.iAssigneeChooseService.getUserListByUserId(pendingTasks.stream().map(BpmActPendingTask::getOwner).distinct().collect(Collectors.toList()), "");
        Map<String, List<BpmActPendingTask>> pendingTasksMap = pendingTasks.stream().collect(Collectors.groupingBy(BpmActPendingTask::getTaskDefKey));
        JSONArray jsonArray = new JSONArray();
        for (String taskDefKey : pendingTasksMap.keySet()) {
            List<BpmActPendingTask> singlePendingTasks = pendingTasksMap.get(taskDefKey);
            String ownerName = singlePendingTasks.stream().map(o -> (String)map.get(o.getOwner())).collect(Collectors.joining(","));
            JSONObject object = new JSONObject();
            object.put("taskDefKey", (Object)taskDefKey);
            object.put("taskName", (Object)singlePendingTasks.get(0).getTaskName());
            object.put("assignee", (Object)ownerName);
            jsonArray.add((Object)object);
        }
        return ApiResponse.success((Object)jsonArray);
    }

    public ApiResponse<?> updatePendingTask(String processKey, String businessId) {
        return this.updatePendingTask(processKey, businessId, null, null, null);
    }

    public ApiResponse<?> updatePendingTask(String processKey, String businessId, String userId, String deptId, String postId) {
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            this.updateFirstPendingTask(processKey, businessId, userId, deptId, postId);
            return ApiResponse.success();
        }
        if (HussarUtils.isEmpty((Object)businessId)) {
            return ApiResponse.success();
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).includeProcessVariables().singleResult();
        if (HussarUtils.isEmpty((Object)processInstance) || processInstance.getEndTime() != null) {
            return ApiResponse.success();
        }
        this.updatePendingTaskDetails(processInstance);
        this.recursiveUpdateCallActivityPendingTask(processInstance.getId());
        return ApiResponse.success();
    }

    private void updateFirstPendingTask(String processKey, String businessId, String userId, String deptId, String postId) {
        List historicTaskInstances;
        List historicProcessInstances;
        if (HussarUtils.isEmpty((Object)businessId)) {
            return;
        }
        if (HussarUtils.isNotEmpty((Object)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult())) {
            throw new PublicClientException("\u6d41\u7a0b\u5df2\u542f\u52a8\uff01");
        }
        String processDefinitionId = this.getProcessDefinitionId(processKey, deptId);
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = (Process)bm.getProcesses().get(0);
        String startTaskKey = this.getStartTaskDefKey(bm);
        Map taskMap = null;
        ProcessExtendProperties processExtendPropertie = this.processDefinitionsMapper.getProcessExtendProperties(processDefinitionId);
        Integer ruleOfHiApproverAtApproval = processExtendPropertie.getRuleOfHiApproverAtApproval();
        HistoricProcessInstance historicProcessInstance = null;
        if (ProcessExtendProperties.AS_DEPT.equals(ruleOfHiApproverAtApproval)) {
            historicProcessInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().finished().startedByDept(deptId).orderByProcessInstanceStartTime().desc()).listPage(0, 1);
            if (!historicProcessInstances.isEmpty()) {
                historicProcessInstance = (HistoricProcessInstance)historicProcessInstances.get(0);
            }
        } else if (ProcessExtendProperties.AS_PERSON.equals(ruleOfHiApproverAtApproval) && !(historicProcessInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().finished().startedBy(userId).orderByProcessInstanceStartTime().desc()).listPage(0, 1)).isEmpty()) {
            historicProcessInstance = (HistoricProcessInstance)historicProcessInstances.get(0);
        }
        if (historicProcessInstance != null && !(historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(historicProcessInstance.getId())).orderByTaskCreateTime()).desc()).list()).isEmpty()) {
            taskMap = historicTaskInstances.stream().collect(Collectors.toMap(TaskInfo::getTaskDefinitionKey, Function.identity(), (key1, key2) -> key2));
        }
        Map<String, Object> variables = CommonCodeUtil.getGodAxeResult(null, startTaskKey, businessId, processDefinitionId);
        HashMap<String, Object> processVariable = new HashMap<String, Object>();
        AnalyticalModelUtil.getSqlVariableMapWithOutExecution(businessId, null, processVariable);
        HashMap<String, Integer> sortedMap = new HashMap<String, Integer>();
        Collection<BpmActPendingTask> pendingTasks = this.recursiveGetNextPendingTaskBySequence(process, (SequenceFlow)((FlowNode)process.getFlowElement(startTaskKey)).getOutgoingFlows().get(0), variables, processVariable, businessId, processDefinitionId, sortedMap, null);
        BpmActPendingTaskServiceImpl.sortPendingTask(pendingTasks, sortedMap);
        ArrayList<Object> addPendingTasks = new ArrayList<Object>();
        String firstUserTask = ((SequenceFlow)((FlowNode)process.getFlowElement(startTaskKey)).getOutgoingFlows().get(0)).getTargetRef();
        if (!(process.getFlowElement(firstUserTask) instanceof UserTask)) {
            firstUserTask = null;
        }
        List sysActExtendProperties = this.extendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)processDefinitionId));
        Map extendPropertiesMap = null;
        if (sysActExtendProperties != null) {
            extendPropertiesMap = sysActExtendProperties.stream().collect(Collectors.toMap(SysActExtendProperties::getTaskDefKey, Function.identity(), (v1, v2) -> v2));
        }
        for (BpmActPendingTask pendingTask : pendingTasks) {
            Object bpmActPendingTask;
            HistoricTaskInstance historicTaskInstance;
            SysActExtendProperties extendProperties = (SysActExtendProperties)extendPropertiesMap.get(pendingTask.getTaskDefKey());
            if (extendProperties != null && !"1".equals(extendProperties.getInitApprovalDisplay())) continue;
            if (taskMap != null && (historicTaskInstance = (HistoricTaskInstance)taskMap.get(pendingTask.getTaskDefKey())) != null) {
                bpmActPendingTask = new BpmActPendingTask();
                bpmActPendingTask.setTaskDefKey(pendingTask.getTaskDefKey());
                bpmActPendingTask.setTaskName(pendingTask.getTaskName());
                bpmActPendingTask.setFormKey(pendingTask.getFormKey());
                bpmActPendingTask.setTodoConfiguration(pendingTask.getTodoConfiguration());
                bpmActPendingTask.setSeq(pendingTask.getSeq());
                bpmActPendingTask.setProcDefId(processDefinitionId);
                bpmActPendingTask.setProcessKey(processKey);
                bpmActPendingTask.setBusinessId(businessId);
                bpmActPendingTask.setPendingType("1");
                bpmActPendingTask.setIsMain("1");
                bpmActPendingTask.setOwner(historicTaskInstance.getOriginalAssignee());
                bpmActPendingTask.setAssignee(historicTaskInstance.getOriginalAssignee());
                bpmActPendingTask.setPosition(historicTaskInstance.getPostId());
                bpmActPendingTask.setDeptId(historicTaskInstance.getDeptId());
                Map userMap = this.sysActEntrustService.queryByUsers(Collections.singletonList(historicTaskInstance.getOriginalAssignee()), processKey, pendingTask.getTaskDefKey());
                String assignee = (String)userMap.get(historicProcessInstance.getStringOriginalProcInstId());
                if (assignee != null) {
                    bpmActPendingTask.setAssignee(assignee);
                }
                addPendingTasks.add(bpmActPendingTask);
                continue;
            }
            List<ApprovalUser> approvalUsers = AnalyticalModelUtil.getPendingTaskConfigUser(null, userId, deptId, bm, pendingTask.getTaskDefKey(), "", processKey, businessId, pendingTask.getTaskName(), processDefinitionId, "", null);
            for (ApprovalUser user : approvalUsers) {
                BpmActPendingTask bpmActPendingTask2 = new BpmActPendingTask();
                bpmActPendingTask2.setTaskDefKey(pendingTask.getTaskDefKey());
                bpmActPendingTask2.setTaskName(pendingTask.getTaskName());
                bpmActPendingTask2.setFormKey(pendingTask.getFormKey());
                bpmActPendingTask2.setTodoConfiguration(pendingTask.getTodoConfiguration());
                bpmActPendingTask2.setSeq(pendingTask.getSeq());
                bpmActPendingTask2.setProcDefId(processDefinitionId);
                bpmActPendingTask2.setProcessKey(processKey);
                bpmActPendingTask2.setBusinessId(businessId);
                bpmActPendingTask2.setIsMain("1");
                bpmActPendingTask2.setPendingType("1");
                bpmActPendingTask2.setOwner(user.getOwner());
                bpmActPendingTask2.setAssignee(user.getUserId());
                addPendingTasks.add(bpmActPendingTask2);
            }
            if (!HussarUtils.isEmpty(approvalUsers)) continue;
            if (Objects.equals(firstUserTask, pendingTask.getTaskDefKey())) {
                bpmActPendingTask = new BpmActPendingTask();
                bpmActPendingTask.setTaskDefKey(pendingTask.getTaskDefKey());
                bpmActPendingTask.setTaskName(pendingTask.getTaskName());
                bpmActPendingTask.setFormKey(pendingTask.getFormKey());
                bpmActPendingTask.setSeq(pendingTask.getSeq());
                bpmActPendingTask.setTodoConfiguration(pendingTask.getTodoConfiguration());
                bpmActPendingTask.setProcDefId(processDefinitionId);
                bpmActPendingTask.setProcessKey(processKey);
                bpmActPendingTask.setBusinessId(businessId);
                bpmActPendingTask.setAssignee(userId);
                bpmActPendingTask.setOwner(userId);
                bpmActPendingTask.setPosition(postId);
                bpmActPendingTask.setDeptId(deptId);
                bpmActPendingTask.setIsMain("1");
                bpmActPendingTask.setPendingType("1");
                addPendingTasks.add(bpmActPendingTask);
                continue;
            }
            bpmActPendingTask = new BpmActPendingTask();
            bpmActPendingTask.setTaskDefKey(pendingTask.getTaskDefKey());
            bpmActPendingTask.setTaskName(pendingTask.getTaskName());
            bpmActPendingTask.setFormKey(pendingTask.getFormKey());
            bpmActPendingTask.setSeq(pendingTask.getSeq());
            bpmActPendingTask.setTodoConfiguration(pendingTask.getTodoConfiguration());
            bpmActPendingTask.setProcDefId(processDefinitionId);
            bpmActPendingTask.setProcessKey(processKey);
            bpmActPendingTask.setBusinessId(businessId);
            bpmActPendingTask.setPendingType("0");
            addPendingTasks.add(bpmActPendingTask);
        }
        this.remove((Wrapper)new LambdaQueryWrapper().eq(BpmActPendingTask::getBusinessId, (Object)businessId));
        this.saveBatch(addPendingTasks);
    }

    private String getProcessDefinitionId(String processKey, String deptId) {
        int version = this.iSysActProcessDeptService.getProcessVersion(deptId, processKey);
        String processDefinitionId = this.processDefinitionsMapper.getProcDefId(version, processKey);
        if (HussarUtils.isNotEmpty((Object)processDefinitionId)) {
            return processDefinitionId;
        }
        throw new PublicClientException(this.bpmConstantProperties.getProcessKeyError());
    }

    private void recursiveUpdateCallActivityPendingTask(String processInstanceId) {
        List processInstanceList = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstanceId).includeProcessVariables().list();
        for (HistoricProcessInstance processInstance : processInstanceList) {
            this.updatePendingTaskDetails(processInstance);
            this.recursiveUpdateCallActivityPendingTask(processInstance.getId());
        }
    }

    private void updatePendingTaskDetails(HistoricProcessInstance processInstance) {
        BpmnModel bm = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        Process process = (Process)bm.getProcesses().get(0);
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).unfinished().list();
        Map taskMap = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().includeTaskLocalVariables()).processInstanceId(processInstance.getId())).taskVariableValueNotEquals("reject_to", null)).orderByTaskCreateTime()).asc()).list().stream().collect(Collectors.toMap(TaskInfo::getTaskDefinitionKey, Function.identity(), (task1, task2) -> task2));
        Set runningTaskKeys = historicActivityInstances.stream().filter(o -> ACTIVITY_TYPES.contains(o.getActivityType())).map(HistoricActivityInstance::getActivityId).collect(Collectors.toSet());
        HashSet<BpmActPendingTask> pendingTasks = new HashSet<BpmActPendingTask>();
        HashMap<String, Integer> sortedMap = new HashMap<String, Integer>();
        for (String taskDefKey : runningTaskKeys) {
            String rejectFromStr;
            Map<String, Object> variables = CommonCodeUtil.getGodAxeResult(null, taskDefKey, processInstance.getBusinessKey(), processInstance.getProcessDefinitionId());
            Map processVariables = processInstance.getProcessVariables();
            AnalyticalModelUtil.getSqlVariableMapWithOutExecution(processInstance.getBusinessKey(), null, processVariables);
            HashSet<String> rejectFrom = null;
            HistoricTaskInstance task = (HistoricTaskInstance)taskMap.get(taskDefKey);
            if (task != null && (rejectFromStr = (String)task.getTaskLocalVariables().get("reject_from")) != null && !rejectFromStr.isEmpty()) {
                rejectFrom = new HashSet<String>(Arrays.asList(rejectFromStr.split(",")));
            }
            pendingTasks.addAll(this.recursiveGetNextPendingTaskBySequence(process, (SequenceFlow)((Activity)process.getFlowElement(taskDefKey)).getOutgoingFlows().get(0), variables, (Map<String, Object>)processVariables, processInstance.getBusinessKey(), processInstance.getProcessDefinitionId(), sortedMap, rejectFrom));
        }
        BpmActPendingTaskServiceImpl.sortPendingTask(pendingTasks, sortedMap);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmActPendingTask::getBusinessId, (Object)processInstance.getBusinessKey());
        List oldPendingTasks = this.list((Wrapper)queryWrapper);
        Map<String, List<BpmActPendingTask>> pendingAssigneeMap = oldPendingTasks.stream().filter(o -> "1".equals(o.getPendingType())).collect(Collectors.groupingBy(BpmActPendingTask::getTaskDefKey));
        this.remove((Wrapper)queryWrapper);
        String startTaskKey = this.getStartTaskDefKey(bm);
        ArrayList<BpmActPendingTask> addPendingTasks = new ArrayList<BpmActPendingTask>();
        for (BpmActPendingTask pendingTask : pendingTasks) {
            ArrayList<ApprovalUser> approvalUserList = new ArrayList<ApprovalUser>();
            String startDept = processInstance.getDepartmentId();
            if (HussarUtils.isNotEmpty(pendingAssigneeMap) && pendingAssigneeMap.containsKey(pendingTask.getTaskDefKey())) {
                pendingAssigneeMap.get(pendingTask.getTaskDefKey()).forEach(thePendingTask -> {
                    thePendingTask.setAssignee(thePendingTask.getOwner());
                    approvalUserList.add(AnalyticalModelUtil.getApprovalUser(thePendingTask));
                });
            }
            List<ApprovalUser> approvalUsers = AnalyticalModelUtil.getPendingTaskConfigUser(approvalUserList, processInstance.getStartUserId(), startDept, bm, pendingTask.getTaskDefKey(), processInstance.getId(), processInstance.getProcessDefinitionKey(), processInstance.getBusinessKey(), pendingTask.getTaskName(), processInstance.getProcessDefinitionId(), "", processInstance.getProcessVariables());
            for (ApprovalUser approvalUser : approvalUsers) {
                BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
                bpmActPendingTask.setTaskDefKey(pendingTask.getTaskDefKey());
                bpmActPendingTask.setTaskName(pendingTask.getTaskName());
                bpmActPendingTask.setFormKey(pendingTask.getFormKey());
                bpmActPendingTask.setSeq(pendingTask.getSeq());
                bpmActPendingTask.setTodoConfiguration(pendingTask.getTodoConfiguration());
                bpmActPendingTask.setProcDefId(processInstance.getProcessDefinitionId());
                bpmActPendingTask.setProcessKey(processInstance.getProcessDefinitionKey());
                bpmActPendingTask.setProcInstId(processInstance.getId());
                bpmActPendingTask.setBusinessId(processInstance.getBusinessKey());
                bpmActPendingTask.setIsMain(HussarUtils.isNotEmpty((Object)approvalUser.getIsMain()) ? approvalUser.getIsMain() : "1");
                bpmActPendingTask.setPendingType("1");
                bpmActPendingTask.setOwner(approvalUser.getOwner());
                bpmActPendingTask.setAssignee(approvalUser.getUserId());
                bpmActPendingTask.setPosition(approvalUser.getPostId());
                bpmActPendingTask.setDeptId(approvalUser.getDeptId());
                addPendingTasks.add(bpmActPendingTask);
            }
            if (!HussarUtils.isEmpty(approvalUsers)) continue;
            BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
            bpmActPendingTask.setTaskDefKey(pendingTask.getTaskDefKey());
            bpmActPendingTask.setTaskName(pendingTask.getTaskName());
            bpmActPendingTask.setFormKey(pendingTask.getFormKey());
            bpmActPendingTask.setSeq(pendingTask.getSeq());
            bpmActPendingTask.setTodoConfiguration(pendingTask.getTodoConfiguration());
            bpmActPendingTask.setProcDefId(processInstance.getProcessDefinitionId());
            bpmActPendingTask.setProcessKey(processInstance.getProcessDefinitionKey());
            bpmActPendingTask.setProcInstId(processInstance.getId());
            bpmActPendingTask.setBusinessId(processInstance.getBusinessKey());
            bpmActPendingTask.setPendingType("0");
            addPendingTasks.add(bpmActPendingTask);
        }
        this.saveBatch(addPendingTasks);
    }

    public List<ApprovalUser> getPendingTaskAssignees(String businessId, String taskDefKey) {
        List<Object> users = new ArrayList<ApprovalUser>();
        if (HussarUtils.isAnyBlank((CharSequence[])new CharSequence[]{businessId, taskDefKey})) {
            return users;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmActPendingTask::getBusinessId, (Object)businessId);
        queryWrapper.eq(BpmActPendingTask::getTaskDefKey, (Object)taskDefKey);
        queryWrapper.eq(BpmActPendingTask::getPendingType, (Object)"1");
        List bpmActPendingTasks = this.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)bpmActPendingTasks)) {
            users = bpmActPendingTasks.stream().map(pendingTask -> {
                ApprovalUser approvalUser = new ApprovalUser();
                approvalUser.setDeptId(pendingTask.getDeptId());
                approvalUser.setPostId(pendingTask.getPosition());
                approvalUser.setUserId(pendingTask.getOwner());
                approvalUser.setIsMain(pendingTask.getIsMain());
                return approvalUser;
            }).collect(Collectors.toList());
        }
        return users;
    }

    public void endProcessUpdatePendingTasks(String processInstanceId) {
        if (HussarUtils.isEmpty((Object)processInstanceId)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (processInstanceId.contains(",")) {
            List<String> processInstanceIdList = Arrays.asList(processInstanceId.split(","));
            queryWrapper.in(BpmActPendingTask::getProcInstId, processInstanceIdList);
        } else {
            queryWrapper.eq(BpmActPendingTask::getProcInstId, (Object)processInstanceId);
        }
        this.remove((Wrapper)queryWrapper);
    }

    public ApiResponse<?> assignPendingTasksUser(String businessId, String taskDefKey, String userId, List<ApprovalUser> approvalUserList) {
        if (HussarUtils.isAnyBlank((CharSequence[])new CharSequence[]{businessId, taskDefKey})) {
            throw new PublicClientException("\u7f3a\u5c11\u5fc5\u4f20\u4fe1\u606f\uff01");
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).includeProcessVariables().singleResult();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmActPendingTask::getBusinessId, (Object)businessId);
        queryWrapper.eq(BpmActPendingTask::getTaskDefKey, (Object)taskDefKey);
        List pendingTasks = this.list((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)pendingTasks)) {
            throw new PublicClientException("\u672a\u627e\u5230\u8282\u70b9\u5f85\u5ba1\u4fe1\u606f\uff01");
        }
        BpmActPendingTask pendingTask = (BpmActPendingTask)pendingTasks.get(0);
        this.remove((Wrapper)queryWrapper);
        BpmnModel bm = HussarUtils.isNotEmpty((Object)processInstance) ? this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId()) : this.repositoryService.getBpmnModel(pendingTask.getProcDefId());
        String startTaskKey = this.getStartTaskDefKey(bm);
        ArrayList<BpmActPendingTask> addPendingTasks = new ArrayList<BpmActPendingTask>();
        String startUser = "";
        String startDeptId = "";
        if (HussarUtils.isNotEmpty((Object)processInstance)) {
            startUser = processInstance.getStartUserId();
            startDeptId = processInstance.getDepartmentId();
        }
        approvalUserList = HussarUtils.isNotEmpty((Object)processInstance) ? AnalyticalModelUtil.getPendingTaskConfigUser(approvalUserList, startUser, startDeptId, bm, pendingTask.getTaskDefKey(), processInstance.getId(), pendingTask.getProcessKey(), processInstance.getBusinessKey(), pendingTask.getTaskName(), processInstance.getProcessDefinitionId(), "", processInstance.getProcessVariables()) : AnalyticalModelUtil.getPendingTaskConfigUser(approvalUserList, startUser, startDeptId, bm, pendingTask.getTaskDefKey(), "", pendingTask.getProcessKey(), businessId, pendingTask.getTaskName(), pendingTask.getProcDefId(), "", null);
        for (ApprovalUser approvalUser : approvalUserList) {
            BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
            BeanUtils.copyProperties((Object)pendingTask, (Object)bpmActPendingTask);
            bpmActPendingTask.setPendingTaskId(null);
            bpmActPendingTask.setAssignedUser(userId);
            bpmActPendingTask.setOwner(approvalUser.getUserId());
            bpmActPendingTask.setAssignee(approvalUser.getUserId());
            bpmActPendingTask.setPendingType("1");
            bpmActPendingTask.setDeptId(approvalUser.getDeptId());
            bpmActPendingTask.setPosition(approvalUser.getPostId());
            bpmActPendingTask.setIsMain(approvalUser.getIsMain());
            addPendingTasks.add(bpmActPendingTask);
        }
        if (HussarUtils.isNotEmpty(addPendingTasks)) {
            this.saveBatch(addPendingTasks);
        }
        return ApiResponse.success();
    }

    private Collection<BpmActPendingTask> recursiveGetNextPendingTaskBySequence(Process process, SequenceFlow sequenceFlow, Map<String, Object> variables, Map<String, Object> processVariables, String businessId, String processDefinitionId, Map<String, Integer> sortedMap, Set<String> rejectFrom) {
        PendTaskRecursionModel recursionParam = new PendTaskRecursionModel(sortedMap);
        HashSet<BpmActPendingTask> pendingTasks = new HashSet<BpmActPendingTask>();
        if (rejectFrom != null) {
            Map<String, HistoricTaskInstance> collect = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().includeTaskLocalVariables()).processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().asc()).finished().list().stream().filter(task -> task.getTaskLocalVariables().containsKey("reject_to")).collect(Collectors.toMap(TaskInfo::getTaskDefinitionKey, Function.identity(), (task1, task2) -> task2));
            recursionParam.setHistoricTaskInstance(collect);
            for (String rejectTask : rejectFrom) {
                sequenceFlow = new SequenceFlow();
                sequenceFlow.setTargetRef(rejectTask);
                recursionParam.setReject();
                this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, sequenceFlow, variables, processVariables, businessId, processDefinitionId, recursionParam);
            }
        } else {
            this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, sequenceFlow, variables, processVariables, businessId, processDefinitionId, recursionParam);
        }
        return pendingTasks;
    }

    private void recursiveGetNextPendingTaskBySequence(Set<BpmActPendingTask> pendingTasks, Process process, SequenceFlow sequenceFlow, Map<String, Object> variables, Map<String, Object> processVariables, String businessId, String processDefinitionId, PendTaskRecursionModel recursionParam) {
        if (HussarUtils.isEmpty((Object)sequenceFlow)) {
            return;
        }
        AnalyticalModelUtil.getAllVariables(processVariables, variables);
        FlowElement flowElement = process.getFlowElement(sequenceFlow.getTargetRef());
        String taskDefKey = flowElement.getId();
        if (flowElement instanceof UserTask) {
            if (recursionParam.isNext(taskDefKey)) {
                Collection<String> rejectNodes;
                Map<String, Object> newVariables = CommonCodeUtil.getGodAxeResult(null, taskDefKey, businessId, processDefinitionId);
                if (recursionParam.isNeedBuildTask(taskDefKey)) {
                    BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
                    bpmActPendingTask.setTaskDefKey(taskDefKey);
                    bpmActPendingTask.setTaskName(flowElement.getName());
                    bpmActPendingTask.setFormKey(((UserTask)flowElement).getFormKey());
                    this.getPendingTaskDetail(bpmActPendingTask, process, newVariables, processVariables);
                    pendingTasks.add(bpmActPendingTask);
                }
                if ((rejectNodes = recursionParam.isContinueReject(taskDefKey)) != null && rejectNodes.size() == 1) {
                    for (String rejectNode : rejectNodes) {
                        SequenceFlow flow = new SequenceFlow();
                        flow.setTargetRef(rejectNode);
                        this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, flow, newVariables, processVariables, businessId, processDefinitionId, recursionParam);
                        recursionParam.returnPer(taskDefKey);
                    }
                } else {
                    this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, (SequenceFlow)((UserTask)flowElement).getOutgoingFlows().get(0), newVariables, processVariables, businessId, processDefinitionId, recursionParam);
                    recursionParam.returnPer(taskDefKey);
                }
            }
        } else if (flowElement instanceof Gateway) {
            Gateway gateway = (Gateway)flowElement;
            if (gateway instanceof ParallelGateway) {
                for (SequenceFlow singleSequenceFlow : gateway.getOutgoingFlows()) {
                    this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, singleSequenceFlow, variables, processVariables, businessId, processDefinitionId, recursionParam);
                }
            } else {
                ArrayList<SequenceFlow> enabledSequenceFlows = new ArrayList<SequenceFlow>();
                SequenceFlow defaultSequenceFlow = null;
                boolean flag = true;
                for (SequenceFlow singleSequenceFlow : gateway.getOutgoingFlows()) {
                    if (HussarUtils.isEmpty((Object)singleSequenceFlow.getConditionExpression())) {
                        if (flowElement instanceof InclusiveGateway) {
                            enabledSequenceFlows.add(singleSequenceFlow);
                            continue;
                        }
                        defaultSequenceFlow = singleSequenceFlow;
                        continue;
                    }
                    boolean isConditionWithNextNode = singleSequenceFlow.getConditionExpression().contains("bpm_next_node");
                    if (!this.validateSequenceFlowByCondition(variables, singleSequenceFlow.getConditionExpression())) continue;
                    enabledSequenceFlows.add(singleSequenceFlow);
                    if (isConditionWithNextNode) continue;
                    flag = false;
                }
                if (flag && HussarUtils.isNotEmpty(defaultSequenceFlow)) {
                    enabledSequenceFlows.add(defaultSequenceFlow);
                }
                for (SequenceFlow singleSequenceFlow : enabledSequenceFlows) {
                    this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, singleSequenceFlow, variables, processVariables, businessId, processDefinitionId, recursionParam);
                }
            }
        } else if (flowElement instanceof CallActivity) {
            this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, (SequenceFlow)((CallActivity)flowElement).getOutgoingFlows().get(0), variables, processVariables, businessId, processDefinitionId, recursionParam);
        } else if (flowElement instanceof ServiceTask) {
            this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, (SequenceFlow)((ServiceTask)flowElement).getOutgoingFlows().get(0), variables, processVariables, businessId, processDefinitionId, recursionParam);
        } else if (flowElement instanceof ReceiveTask) {
            this.recursiveGetNextPendingTaskBySequence(pendingTasks, process, (SequenceFlow)((ReceiveTask)flowElement).getOutgoingFlows().get(0), variables, processVariables, businessId, processDefinitionId, recursionParam);
        }
    }

    private boolean validateSequenceFlowByCondition(Map<String, Object> variables, String conditionExpression) {
        ValueExpression valueExpression;
        Matcher matcher;
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (HussarUtils.isNotEmpty(variables)) {
            for (String k : variables.keySet()) {
                if (HussarUtils.isNotEmpty((Object)variables.get(k.toString()))) {
                    context.setVariable(k.toString(), factory.createValueExpression(variables.get(k.toString()), variables.get(k.toString()).getClass()));
                    continue;
                }
                context.setVariable(k.toString(), factory.createValueExpression(variables.get(k.toString()), Object.class));
            }
        }
        if ((matcher = BPM_NEXT_NODE_REGEX.matcher(conditionExpression)).find()) {
            conditionExpression = conditionExpression.replaceAll(matcher.group(), "true");
        }
        return HussarUtils.isNotEmpty((Object)(valueExpression = factory.createValueExpression((ELContext)context, conditionExpression = this.sqlConditionHandleService.getSqlRealCondition(conditionExpression, variables), Boolean.TYPE))) && (Boolean)valueExpression.getValue((ELContext)context) != false;
    }

    private void getPendingTaskDetail(BpmActPendingTask pendingTask, Process process, Map<String, Object> variables, Map<String, Object> processVariables) {
        AnalyticalModelUtil.getAllVariables(processVariables, variables);
        String todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)process.getFlowElement(pendingTask.getTaskDefKey()).getExtensionElements().get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
        if (HussarUtils.isEmpty((Object)todo)) {
            todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)process.getExtensionElements().get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
        }
        todo = AnalyticalModelUtil.getTodo(variables, todo);
        pendingTask.setTodoConfiguration(todo);
    }

    private String getStartTaskDefKey(BpmnModel bm) {
        for (FlowElement flowElement : ((Process)bm.getProcesses().get(0)).getFlowElements()) {
            if (!(flowElement instanceof StartEvent)) continue;
            return flowElement.getId();
        }
        return null;
    }

    private static void sortPendingTask(Collection<BpmActPendingTask> pendingTasks, Map<String, Integer> sortedMap) {
        for (BpmActPendingTask pendingTask : pendingTasks) {
            Integer sort = sortedMap.get(pendingTask.getTaskDefKey());
            if (sort == null) {
                sort = Integer.MAX_VALUE;
            }
            pendingTask.setSeq(sort.intValue());
        }
    }

    private static class PendTaskRecursionModel {
        private int deep = 0;
        private final Map<String, Integer> sortMap;
        private final Set<String> passedTask = new HashSet<String>();
        private boolean isReject;
        private Map<String, HistoricTaskInstance> historicTaskInstance = new HashMap<String, HistoricTaskInstance>();

        public boolean isNext(String taskDefKey) {
            if (this.passedTask.contains(taskDefKey)) {
                return false;
            }
            Integer perDeep = this.sortMap.get(taskDefKey);
            if (perDeep != null && perDeep >= this.deep) {
                return false;
            }
            ++this.deep;
            this.passedTask.add(taskDefKey);
            return true;
        }

        public boolean isNeedBuildTask(String taskDefKey) {
            boolean res = !this.sortMap.containsKey(taskDefKey);
            this.sortMap.put(taskDefKey, this.deep);
            return res;
        }

        public void returnPer(String taskDefKey) {
            if (this.passedTask.remove(taskDefKey)) {
                --this.deep;
            }
        }

        public Collection<String> isContinueReject(String taskDefKey) {
            if (this.isReject) {
                String rejectFromStr;
                HistoricTaskInstance historicTaskInstance = this.historicTaskInstance.get(taskDefKey);
                if (historicTaskInstance != null && (rejectFromStr = (String)historicTaskInstance.getTaskLocalVariables().get("reject_from")) != null && !rejectFromStr.isEmpty()) {
                    return new HashSet<String>(Arrays.asList(rejectFromStr.split(",")));
                }
                this.isReject = false;
            }
            return null;
        }

        public PendTaskRecursionModel(Map<String, Integer> sortMap) {
            this.sortMap = sortMap != null ? sortMap : new HashMap<String, Integer>();
        }

        public void setReject() {
            this.isReject = true;
        }

        public void setHistoricTaskInstance(Map<String, HistoricTaskInstance> historicTaskInstance) {
            this.historicTaskInstance = historicTaskInstance;
        }
    }
}

